/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.UCharacterProperty;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.math.BigDecimal;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.DigitList;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.CurrencyAmount;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.math.BigInteger;
import java.text.ChoiceFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;

public class DecimalFormat
extends NumberFormat {
    private static double epsilon = 1.0E-11;
    private static final int STATUS_INFINITE = 0;
    private static final int STATUS_POSITIVE = 1;
    private static final int STATUS_LENGTH = 2;
    static final double roundingIncrementEpsilon = 1.0E-9;
    private transient DigitList digitList = new DigitList();
    private String positivePrefix = "";
    private String positiveSuffix = "";
    private String negativePrefix = "-";
    private String negativeSuffix = "";
    private String posPrefixPattern;
    private String posSuffixPattern;
    private String negPrefixPattern;
    private String negSuffixPattern;
    private ChoiceFormat currencyChoice;
    private int multiplier = 1;
    private byte groupingSize = (byte)3;
    private byte groupingSize2 = 0;
    private boolean decimalSeparatorAlwaysShown = false;
    private transient boolean isCurrencyFormat = false;
    private DecimalFormatSymbols symbols = null;
    private boolean useSignificantDigits = false;
    private int minSignificantDigits = 1;
    private int maxSignificantDigits = 6;
    private boolean useExponentialNotation;
    private byte minExponentDigits;
    private boolean exponentSignAlwaysShown = false;
    private transient BigDecimal roundingIncrementICU = null;
    private transient double roundingDouble = 0.0;
    private transient double roundingDoubleReciprocal = 0.0;
    private int roundingMode = 6;
    private int formatWidth = 0;
    private char pad = (char)32;
    private int padPosition = 0;
    static final int currentSerialVersion = 3;
    private int serialVersionOnStream = 3;
    public static final int PAD_BEFORE_PREFIX = 0;
    public static final int PAD_AFTER_PREFIX = 1;
    public static final int PAD_BEFORE_SUFFIX = 2;
    public static final int PAD_AFTER_SUFFIX = 3;
    private static final char PATTERN_ZERO_DIGIT = '0';
    private static final char PATTERN_GROUPING_SEPARATOR = ',';
    private static final char PATTERN_DECIMAL_SEPARATOR = '.';
    private static final char PATTERN_DIGIT = '#';
    static final char PATTERN_SIGNIFICANT_DIGIT = '@';
    static final String PATTERN_EXPONENT = "E";
    static final char PATTERN_PLUS_SIGN = '+';
    private static final char PATTERN_PER_MILLE = '\u2030';
    private static final char PATTERN_PERCENT = '%';
    static final char PATTERN_PAD_ESCAPE = '*';
    private static final char PATTERN_MINUS = '-';
    private static final char PATTERN_SEPARATOR = ';';
    private static final char CURRENCY_SIGN = '\u00a4';
    private static final char QUOTE = '\'';
    static final int DOUBLE_INTEGER_DIGITS = 309;
    static final int DOUBLE_FRACTION_DIGITS = 340;
    static final int MAX_SCIENTIFIC_INTEGER_DIGITS = 8;
    private static final long serialVersionUID = 2L;

    public DecimalFormat() {
        ULocale def = ULocale.getDefault();
        String pattern = NumberFormat.getPattern(def, 0);
        this.symbols = new DecimalFormatSymbols(def);
        this.setCurrency(Currency.getInstance(def));
        this.applyPattern(pattern, false);
    }

    public DecimalFormat(String pattern) {
        ULocale def = ULocale.getDefault();
        this.symbols = new DecimalFormatSymbols(def);
        this.setCurrency(Currency.getInstance(def));
        this.applyPattern(pattern, false);
    }

    public DecimalFormat(String pattern, DecimalFormatSymbols symbols) {
        this.symbols = (DecimalFormatSymbols)symbols.clone();
        this.setCurrencyForSymbols();
        this.applyPattern(pattern, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer format(double number, StringBuffer result, FieldPosition fieldPosition) {
        boolean isNegative;
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        if (Double.isNaN(number)) {
            if (fieldPosition.getField() == 0) {
                fieldPosition.setBeginIndex(result.length());
            }
            result.append(this.symbols.getNaN());
            if (fieldPosition.getField() == 0) {
                fieldPosition.setEndIndex(result.length());
            }
            this.addPadding(result, fieldPosition, 0, 0);
            return result;
        }
        boolean bl = isNegative = number < 0.0 || number == 0.0 && 1.0 / number < 0.0;
        if (isNegative) {
            number = -number;
        }
        if (this.multiplier != 1) {
            number *= (double)this.multiplier;
        }
        if (this.roundingDouble > 0.0) {
            double newNumber = DecimalFormat.round(number, this.roundingDouble, this.roundingDoubleReciprocal, this.roundingMode, isNegative);
            if (newNumber == 0.0 && number != newNumber) {
                isNegative = false;
            }
            number = newNumber;
        }
        if (Double.isInfinite(number)) {
            int prefixLen = this.appendAffix(result, isNegative, true);
            if (fieldPosition.getField() == 0) {
                fieldPosition.setBeginIndex(result.length());
            }
            result.append(this.symbols.getInfinity());
            if (fieldPosition.getField() == 0) {
                fieldPosition.setEndIndex(result.length());
            }
            int suffixLen = this.appendAffix(result, isNegative, false);
            this.addPadding(result, fieldPosition, prefixLen, suffixLen);
            return result;
        }
        DigitList digitList = this.digitList;
        synchronized (digitList) {
            this.digitList.set(number, this.precision(false), !this.useExponentialNotation && !this.areSignificantDigitsUsed());
            return this.subformat(result, fieldPosition, isNegative, false);
        }
    }

    private static double round(double number, double roundingInc, double roundingIncReciprocal, int mode, boolean isNegative) {
        double div = roundingIncReciprocal == 0.0 ? number / roundingInc : number * roundingIncReciprocal;
        block0 : switch (mode) {
            case 2: {
                div = isNegative ? Math.floor(div + epsilon) : Math.ceil(div - epsilon);
                break;
            }
            case 3: {
                div = isNegative ? Math.ceil(div - epsilon) : Math.floor(div + epsilon);
                break;
            }
            case 1: {
                div = Math.floor(div + epsilon);
                break;
            }
            case 0: {
                div = Math.ceil(div - epsilon);
                break;
            }
            case 7: {
                if (div != Math.floor(div)) {
                    throw new ArithmeticException("Rounding necessary");
                }
                return number;
            }
            default: {
                double ceil = Math.ceil(div);
                double ceildiff = ceil - div;
                double floor = Math.floor(div);
                double floordiff = div - floor;
                switch (mode) {
                    case 6: {
                        if (floordiff + epsilon < ceildiff) {
                            div = floor;
                            break block0;
                        }
                        if (ceildiff + epsilon < floordiff) {
                            div = ceil;
                            break block0;
                        }
                        double testFloor = floor / 2.0;
                        div = testFloor == Math.floor(testFloor) ? floor : ceil;
                        break block0;
                    }
                    case 5: {
                        div = floordiff <= ceildiff + epsilon ? floor : ceil;
                        break block0;
                    }
                    case 4: {
                        div = ceildiff <= floordiff + epsilon ? ceil : floor;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Invalid rounding mode: " + mode);
            }
        }
        number = roundingIncReciprocal == 0.0 ? div * roundingInc : div / roundingIncReciprocal;
        return number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer format(long number, StringBuffer result, FieldPosition fieldPosition) {
        boolean isNegative;
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        if (this.roundingIncrementICU != null) {
            return this.format(BigDecimal.valueOf(number), result, fieldPosition);
        }
        boolean bl = isNegative = number < 0L;
        if (isNegative) {
            number = -number;
        }
        if (this.multiplier != 1) {
            boolean tooBig = false;
            if (number < 0L) {
                long cutoff = Long.MIN_VALUE / (long)this.multiplier;
                tooBig = number < cutoff;
            } else {
                long cutoff = Long.MAX_VALUE / (long)this.multiplier;
                boolean bl2 = tooBig = number > cutoff;
            }
            if (tooBig) {
                return this.format(BigInteger.valueOf(isNegative ? -number : number), result, fieldPosition);
            }
        }
        number *= (long)this.multiplier;
        DigitList digitList = this.digitList;
        synchronized (digitList) {
            this.digitList.set(number, this.precision(true));
            return this.subformat(result, fieldPosition, isNegative, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer format(BigInteger number, StringBuffer result, FieldPosition fieldPosition) {
        if (this.roundingIncrementICU != null) {
            return this.format(new BigDecimal(number), result, fieldPosition);
        }
        if (this.multiplier != 1) {
            number = number.multiply(BigInteger.valueOf(this.multiplier));
        }
        DigitList digitList = this.digitList;
        synchronized (digitList) {
            this.digitList.set(number, this.precision(true));
            return this.subformat(result, fieldPosition, number.signum() < 0, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer format(BigDecimal number, StringBuffer result, FieldPosition fieldPosition) {
        if (this.multiplier != 1) {
            number = number.multiply(BigDecimal.valueOf(this.multiplier));
        }
        if (this.roundingIncrementICU != null) {
            number = number.divide(this.roundingIncrementICU, 0, this.roundingMode).multiply(this.roundingIncrementICU);
        }
        DigitList digitList = this.digitList;
        synchronized (digitList) {
            this.digitList.set(number, this.precision(false), !this.useExponentialNotation && !this.areSignificantDigitsUsed());
            return this.subformat(result, fieldPosition, number.signum() < 0, false);
        }
    }

    private boolean isGroupingPosition(int pos) {
        boolean result = false;
        if (this.isGroupingUsed() && pos > 0 && this.groupingSize > 0) {
            result = this.groupingSize2 > 0 && pos > this.groupingSize ? (pos - this.groupingSize) % this.groupingSize2 == 0 : pos % this.groupingSize == 0;
        }
        return result;
    }

    private int precision(boolean isIntegral) {
        if (this.areSignificantDigitsUsed()) {
            return this.getMaximumSignificantDigits();
        }
        if (this.useExponentialNotation) {
            return this.getMinimumIntegerDigits() + this.getMaximumFractionDigits();
        }
        return isIntegral ? 0 : this.getMaximumFractionDigits();
    }

    private StringBuffer subformat(StringBuffer result, FieldPosition fieldPosition, boolean isNegative, boolean isInteger) {
        char zero = this.symbols.getZeroDigit();
        int zeroDelta = zero - 48;
        char grouping = this.symbols.getGroupingSeparator();
        char decimal = this.isCurrencyFormat ? this.symbols.getMonetaryDecimalSeparator() : this.symbols.getDecimalSeparator();
        boolean useSigDig = this.areSignificantDigitsUsed();
        int maxIntDig = this.getMaximumIntegerDigits();
        int minIntDig = this.getMinimumIntegerDigits();
        if (this.digitList.isZero()) {
            this.digitList.decimalAt = 0;
        }
        int prefixLen = this.appendAffix(result, isNegative, true);
        if (this.useExponentialNotation) {
            boolean negativeExponent;
            if (fieldPosition.getField() == 0) {
                fieldPosition.setBeginIndex(result.length());
                fieldPosition.setEndIndex(-1);
            } else if (fieldPosition.getField() == 1) {
                fieldPosition.setBeginIndex(-1);
            }
            int minFracDig = 0;
            if (useSigDig) {
                minIntDig = 1;
                maxIntDig = 1;
                minFracDig = this.getMinimumSignificantDigits() - 1;
            } else {
                minFracDig = this.getMinimumFractionDigits();
                if (maxIntDig > 8 && (maxIntDig = 1) < minIntDig) {
                    maxIntDig = minIntDig;
                }
                if (maxIntDig > minIntDig) {
                    minIntDig = 1;
                }
            }
            int exponent = this.digitList.decimalAt;
            if (maxIntDig > 1 && maxIntDig != minIntDig) {
                exponent = exponent > 0 ? (exponent - 1) / maxIntDig : exponent / maxIntDig - 1;
                exponent *= maxIntDig;
            } else {
                exponent -= minIntDig > 0 || minFracDig > 0 ? minIntDig : 1;
            }
            int minimumDigits = minIntDig + minFracDig;
            int integerDigits = this.digitList.isZero() ? minIntDig : this.digitList.decimalAt - exponent;
            int totalDigits = this.digitList.count;
            if (minimumDigits > totalDigits) {
                totalDigits = minimumDigits;
            }
            if (integerDigits > totalDigits) {
                totalDigits = integerDigits;
            }
            int i = 0;
            while (i < totalDigits) {
                if (i == integerDigits) {
                    if (fieldPosition.getField() == 0) {
                        fieldPosition.setEndIndex(result.length());
                    }
                    result.append(decimal);
                    if (fieldPosition.getField() == 1) {
                        fieldPosition.setBeginIndex(result.length());
                    }
                }
                result.append(i < this.digitList.count ? (char)(this.digitList.digits[i] + zeroDelta) : zero);
                ++i;
            }
            if (this.digitList.isZero() && totalDigits == 0) {
                result.append(zero);
            }
            if (fieldPosition.getField() == 0) {
                if (fieldPosition.getEndIndex() < 0) {
                    fieldPosition.setEndIndex(result.length());
                }
            } else if (fieldPosition.getField() == 1) {
                if (fieldPosition.getBeginIndex() < 0) {
                    fieldPosition.setBeginIndex(result.length());
                }
                fieldPosition.setEndIndex(result.length());
            }
            result.append(this.symbols.getExponentSeparator());
            if (this.digitList.isZero()) {
                exponent = 0;
            }
            boolean bl = negativeExponent = exponent < 0;
            if (negativeExponent) {
                exponent = -exponent;
                result.append(this.symbols.getMinusSign());
            } else if (this.exponentSignAlwaysShown) {
                result.append(this.symbols.getPlusSign());
            }
            this.digitList.set(exponent);
            byte expDig = this.minExponentDigits;
            if (this.useExponentialNotation && expDig < 1) {
                expDig = 1;
            }
            i = this.digitList.decimalAt;
            while (i < expDig) {
                result.append(zero);
                ++i;
            }
            i = 0;
            while (i < this.digitList.decimalAt) {
                result.append(i < this.digitList.count ? (char)(this.digitList.digits[i] + zeroDelta) : zero);
                ++i;
            }
        } else {
            boolean fractionPresent;
            int count;
            if (fieldPosition.getField() == 0) {
                fieldPosition.setBeginIndex(result.length());
            }
            int sigCount = 0;
            int minSigDig = this.getMinimumSignificantDigits();
            int maxSigDig = this.getMaximumSignificantDigits();
            if (!useSigDig) {
                minSigDig = 0;
                maxSigDig = Integer.MAX_VALUE;
            }
            int n = count = useSigDig ? Math.max(1, this.digitList.decimalAt) : minIntDig;
            if (this.digitList.decimalAt > 0 && count < this.digitList.decimalAt) {
                count = this.digitList.decimalAt;
            }
            int digitIndex = 0;
            if (count > maxIntDig && maxIntDig >= 0) {
                count = maxIntDig;
                digitIndex = this.digitList.decimalAt - count;
            }
            int sizeBeforeIntegerPart = result.length();
            int i = count - 1;
            while (i >= 0) {
                if (i < this.digitList.decimalAt && digitIndex < this.digitList.count && sigCount < maxSigDig) {
                    byte d = this.digitList.digits[digitIndex++];
                    result.append((char)(d + zeroDelta));
                    ++sigCount;
                } else {
                    result.append(zero);
                    if (sigCount > 0) {
                        ++sigCount;
                    }
                }
                if (this.isGroupingPosition(i)) {
                    result.append(grouping);
                }
                --i;
            }
            if (fieldPosition.getField() == 0) {
                fieldPosition.setEndIndex(result.length());
            }
            boolean bl = (isInteger || digitIndex >= this.digitList.count) && (useSigDig ? sigCount >= minSigDig : this.getMinimumFractionDigits() <= 0) ? false : (fractionPresent = true);
            if (!fractionPresent && result.length() == sizeBeforeIntegerPart) {
                result.append(zero);
            }
            if (this.decimalSeparatorAlwaysShown || fractionPresent) {
                result.append(decimal);
            }
            if (fieldPosition.getField() == 1) {
                fieldPosition.setBeginIndex(result.length());
            }
            int n2 = count = useSigDig ? Integer.MAX_VALUE : this.getMaximumFractionDigits();
            if (useSigDig && (sigCount == maxSigDig || sigCount >= minSigDig && digitIndex == this.digitList.count)) {
                count = 0;
            }
            i = 0;
            while (i < count) {
                if (!useSigDig && i >= this.getMinimumFractionDigits() && (isInteger || digitIndex >= this.digitList.count)) break;
                if (-1 - i > this.digitList.decimalAt - 1) {
                    result.append(zero);
                } else {
                    if (!isInteger && digitIndex < this.digitList.count) {
                        result.append((char)(this.digitList.digits[digitIndex++] + zeroDelta));
                    } else {
                        result.append(zero);
                    }
                    if (useSigDig && (++sigCount == maxSigDig || digitIndex == this.digitList.count && sigCount >= minSigDig)) break;
                }
                ++i;
            }
            if (fieldPosition.getField() == 1) {
                fieldPosition.setEndIndex(result.length());
            }
        }
        int suffixLen = this.appendAffix(result, isNegative, false);
        this.addPadding(result, fieldPosition, prefixLen, suffixLen);
        return result;
    }

    private final void addPadding(StringBuffer result, FieldPosition fieldPosition, int prefixLen, int suffixLen) {
        int len;
        if (this.formatWidth > 0 && (len = this.formatWidth - result.length()) > 0) {
            char[] padding = new char[len];
            int i = 0;
            while (i < len) {
                padding[i] = this.pad;
                ++i;
            }
            switch (this.padPosition) {
                case 1: {
                    result.insert(prefixLen, padding);
                    break;
                }
                case 0: {
                    result.insert(0, padding);
                    break;
                }
                case 2: {
                    result.insert(result.length() - suffixLen, padding);
                    break;
                }
                case 3: {
                    result.append(padding);
                }
            }
            if (this.padPosition == 0 || this.padPosition == 1) {
                fieldPosition.setBeginIndex(fieldPosition.getBeginIndex() + len);
                fieldPosition.setEndIndex(fieldPosition.getEndIndex() + len);
            }
        }
    }

    public Number parse(String text, ParsePosition parsePosition) {
        return (Number)this.parse(text, parsePosition, false);
    }

    CurrencyAmount parseCurrency(String text, ParsePosition pos) {
        return (CurrencyAmount)this.parse(text, pos, true);
    }

    private Object parse(String text, ParsePosition parsePosition, boolean parseCurrency) {
        Currency[] currency;
        int backup;
        int i = backup = parsePosition.getIndex();
        if (this.formatWidth > 0 && (this.padPosition == 0 || this.padPosition == 1)) {
            i = this.skipPadding(text, i);
        }
        if (text.regionMatches(i, this.symbols.getNaN(), 0, this.symbols.getNaN().length())) {
            i += this.symbols.getNaN().length();
            if (this.formatWidth > 0 && (this.padPosition == 2 || this.padPosition == 3)) {
                i = this.skipPadding(text, i);
            }
            parsePosition.setIndex(i);
            return new Double(Double.NaN);
        }
        i = backup;
        boolean[] status = new boolean[2];
        Currency[] currencyArray = currency = parseCurrency ? new Currency[1] : null;
        if (!this.subparse(text, parsePosition, this.digitList, false, status, currency)) {
            parsePosition.setIndex(backup);
            return null;
        }
        Number n = null;
        if (status[0]) {
            n = new Double(status[1] ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY);
        } else if (!status[1] && this.digitList.isZero()) {
            n = new Double(-0.0);
        } else {
            int mult = this.multiplier;
            while (mult % 10 == 0) {
                --this.digitList.decimalAt;
                mult /= 10;
            }
            if (mult == 1 && this.digitList.isIntegral()) {
                if (this.digitList.decimalAt < 12) {
                    long l = 0L;
                    if (this.digitList.count > 0) {
                        int nx = 0;
                        while (nx < this.digitList.count) {
                            l = l * 10L + (long)((char)this.digitList.digits[nx++]) - 48L;
                        }
                        while (nx++ < this.digitList.decimalAt) {
                            l *= 10L;
                        }
                        if (!status[1]) {
                            l = -l;
                        }
                    }
                    n = new Long(l);
                } else {
                    BigInteger big = this.digitList.getBigInteger(status[1]);
                    n = big.bitLength() < 64 ? new Long(big.longValue()) : big;
                }
            } else {
                BigDecimal big = this.digitList.getBigDecimalICU(status[1]);
                n = big;
                if (mult != 1) {
                    n = big.divide(BigDecimal.valueOf(mult), 6);
                }
            }
        }
        return parseCurrency ? new CurrencyAmount(n, currency[0]) : n;
    }

    private final boolean subparse(String text, ParsePosition parsePosition, DigitList digits, boolean isExponent, boolean[] status, Currency[] currency) {
        int position = parsePosition.getIndex();
        int oldStart = parsePosition.getIndex();
        if (this.formatWidth > 0 && this.padPosition == 0) {
            position = this.skipPadding(text, position);
        }
        int posMatch = this.compareAffix(text, position, false, true, currency);
        int negMatch = this.compareAffix(text, position, true, true, currency);
        if (posMatch >= 0 && negMatch >= 0) {
            if (posMatch > negMatch) {
                negMatch = -1;
            } else if (negMatch > posMatch) {
                posMatch = -1;
            }
        }
        if (posMatch >= 0) {
            position += posMatch;
        } else if (negMatch >= 0) {
            position += negMatch;
        } else {
            parsePosition.setErrorIndex(position);
            return false;
        }
        if (this.formatWidth > 0 && this.padPosition == 1) {
            position = this.skipPadding(text, position);
        }
        status[0] = false;
        if (!isExponent && text.regionMatches(position, this.symbols.getInfinity(), 0, this.symbols.getInfinity().length())) {
            position += this.symbols.getInfinity().length();
            status[0] = true;
        } else {
            digits.count = 0;
            digits.decimalAt = 0;
            char zero = this.symbols.getZeroDigit();
            char decimal = this.isCurrencyFormat ? this.symbols.getMonetaryDecimalSeparator() : this.symbols.getDecimalSeparator();
            char grouping = this.symbols.getGroupingSeparator();
            String exponentSep = this.symbols.getExponentSeparator();
            boolean sawDecimal = false;
            boolean sawExponent = false;
            boolean sawDigit = false;
            int exponent = 0;
            int digit = 0;
            int digitCount = 0;
            int backup = -1;
            while (position < text.length()) {
                char ch = text.charAt(position);
                digit = ch - zero;
                if (digit < 0 || digit > 9) {
                    digit = UCharacter.digit(ch, 10);
                }
                if (digit == 0) {
                    backup = -1;
                    sawDigit = true;
                    if (digits.count == 0) {
                        if (sawDecimal) {
                            --digits.decimalAt;
                        }
                    } else {
                        ++digitCount;
                        digits.append((char)(digit + 48));
                    }
                } else if (digit > 0 && digit <= 9) {
                    sawDigit = true;
                    ++digitCount;
                    digits.append((char)(digit + 48));
                    backup = -1;
                } else if (!isExponent && ch == decimal) {
                    if (this.isParseIntegerOnly() || sawDecimal) break;
                    digits.decimalAt = digitCount;
                    sawDecimal = true;
                } else if (!isExponent && ch == grouping && this.isGroupingUsed()) {
                    if (sawDecimal) break;
                    backup = position;
                } else {
                    if (isExponent || sawExponent || !text.regionMatches(position, exponentSep, 0, exponentSep.length())) break;
                    boolean negExp = false;
                    int pos = position + exponentSep.length();
                    if (pos < text.length()) {
                        ch = text.charAt(pos);
                        if (ch == this.symbols.getPlusSign()) {
                            ++pos;
                        } else if (ch == this.symbols.getMinusSign()) {
                            ++pos;
                            negExp = true;
                        }
                    }
                    DigitList exponentDigits = new DigitList();
                    exponentDigits.count = 0;
                    while (pos < text.length()) {
                        digit = text.charAt(pos) - zero;
                        if (digit < 0 || digit > 9) {
                            digit = UCharacter.digit(text.charAt(pos), 10);
                        }
                        if (digit < 0 || digit > 9) break;
                        exponentDigits.append((char)(digit + 48));
                        ++pos;
                    }
                    if (exponentDigits.count <= 0) break;
                    exponentDigits.decimalAt = exponentDigits.count;
                    exponent = (int)exponentDigits.getLong();
                    if (negExp) {
                        exponent = -exponent;
                    }
                    position = pos;
                    sawExponent = true;
                    break;
                }
                ++position;
            }
            if (backup != -1) {
                position = backup;
            }
            if (!sawDecimal) {
                digits.decimalAt = digitCount;
            }
            digits.decimalAt += exponent;
            if (!sawDigit && digitCount == 0) {
                parsePosition.setIndex(oldStart);
                parsePosition.setErrorIndex(oldStart);
                return false;
            }
        }
        if (this.formatWidth > 0 && this.padPosition == 2) {
            position = this.skipPadding(text, position);
        }
        if (posMatch >= 0) {
            posMatch = this.compareAffix(text, position, false, false, currency);
        }
        if (negMatch >= 0) {
            negMatch = this.compareAffix(text, position, true, false, currency);
        }
        if (posMatch >= 0 && negMatch >= 0) {
            if (posMatch > negMatch) {
                negMatch = -1;
            } else if (negMatch > posMatch) {
                posMatch = -1;
            }
        }
        if (posMatch >= 0 == negMatch >= 0) {
            parsePosition.setErrorIndex(position);
            return false;
        }
        position += posMatch >= 0 ? posMatch : negMatch;
        if (this.formatWidth > 0 && this.padPosition == 3) {
            position = this.skipPadding(text, position);
        }
        parsePosition.setIndex(position);
        boolean bl = status[1] = posMatch >= 0;
        if (parsePosition.getIndex() == oldStart) {
            parsePosition.setErrorIndex(position);
            return false;
        }
        return true;
    }

    private final int skipPadding(String text, int position) {
        while (position < text.length() && text.charAt(position) == this.pad) {
            ++position;
        }
        return position;
    }

    private int compareAffix(String text, int pos, boolean isNegative, boolean isPrefix, Currency[] currency) {
        if (currency != null || this.currencyChoice != null) {
            if (isPrefix) {
                return this.compareComplexAffix(isNegative ? this.negPrefixPattern : this.posPrefixPattern, text, pos, currency);
            }
            return this.compareComplexAffix(isNegative ? this.negSuffixPattern : this.posSuffixPattern, text, pos, currency);
        }
        if (isPrefix) {
            return DecimalFormat.compareSimpleAffix(isNegative ? this.negativePrefix : this.positivePrefix, text, pos);
        }
        return DecimalFormat.compareSimpleAffix(isNegative ? this.negativeSuffix : this.positiveSuffix, text, pos);
    }

    private static int compareSimpleAffix(String affix, String input, int pos) {
        int start = pos;
        int i = 0;
        while (i < affix.length()) {
            int c = UTF16.charAt(affix, i);
            int len = UTF16.getCharCount(c);
            if (UCharacterProperty.isRuleWhiteSpace(c)) {
                boolean literalMatch = false;
                while (pos < input.length() && UTF16.charAt(input, pos) == c) {
                    literalMatch = true;
                    pos += len;
                    if ((i += len) == affix.length()) break;
                    c = UTF16.charAt(affix, i);
                    len = UTF16.getCharCount(c);
                    if (!UCharacterProperty.isRuleWhiteSpace(c)) break;
                }
                i = DecimalFormat.skipRuleWhiteSpace(affix, i);
                int s = pos;
                pos = DecimalFormat.skipUWhiteSpace(input, pos);
                if (pos != s || literalMatch) continue;
                return -1;
            }
            if (pos < input.length() && UTF16.charAt(input, pos) == c) {
                i += len;
                pos += len;
                continue;
            }
            return -1;
        }
        return pos - start;
    }

    private static int skipRuleWhiteSpace(String text, int pos) {
        while (pos < text.length()) {
            int c = UTF16.charAt(text, pos);
            if (!UCharacterProperty.isRuleWhiteSpace(c)) break;
            pos += UTF16.getCharCount(c);
        }
        return pos;
    }

    private static int skipUWhiteSpace(String text, int pos) {
        while (pos < text.length()) {
            int c = UTF16.charAt(text, pos);
            if (!UCharacter.isUWhiteSpace(c)) break;
            pos += UTF16.getCharCount(c);
        }
        return pos;
    }

    /*
     * Unable to fully structure code
     */
    private int compareComplexAffix(String affixPat, String text, int pos, Currency[] currency) {
        i = 0;
        block6: while (i < affixPat.length() && pos >= 0) {
            if ((c = affixPat.charAt(i++)) == '\'') {
                while (true) {
                    if ((j = affixPat.indexOf(39, i)) == i) {
                        pos = DecimalFormat.match(text, pos, 39);
                        i = j + 1;
                        continue block6;
                    }
                    if (j <= i) break;
                    pos = DecimalFormat.match(text, pos, affixPat.substring(i, j));
                    i = j + 1;
                    if (i >= affixPat.length() || affixPat.charAt(i) != '\'') continue block6;
                    pos = DecimalFormat.match(text, pos, 39);
                    ++i;
                }
                throw new RuntimeException();
            }
            switch (c) {
                case '\u00a4': {
                    v0 = intl = i < affixPat.length() && affixPat.charAt(i) == '\u00a4';
                    if (currency != null) {
                        uloc = this.getLocale(ULocale.VALID_LOCALE);
                        if (uloc == null) {
                            uloc = this.symbols.getLocale(ULocale.VALID_LOCALE);
                        }
                        if ((iso = Currency.parse(uloc, text, ppos = new ParsePosition(pos))) != null) {
                            currency[0] = Currency.getInstance(iso);
                            pos = ppos.getIndex();
                            break;
                        }
                        pos = -1;
                        break;
                    }
                    if (intl) {
                        ++i;
                        pos = DecimalFormat.match(text, pos, this.getCurrency().getCurrencyCode());
                        break;
                    }
                    ppos = new ParsePosition(pos);
                    this.currencyChoice.parse(text, ppos);
                    pos = ppos.getIndex() == pos ? -1 : ppos.getIndex();
                    break;
                }
                case '%': {
                    c = this.symbols.getPercent();
                    ** GOTO lbl47
                }
                case '\u2030': {
                    c = this.symbols.getPerMill();
                    ** GOTO lbl47
                }
                case '-': {
                    c = this.symbols.getMinusSign();
                }
lbl47:
                // 4 sources

                default: {
                    pos = DecimalFormat.match(text, pos, c);
                    if (!UCharacterProperty.isRuleWhiteSpace(c)) continue block6;
                    i = DecimalFormat.skipRuleWhiteSpace(affixPat, i);
                }
            }
        }
        return pos;
    }

    static final int match(String text, int pos, int ch) {
        if (UCharacterProperty.isRuleWhiteSpace(ch)) {
            int s = pos;
            if ((pos = DecimalFormat.skipUWhiteSpace(text, pos)) == s) {
                return -1;
            }
            return pos;
        }
        return pos >= 0 && UTF16.charAt(text, pos) == ch ? pos + UTF16.getCharCount(ch) : -1;
    }

    static final int match(String text, int pos, String str) {
        int i = 0;
        while (i < str.length() && pos >= 0) {
            int ch = UTF16.charAt(str, i);
            i += UTF16.getCharCount(ch);
            pos = DecimalFormat.match(text, pos, ch);
            if (!UCharacterProperty.isRuleWhiteSpace(ch)) continue;
            i = DecimalFormat.skipRuleWhiteSpace(str, i);
        }
        return pos;
    }

    public DecimalFormatSymbols getDecimalFormatSymbols() {
        try {
            return (DecimalFormatSymbols)this.symbols.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols newSymbols) {
        this.symbols = (DecimalFormatSymbols)newSymbols.clone();
        this.setCurrencyForSymbols();
        this.expandAffixes();
    }

    private void setCurrencyForSymbols() {
        DecimalFormatSymbols def = new DecimalFormatSymbols(this.symbols.getLocale());
        if (this.symbols.getCurrencySymbol().equals(def.getCurrencySymbol()) && this.symbols.getInternationalCurrencySymbol().equals(def.getInternationalCurrencySymbol())) {
            this.setCurrency(Currency.getInstance(this.symbols.getLocale()));
        } else {
            this.setCurrency(null);
        }
    }

    public String getPositivePrefix() {
        return this.positivePrefix;
    }

    public void setPositivePrefix(String newValue) {
        this.positivePrefix = newValue;
        this.posPrefixPattern = null;
    }

    public String getNegativePrefix() {
        return this.negativePrefix;
    }

    public void setNegativePrefix(String newValue) {
        this.negativePrefix = newValue;
        this.negPrefixPattern = null;
    }

    public String getPositiveSuffix() {
        return this.positiveSuffix;
    }

    public void setPositiveSuffix(String newValue) {
        this.positiveSuffix = newValue;
        this.posSuffixPattern = null;
    }

    public String getNegativeSuffix() {
        return this.negativeSuffix;
    }

    public void setNegativeSuffix(String newValue) {
        this.negativeSuffix = newValue;
        this.negSuffixPattern = null;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(int newValue) {
        if (newValue <= 0) {
            throw new IllegalArgumentException("Bad multiplier: " + newValue);
        }
        this.multiplier = newValue;
    }

    public BigDecimal getRoundingIncrement() {
        if (this.roundingIncrementICU == null) {
            return null;
        }
        return new BigDecimal(this.roundingIncrementICU.toString());
    }

    public void setRoundingIncrement(BigDecimal newValue) {
        int i;
        int n = i = newValue == null ? 0 : newValue.compareTo(BigDecimal.ZERO);
        if (i < 0) {
            throw new IllegalArgumentException("Illegal rounding increment");
        }
        if (i == 0) {
            this.setInternalRoundingIncrement(null);
        } else {
            this.setInternalRoundingIncrement(newValue);
        }
        this.setRoundingDouble();
    }

    public void setRoundingIncrement(double newValue) {
        if (newValue < 0.0) {
            throw new IllegalArgumentException("Illegal rounding increment");
        }
        this.roundingDouble = newValue;
        this.roundingDoubleReciprocal = 0.0;
        if (newValue == 0.0) {
            this.setRoundingIncrement(null);
        } else {
            this.roundingDouble = newValue;
            if (this.roundingDouble < 1.0) {
                double rawRoundedReciprocal = 1.0 / this.roundingDouble;
                this.setRoundingDoubleReciprocal(rawRoundedReciprocal);
            }
            this.setInternalRoundingIncrement(new BigDecimal(newValue));
        }
    }

    private void setRoundingDoubleReciprocal(double rawRoundedReciprocal) {
        this.roundingDoubleReciprocal = Math.rint(rawRoundedReciprocal);
        if (Math.abs(rawRoundedReciprocal - this.roundingDoubleReciprocal) > 1.0E-9) {
            this.roundingDoubleReciprocal = 0.0;
        }
    }

    public int getRoundingMode() {
        return this.roundingMode;
    }

    public void setRoundingMode(int roundingMode) {
        if (roundingMode < 0 || roundingMode > 7) {
            throw new IllegalArgumentException("Invalid rounding mode: " + roundingMode);
        }
        this.roundingMode = roundingMode;
    }

    public int getFormatWidth() {
        return this.formatWidth;
    }

    public void setFormatWidth(int width) {
        if (width < 0) {
            throw new IllegalArgumentException("Illegal format width");
        }
        this.formatWidth = width;
    }

    public char getPadCharacter() {
        return this.pad;
    }

    public void setPadCharacter(char padChar) {
        this.pad = padChar;
    }

    public int getPadPosition() {
        return this.padPosition;
    }

    public void setPadPosition(int padPos) {
        if (padPos < 0 || padPos > 3) {
            throw new IllegalArgumentException("Illegal pad position");
        }
        this.padPosition = padPos;
    }

    public boolean isScientificNotation() {
        return this.useExponentialNotation;
    }

    public void setScientificNotation(boolean useScientific) {
        this.useExponentialNotation = useScientific;
    }

    public byte getMinimumExponentDigits() {
        return this.minExponentDigits;
    }

    public void setMinimumExponentDigits(byte minExpDig) {
        if (minExpDig < 1) {
            throw new IllegalArgumentException("Exponent digits must be >= 1");
        }
        this.minExponentDigits = minExpDig;
    }

    public boolean isExponentSignAlwaysShown() {
        return this.exponentSignAlwaysShown;
    }

    public void setExponentSignAlwaysShown(boolean expSignAlways) {
        this.exponentSignAlwaysShown = expSignAlways;
    }

    public int getGroupingSize() {
        return this.groupingSize;
    }

    public void setGroupingSize(int newValue) {
        this.groupingSize = (byte)newValue;
    }

    public int getSecondaryGroupingSize() {
        return this.groupingSize2;
    }

    public void setSecondaryGroupingSize(int newValue) {
        this.groupingSize2 = (byte)newValue;
    }

    public boolean isDecimalSeparatorAlwaysShown() {
        return this.decimalSeparatorAlwaysShown;
    }

    public void setDecimalSeparatorAlwaysShown(boolean newValue) {
        this.decimalSeparatorAlwaysShown = newValue;
    }

    public Object clone() {
        try {
            DecimalFormat other = (DecimalFormat)super.clone();
            other.symbols = (DecimalFormatSymbols)this.symbols.clone();
            return other;
        }
        catch (Exception exception) {
            throw new InternalError();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        DecimalFormat other = (DecimalFormat)obj;
        return this.posPrefixPattern != null && this.posPrefixPattern.equals(other.posPrefixPattern) && this.posSuffixPattern != null && this.posSuffixPattern.equals(other.posSuffixPattern) && this.negPrefixPattern != null && this.negPrefixPattern.equals(other.negPrefixPattern) && this.negSuffixPattern != null && this.negSuffixPattern.equals(other.negSuffixPattern) && this.multiplier == other.multiplier && this.groupingSize == other.groupingSize && this.groupingSize2 == other.groupingSize2 && this.decimalSeparatorAlwaysShown == other.decimalSeparatorAlwaysShown && this.useExponentialNotation == other.useExponentialNotation && (!this.useExponentialNotation || this.minExponentDigits == other.minExponentDigits) && this.useSignificantDigits == other.useSignificantDigits && (!this.useSignificantDigits || this.minSignificantDigits == other.minSignificantDigits && this.maxSignificantDigits == other.maxSignificantDigits) && this.symbols.equals(other.symbols);
    }

    public int hashCode() {
        return super.hashCode() * 37 + this.positivePrefix.hashCode();
    }

    public String toPattern() {
        return this.toPattern(false);
    }

    public String toLocalizedPattern() {
        return this.toPattern(true);
    }

    private void expandAffixes() {
        this.currencyChoice = null;
        StringBuffer buffer = new StringBuffer();
        if (this.posPrefixPattern != null) {
            this.expandAffix(this.posPrefixPattern, buffer, false);
            this.positivePrefix = buffer.toString();
        }
        if (this.posSuffixPattern != null) {
            this.expandAffix(this.posSuffixPattern, buffer, false);
            this.positiveSuffix = buffer.toString();
        }
        if (this.negPrefixPattern != null) {
            this.expandAffix(this.negPrefixPattern, buffer, false);
            this.negativePrefix = buffer.toString();
        }
        if (this.negSuffixPattern != null) {
            this.expandAffix(this.negSuffixPattern, buffer, false);
            this.negativeSuffix = buffer.toString();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private void expandAffix(String pattern, StringBuffer buffer, boolean doFormat) {
        buffer.setLength(0);
        i = 0;
        block6: while (i < pattern.length()) {
            block14: {
                if ((c = pattern.charAt(i++)) == '\'') break block14;
                switch (c) {
                    case '\u00a4': {
                        v0 = intl = i < pattern.length() && pattern.charAt(i) == '\u00a4';
                        if (intl) {
                            ++i;
                        }
                        s = null;
                        currency = this.getCurrency();
                        if (currency == null) ** GOTO lbl29
                        if (intl) ** GOTO lbl27
                        isChoiceFormat = new boolean[1];
                        s = currency.getName(this.symbols.getULocale(), 0, isChoiceFormat);
                        if (!isChoiceFormat[0]) ** GOTO lbl30
                        if (!doFormat) {
                            if (this.currencyChoice == null) {
                                this.currencyChoice = new ChoiceFormat(s);
                            }
                            s = String.valueOf('\u00a4');
                        } else {
                            pos = new FieldPosition(0);
                            this.currencyChoice.format(this.digitList.getDouble(), buffer, pos);
                            ** break;
                        }
lbl27:
                        // 1 sources

                        s = currency.getCurrencyCode();
                        ** GOTO lbl30
lbl29:
                        // 1 sources

                        s = intl != false ? this.symbols.getInternationalCurrencySymbol() : this.symbols.getCurrencySymbol();
lbl30:
                        // 4 sources

                        buffer.append(s);
                        ** break;
                    }
                    case '%': {
                        c = this.symbols.getPercent();
                        break;
                    }
                    case '\u2030': {
                        c = this.symbols.getPerMill();
                        break;
                    }
                    case '-': {
                        c = this.symbols.getMinusSign();
                    }
                }
                buffer.append(c);
                continue;
            }
            while (true) {
                if ((j = pattern.indexOf(39, i)) == i) {
                    buffer.append('\'');
                    i = j + 1;
                    continue block6;
                }
                if (j <= i) {
                    throw new RuntimeException();
                }
                buffer.append(pattern.substring(i, j));
                i = j + 1;
                if (i >= pattern.length() || pattern.charAt(i) != '\'') continue block6;
                buffer.append('\'');
                ++i;
            }
lbl61:
            // 2 sources

        }
    }

    private int appendAffix(StringBuffer buf, boolean isNegative, boolean isPrefix) {
        if (this.currencyChoice != null) {
            String affixPat = null;
            affixPat = isPrefix ? (isNegative ? this.negPrefixPattern : this.posPrefixPattern) : (isNegative ? this.negSuffixPattern : this.posSuffixPattern);
            StringBuffer affixBuf = new StringBuffer();
            this.expandAffix(affixPat, affixBuf, true);
            buf.append(affixBuf.toString());
            return affixBuf.length();
        }
        String affix = null;
        affix = isPrefix ? (isNegative ? this.negativePrefix : this.positivePrefix) : (isNegative ? this.negativeSuffix : this.positiveSuffix);
        buf.append(affix);
        return affix.length();
    }

    /*
     * Unable to fully structure code
     */
    private void appendAffixPattern(StringBuffer buffer, boolean isNegative, boolean isPrefix, boolean localized) {
        block14: {
            block13: {
                affixPat = null;
                if (isPrefix) {
                    affixPat = isNegative != false ? this.negPrefixPattern : this.posPrefixPattern;
                } else {
                    v0 = affixPat = isNegative != false ? this.negSuffixPattern : this.posSuffixPattern;
                }
                if (affixPat == null) {
                    affix = null;
                    affix = isPrefix != false ? (isNegative != false ? this.negativePrefix : this.positivePrefix) : (isNegative != false ? this.negativeSuffix : this.positiveSuffix);
                    buffer.append('\'');
                    i = 0;
                    while (i < affix.length()) {
                        ch = affix.charAt(i);
                        if (ch == '\'') {
                            buffer.append(ch);
                        }
                        buffer.append(ch);
                        ++i;
                    }
                    buffer.append('\'');
                    return;
                }
                if (localized) break block13;
                buffer.append(affixPat);
                break block14;
            }
            i = 0;
            while (i < affixPat.length()) {
                ch = affixPat.charAt(i);
                switch (ch) {
                    case '\'': {
                        j = affixPat.indexOf(39, i + 1);
                        if (j < 0) {
                            throw new IllegalArgumentException("Malformed affix pattern: " + affixPat);
                        }
                        buffer.append(affixPat.substring(i, j + 1));
                        i = j;
                        break;
                    }
                    case '\u2030': {
                        ch = this.symbols.getPerMill();
                        ** GOTO lbl49
                    }
                    case '%': {
                        ch = this.symbols.getPercent();
                        ** GOTO lbl49
                    }
                    case '-': {
                        ch = this.symbols.getMinusSign();
                    }
lbl49:
                    // 4 sources

                    default: {
                        buffer.append(ch);
                    }
                }
                ++i;
            }
        }
    }

    private String toPattern(boolean localized) {
        int i;
        String padSpec;
        int padPos;
        StringBuffer result = new StringBuffer();
        char zero = localized ? (char)this.symbols.getZeroDigit() : (char)'0';
        char digit = localized ? (char)this.symbols.getDigit() : (char)'#';
        char sigDigit = '\u0000';
        boolean useSigDig = this.areSignificantDigitsUsed();
        if (useSigDig) {
            sigDigit = localized ? (char)this.symbols.getSignificantDigit() : (char)'@';
        }
        char group = localized ? (char)this.symbols.getGroupingSeparator() : (char)',';
        int roundingDecimalPos = 0;
        String roundingDigits = null;
        int n = padPos = this.formatWidth > 0 ? this.padPosition : -1;
        String string = this.formatWidth > 0 ? new StringBuffer(2).append(localized ? this.symbols.getPadEscape() : (char)'*').append(this.pad).toString() : (padSpec = null);
        if (this.roundingIncrementICU != null) {
            i = this.roundingIncrementICU.scale();
            roundingDigits = this.roundingIncrementICU.movePointRight(i).toString();
            roundingDecimalPos = roundingDigits.length() - i;
        }
        int part = 0;
        while (part < 2) {
            int pos;
            int g;
            if (padPos == 0) {
                result.append(padSpec);
            }
            this.appendAffixPattern(result, part != 0, true, localized);
            if (padPos == 1) {
                result.append(padSpec);
            }
            int sub0Start = result.length();
            int n2 = g = this.isGroupingUsed() ? Math.max(0, this.groupingSize) : 0;
            if (g > 0 && this.groupingSize2 > 0 && this.groupingSize2 != this.groupingSize) {
                g += this.groupingSize2;
            }
            int maxDig = 0;
            int minDig = 0;
            int maxSigDig = 0;
            if (useSigDig) {
                minDig = this.getMinimumSignificantDigits();
                maxDig = maxSigDig = this.getMaximumSignificantDigits();
            } else {
                minDig = this.getMinimumIntegerDigits();
                maxDig = this.getMaximumIntegerDigits();
            }
            if (this.useExponentialNotation) {
                if (maxDig > 8) {
                    maxDig = 1;
                }
            } else {
                maxDig = useSigDig ? Math.max(maxDig, g + 1) : Math.max(Math.max(g, this.getMinimumIntegerDigits()), roundingDecimalPos) + 1;
            }
            i = maxDig;
            while (i > 0) {
                if (!this.useExponentialNotation && i < maxDig && this.isGroupingPosition(i)) {
                    result.append(group);
                }
                if (useSigDig) {
                    result.append(maxSigDig >= i && i > maxSigDig - minDig ? sigDigit : digit);
                } else if (roundingDigits != null && (pos = roundingDecimalPos - i) >= 0 && pos < roundingDigits.length()) {
                    result.append((char)(roundingDigits.charAt(pos) - 48 + zero));
                } else {
                    result.append(i <= minDig ? zero : digit);
                }
                --i;
            }
            if (!useSigDig) {
                if (this.getMaximumFractionDigits() > 0 || this.decimalSeparatorAlwaysShown) {
                    result.append(localized ? this.symbols.getDecimalSeparator() : (char)'.');
                }
                pos = roundingDecimalPos;
                i = 0;
                while (i < this.getMaximumFractionDigits()) {
                    if (roundingDigits != null && pos < roundingDigits.length()) {
                        result.append(pos < 0 ? zero : (char)(roundingDigits.charAt(pos) - 48 + zero));
                        ++pos;
                    } else {
                        result.append(i < this.getMinimumFractionDigits() ? zero : digit);
                    }
                    ++i;
                }
            }
            if (this.useExponentialNotation) {
                result.append(localized ? this.symbols.getExponentSeparator() : PATTERN_EXPONENT);
                if (this.exponentSignAlwaysShown) {
                    result.append(localized ? this.symbols.getPlusSign() : (char)'+');
                }
                i = 0;
                while (i < this.minExponentDigits) {
                    result.append(zero);
                    ++i;
                }
            }
            if (padSpec != null && !this.useExponentialNotation) {
                int add = this.formatWidth - result.length() + sub0Start - (part == 0 ? this.positivePrefix.length() + this.positiveSuffix.length() : this.negativePrefix.length() + this.negativeSuffix.length());
                while (add > 0) {
                    result.insert(sub0Start, digit);
                    if (--add <= 1 || !this.isGroupingPosition(++maxDig)) continue;
                    result.insert(sub0Start, group);
                    --add;
                }
            }
            if (padPos == 2) {
                result.append(padSpec);
            }
            this.appendAffixPattern(result, part != 0, false, localized);
            if (padPos == 3) {
                result.append(padSpec);
            }
            if (part == 0) {
                if (this.negativeSuffix.equals(this.positiveSuffix) && this.negativePrefix.equals(String.valueOf(this.symbols.getMinusSign()) + this.positivePrefix)) break;
                result.append(localized ? this.symbols.getPatternSeparator() : (char)';');
            }
            ++part;
        }
        return result.toString();
    }

    public void applyPattern(String pattern) {
        this.applyPattern(pattern, false);
    }

    public void applyLocalizedPattern(String pattern) {
        this.applyPattern(pattern, true);
    }

    /*
     * Unable to fully structure code
     */
    private void applyPattern(String pattern, boolean localized) {
        zeroDigit = '0';
        sigDigit = '@';
        groupingSeparator = ',';
        decimalSeparator = '.';
        percent = '%';
        perMill = '\u2030';
        digit = '#';
        separator = ';';
        exponent = "E";
        plus = '+';
        padEscape = '*';
        minus = '-';
        if (localized) {
            zeroDigit = this.symbols.getZeroDigit();
            sigDigit = this.symbols.getSignificantDigit();
            groupingSeparator = this.symbols.getGroupingSeparator();
            decimalSeparator = this.symbols.getDecimalSeparator();
            percent = this.symbols.getPercent();
            perMill = this.symbols.getPerMill();
            digit = this.symbols.getDigit();
            separator = this.symbols.getPatternSeparator();
            exponent = this.symbols.getExponentSeparator();
            plus = this.symbols.getPlusSign();
            padEscape = this.symbols.getPadEscape();
            minus = this.symbols.getMinusSign();
        }
        nineDigit = (char)(zeroDigit + 9);
        gotNegative = false;
        pos = 0;
        part = 0;
        while (part < 2 && pos < pattern.length()) {
            subpart = 1;
            sub0Start = 0;
            sub0Limit = 0;
            sub2Limit = 0;
            prefix = new StringBuffer();
            suffix = new StringBuffer();
            decimalPos = -1;
            multiplier = 1;
            digitLeftCount = 0;
            zeroDigitCount = 0;
            digitRightCount = 0;
            sigDigitCount = 0;
            groupingCount = -1;
            groupingCount2 = -1;
            padPos = -1;
            padChar = '\u0000';
            incrementPos = -1;
            incrementVal = 0L;
            expDigits = -1;
            expSignAlways = false;
            isCurrency = false;
            affix = prefix;
            start = pos;
            block6: while (pos < pattern.length()) {
                ch = pattern.charAt(pos);
                switch (subpart) {
                    case 0: {
                        if (ch != digit) ** GOTO lbl66
                        if (zeroDigitCount > 0 || sigDigitCount > 0) {
                            ++digitRightCount;
                        } else {
                            ++digitLeftCount;
                        }
                        if (groupingCount >= 0 && decimalPos < 0) {
                            groupingCount = (byte)(groupingCount + 1);
                        }
                        ** GOTO lbl193
lbl66:
                        // 1 sources

                        if ((ch < zeroDigit || ch > nineDigit) && ch != sigDigit) ** GOTO lbl86
                        if (digitRightCount > 0) {
                            this.patternError("Unexpected '" + ch + '\'', pattern);
                        }
                        if (ch == sigDigit) {
                            ++sigDigitCount;
                        } else {
                            ++zeroDigitCount;
                            if (ch != zeroDigit) {
                                p = digitLeftCount + zeroDigitCount + digitRightCount;
                                if (incrementPos >= 0) {
                                    while (incrementPos < p) {
                                        incrementVal *= 10L;
                                        ++incrementPos;
                                    }
                                } else {
                                    incrementPos = p;
                                }
                                incrementVal += (long)(ch - zeroDigit);
                            }
                        }
                        if (groupingCount >= 0 && decimalPos < 0) {
                            groupingCount = (byte)(groupingCount + 1);
                        }
                        ** GOTO lbl193
lbl86:
                        // 1 sources

                        if (ch != groupingSeparator) ** GOTO lbl102
                        if (ch != '\'' || pos + 1 >= pattern.length() || (after = pattern.charAt(pos + 1)) == digit || after >= zeroDigit && after <= nineDigit) ** GOTO lbl97
                        if (after != '\'') {
                            if (groupingCount < 0) {
                                subpart = 3;
                            } else {
                                subpart = 2;
                                affix = suffix;
                                sub0Limit = pos--;
                            }
                        } else {
                            ++pos;
lbl97:
                            // 2 sources

                            if (decimalPos >= 0) {
                                this.patternError("Grouping separator after decimal", pattern);
                            }
                            groupingCount2 = groupingCount;
                            groupingCount = 0;
                        }
                        ** GOTO lbl193
lbl102:
                        // 1 sources

                        if (ch == decimalSeparator) {
                            if (decimalPos >= 0) {
                                this.patternError("Multiple decimal separators", pattern);
                            }
                            decimalPos = digitLeftCount + zeroDigitCount + digitRightCount;
                        } else {
                            if (pattern.regionMatches(pos, exponent, 0, exponent.length())) {
                                if (expDigits >= 0) {
                                    this.patternError("Multiple exponential symbols", pattern);
                                }
                                if (groupingCount >= 0) {
                                    this.patternError("Grouping separator in exponential", pattern);
                                }
                                if ((pos += exponent.length()) < pattern.length() && pattern.charAt(pos) == plus) {
                                    expSignAlways = true;
                                    ++pos;
                                }
                                expDigits = 0;
                                while (pos < pattern.length() && pattern.charAt(pos) == zeroDigit) {
                                    expDigits = (byte)(expDigits + 1);
                                    ++pos;
                                }
                                if (digitLeftCount + zeroDigitCount < 1 && sigDigitCount + digitRightCount < 1 || sigDigitCount > 0 && digitLeftCount > 0 || expDigits < 1) {
                                    this.patternError("Malformed exponential", pattern);
                                }
                            }
                            subpart = 2;
                            affix = suffix;
                            sub0Limit = pos--;
                        }
                        ** GOTO lbl193
                    }
                    case 1: 
                    case 2: {
                        if (ch != digit && ch != groupingSeparator && ch != decimalSeparator && (ch < zeroDigit || ch > nineDigit) && ch != sigDigit) ** GOTO lbl142
                        if (subpart != 1) ** GOTO lbl132
                        subpart = 0;
                        sub0Start = pos--;
                        ** GOTO lbl193
lbl132:
                        // 1 sources

                        if (ch != '\'') ** GOTO lbl140
                        if (pos + 1 < pattern.length() && pattern.charAt(pos + 1) == '\'') {
                            ++pos;
                            affix.append(ch);
                        } else {
                            subpart += 2;
                        }
                        ** GOTO lbl193
lbl140:
                        // 1 sources

                        this.patternError("Unquoted special character '" + ch + '\'', pattern);
                        ** GOTO lbl-1000
lbl142:
                        // 1 sources

                        if (ch != '\u00a4') ** GOTO lbl150
                        v0 = doubled = pos + 1 < pattern.length() && pattern.charAt(pos + 1) == '\u00a4';
                        if (doubled) {
                            ++pos;
                            affix.append(ch);
                        }
                        isCurrency = true;
                        ** GOTO lbl-1000
lbl150:
                        // 1 sources

                        if (ch != '\'') ** GOTO lbl158
                        if (pos + 1 < pattern.length() && pattern.charAt(pos + 1) == '\'') {
                            ++pos;
                            affix.append(ch);
                        } else {
                            subpart += 2;
                        }
                        ** GOTO lbl-1000
lbl158:
                        // 1 sources

                        if (ch == separator) {
                            if (subpart == 1 || part == 1) {
                                this.patternError("Unquoted special character '" + ch + '\'', pattern);
                            }
                            sub2Limit = pos++;
                            break block6;
                        }
                        if (ch != percent && ch != perMill) ** GOTO lbl169
                        if (multiplier != 1) {
                            this.patternError("Too many percent/permille characters", pattern);
                        }
                        multiplier = ch == percent ? 100 : 1000;
                        ch = ch == percent ? '%' : '\u2030';
                        ** GOTO lbl-1000
lbl169:
                        // 1 sources

                        if (ch != minus) ** GOTO lbl172
                        ch = '-';
                        ** GOTO lbl-1000
lbl172:
                        // 1 sources

                        if (ch == padEscape) {
                            if (padPos >= 0) {
                                this.patternError("Multiple pad specifiers", pattern);
                            }
                            if (pos + 1 == pattern.length()) {
                                this.patternError("Invalid pad specifier", pattern);
                            }
                            padPos = pos++;
                            padChar = pattern.charAt(pos);
                        } else lbl-1000:
                        // 7 sources

                        {
                            affix.append(ch);
                        }
                        ** GOTO lbl193
                    }
                    case 3: 
                    case 4: {
                        if (ch == '\'') {
                            if (pos + 1 < pattern.length() && pattern.charAt(pos + 1) == '\'') {
                                ++pos;
                                affix.append(ch);
                            } else {
                                subpart -= 2;
                            }
                        }
                        affix.append(ch);
                    }
lbl193:
                    // 14 sources

                    default: {
                        ++pos;
                    }
                }
            }
            if (subpart == 3 || subpart == 4) {
                this.patternError("Unterminated quote", pattern);
            }
            if (sub0Limit == 0) {
                sub0Limit = pattern.length();
            }
            if (sub2Limit == 0) {
                sub2Limit = pattern.length();
            }
            if (zeroDigitCount == 0 && sigDigitCount == 0 && digitLeftCount > 0 && decimalPos >= 0) {
                n = decimalPos;
                if (n == 0) {
                    ++n;
                }
                digitRightCount = digitLeftCount - n;
                digitLeftCount = n - 1;
                zeroDigitCount = 1;
            }
            if (decimalPos < 0 && digitRightCount > 0 && sigDigitCount == 0 || decimalPos >= 0 && (sigDigitCount > 0 || decimalPos < digitLeftCount || decimalPos > digitLeftCount + zeroDigitCount) || groupingCount == 0 || groupingCount2 == 0 || sigDigitCount > 0 && zeroDigitCount > 0 || subpart > 2) {
                this.patternError("Malformed pattern", pattern);
            }
            if (padPos >= 0) {
                if (padPos == start) {
                    padPos = 0;
                } else if (padPos + 2 == sub0Start) {
                    padPos = 1;
                } else if (padPos == sub0Limit) {
                    padPos = 2;
                } else if (padPos + 2 == sub2Limit) {
                    padPos = 3;
                } else {
                    this.patternError("Illegal pad position", pattern);
                }
            }
            if (part == 0) {
                this.posPrefixPattern = this.negPrefixPattern = prefix.toString();
                this.posSuffixPattern = this.negSuffixPattern = suffix.toString();
                v1 = this.useExponentialNotation = expDigits >= 0;
                if (this.useExponentialNotation) {
                    this.minExponentDigits = (byte)expDigits;
                    this.exponentSignAlwaysShown = expSignAlways;
                }
                this.isCurrencyFormat = isCurrency;
                digitTotalCount = digitLeftCount + zeroDigitCount + digitRightCount;
                effectiveDecimalPos = decimalPos >= 0 ? decimalPos : digitTotalCount;
                useSigDig = sigDigitCount > 0;
                this.setSignificantDigitsUsed(useSigDig);
                if (useSigDig) {
                    this.setMinimumSignificantDigits(sigDigitCount);
                    this.setMaximumSignificantDigits(sigDigitCount + digitRightCount);
                } else {
                    minInt = effectiveDecimalPos - digitLeftCount;
                    this.setMinimumIntegerDigits(minInt);
                    this.setMaximumIntegerDigits(this.useExponentialNotation != false ? digitLeftCount + minInt : 309);
                    this.setMaximumFractionDigits(decimalPos >= 0 ? digitTotalCount - decimalPos : 0);
                    this.setMinimumFractionDigits(decimalPos >= 0 ? digitLeftCount + zeroDigitCount - decimalPos : 0);
                }
                this.setGroupingUsed(groupingCount > 0);
                this.groupingSize = (byte)(groupingCount > 0 ? groupingCount : 0);
                this.groupingSize2 = groupingCount2 > 0 && groupingCount2 != groupingCount ? groupingCount2 : 0;
                this.multiplier = multiplier;
                this.setDecimalSeparatorAlwaysShown(decimalPos == 0 || decimalPos == digitTotalCount);
                if (padPos >= 0) {
                    this.padPosition = padPos;
                    this.formatWidth = sub0Limit - sub0Start;
                    this.pad = padChar;
                } else {
                    this.formatWidth = 0;
                }
                if (incrementVal != 0L) {
                    scale = incrementPos - effectiveDecimalPos;
                    this.roundingIncrementICU = BigDecimal.valueOf(incrementVal, scale > 0 ? scale : 0);
                    if (scale < 0) {
                        this.roundingIncrementICU = this.roundingIncrementICU.movePointRight(-scale);
                    }
                    this.setRoundingDouble();
                    this.roundingMode = 6;
                } else {
                    this.setRoundingIncrement(null);
                }
            } else {
                this.negPrefixPattern = prefix.toString();
                this.negSuffixPattern = suffix.toString();
                gotNegative = true;
            }
            ++part;
        }
        if (pattern.length() == 0) {
            this.posSuffixPattern = "";
            this.posPrefixPattern = "";
            this.setMinimumIntegerDigits(0);
            this.setMaximumIntegerDigits(309);
            this.setMinimumFractionDigits(0);
            this.setMaximumFractionDigits(340);
        }
        if (!gotNegative || this.negPrefixPattern.equals(this.posPrefixPattern) && this.negSuffixPattern.equals(this.posSuffixPattern)) {
            this.negSuffixPattern = this.posSuffixPattern;
            this.negPrefixPattern = String.valueOf('-') + this.posPrefixPattern;
        }
        this.expandAffixes();
        if (this.formatWidth > 0) {
            this.formatWidth += this.positivePrefix.length() + this.positiveSuffix.length();
        }
        this.setLocale(null, null);
    }

    private void setRoundingDouble() {
        if (this.roundingIncrementICU == null) {
            this.roundingDouble = 0.0;
            this.roundingDoubleReciprocal = 0.0;
        } else {
            this.roundingDouble = this.roundingIncrementICU.doubleValue();
            this.setRoundingDoubleReciprocal(BigDecimal.ONE.divide(this.roundingIncrementICU, 6).doubleValue());
        }
    }

    private void patternError(String msg, String pattern) {
        throw new IllegalArgumentException(String.valueOf(msg) + " in pattern \"" + pattern + '\"');
    }

    public void setMaximumIntegerDigits(int newValue) {
        super.setMaximumIntegerDigits(Math.min(newValue, 309));
    }

    public void setMinimumIntegerDigits(int newValue) {
        super.setMinimumIntegerDigits(Math.min(newValue, 309));
    }

    public int getMinimumSignificantDigits() {
        return this.minSignificantDigits;
    }

    public int getMaximumSignificantDigits() {
        return this.maxSignificantDigits;
    }

    public void setMinimumSignificantDigits(int min) {
        if (min < 1) {
            min = 1;
        }
        int max = Math.max(this.maxSignificantDigits, min);
        this.minSignificantDigits = min;
        this.maxSignificantDigits = max;
    }

    public void setMaximumSignificantDigits(int max) {
        int min;
        if (max < 1) {
            max = 1;
        }
        this.minSignificantDigits = min = Math.min(this.minSignificantDigits, max);
        this.maxSignificantDigits = max;
    }

    public boolean areSignificantDigitsUsed() {
        return this.useSignificantDigits;
    }

    public void setSignificantDigitsUsed(boolean useSignificantDigits) {
        this.useSignificantDigits = useSignificantDigits;
    }

    public void setCurrency(Currency theCurrency) {
        super.setCurrency(theCurrency);
        if (theCurrency != null) {
            boolean[] isChoiceFormat = new boolean[1];
            String s = theCurrency.getName(this.symbols.getULocale(), 0, isChoiceFormat);
            this.symbols.setCurrencySymbol(s);
            this.symbols.setInternationalCurrencySymbol(theCurrency.getCurrencyCode());
        }
        if (this.isCurrencyFormat) {
            if (theCurrency != null) {
                this.setRoundingIncrement(theCurrency.getRoundingIncrement());
                int d = theCurrency.getDefaultFractionDigits();
                this.setMinimumFractionDigits(d);
                this.setMaximumFractionDigits(d);
            }
            this.expandAffixes();
        }
    }

    protected Currency getEffectiveCurrency() {
        Currency c = this.getCurrency();
        if (c == null) {
            c = Currency.getInstance(this.symbols.getInternationalCurrencySymbol());
        }
        return c;
    }

    public void setMaximumFractionDigits(int newValue) {
        super.setMaximumFractionDigits(Math.min(newValue, 340));
    }

    public void setMinimumFractionDigits(int newValue) {
        super.setMinimumFractionDigits(Math.min(newValue, 340));
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.getMaximumIntegerDigits() > 309) {
            this.setMaximumIntegerDigits(309);
        }
        if (this.getMaximumFractionDigits() > 340) {
            this.setMaximumFractionDigits(340);
        }
        if (this.serialVersionOnStream < 2) {
            this.exponentSignAlwaysShown = false;
            this.setInternalRoundingIncrement(null);
            this.setRoundingDouble();
            this.roundingMode = 6;
            this.formatWidth = 0;
            this.pad = (char)32;
            this.padPosition = 0;
            if (this.serialVersionOnStream < 1) {
                this.useExponentialNotation = false;
            }
        }
        if (this.serialVersionOnStream < 3) {
            this.setCurrencyForSymbols();
        }
        this.serialVersionOnStream = 3;
        this.digitList = new DigitList();
    }

    private void setInternalRoundingIncrement(BigDecimal value) {
        this.roundingIncrementICU = value;
    }
}

