/* Driver template for the LEMON parser generator.
** Copyright 1991-1995 by D. Richard Hipp.
**
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Library General Public
** License as published by the Free Software Foundation; either
** version 2 of the License, or (at your option) any later version.
**
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Library General Public License for more details.
**
** You should have received a copy of the GNU Library General Public
** License along with this library; if not, write to the
** Free Software Foundation, Inc., 59 Temple Place - Suite 330,
** Boston, MA  02111-1307, USA.
**
** Modified 1997 to make it suitable for use with makeheaders.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 1 "./mate_grammar.lemon"


/* mate_grammar.lemon
* MATE's configuration language grammar 
*
* Copyright 2005, Luis E. Garcia Ontanon <luis.ontanon@gmail.com>
*
* $Id $
*
* Ethereal - Network traffic analyzer
* By Gerald Combs <gerald@ethereal.com>
* Copyright 1998 Gerald Combs
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
* 
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "mate.h"

#define DUMMY void*

typedef struct _extraction {
	gchar* as;
	header_field_info* hfi;
	struct _extraction* next;
	struct _extraction* last;
} extraction_t;

typedef struct _pdu_flags {
	gboolean drop_unassigned;
	gboolean discard;
	gboolean last_extracted;
} pdu_flags_t;

typedef struct _pdu_criteria_t {
	AVPL* criterium_avpl;
	avpl_match_mode criterium_match_mode;
	accept_mode_t criterium_accept_mode;
} pdu_criteria_t;

typedef struct _pdu_statement {
	GPtrArray* payload;
	pdu_flags_t* flags;
	extraction_t* extraction;
	pdu_criteria_t* criteria;
	GPtrArray* transforms;
} pdu_statement_t;

typedef struct _gop_tree_statement {
	gop_tree_mode_t pdu_tree_mode;
	gboolean drop_unassigned;
	gboolean show_times;
} gop_tree_statement;

typedef struct _gop_timer_statement {
	float expiration;
	float idle_timeout;
	float lifetime;
} gop_timer_statement;

typedef struct _gop_option_statement {
	gop_timer_statement* timer_sts;
	gop_tree_statement* tree_sts;
} gop_option_statement;

typedef struct _gop_control_statement {
	AVPL* start;
	AVPL* stop;
	AVPL* extras;
} gop_control_statement;

typedef struct _gop_statement {
	gop_control_statement* control;
	gop_option_statement* options;
	GPtrArray* transforms;
} gop_statement;

typedef struct _gog_statements {
	float expiration;
	gop_tree_mode_t gop_tree_mode;
	GPtrArray* transform_list;
	AVPL* extras;
	LoAL* current_gogkeys;
} gog_statement_t;

static void configuration_error(mate_config* mc, const gchar* fmt, ...) {
	static gchar error_buffer[256];
	const gchar* incl;
	gint i;
	mate_config_frame* current_frame;
	va_list list;
	
	va_start( list, fmt );
	g_vsnprintf(error_buffer,sizeof(error_buffer),fmt,list);
	va_end( list );

	i = (gint) mc->config_stack->len;
	
	while (i--) {

		if (i>0) {
			incl = "\n   included from: ";
		} else {
			incl = " ";
		}
		
		current_frame = g_ptr_array_index(mc->config_stack,(guint)i);
		
		g_string_sprintfa(mc->config_error,"%s%s at line %u",incl, current_frame->filename, current_frame->linenum);
	}
	
	g_string_sprintfa(mc->config_error,": %s\n",error_buffer);
	
	THROW(MateConfigError);

}

static AVPL_Transf* new_transform_elem(AVPL* match, AVPL* replace, avpl_match_mode match_mode, avpl_replace_mode replace_mode) {
	 AVPL_Transf* t = g_malloc(sizeof(AVPL_Transf));
	 
	 t->name = NULL;
	 t->match = match;
	 t->replace = replace;
	 t->match_mode = match_mode;
	 t->replace_mode = replace_mode;
	 
	 t->map = NULL;
	 t->next = NULL;
	 
	 return t;
}

static pdu_statement_t* do_pdu_statements(GPtrArray* payload, pdu_flags_t* flags, extraction_t* extraction, pdu_criteria_t* criteria, GPtrArray* transforms) {
	pdu_statement_t* s = g_malloc(sizeof(pdu_statement_t));
	
	s->payload = payload;
	s->flags = flags;
	s->extraction = extraction;
	s->criteria = criteria;
	s->transforms = transforms;
	
	return s;
}

static gchar* recolonize(mate_config* mc, gchar* s) {
	GString* str = g_string_new("");
	gchar** vec;
	gchar* r;
	guint i,v;
	gchar c;
	
	vec = g_strsplit(s,":",0);
	
	for (i = 0; vec[i]; i++) {
		g_strdown(vec[i]);
		
		v = 0;
		switch ( strlen(vec[i]) ) {
		 case 2:
		    c = vec[i][1];
			vec[i][1] = vec[i][0];
			vec[i][0] = c;
			if (vec[i][0] >= '0' && vec[i][0] <= '9') {
				v += (vec[i][1] - '0' )*16;
			} else {
				v += (vec[i][1] - 'a' + 10)*16;
			}
		 case 1:
			if (vec[i][0] >= '0' && vec[i][0] <= '9') {
				v += (vec[i][0] - '0' );
			} else {
				v += (vec[i][0] - 'a' + 10);
			}
		 case 0:
			break;
		  default:
			configuration_error(mc,"bad token %s",s);
		}
		
		g_string_sprintfa(str,":%.2X",v);					
	}
	
	g_strfreev(vec);
	
	g_string_erase(str,0,1);
	
	r = str->str;
	
	g_string_free(str,FALSE);

	return r;
}


#line 231 "mate_grammar.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/*
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands.
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash
**                       table.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    MateParserTOKENTYPE     is the data type used for minor tokens given
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is MateParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    MateParserARGDECL       is a declaration of a 3rd argument to the
**                       parser, or null if there is no extra argument.
**    MateParserKRARGDECL     A version of MateParserARGDECL for K&R C.
**    MateParserANSIARGDECL   A version of MateParserARGDECL for ANSI C.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
/*  */
#define YYCODETYPE unsigned char
#define YYNOCODE 119
#define YYACTIONTYPE int
#define MateParserTOKENTYPE  gchar* 
typedef union {
  MateParserTOKENTYPE yy0;
  gop_statement* yy1;
  AVP* yy6;
  gop_tree_statement* yy8;
  avpl_match_mode yy14;
  avpl_replace_mode yy15;
  gboolean yy32;
  header_field_info* yy42;
  pdu_criteria_t* yy45;
  float yy59;
  AVPL_Transf* yy63;
  gog_statement_t* yy91;
  accept_mode_t yy102;
  gop_tree_mode_t yy125;
  extraction_t* yy135;
  gop_timer_statement* yy145;
  gop_control_statement* yy173;
  pdu_flags_t* yy187;
  GPtrArray* yy199;
  gop_option_statement* yy201;
  pdu_statement_t* yy207;
  gchar* yy208;
  LoAL* yy219;
  AVPL* yy222;
  int yy237;
} YYMINORTYPE;
#define YYSTACKDEPTH 100
#define MateParserARGDECL ,mc 
#define MateParserXARGDECL  mate_config* mc ;
#define MateParserANSIARGDECL , mate_config* mc 
#define YYNSTATE 249
#define YYNRULE 154
#define YYERRORSYMBOL 68
#define YYERRSYMDT yy237
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)
/* Next is the action table.  Each entry in this table contains
**
**  +  An integer which is the number representing the look-ahead
**     token
**
**  +  An integer indicating what action to take.  Number (N) between
**     0 and YYNSTATE-1 mean shift the look-ahead and go to state N.
**     Numbers between YYNSTATE and YYNSTATE+YYNRULE-1 mean reduce by
**     rule N-YYNSTATE.  Number YYNSTATE+YYNRULE means that a syntax
**     error has occurred.  Number YYNSTATE+YYNRULE+1 means the parser
**     accepts its input.
**
**  +  A pointer to the next entry with the same hash value.
**
** The action table is really a series of hash tables.  Each hash
** table contains a number of entries which is a power of two.  The
** "state" table (which follows) contains information about the starting
** point and size of each hash table.
*/
struct yyActionEntry {
  YYCODETYPE   lookahead;   /* The value of the look-ahead token */
  YYACTIONTYPE action;      /* Action to take for this look-ahead */
  struct yyActionEntry *next; /* Next look-ahead with the same hash, or NULL */
};
static struct yyActionEntry yyActionTable[] = {
/* State 0 */
  {  80,   6, &yyActionTable[   3] }, /*               gop_decl shift  6 */
  {  65,   1, 0                    }, /*                  decls shift  1 */
  {  98,   5, 0                    }, /*               pdu_decl shift  5 */
  {  64, 248, 0                    }, /*                   decl shift  248 */
  {  23, 210, 0                    }, /*                 GOG_KW shift  210 */
  {  95, 404, 0                    }, /*            mate_config accept */
  {YYNOCODE,0,0}, /* Unused */
  {  55,   9, &yyActionTable[   4] }, /*           TRANSFORM_KW shift  9 */
  {  24, 136, 0                    }, /*                 GOP_KW shift  136 */
  {  41,  60, 0                    }, /*                 PDU_KW shift  60 */
  {  74,   7, 0                    }, /*               gog_decl shift  7 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  { 111,   8, &yyActionTable[   5] }, /*         transform_decl shift  8 */
/* State 1 */
  {  80,   6, &yyActionTable[  17] }, /*               gop_decl shift  6 */
  {  64,   4, 0                    }, /*                   decl shift  4 */
  {  98,   5, 0                    }, /*               pdu_decl shift  5 */
  {  23, 210, 0                    }, /*                 GOG_KW shift  210 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  55,   9, &yyActionTable[  19] }, /*           TRANSFORM_KW shift  9 */
  {  24, 136, 0                    }, /*                 GOP_KW shift  136 */
  {  41,  60, 0                    }, /*                 PDU_KW shift  60 */
  {  74,   7, 0                    }, /*               gog_decl shift  7 */
  {  11,   2, 0                    }, /*                DONE_KW shift  2 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  { 111,   8, 0                    }, /*         transform_decl shift  8 */
/* State 2 */
  {  48,   3, 0                    }, /*              SEMICOLON shift  3 */
/* State 3 */
  {   0, 249, 0                    }, /*                      $ reduce 0 */
/* State 4 */
  {YYNOCODE,0,0}, /* Unused */
/* State 5 */
  {YYNOCODE,0,0}, /* Unused */
/* State 6 */
  {YYNOCODE,0,0}, /* Unused */
/* State 7 */
  {YYNOCODE,0,0}, /* Unused */
/* State 8 */
  {YYNOCODE,0,0}, /* Unused */
/* State 9 */
  {  34,  10, 0                    }, /*                   NAME shift  10 */
/* State 10 */
  { 110,  11, &yyActionTable[  41] }, /*         transform_body shift  11 */
  {  38,  13, 0                    }, /*             OPEN_BRACE shift  13 */
/* State 11 */
  {  48,  12, 0                    }, /*              SEMICOLON shift  12 */
/* State 12 */
  {YYNOCODE,0,0}, /* Unused */
/* State 13 */
  {  32,  17, 0                    }, /*               MATCH_KW shift  17 */
  {  27,  47, 0                    }, /*              INSERT_KW shift  47 */
  {YYNOCODE,0,0}, /* Unused */
  {  59,  56, &yyActionTable[  45] }, /*            action_mode shift  56 */
  { 108,  59, 0                    }, /*          transform_blk shift  59 */
  { 109,  14, 0                    }, /*         transform_blks shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  47,  46, 0                    }, /*             REPLACE_KW shift  46 */
/* State 14 */
  {  32,  17, 0                    }, /*               MATCH_KW shift  17 */
  {  27,  47, 0                    }, /*              INSERT_KW shift  47 */
  {YYNOCODE,0,0}, /* Unused */
  {  59,  56, &yyActionTable[  53] }, /*            action_mode shift  56 */
  { 108,  16, 0                    }, /*          transform_blk shift  16 */
  {   5,  15, 0                    }, /*            CLOSE_BRACE shift  15 */
  {YYNOCODE,0,0}, /* Unused */
  {  47,  46, 0                    }, /*             REPLACE_KW shift  46 */
/* State 15 */
  {  48, 257, 0                    }, /*              SEMICOLON reduce 8 */
/* State 16 */
  {YYNOCODE,0,0}, /* Unused */
/* State 17 */
  {  62,  48, &yyActionTable[  63] }, /*                   avpl shift  48 */
  {  54,  53, &yyActionTable[  64] }, /*              STRICT_KW shift  53 */
  {  14,  54, 0                    }, /*               EVERY_KW shift  54 */
  {  31,  55, 0                    }, /*               LOOSE_KW shift  55 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  94,  18, &yyActionTable[  62] }, /*             match_mode shift  18 */
  {  39,  23, &yyActionTable[  65] }, /*            OPEN_PARENS shift  23 */
/* State 18 */
  {  62,  19, 0                    }, /*                   avpl shift  19 */
  {  39,  23, 0                    }, /*            OPEN_PARENS shift  23 */
/* State 19 */
  {  48,  45, 0                    }, /*              SEMICOLON shift  45 */
  {  47,  46, &yyActionTable[  74] }, /*             REPLACE_KW shift  46 */
  {  27,  47, 0                    }, /*              INSERT_KW shift  47 */
  {  59,  20, &yyActionTable[  73] }, /*            action_mode shift  20 */
/* State 20 */
  {  62,  21, 0                    }, /*                   avpl shift  21 */
  {  39,  23, 0                    }, /*            OPEN_PARENS shift  23 */
/* State 21 */
  {  48,  22, 0                    }, /*              SEMICOLON shift  22 */
/* State 22 */
  {YYNOCODE,0,0}, /* Unused */
/* State 23 */
  {  60,  44, 0                    }, /*                    avp shift  44 */
  {   6,  43, 0                    }, /*           CLOSE_PARENS shift  43 */
  {  34,  28, &yyActionTable[  81] }, /*                   NAME shift  28 */
  {  63,  24, 0                    }, /*                   avps shift  24 */
/* State 24 */
  {   8,  26, &yyActionTable[  85] }, /*                  COMMA shift  26 */
  {   6,  25, 0                    }, /*           CLOSE_PARENS shift  25 */
/* State 25 */
  {YYNOCODE,0,0}, /* Unused */
/* State 26 */
  {  60,  27, &yyActionTable[  88] }, /*                    avp shift  27 */
  {  34,  28, 0                    }, /*                   NAME shift  28 */
/* State 27 */
  {YYNOCODE,0,0}, /* Unused */
/* State 28 */
  {  38,  37, &yyActionTable[  91] }, /*             OPEN_BRACE shift  37 */
  {   2,  29, 0                    }, /*           AVP_OPERATOR shift  29 */
/* State 29 */
  {  12,  35, 0                    }, /*               DOTED_IP shift  35 */
  {  45,  31, 0                    }, /*                 QUOTED shift  31 */
  {  34,  32, 0                    }, /*                   NAME shift  32 */
  {  19,  33, 0                    }, /*               FLOATING shift  33 */
  {  28,  34, &yyActionTable[  92] }, /*                INTEGER shift  34 */
  { 117,  30, &yyActionTable[  93] }, /*                  value shift  30 */
  {YYNOCODE,0,0}, /* Unused */
  {   7,  36, 0                    }, /*              COLONIZED shift  36 */
/* State 30 */
  {YYNOCODE,0,0}, /* Unused */
/* State 31 */
  {YYNOCODE,0,0}, /* Unused */
/* State 32 */
  {YYNOCODE,0,0}, /* Unused */
/* State 33 */
  {YYNOCODE,0,0}, /* Unused */
/* State 34 */
  {YYNOCODE,0,0}, /* Unused */
/* State 35 */
  {YYNOCODE,0,0}, /* Unused */
/* State 36 */
  {YYNOCODE,0,0}, /* Unused */
/* State 37 */
  {  12,  35, 0                    }, /*               DOTED_IP shift  35 */
  {  61,  38, &yyActionTable[ 113] }, /*             avp_oneoff shift  38 */
  {  34,  32, 0                    }, /*                   NAME shift  32 */
  {  19,  33, 0                    }, /*               FLOATING shift  33 */
  {  28,  34, &yyActionTable[ 107] }, /*                INTEGER shift  34 */
  { 117,  42, &yyActionTable[ 108] }, /*                  value shift  42 */
  {  45,  31, 0                    }, /*                 QUOTED shift  31 */
  {   7,  36, 0                    }, /*              COLONIZED shift  36 */
/* State 38 */
  {   5,  39, 0                    }, /*            CLOSE_BRACE shift  39 */
  {  43,  40, &yyActionTable[ 115] }, /*                   PIPE shift  40 */
/* State 39 */
  {YYNOCODE,0,0}, /* Unused */
/* State 40 */
  {  12,  35, 0                    }, /*               DOTED_IP shift  35 */
  {  45,  31, 0                    }, /*                 QUOTED shift  31 */
  {  34,  32, 0                    }, /*                   NAME shift  32 */
  {  19,  33, 0                    }, /*               FLOATING shift  33 */
  {  28,  34, &yyActionTable[ 118] }, /*                INTEGER shift  34 */
  { 117,  41, &yyActionTable[ 119] }, /*                  value shift  41 */
  {YYNOCODE,0,0}, /* Unused */
  {   7,  36, 0                    }, /*              COLONIZED shift  36 */
/* State 41 */
  {YYNOCODE,0,0}, /* Unused */
/* State 42 */
  {YYNOCODE,0,0}, /* Unused */
/* State 43 */
  {YYNOCODE,0,0}, /* Unused */
/* State 44 */
  {YYNOCODE,0,0}, /* Unused */
/* State 45 */
  {YYNOCODE,0,0}, /* Unused */
/* State 46 */
  {  39, 268, 0                    }, /*            OPEN_PARENS reduce 19 */
/* State 47 */
  {  39, 269, 0                    }, /*            OPEN_PARENS reduce 20 */
/* State 48 */
  {  48,  52, 0                    }, /*              SEMICOLON shift  52 */
  {  47,  46, &yyActionTable[ 135] }, /*             REPLACE_KW shift  46 */
  {  27,  47, 0                    }, /*              INSERT_KW shift  47 */
  {  59,  49, &yyActionTable[ 134] }, /*            action_mode shift  49 */
/* State 49 */
  {  62,  50, 0                    }, /*                   avpl shift  50 */
  {  39,  23, 0                    }, /*            OPEN_PARENS shift  23 */
/* State 50 */
  {  48,  51, 0                    }, /*              SEMICOLON shift  51 */
/* State 51 */
  {YYNOCODE,0,0}, /* Unused */
/* State 52 */
  {YYNOCODE,0,0}, /* Unused */
/* State 53 */
  {  39, 265, 0                    }, /*            OPEN_PARENS reduce 16 */
/* State 54 */
  {  39, 266, 0                    }, /*            OPEN_PARENS reduce 17 */
/* State 55 */
  {  39, 267, 0                    }, /*            OPEN_PARENS reduce 18 */
/* State 56 */
  {  62,  57, 0                    }, /*                   avpl shift  57 */
  {  39,  23, 0                    }, /*            OPEN_PARENS shift  23 */
/* State 57 */
  {  48,  58, 0                    }, /*              SEMICOLON shift  58 */
/* State 58 */
  {YYNOCODE,0,0}, /* Unused */
/* State 59 */
  {YYNOCODE,0,0}, /* Unused */
/* State 60 */
  {  34,  61, 0                    }, /*                   NAME shift  61 */
/* State 61 */
  {  44,  62, 0                    }, /*               PROTO_KW shift  62 */
/* State 62 */
  {  34,  97, 0                    }, /*                   NAME shift  97 */
  {  73,  63, 0                    }, /*                  field shift  63 */
/* State 63 */
  {  56,  64, 0                    }, /*           TRANSPORT_KW shift  64 */
/* State 64 */
  {YYNOCODE,0,0}, /* Unused */
  {  73, 135, 0                    }, /*                  field shift  135 */
  {  34,  97, 0                    }, /*                   NAME shift  97 */
  { 103,  65, 0                    }, /*            proto_stack shift  65 */
/* State 65 */
  {YYNOCODE,0,0}, /* Unused */
  { 101,  66, 0                    }, /*              pdu_setup shift  66 */
  {  38,  68, 0                    }, /*             OPEN_BRACE shift  68 */
  {  51, 133, 0                    }, /*                  SLASH shift  133 */
/* State 66 */
  {  48,  67, 0                    }, /*              SEMICOLON shift  67 */
/* State 67 */
  {YYNOCODE,0,0}, /* Unused */
/* State 68 */
  {  96,  71, &yyActionTable[ 166] }, /*      payload_statement shift  71 */
  {  16,  92, 0                    }, /*             EXTRACT_KW shift  92 */
  {  66, 115, 0                    }, /* discard_pdu_data_statement shift  115 */
  {  99, 121, &yyActionTable[ 169] }, /*    pdu_flag_statements shift  121 */
  {  67, 103, 0                    }, /* drop_unassigned_statement shift  103 */
  {  40, 130, 0                    }, /*             PAYLOAD_KW shift  130 */
  { 102,  69, 0                    }, /*         pdu_statements shift  69 */
  {  71,  98, 0                    }, /*   extraction_statement shift  98 */
  {  72, 126, &yyActionTable[ 170] }, /*  extraction_statements shift  126 */
  {  13, 118, 0                    }, /*     DROP_UNASSIGNED_KW shift  118 */
  {  10, 112, 0                    }, /*    DISCARD_PDU_DATA_KW shift  112 */
  {YYNOCODE,0,0}, /* Unused */
  {  92, 117, 0                    }, /* last_extracted_statement shift  117 */
  {  29, 106, &yyActionTable[ 174] }, /*            LAST_PDU_KW shift  106 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 69 */
  {   5,  70, 0                    }, /*            CLOSE_BRACE shift  70 */
/* State 70 */
  {  48, 271, 0                    }, /*              SEMICOLON reduce 22 */
/* State 71 */
  {  16,  92, 0                    }, /*             EXTRACT_KW shift  92 */
  {  67, 103, 0                    }, /* drop_unassigned_statement shift  103 */
  {  66, 115, 0                    }, /* discard_pdu_data_statement shift  115 */
  {  99,  72, &yyActionTable[ 184] }, /*    pdu_flag_statements shift  72 */
  {  13, 118, 0                    }, /*     DROP_UNASSIGNED_KW shift  118 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  71,  98, 0                    }, /*   extraction_statement shift  98 */
  {  72,  99, 0                    }, /*  extraction_statements shift  99 */
  {YYNOCODE,0,0}, /* Unused */
  {  10, 112, 0                    }, /*    DISCARD_PDU_DATA_KW shift  112 */
  {YYNOCODE,0,0}, /* Unused */
  {  92, 117, 0                    }, /* last_extracted_statement shift  117 */
  {  29, 106, &yyActionTable[ 187] }, /*            LAST_PDU_KW shift  106 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 72 */
  {  72,  73, &yyActionTable[ 200] }, /*  extraction_statements shift  73 */
  {  16,  92, 0                    }, /*             EXTRACT_KW shift  92 */
  {YYNOCODE,0,0}, /* Unused */
  {  71,  98, 0                    }, /*   extraction_statement shift  98 */
/* State 73 */
  {  16,  92, 0                    }, /*             EXTRACT_KW shift  92 */
  { 113,  83, &yyActionTable[ 205] }, /* transform_list_statement shift  83 */
  {  97,  74, &yyActionTable[ 206] }, /* pdu_criteria_statement shift  74 */
  {   9,  84, 0                    }, /*            CRITERIA_KW shift  84 */
  {  55,  76, 0                    }, /*           TRANSFORM_KW shift  76 */
  {   5, 275, 0                    }, /*            CLOSE_BRACE reduce 26 */
  {YYNOCODE,0,0}, /* Unused */
  {  71,  91, &yyActionTable[ 207] }, /*   extraction_statement shift  91 */
/* State 74 */
  {   5, 273, 0                    }, /*            CLOSE_BRACE reduce 24 */
  { 113,  75, &yyActionTable[ 211] }, /* transform_list_statement shift  75 */
  {YYNOCODE,0,0}, /* Unused */
  {  55,  76, 0                    }, /*           TRANSFORM_KW shift  76 */
/* State 75 */
  {   5, 272, 0                    }, /*            CLOSE_BRACE reduce 23 */
/* State 76 */
  { 112,  77, 0                    }, /*         transform_list shift  77 */
  {YYNOCODE,0,0}, /* Unused */
  {  34,  81, 0                    }, /*                   NAME shift  81 */
  { 107,  82, 0                    }, /*              transform shift  82 */
/* State 77 */
  {  48,  78, &yyActionTable[ 221] }, /*              SEMICOLON shift  78 */
  {   8,  79, 0                    }, /*                  COMMA shift  79 */
/* State 78 */
  {   5, 384, 0                    }, /*            CLOSE_BRACE reduce 135 */
/* State 79 */
  {  34,  81, 0                    }, /*                   NAME shift  81 */
  { 107,  80, 0                    }, /*              transform shift  80 */
/* State 80 */
  {YYNOCODE,0,0}, /* Unused */
/* State 81 */
  {YYNOCODE,0,0}, /* Unused */
/* State 82 */
  {YYNOCODE,0,0}, /* Unused */
/* State 83 */
  {   5, 274, 0                    }, /*            CLOSE_BRACE reduce 25 */
/* State 84 */
  {  46,  90, 0                    }, /*              REJECT_KW shift  90 */
  {   1,  89, 0                    }, /*              ACCEPT_KW shift  89 */
  {  58,  85, &yyActionTable[ 229] }, /*            accept_mode shift  85 */
  {YYNOCODE,0,0}, /* Unused */
/* State 85 */
  {  54,  53, &yyActionTable[ 234] }, /*              STRICT_KW shift  53 */
  {  14,  54, 0                    }, /*               EVERY_KW shift  54 */
  {  94,  86, &yyActionTable[ 233] }, /*             match_mode shift  86 */
  {  31,  55, 0                    }, /*               LOOSE_KW shift  55 */
/* State 86 */
  {  62,  87, 0                    }, /*                   avpl shift  87 */
  {  39,  23, 0                    }, /*            OPEN_PARENS shift  23 */
/* State 87 */
  {  48,  88, 0                    }, /*              SEMICOLON shift  88 */
/* State 88 */
  {YYNOCODE,0,0}, /* Unused */
/* State 89 */
  {YYNOCODE,0,0}, /* Unused */
/* State 90 */
  {YYNOCODE,0,0}, /* Unused */
/* State 91 */
  {YYNOCODE,0,0}, /* Unused */
/* State 92 */
  {  34,  93, 0                    }, /*                   NAME shift  93 */
/* State 93 */
  {  21,  94, 0                    }, /*                FROM_KW shift  94 */
/* State 94 */
  {  34,  97, 0                    }, /*                   NAME shift  97 */
  {  73,  95, 0                    }, /*                  field shift  95 */
/* State 95 */
  {  48,  96, 0                    }, /*              SEMICOLON shift  96 */
/* State 96 */
  {YYNOCODE,0,0}, /* Unused */
/* State 97 */
  {YYNOCODE,0,0}, /* Unused */
/* State 98 */
  {YYNOCODE,0,0}, /* Unused */
/* State 99 */
  {  16,  92, 0                    }, /*             EXTRACT_KW shift  92 */
  { 113, 102, &yyActionTable[ 254] }, /* transform_list_statement shift  102 */
  {  97, 100, &yyActionTable[ 255] }, /* pdu_criteria_statement shift  100 */
  {   9,  84, 0                    }, /*            CRITERIA_KW shift  84 */
  {  55,  76, 0                    }, /*           TRANSFORM_KW shift  76 */
  {   5, 279, 0                    }, /*            CLOSE_BRACE reduce 30 */
  {YYNOCODE,0,0}, /* Unused */
  {  71,  91, &yyActionTable[ 256] }, /*   extraction_statement shift  91 */
/* State 100 */
  {   5, 277, 0                    }, /*            CLOSE_BRACE reduce 28 */
  { 113, 101, &yyActionTable[ 260] }, /* transform_list_statement shift  101 */
  {YYNOCODE,0,0}, /* Unused */
  {  55,  76, 0                    }, /*           TRANSFORM_KW shift  76 */
/* State 101 */
  {   5, 276, 0                    }, /*            CLOSE_BRACE reduce 27 */
/* State 102 */
  {   5, 278, 0                    }, /*            CLOSE_BRACE reduce 29 */
/* State 103 */
  {  16, 294, 0                    }, /*             EXTRACT_KW reduce 45 */
  {  10, 112, 0                    }, /*    DISCARD_PDU_DATA_KW shift  112 */
  {  66, 104, &yyActionTable[ 267] }, /* discard_pdu_data_statement shift  104 */
  {YYNOCODE,0,0}, /* Unused */
  {  92, 111, 0                    }, /* last_extracted_statement shift  111 */
  {  29, 106, 0                    }, /*            LAST_PDU_KW shift  106 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 104 */
  {  92, 105, &yyActionTable[ 276] }, /* last_extracted_statement shift  105 */
  {  29, 106, 0                    }, /*            LAST_PDU_KW shift  106 */
  {  16, 289, 0                    }, /*             EXTRACT_KW reduce 40 */
  {YYNOCODE,0,0}, /* Unused */
/* State 105 */
  {  16, 288, 0                    }, /*             EXTRACT_KW reduce 39 */
/* State 106 */
  { 116, 107, 0                    }, /*             true_false shift  107 */
  {  57, 109, 0                    }, /*                TRUE_KW shift  109 */
  {  18, 110, 0                    }, /*               FALSE_KW shift  110 */
  {YYNOCODE,0,0}, /* Unused */
/* State 107 */
  {  48, 108, 0                    }, /*              SEMICOLON shift  108 */
/* State 108 */
  {  16, 304, 0                    }, /*             EXTRACT_KW reduce 55 */
/* State 109 */
  {  48, 353, 0                    }, /*              SEMICOLON reduce 104 */
/* State 110 */
  {  48, 354, 0                    }, /*              SEMICOLON reduce 105 */
/* State 111 */
  {  16, 290, 0                    }, /*             EXTRACT_KW reduce 41 */
/* State 112 */
  { 116, 113, 0                    }, /*             true_false shift  113 */
  {  57, 109, 0                    }, /*                TRUE_KW shift  109 */
  {  18, 110, 0                    }, /*               FALSE_KW shift  110 */
  {YYNOCODE,0,0}, /* Unused */
/* State 113 */
  {  48, 114, 0                    }, /*              SEMICOLON shift  114 */
/* State 114 */
  {YYNOCODE,0,0}, /* Unused */
/* State 115 */
  {  92, 116, &yyActionTable[ 296] }, /* last_extracted_statement shift  116 */
  {  29, 106, 0                    }, /*            LAST_PDU_KW shift  106 */
  {  16, 293, 0                    }, /*             EXTRACT_KW reduce 44 */
  {YYNOCODE,0,0}, /* Unused */
/* State 116 */
  {  16, 291, 0                    }, /*             EXTRACT_KW reduce 42 */
/* State 117 */
  {  16, 292, 0                    }, /*             EXTRACT_KW reduce 43 */
/* State 118 */
  { 116, 119, 0                    }, /*             true_false shift  119 */
  {  57, 109, 0                    }, /*                TRUE_KW shift  109 */
  {  18, 110, 0                    }, /*               FALSE_KW shift  110 */
  {YYNOCODE,0,0}, /* Unused */
/* State 119 */
  {  48, 120, 0                    }, /*              SEMICOLON shift  120 */
/* State 120 */
  {YYNOCODE,0,0}, /* Unused */
/* State 121 */
  {  72, 122, &yyActionTable[ 307] }, /*  extraction_statements shift  122 */
  {  16,  92, 0                    }, /*             EXTRACT_KW shift  92 */
  {YYNOCODE,0,0}, /* Unused */
  {  71,  98, 0                    }, /*   extraction_statement shift  98 */
/* State 122 */
  {  16,  92, 0                    }, /*             EXTRACT_KW shift  92 */
  { 113, 125, &yyActionTable[ 312] }, /* transform_list_statement shift  125 */
  {  97, 123, &yyActionTable[ 313] }, /* pdu_criteria_statement shift  123 */
  {   9,  84, 0                    }, /*            CRITERIA_KW shift  84 */
  {  55,  76, 0                    }, /*           TRANSFORM_KW shift  76 */
  {   5, 283, 0                    }, /*            CLOSE_BRACE reduce 34 */
  {YYNOCODE,0,0}, /* Unused */
  {  71,  91, &yyActionTable[ 314] }, /*   extraction_statement shift  91 */
/* State 123 */
  {   5, 281, 0                    }, /*            CLOSE_BRACE reduce 32 */
  { 113, 124, &yyActionTable[ 318] }, /* transform_list_statement shift  124 */
  {YYNOCODE,0,0}, /* Unused */
  {  55,  76, 0                    }, /*           TRANSFORM_KW shift  76 */
/* State 124 */
  {   5, 280, 0                    }, /*            CLOSE_BRACE reduce 31 */
/* State 125 */
  {   5, 282, 0                    }, /*            CLOSE_BRACE reduce 33 */
/* State 126 */
  {  16,  92, 0                    }, /*             EXTRACT_KW shift  92 */
  { 113, 129, &yyActionTable[ 326] }, /* transform_list_statement shift  129 */
  {  97, 127, &yyActionTable[ 327] }, /* pdu_criteria_statement shift  127 */
  {   9,  84, 0                    }, /*            CRITERIA_KW shift  84 */
  {  55,  76, 0                    }, /*           TRANSFORM_KW shift  76 */
  {   5, 287, 0                    }, /*            CLOSE_BRACE reduce 38 */
  {YYNOCODE,0,0}, /* Unused */
  {  71,  91, &yyActionTable[ 328] }, /*   extraction_statement shift  91 */
/* State 127 */
  {   5, 285, 0                    }, /*            CLOSE_BRACE reduce 36 */
  { 113, 128, &yyActionTable[ 332] }, /* transform_list_statement shift  128 */
  {YYNOCODE,0,0}, /* Unused */
  {  55,  76, 0                    }, /*           TRANSFORM_KW shift  76 */
/* State 128 */
  {   5, 284, 0                    }, /*            CLOSE_BRACE reduce 35 */
/* State 129 */
  {   5, 286, 0                    }, /*            CLOSE_BRACE reduce 37 */
/* State 130 */
  {YYNOCODE,0,0}, /* Unused */
  {  73, 135, 0                    }, /*                  field shift  135 */
  {  34,  97, 0                    }, /*                   NAME shift  97 */
  { 103, 131, 0                    }, /*            proto_stack shift  131 */
/* State 131 */
  {  48, 132, 0                    }, /*              SEMICOLON shift  132 */
  {  51, 133, 0                    }, /*                  SLASH shift  133 */
/* State 132 */
  {YYNOCODE,0,0}, /* Unused */
/* State 133 */
  {  34,  97, 0                    }, /*                   NAME shift  97 */
  {  73, 134, 0                    }, /*                  field shift  134 */
/* State 134 */
  {YYNOCODE,0,0}, /* Unused */
/* State 135 */
  {YYNOCODE,0,0}, /* Unused */
/* State 136 */
  {  34, 137, 0                    }, /*                   NAME shift  137 */
/* State 137 */
  {  37, 138, 0                    }, /*                  ON_KW shift  138 */
/* State 138 */
  { 100, 139, &yyActionTable[ 352] }, /*               pdu_name shift  139 */
  {  34, 209, 0                    }, /*                   NAME shift  209 */
/* State 139 */
  {  32, 140, 0                    }, /*               MATCH_KW shift  140 */
/* State 140 */
  {  62, 141, 0                    }, /*                   avpl shift  141 */
  {  39,  23, 0                    }, /*            OPEN_PARENS shift  23 */
/* State 141 */
  {  48, 144, 0                    }, /*              SEMICOLON shift  144 */
  {YYNOCODE,0,0}, /* Unused */
  {  38, 145, 0                    }, /*             OPEN_BRACE shift  145 */
  {  83, 142, 0                    }, /*              gop_setup shift  142 */
/* State 142 */
  {  48, 143, 0                    }, /*              SEMICOLON shift  143 */
/* State 143 */
  {YYNOCODE,0,0}, /* Unused */
/* State 144 */
  {YYNOCODE,0,0}, /* Unused */
/* State 145 */
  {  15, 187, 0                    }, /*          EXPIRATION_KW shift  187 */
  {  49, 157, &yyActionTable[ 365] }, /*          SHOW_TIMES_KW shift  157 */
  {  17, 196, 0                    }, /*               EXTRA_KW shift  196 */
  {  67, 154, 0                    }, /* drop_unassigned_statement shift  154 */
  {  50, 161, 0                    }, /*           SHOW_TREE_KW shift  161 */
  {  69, 172, 0                    }, /*   expiration_statement shift  172 */
  {  70, 205, 0                    }, /*        extra_statement shift  205 */
  {  52, 206, 0                    }, /*               START_KW shift  206 */
  { 104, 168, 0                    }, /* show_goptree_statement shift  168 */
  { 105, 170, 0                    }, /*   show_times_statement shift  170 */
  {  53, 200, 0                    }, /*                STOP_KW shift  200 */
  {  55,  76, 0                    }, /*           TRANSFORM_KW shift  76 */
  {YYNOCODE,0,0}, /* Unused */
  {  13, 118, 0                    }, /*     DROP_UNASSIGNED_KW shift  118 */
  {YYNOCODE,0,0}, /* Unused */
  {  79, 148, &yyActionTable[ 363] }, /* gop_control_statements shift  148 */
  {YYNOCODE,0,0}, /* Unused */
  { 113, 192, &yyActionTable[ 364] }, /* transform_list_statement shift  192 */
  {  82, 190, &yyActionTable[ 367] }, /*  gop_option_statements shift  190 */
  {YYNOCODE,0,0}, /* Unused */
  {  84, 193, &yyActionTable[ 370] }, /*    gop_start_statement shift  193 */
  {  85, 146, &yyActionTable[ 373] }, /*         gop_statements shift  146 */
  {  86, 203, 0                    }, /*     gop_stop_statement shift  203 */
  {  87, 152, &yyActionTable[ 374] }, /*   gop_timer_statements shift  152 */
  {YYNOCODE,0,0}, /* Unused */
  {  89, 171, 0                    }, /*    gop_tree_statements shift  171 */
  {  26, 181, 0                    }, /*        IDLE_TIMEOUT_KW shift  181 */
  {  91, 184, 0                    }, /* idle_timeout_statement shift  184 */
  {YYNOCODE,0,0}, /* Unused */
  {  93, 186, 0                    }, /*     lifetime_statement shift  186 */
  {  30, 175, 0                    }, /*            LIFETIME_KW shift  175 */
  {YYNOCODE,0,0}, /* Unused */
/* State 146 */
  {   5, 147, 0                    }, /*            CLOSE_BRACE shift  147 */
/* State 147 */
  {  48, 310, 0                    }, /*              SEMICOLON reduce 61 */
/* State 148 */
  {   5, 316, 0                    }, /*            CLOSE_BRACE reduce 67 */
  {  49, 157, 0                    }, /*          SHOW_TIMES_KW shift  157 */
  {  50, 161, 0                    }, /*           SHOW_TREE_KW shift  161 */
  {  67, 154, 0                    }, /* drop_unassigned_statement shift  154 */
  {  55,  76, 0                    }, /*           TRANSFORM_KW shift  76 */
  {  69, 172, &yyActionTable[ 397] }, /*   expiration_statement shift  172 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  { 104, 168, 0                    }, /* show_goptree_statement shift  168 */
  { 105, 170, 0                    }, /*   show_times_statement shift  170 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  13, 118, 0                    }, /*     DROP_UNASSIGNED_KW shift  118 */
  {YYNOCODE,0,0}, /* Unused */
  {  15, 187, 0                    }, /*          EXPIRATION_KW shift  187 */
  {YYNOCODE,0,0}, /* Unused */
  { 113, 151, &yyActionTable[ 398] }, /* transform_list_statement shift  151 */
  {  82, 149, &yyActionTable[ 399] }, /*  gop_option_statements shift  149 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  87, 152, &yyActionTable[ 401] }, /*   gop_timer_statements shift  152 */
  {YYNOCODE,0,0}, /* Unused */
  {  89, 171, 0                    }, /*    gop_tree_statements shift  171 */
  {  26, 181, 0                    }, /*        IDLE_TIMEOUT_KW shift  181 */
  {  91, 184, 0                    }, /* idle_timeout_statement shift  184 */
  {YYNOCODE,0,0}, /* Unused */
  {  93, 186, 0                    }, /*     lifetime_statement shift  186 */
  {  30, 175, 0                    }, /*            LIFETIME_KW shift  175 */
  {YYNOCODE,0,0}, /* Unused */
/* State 149 */
  {   5, 314, 0                    }, /*            CLOSE_BRACE reduce 65 */
  { 113, 150, &yyActionTable[ 429] }, /* transform_list_statement shift  150 */
  {YYNOCODE,0,0}, /* Unused */
  {  55,  76, 0                    }, /*           TRANSFORM_KW shift  76 */
/* State 150 */
  {   5, 311, 0                    }, /*            CLOSE_BRACE reduce 62 */
/* State 151 */
  {   5, 313, 0                    }, /*            CLOSE_BRACE reduce 64 */
/* State 152 */
  { 104, 168, 0                    }, /* show_goptree_statement shift  168 */
  { 105, 170, &yyActionTable[ 439] }, /*   show_times_statement shift  170 */
  {  50, 161, 0                    }, /*           SHOW_TREE_KW shift  161 */
  {  67, 154, 0                    }, /* drop_unassigned_statement shift  154 */
  {  89, 153, &yyActionTable[ 441] }, /*    gop_tree_statements shift  153 */
  {  13, 118, 0                    }, /*     DROP_UNASSIGNED_KW shift  118 */
  {  49, 157, 0                    }, /*          SHOW_TIMES_KW shift  157 */
  {YYNOCODE,0,0}, /* Unused */
/* State 153 */
  {YYNOCODE,0,0}, /* Unused */
/* State 154 */
  { 104, 155, 0                    }, /* show_goptree_statement shift  155 */
  { 105, 160, &yyActionTable[ 447] }, /*   show_times_statement shift  160 */
  {  50, 161, 0                    }, /*           SHOW_TREE_KW shift  161 */
  {  49, 157, 0                    }, /*          SHOW_TIMES_KW shift  157 */
/* State 155 */
  {  49, 157, 0                    }, /*          SHOW_TIMES_KW shift  157 */
  { 105, 156, &yyActionTable[ 448] }, /*   show_times_statement shift  156 */
/* State 156 */
  {YYNOCODE,0,0}, /* Unused */
/* State 157 */
  { 116, 158, 0                    }, /*             true_false shift  158 */
  {  57, 109, 0                    }, /*                TRUE_KW shift  109 */
  {  18, 110, 0                    }, /*               FALSE_KW shift  110 */
  {YYNOCODE,0,0}, /* Unused */
/* State 158 */
  {  48, 159, 0                    }, /*              SEMICOLON shift  159 */
/* State 159 */
  {YYNOCODE,0,0}, /* Unused */
/* State 160 */
  {YYNOCODE,0,0}, /* Unused */
/* State 161 */
  {  88, 162, 0                    }, /*          gop_tree_mode shift  162 */
  {   4, 167, 0                    }, /*          BASIC_TREE_KW shift  167 */
  {  42, 165, 0                    }, /*            PDU_TREE_KW shift  165 */
  {  35, 164, 0                    }, /*             NO_TREE_KW shift  164 */
  {  20, 166, &yyActionTable[ 459] }, /*          FRAME_TREE_KW shift  166 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 162 */
  {  48, 163, 0                    }, /*              SEMICOLON shift  163 */
/* State 163 */
  {YYNOCODE,0,0}, /* Unused */
/* State 164 */
  {  48, 349, 0                    }, /*              SEMICOLON reduce 100 */
/* State 165 */
  {  48, 350, 0                    }, /*              SEMICOLON reduce 101 */
/* State 166 */
  {  48, 351, 0                    }, /*              SEMICOLON reduce 102 */
/* State 167 */
  {  48, 352, 0                    }, /*              SEMICOLON reduce 103 */
/* State 168 */
  {  49, 157, 0                    }, /*          SHOW_TIMES_KW shift  157 */
  { 105, 169, &yyActionTable[ 472] }, /*   show_times_statement shift  169 */
/* State 169 */
  {YYNOCODE,0,0}, /* Unused */
/* State 170 */
  {YYNOCODE,0,0}, /* Unused */
/* State 171 */
  {YYNOCODE,0,0}, /* Unused */
/* State 172 */
  {  26, 181, 0                    }, /*        IDLE_TIMEOUT_KW shift  181 */
  {  93, 180, 0                    }, /*     lifetime_statement shift  180 */
  {  30, 175, &yyActionTable[ 477] }, /*            LIFETIME_KW shift  175 */
  {  91, 173, 0                    }, /* idle_timeout_statement shift  173 */
/* State 173 */
  {  30, 175, 0                    }, /*            LIFETIME_KW shift  175 */
  {  93, 174, 0                    }, /*     lifetime_statement shift  174 */
/* State 174 */
  {YYNOCODE,0,0}, /* Unused */
/* State 175 */
  {  28, 179, 0                    }, /*                INTEGER shift  179 */
  {YYNOCODE,0,0}, /* Unused */
  { 106, 176, 0                    }, /*             time_value shift  176 */
  {  19, 178, 0                    }, /*               FLOATING shift  178 */
/* State 176 */
  {  48, 177, 0                    }, /*              SEMICOLON shift  177 */
/* State 177 */
  {YYNOCODE,0,0}, /* Unused */
/* State 178 */
  {  48, 356, 0                    }, /*              SEMICOLON reduce 107 */
/* State 179 */
  {  48, 357, 0                    }, /*              SEMICOLON reduce 108 */
/* State 180 */
  {YYNOCODE,0,0}, /* Unused */
/* State 181 */
  {  28, 179, 0                    }, /*                INTEGER shift  179 */
  {YYNOCODE,0,0}, /* Unused */
  { 106, 182, 0                    }, /*             time_value shift  182 */
  {  19, 178, 0                    }, /*               FLOATING shift  178 */
/* State 182 */
  {  48, 183, 0                    }, /*              SEMICOLON shift  183 */
/* State 183 */
  {YYNOCODE,0,0}, /* Unused */
/* State 184 */
  {  30, 175, 0                    }, /*            LIFETIME_KW shift  175 */
  {  93, 185, 0                    }, /*     lifetime_statement shift  185 */
/* State 185 */
  {YYNOCODE,0,0}, /* Unused */
/* State 186 */
  {YYNOCODE,0,0}, /* Unused */
/* State 187 */
  {  28, 179, 0                    }, /*                INTEGER shift  179 */
  {YYNOCODE,0,0}, /* Unused */
  { 106, 188, 0                    }, /*             time_value shift  188 */
  {  19, 178, 0                    }, /*               FLOATING shift  178 */
/* State 188 */
  {  48, 189, 0                    }, /*              SEMICOLON shift  189 */
/* State 189 */
  {YYNOCODE,0,0}, /* Unused */
/* State 190 */
  {   5, 315, 0                    }, /*            CLOSE_BRACE reduce 66 */
  { 113, 191, &yyActionTable[ 509] }, /* transform_list_statement shift  191 */
  {YYNOCODE,0,0}, /* Unused */
  {  55,  76, 0                    }, /*           TRANSFORM_KW shift  76 */
/* State 191 */
  {   5, 312, 0                    }, /*            CLOSE_BRACE reduce 63 */
/* State 192 */
  {   5, 317, 0                    }, /*            CLOSE_BRACE reduce 68 */
/* State 193 */
  {  17, 196, 0                    }, /*               EXTRA_KW shift  196 */
  {  53, 200, &yyActionTable[ 515] }, /*                STOP_KW shift  200 */
  {  86, 194, &yyActionTable[ 518] }, /*     gop_stop_statement shift  194 */
  {  70, 199, 0                    }, /*        extra_statement shift  199 */
/* State 194 */
  {  70, 195, 0                    }, /*        extra_statement shift  195 */
  {  17, 196, 0                    }, /*               EXTRA_KW shift  196 */
/* State 195 */
  {YYNOCODE,0,0}, /* Unused */
/* State 196 */
  {  62, 197, 0                    }, /*                   avpl shift  197 */
  {  39,  23, 0                    }, /*            OPEN_PARENS shift  23 */
/* State 197 */
  {  48, 198, 0                    }, /*              SEMICOLON shift  198 */
/* State 198 */
  {YYNOCODE,0,0}, /* Unused */
/* State 199 */
  {YYNOCODE,0,0}, /* Unused */
/* State 200 */
  {  62, 201, 0                    }, /*                   avpl shift  201 */
  {  39,  23, 0                    }, /*            OPEN_PARENS shift  23 */
/* State 201 */
  {  48, 202, 0                    }, /*              SEMICOLON shift  202 */
/* State 202 */
  {YYNOCODE,0,0}, /* Unused */
/* State 203 */
  {  70, 204, 0                    }, /*        extra_statement shift  204 */
  {  17, 196, 0                    }, /*               EXTRA_KW shift  196 */
/* State 204 */
  {YYNOCODE,0,0}, /* Unused */
/* State 205 */
  {YYNOCODE,0,0}, /* Unused */
/* State 206 */
  {  62, 207, 0                    }, /*                   avpl shift  207 */
  {  39,  23, 0                    }, /*            OPEN_PARENS shift  23 */
/* State 207 */
  {  48, 208, 0                    }, /*              SEMICOLON shift  208 */
/* State 208 */
  {YYNOCODE,0,0}, /* Unused */
/* State 209 */
  {  32, 355, 0                    }, /*               MATCH_KW reduce 106 */
/* State 210 */
  {  34, 211, 0                    }, /*                   NAME shift  211 */
/* State 211 */
  {  38, 212, 0                    }, /*             OPEN_BRACE shift  212 */
/* State 212 */
  {  25, 233, 0                    }, /*            GOP_TREE_KW shift  233 */
  {  33, 223, &yyActionTable[ 542] }, /*              MEMBER_KW shift  223 */
  {  69, 216, 0                    }, /*   expiration_statement shift  216 */
  {  75, 239, 0                    }, /*  gog_goptree_statement shift  239 */
  {  76, 228, 0                    }, /*      gog_key_statement shift  228 */
  {  77, 244, &yyActionTable[ 544] }, /*     gog_key_statements shift  244 */
  {  78, 213, 0                    }, /*         gog_statements shift  213 */
  {  15, 187, 0                    }, /*          EXPIRATION_KW shift  187 */
/* State 213 */
  {   5, 214, 0                    }, /*            CLOSE_BRACE shift  214 */
/* State 214 */
  {  48, 215, 0                    }, /*              SEMICOLON shift  215 */
/* State 215 */
  {YYNOCODE,0,0}, /* Unused */
/* State 216 */
  {  25, 233, 0                    }, /*            GOP_TREE_KW shift  233 */
  {  33, 223, &yyActionTable[ 553] }, /*              MEMBER_KW shift  223 */
  {YYNOCODE,0,0}, /* Unused */
  {  75, 217, 0                    }, /*  gog_goptree_statement shift  217 */
  {  76, 228, 0                    }, /*      gog_key_statement shift  228 */
  {  77, 229, 0                    }, /*     gog_key_statements shift  229 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 217 */
  {  76, 228, 0                    }, /*      gog_key_statement shift  228 */
  {  77, 218, &yyActionTable[ 563] }, /*     gog_key_statements shift  218 */
  {  33, 223, 0                    }, /*              MEMBER_KW shift  223 */
  {YYNOCODE,0,0}, /* Unused */
/* State 218 */
  {  33, 223, &yyActionTable[ 567] }, /*              MEMBER_KW shift  223 */
  { 113, 221, &yyActionTable[ 565] }, /* transform_list_statement shift  221 */
  {  17, 196, 0                    }, /*               EXTRA_KW shift  196 */
  {YYNOCODE,0,0}, /* Unused */
  {  76, 222, 0                    }, /*      gog_key_statement shift  222 */
  {   5, 368, 0                    }, /*            CLOSE_BRACE reduce 119 */
  {  70, 219, 0                    }, /*        extra_statement shift  219 */
  {  55,  76, 0                    }, /*           TRANSFORM_KW shift  76 */
/* State 219 */
  {   5, 367, 0                    }, /*            CLOSE_BRACE reduce 118 */
  { 113, 220, &yyActionTable[ 573] }, /* transform_list_statement shift  220 */
  {YYNOCODE,0,0}, /* Unused */
  {  55,  76, 0                    }, /*           TRANSFORM_KW shift  76 */
/* State 220 */
  {   5, 359, 0                    }, /*            CLOSE_BRACE reduce 110 */
/* State 221 */
  {   5, 360, 0                    }, /*            CLOSE_BRACE reduce 111 */
/* State 222 */
  {YYNOCODE,0,0}, /* Unused */
/* State 223 */
  {  34, 227, 0                    }, /*                   NAME shift  227 */
  {  81, 224, 0                    }, /*               gop_name shift  224 */
/* State 224 */
  {  62, 225, 0                    }, /*                   avpl shift  225 */
  {  39,  23, 0                    }, /*            OPEN_PARENS shift  23 */
/* State 225 */
  {  48, 226, 0                    }, /*              SEMICOLON shift  226 */
/* State 226 */
  {YYNOCODE,0,0}, /* Unused */
/* State 227 */
  {  39, 382, 0                    }, /*            OPEN_PARENS reduce 133 */
/* State 228 */
  {YYNOCODE,0,0}, /* Unused */
/* State 229 */
  {  33, 223, &yyActionTable[ 590] }, /*              MEMBER_KW shift  223 */
  { 113, 232, &yyActionTable[ 588] }, /* transform_list_statement shift  232 */
  {  17, 196, 0                    }, /*               EXTRA_KW shift  196 */
  {YYNOCODE,0,0}, /* Unused */
  {  76, 222, 0                    }, /*      gog_key_statement shift  222 */
  {   5, 370, 0                    }, /*            CLOSE_BRACE reduce 121 */
  {  70, 230, 0                    }, /*        extra_statement shift  230 */
  {  55,  76, 0                    }, /*           TRANSFORM_KW shift  76 */
/* State 230 */
  {   5, 369, 0                    }, /*            CLOSE_BRACE reduce 120 */
  { 113, 231, &yyActionTable[ 596] }, /* transform_list_statement shift  231 */
  {YYNOCODE,0,0}, /* Unused */
  {  55,  76, 0                    }, /*           TRANSFORM_KW shift  76 */
/* State 231 */
  {   5, 361, 0                    }, /*            CLOSE_BRACE reduce 112 */
/* State 232 */
  {   5, 362, 0                    }, /*            CLOSE_BRACE reduce 113 */
/* State 233 */
  {  36, 236, 0                    }, /*              NULL_TREE shift  236 */
  {  22, 237, 0                    }, /*              FULL_TREE shift  237 */
  {  90, 234, &yyActionTable[ 603] }, /*          gop_tree_type shift  234 */
  {   3, 238, 0                    }, /*             BASIC_TREE shift  238 */
/* State 234 */
  {  48, 235, 0                    }, /*              SEMICOLON shift  235 */
/* State 235 */
  {  33, 375, 0                    }, /*              MEMBER_KW reduce 126 */
/* State 236 */
  {  48, 376, 0                    }, /*              SEMICOLON reduce 127 */
/* State 237 */
  {  48, 377, 0                    }, /*              SEMICOLON reduce 128 */
/* State 238 */
  {  48, 378, 0                    }, /*              SEMICOLON reduce 129 */
/* State 239 */
  {  76, 228, 0                    }, /*      gog_key_statement shift  228 */
  {  77, 240, &yyActionTable[ 613] }, /*     gog_key_statements shift  240 */
  {  33, 223, 0                    }, /*              MEMBER_KW shift  223 */
  {YYNOCODE,0,0}, /* Unused */
/* State 240 */
  {  33, 223, &yyActionTable[ 617] }, /*              MEMBER_KW shift  223 */
  { 113, 243, &yyActionTable[ 615] }, /* transform_list_statement shift  243 */
  {  17, 196, 0                    }, /*               EXTRA_KW shift  196 */
  {YYNOCODE,0,0}, /* Unused */
  {  76, 222, 0                    }, /*      gog_key_statement shift  222 */
  {   5, 372, 0                    }, /*            CLOSE_BRACE reduce 123 */
  {  70, 241, 0                    }, /*        extra_statement shift  241 */
  {  55,  76, 0                    }, /*           TRANSFORM_KW shift  76 */
/* State 241 */
  {   5, 371, 0                    }, /*            CLOSE_BRACE reduce 122 */
  { 113, 242, &yyActionTable[ 623] }, /* transform_list_statement shift  242 */
  {YYNOCODE,0,0}, /* Unused */
  {  55,  76, 0                    }, /*           TRANSFORM_KW shift  76 */
/* State 242 */
  {   5, 363, 0                    }, /*            CLOSE_BRACE reduce 114 */
/* State 243 */
  {   5, 364, 0                    }, /*            CLOSE_BRACE reduce 115 */
/* State 244 */
  {  33, 223, &yyActionTable[ 631] }, /*              MEMBER_KW shift  223 */
  { 113, 247, &yyActionTable[ 629] }, /* transform_list_statement shift  247 */
  {  17, 196, 0                    }, /*               EXTRA_KW shift  196 */
  {YYNOCODE,0,0}, /* Unused */
  {  76, 222, 0                    }, /*      gog_key_statement shift  222 */
  {   5, 374, 0                    }, /*            CLOSE_BRACE reduce 125 */
  {  70, 245, 0                    }, /*        extra_statement shift  245 */
  {  55,  76, 0                    }, /*           TRANSFORM_KW shift  76 */
/* State 245 */
  {   5, 373, 0                    }, /*            CLOSE_BRACE reduce 124 */
  { 113, 246, &yyActionTable[ 637] }, /* transform_list_statement shift  246 */
  {YYNOCODE,0,0}, /* Unused */
  {  55,  76, 0                    }, /*           TRANSFORM_KW shift  76 */
/* State 246 */
  {   5, 365, 0                    }, /*            CLOSE_BRACE reduce 116 */
/* State 247 */
  {   5, 366, 0                    }, /*            CLOSE_BRACE reduce 117 */
/* State 248 */
  {YYNOCODE,0,0}, /* Unused */
};

/* The state table contains information needed to look up the correct
** action in the action table, given the current state of the parser.
** Information needed includes:
**
**  +  A pointer to the start of the action hash table in yyActionTable.
**
**  +  A mask used to hash the look-ahead token.  The mask is an integer
**     which is one less than the size of the hash table.
**
**  +  The default action.  This is the action to take if no entry for
**     the given look-ahead is found in the action hash table.
*/
struct yyStateEntry {
  struct yyActionEntry *hashtbl; /* Start of the hash table in yyActionTable */
  int mask;                      /* Mask used for hashing the look-ahead */
  YYACTIONTYPE actionDefault;    /* Default action if look-ahead not found */
};
static struct yyStateEntry yyStateTable[] = {
  { &yyActionTable[0], 15, 403},
  { &yyActionTable[16], 15, 403},
  { &yyActionTable[32], 0, 403},
  { &yyActionTable[33], 0, 403},
  { &yyActionTable[34], 0, 250},
  { &yyActionTable[35], 0, 252},
  { &yyActionTable[36], 0, 253},
  { &yyActionTable[37], 0, 254},
  { &yyActionTable[38], 0, 255},
  { &yyActionTable[39], 0, 403},
  { &yyActionTable[40], 1, 403},
  { &yyActionTable[42], 0, 403},
  { &yyActionTable[43], 0, 256},
  { &yyActionTable[44], 7, 403},
  { &yyActionTable[52], 7, 403},
  { &yyActionTable[60], 0, 403},
  { &yyActionTable[61], 0, 258},
  { &yyActionTable[62], 7, 403},
  { &yyActionTable[70], 1, 403},
  { &yyActionTable[72], 3, 403},
  { &yyActionTable[76], 1, 403},
  { &yyActionTable[78], 0, 403},
  { &yyActionTable[79], 0, 260},
  { &yyActionTable[80], 3, 403},
  { &yyActionTable[84], 1, 403},
  { &yyActionTable[86], 0, 388},
  { &yyActionTable[87], 1, 403},
  { &yyActionTable[89], 0, 390},
  { &yyActionTable[90], 1, 393},
  { &yyActionTable[92], 7, 403},
  { &yyActionTable[100], 0, 392},
  { &yyActionTable[101], 0, 397},
  { &yyActionTable[102], 0, 398},
  { &yyActionTable[103], 0, 399},
  { &yyActionTable[104], 0, 400},
  { &yyActionTable[105], 0, 401},
  { &yyActionTable[106], 0, 402},
  { &yyActionTable[107], 7, 403},
  { &yyActionTable[115], 1, 403},
  { &yyActionTable[117], 0, 394},
  { &yyActionTable[118], 7, 403},
  { &yyActionTable[126], 0, 395},
  { &yyActionTable[127], 0, 396},
  { &yyActionTable[128], 0, 389},
  { &yyActionTable[129], 0, 391},
  { &yyActionTable[130], 0, 261},
  { &yyActionTable[131], 0, 403},
  { &yyActionTable[132], 0, 403},
  { &yyActionTable[133], 3, 403},
  { &yyActionTable[137], 1, 403},
  { &yyActionTable[139], 0, 403},
  { &yyActionTable[140], 0, 262},
  { &yyActionTable[141], 0, 264},
  { &yyActionTable[142], 0, 403},
  { &yyActionTable[143], 0, 403},
  { &yyActionTable[144], 0, 403},
  { &yyActionTable[145], 1, 403},
  { &yyActionTable[147], 0, 403},
  { &yyActionTable[148], 0, 263},
  { &yyActionTable[149], 0, 259},
  { &yyActionTable[150], 0, 403},
  { &yyActionTable[151], 0, 403},
  { &yyActionTable[152], 1, 403},
  { &yyActionTable[154], 0, 403},
  { &yyActionTable[155], 3, 403},
  { &yyActionTable[159], 3, 403},
  { &yyActionTable[163], 0, 403},
  { &yyActionTable[164], 0, 270},
  { &yyActionTable[165], 15, 403},
  { &yyActionTable[181], 0, 403},
  { &yyActionTable[182], 0, 403},
  { &yyActionTable[183], 15, 403},
  { &yyActionTable[199], 3, 403},
  { &yyActionTable[203], 7, 403},
  { &yyActionTable[211], 3, 403},
  { &yyActionTable[215], 0, 403},
  { &yyActionTable[216], 3, 403},
  { &yyActionTable[220], 1, 403},
  { &yyActionTable[222], 0, 403},
  { &yyActionTable[223], 1, 403},
  { &yyActionTable[225], 0, 385},
  { &yyActionTable[226], 0, 387},
  { &yyActionTable[227], 0, 386},
  { &yyActionTable[228], 0, 403},
  { &yyActionTable[229], 3, 403},
  { &yyActionTable[233], 3, 403},
  { &yyActionTable[237], 1, 403},
  { &yyActionTable[239], 0, 403},
  { &yyActionTable[240], 0, 296},
  { &yyActionTable[241], 0, 297},
  { &yyActionTable[242], 0, 298},
  { &yyActionTable[243], 0, 299},
  { &yyActionTable[244], 0, 403},
  { &yyActionTable[245], 0, 403},
  { &yyActionTable[246], 1, 403},
  { &yyActionTable[248], 0, 403},
  { &yyActionTable[249], 0, 301},
  { &yyActionTable[250], 0, 307},
  { &yyActionTable[251], 0, 300},
  { &yyActionTable[252], 7, 403},
  { &yyActionTable[260], 3, 403},
  { &yyActionTable[264], 0, 403},
  { &yyActionTable[265], 0, 403},
  { &yyActionTable[266], 7, 403},
  { &yyActionTable[274], 3, 403},
  { &yyActionTable[278], 0, 403},
  { &yyActionTable[279], 3, 403},
  { &yyActionTable[283], 0, 403},
  { &yyActionTable[284], 0, 403},
  { &yyActionTable[285], 0, 403},
  { &yyActionTable[286], 0, 403},
  { &yyActionTable[287], 0, 403},
  { &yyActionTable[288], 3, 403},
  { &yyActionTable[292], 0, 403},
  { &yyActionTable[293], 0, 303},
  { &yyActionTable[294], 3, 403},
  { &yyActionTable[298], 0, 403},
  { &yyActionTable[299], 0, 403},
  { &yyActionTable[300], 3, 403},
  { &yyActionTable[304], 0, 403},
  { &yyActionTable[305], 0, 302},
  { &yyActionTable[306], 3, 403},
  { &yyActionTable[310], 7, 403},
  { &yyActionTable[318], 3, 403},
  { &yyActionTable[322], 0, 403},
  { &yyActionTable[323], 0, 403},
  { &yyActionTable[324], 7, 403},
  { &yyActionTable[332], 3, 403},
  { &yyActionTable[336], 0, 403},
  { &yyActionTable[337], 0, 403},
  { &yyActionTable[338], 3, 403},
  { &yyActionTable[342], 1, 403},
  { &yyActionTable[344], 0, 295},
  { &yyActionTable[345], 1, 403},
  { &yyActionTable[347], 0, 305},
  { &yyActionTable[348], 0, 306},
  { &yyActionTable[349], 0, 403},
  { &yyActionTable[350], 0, 403},
  { &yyActionTable[351], 1, 403},
  { &yyActionTable[353], 0, 403},
  { &yyActionTable[354], 1, 403},
  { &yyActionTable[356], 3, 403},
  { &yyActionTable[360], 0, 403},
  { &yyActionTable[361], 0, 308},
  { &yyActionTable[362], 0, 309},
  { &yyActionTable[363], 31, 403},
  { &yyActionTable[395], 0, 403},
  { &yyActionTable[396], 0, 403},
  { &yyActionTable[397], 31, 403},
  { &yyActionTable[429], 3, 403},
  { &yyActionTable[433], 0, 403},
  { &yyActionTable[434], 0, 403},
  { &yyActionTable[435], 7, 326},
  { &yyActionTable[443], 0, 325},
  { &yyActionTable[444], 3, 339},
  { &yyActionTable[448], 1, 336},
  { &yyActionTable[450], 0, 335},
  { &yyActionTable[451], 3, 403},
  { &yyActionTable[455], 0, 403},
  { &yyActionTable[456], 0, 345},
  { &yyActionTable[457], 0, 337},
  { &yyActionTable[458], 7, 403},
  { &yyActionTable[466], 0, 403},
  { &yyActionTable[467], 0, 344},
  { &yyActionTable[468], 0, 403},
  { &yyActionTable[469], 0, 403},
  { &yyActionTable[470], 0, 403},
  { &yyActionTable[471], 0, 403},
  { &yyActionTable[472], 1, 340},
  { &yyActionTable[474], 0, 338},
  { &yyActionTable[475], 0, 341},
  { &yyActionTable[476], 0, 327},
  { &yyActionTable[477], 3, 332},
  { &yyActionTable[481], 1, 329},
  { &yyActionTable[483], 0, 328},
  { &yyActionTable[484], 3, 403},
  { &yyActionTable[488], 0, 403},
  { &yyActionTable[489], 0, 348},
  { &yyActionTable[490], 0, 403},
  { &yyActionTable[491], 0, 403},
  { &yyActionTable[492], 0, 330},
  { &yyActionTable[493], 3, 403},
  { &yyActionTable[497], 0, 403},
  { &yyActionTable[498], 0, 347},
  { &yyActionTable[499], 1, 333},
  { &yyActionTable[501], 0, 331},
  { &yyActionTable[502], 0, 334},
  { &yyActionTable[503], 3, 403},
  { &yyActionTable[507], 0, 403},
  { &yyActionTable[508], 0, 346},
  { &yyActionTable[509], 3, 403},
  { &yyActionTable[513], 0, 403},
  { &yyActionTable[514], 0, 403},
  { &yyActionTable[515], 3, 322},
  { &yyActionTable[519], 1, 321},
  { &yyActionTable[521], 0, 318},
  { &yyActionTable[522], 1, 403},
  { &yyActionTable[524], 0, 403},
  { &yyActionTable[525], 0, 383},
  { &yyActionTable[526], 0, 320},
  { &yyActionTable[527], 1, 403},
  { &yyActionTable[529], 0, 403},
  { &yyActionTable[530], 0, 343},
  { &yyActionTable[531], 1, 323},
  { &yyActionTable[533], 0, 319},
  { &yyActionTable[534], 0, 324},
  { &yyActionTable[535], 1, 403},
  { &yyActionTable[537], 0, 403},
  { &yyActionTable[538], 0, 342},
  { &yyActionTable[539], 0, 403},
  { &yyActionTable[540], 0, 403},
  { &yyActionTable[541], 0, 403},
  { &yyActionTable[542], 7, 403},
  { &yyActionTable[550], 0, 403},
  { &yyActionTable[551], 0, 403},
  { &yyActionTable[552], 0, 358},
  { &yyActionTable[553], 7, 403},
  { &yyActionTable[561], 3, 403},
  { &yyActionTable[565], 7, 403},
  { &yyActionTable[573], 3, 403},
  { &yyActionTable[577], 0, 403},
  { &yyActionTable[578], 0, 403},
  { &yyActionTable[579], 0, 379},
  { &yyActionTable[580], 1, 403},
  { &yyActionTable[582], 1, 403},
  { &yyActionTable[584], 0, 403},
  { &yyActionTable[585], 0, 381},
  { &yyActionTable[586], 0, 403},
  { &yyActionTable[587], 0, 380},
  { &yyActionTable[588], 7, 403},
  { &yyActionTable[596], 3, 403},
  { &yyActionTable[600], 0, 403},
  { &yyActionTable[601], 0, 403},
  { &yyActionTable[602], 3, 403},
  { &yyActionTable[606], 0, 403},
  { &yyActionTable[607], 0, 403},
  { &yyActionTable[608], 0, 403},
  { &yyActionTable[609], 0, 403},
  { &yyActionTable[610], 0, 403},
  { &yyActionTable[611], 3, 403},
  { &yyActionTable[615], 7, 403},
  { &yyActionTable[623], 3, 403},
  { &yyActionTable[627], 0, 403},
  { &yyActionTable[628], 0, 403},
  { &yyActionTable[629], 7, 403},
  { &yyActionTable[637], 3, 403},
  { &yyActionTable[641], 0, 403},
  { &yyActionTable[642], 0, 403},
  { &yyActionTable[643], 0, 251},
};

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int idx;                            /* Index of top element in stack */
  int errcnt;                         /* Shifts left before out of the error */
  struct yyStackEntry *top;           /* Pointer to the top stack element */
  struct yyStackEntry stack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;

/*
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void MateParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}

/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *yyTokenName[] = {
  "$",             "ACCEPT_KW",     "AVP_OPERATOR",  "BASIC_TREE",  
  "BASIC_TREE_KW",  "CLOSE_BRACE",   "CLOSE_PARENS",  "COLONIZED",   
  "COMMA",         "CRITERIA_KW",   "DISCARD_PDU_DATA_KW",  "DONE_KW",     
  "DOTED_IP",      "DROP_UNASSIGNED_KW",  "EVERY_KW",      "EXPIRATION_KW",
  "EXTRACT_KW",    "EXTRA_KW",      "FALSE_KW",      "FLOATING",    
  "FRAME_TREE_KW",  "FROM_KW",       "FULL_TREE",     "GOG_KW",      
  "GOP_KW",        "GOP_TREE_KW",   "IDLE_TIMEOUT_KW",  "INSERT_KW",   
  "INTEGER",       "LAST_PDU_KW",   "LIFETIME_KW",   "LOOSE_KW",    
  "MATCH_KW",      "MEMBER_KW",     "NAME",          "NO_TREE_KW",  
  "NULL_TREE",     "ON_KW",         "OPEN_BRACE",    "OPEN_PARENS", 
  "PAYLOAD_KW",    "PDU_KW",        "PDU_TREE_KW",   "PIPE",        
  "PROTO_KW",      "QUOTED",        "REJECT_KW",     "REPLACE_KW",  
  "SEMICOLON",     "SHOW_TIMES_KW",  "SHOW_TREE_KW",  "SLASH",       
  "START_KW",      "STOP_KW",       "STRICT_KW",     "TRANSFORM_KW",
  "TRANSPORT_KW",  "TRUE_KW",       "accept_mode",   "action_mode", 
  "avp",           "avp_oneoff",    "avpl",          "avps",        
  "decl",          "decls",         "discard_pdu_data_statement",  "drop_unassigned_statement",
  "error",         "expiration_statement",  "extra_statement",  "extraction_statement",
  "extraction_statements",  "field",         "gog_decl",      "gog_goptree_statement",
  "gog_key_statement",  "gog_key_statements",  "gog_statements",  "gop_control_statements",
  "gop_decl",      "gop_name",      "gop_option_statements",  "gop_setup",   
  "gop_start_statement",  "gop_statements",  "gop_stop_statement",  "gop_timer_statements",
  "gop_tree_mode",  "gop_tree_statements",  "gop_tree_type",  "idle_timeout_statement",
  "last_extracted_statement",  "lifetime_statement",  "match_mode",    "mate_config", 
  "payload_statement",  "pdu_criteria_statement",  "pdu_decl",      "pdu_flag_statements",
  "pdu_name",      "pdu_setup",     "pdu_statements",  "proto_stack", 
  "show_goptree_statement",  "show_times_statement",  "time_value",    "transform",   
  "transform_blk",  "transform_blks",  "transform_body",  "transform_decl",
  "transform_list",  "transform_list_statement",  "transform_statement",  "transform_statements",
  "true_false",    "value",       
};
#define YYTRACE(X) if( yyTraceFILE ) fprintf(yyTraceFILE,"%sReduce [%s].\n",yyTracePrompt,X);
#else
#define YYTRACE(X)
#endif

/*
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to MateParser and MateParserFree.
*/
void *MateParserAlloc(void *(*mallocProc)(gulong)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( sizeof(yyParser) );
  if( pParser ){
    pParser->idx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 28:
    case 29:
    case 30:
    case 31:
    case 32:
    case 33:
    case 34:
    case 35:
    case 36:
    case 37:
    case 38:
    case 39:
    case 40:
    case 41:
    case 42:
    case 43:
    case 44:
    case 45:
    case 46:
    case 47:
    case 48:
    case 49:
    case 50:
    case 51:
    case 52:
    case 53:
    case 54:
    case 55:
    case 56:
    case 57:
#line 212 "./mate_grammar.lemon"
{ if ((yypminor->yy0)) g_free((yypminor->yy0)); }
#line 1703 "mate_grammar.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;

  if( pParser->idx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->idx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[pParser->top->major]);
  }
#endif
  yymajor = pParser->top->major;
  yy_destructor( yymajor, &pParser->top->minor);
  pParser->idx--;
  pParser->top--;
  return yymajor;
}

/*
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from MateParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void MateParserFree(
  void *p,                 /* The parser to be deleted */
  void (*freeProc)(void *) /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->idx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)(pParser);
}

/*
** Find the appropriate action for a parser given the look-ahead token.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_parser_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead             /* The look-ahead token */
){
  struct yyStateEntry *pState;   /* Appropriate entry in the state table */
  struct yyActionEntry *pAction; /* Action appropriate for the look-ahead */

  /* if( pParser->idx<0 ) return YY_NO_ACTION;  */
  pState = &yyStateTable[pParser->top->stateno];
  if( iLookAhead!=YYNOCODE ){
    pAction = &pState->hashtbl[iLookAhead & pState->mask];
    while( pAction ){
      if( pAction->lookahead==iLookAhead ) return pAction->action;
      pAction = pAction->next;
    }
  }else if( pState->mask!=0 || pState->hashtbl->lookahead!=YYNOCODE ){
    return YY_NO_ACTION;
  }
  return pState->actionDefault;
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yypParser->idx++;
  yypParser->top++;
  if( yypParser->idx>=YYSTACKDEPTH ){
     yypParser->idx--;
     yypParser->top--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->idx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
     return;
  }
  yypParser->top->stateno = yyNewState;
  yypParser->top->major = yyMajor;
  yypParser->top->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->idx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->idx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->stack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 95, 3 },
  { 65, 2 },
  { 65, 1 },
  { 64, 1 },
  { 64, 1 },
  { 64, 1 },
  { 64, 1 },
  { 111, 4 },
  { 110, 3 },
  { 109, 2 },
  { 109, 1 },
  { 108, 6 },
  { 108, 4 },
  { 108, 5 },
  { 108, 3 },
  { 108, 3 },
  { 94, 1 },
  { 94, 1 },
  { 94, 1 },
  { 59, 1 },
  { 59, 1 },
  { 98, 8 },
  { 101, 3 },
  { 102, 5 },
  { 102, 4 },
  { 102, 4 },
  { 102, 3 },
  { 102, 4 },
  { 102, 3 },
  { 102, 3 },
  { 102, 2 },
  { 102, 4 },
  { 102, 3 },
  { 102, 3 },
  { 102, 2 },
  { 102, 3 },
  { 102, 2 },
  { 102, 2 },
  { 102, 1 },
  { 99, 3 },
  { 99, 2 },
  { 99, 2 },
  { 99, 2 },
  { 99, 1 },
  { 99, 1 },
  { 99, 1 },
  { 96, 3 },
  { 97, 5 },
  { 58, 1 },
  { 58, 1 },
  { 72, 2 },
  { 72, 1 },
  { 71, 5 },
  { 67, 3 },
  { 66, 3 },
  { 92, 3 },
  { 103, 3 },
  { 103, 1 },
  { 73, 1 },
  { 80, 8 },
  { 80, 7 },
  { 83, 3 },
  { 85, 3 },
  { 85, 2 },
  { 85, 2 },
  { 85, 2 },
  { 85, 1 },
  { 85, 1 },
  { 85, 1 },
  { 79, 3 },
  { 79, 2 },
  { 79, 2 },
  { 79, 2 },
  { 79, 1 },
  { 79, 1 },
  { 79, 1 },
  { 82, 2 },
  { 82, 1 },
  { 82, 1 },
  { 87, 3 },
  { 87, 2 },
  { 87, 2 },
  { 87, 2 },
  { 87, 1 },
  { 87, 1 },
  { 87, 1 },
  { 89, 3 },
  { 89, 2 },
  { 89, 2 },
  { 89, 2 },
  { 89, 1 },
  { 89, 1 },
  { 89, 1 },
  { 84, 3 },
  { 86, 3 },
  { 104, 3 },
  { 105, 3 },
  { 69, 3 },
  { 91, 3 },
  { 93, 3 },
  { 88, 1 },
  { 88, 1 },
  { 88, 1 },
  { 88, 1 },
  { 116, 1 },
  { 116, 1 },
  { 100, 1 },
  { 106, 1 },
  { 106, 1 },
  { 74, 6 },
  { 78, 5 },
  { 78, 4 },
  { 78, 4 },
  { 78, 3 },
  { 78, 4 },
  { 78, 3 },
  { 78, 3 },
  { 78, 2 },
  { 78, 4 },
  { 78, 3 },
  { 78, 3 },
  { 78, 2 },
  { 78, 3 },
  { 78, 2 },
  { 78, 2 },
  { 78, 1 },
  { 75, 3 },
  { 90, 1 },
  { 90, 1 },
  { 90, 1 },
  { 77, 2 },
  { 77, 1 },
  { 76, 4 },
  { 81, 1 },
  { 70, 3 },
  { 113, 3 },
  { 112, 3 },
  { 112, 1 },
  { 107, 1 },
  { 62, 3 },
  { 62, 2 },
  { 63, 3 },
  { 63, 1 },
  { 60, 3 },
  { 60, 1 },
  { 60, 4 },
  { 61, 3 },
  { 61, 1 },
  { 117, 1 },
  { 117, 1 },
  { 117, 1 },
  { 117, 1 },
  { 117, 1 },
  { 117, 1 },
};

static void yy_accept(
  yyParser *yypParser           /* The parser */
  MateParserANSIARGDECL _U_          /* Extra arguments (if any) */
);  /* Forward declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
  MateParserANSIARGDECL
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  struct yyStackEntry *yymsp;     /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  yymsp = yypParser->top;
  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **     YYTRACE("<text of the rule>");
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0:
        YYTRACE("mate_config ::= decls DONE_KW SEMICOLON")
        /* No destructor defined for decls */
  yy_destructor(11,&yymsp[-1].minor);
  yy_destructor(48,&yymsp[0].minor);
        break;
      case 1:
        YYTRACE("decls ::= decls decl")
        /* No destructor defined for decls */
        /* No destructor defined for decl */
        break;
      case 2:
        YYTRACE("decls ::= decl")
        /* No destructor defined for decl */
        break;
      case 3:
        YYTRACE("decl ::= pdu_decl")
        /* No destructor defined for pdu_decl */
        break;
      case 4:
        YYTRACE("decl ::= gop_decl")
        /* No destructor defined for gop_decl */
        break;
      case 5:
        YYTRACE("decl ::= gog_decl")
        /* No destructor defined for gog_decl */
        break;
      case 6:
        YYTRACE("decl ::= transform_decl")
        /* No destructor defined for transform_decl */
        break;
      case 7:
        YYTRACE("transform_decl ::= TRANSFORM_KW NAME transform_body SEMICOLON")
#line 300 "./mate_grammar.lemon"
{
	AVPL_Transf* c;

	if ( g_hash_table_lookup(mc->transfs,yymsp[-2].minor.yy0) ) {
		configuration_error(mc,"yygotominor.yy63 transformation called '%s' exists already",yymsp[-2].minor.yy0);
	}

	for ( c = yymsp[-1].minor.yy63; c; c = c->next )
		c->name = g_strdup(yymsp[-2].minor.yy0);
	
	g_hash_table_insert(mc->transfs,yymsp[-1].minor.yy63->name,yymsp[-1].minor.yy63);
	
	yygotominor.yy63 = NULL;
}
#line 2065 "mate_grammar.c"
  yy_destructor(55,&yymsp[-3].minor);
  yy_destructor(48,&yymsp[0].minor);
        break;
      case 8:
        YYTRACE("transform_body ::= OPEN_BRACE transform_blks CLOSE_BRACE")
#line 315 "./mate_grammar.lemon"
{ yygotominor.yy63 = yymsp[-1].minor.yy63; }
#line 2073 "mate_grammar.c"
  yy_destructor(38,&yymsp[-2].minor);
  yy_destructor(5,&yymsp[0].minor);
        break;
      case 9:
        YYTRACE("transform_blks ::= transform_blks transform_blk")
#line 317 "./mate_grammar.lemon"
{
	AVPL_Transf* c;
	
	for ( c = yymsp[-1].minor.yy63; c->next; c = c->next ) ;
	c->next = yymsp[0].minor.yy63;
	yygotominor.yy63 = yymsp[-1].minor.yy63;
}
#line 2087 "mate_grammar.c"
        break;
      case 10:
        YYTRACE("transform_blks ::= transform_blk")
#line 325 "./mate_grammar.lemon"
{ yygotominor.yy63 = yymsp[0].minor.yy63; }
#line 2093 "mate_grammar.c"
        break;
      case 11:
        YYTRACE("transform_blk ::= MATCH_KW match_mode avpl action_mode avpl SEMICOLON")
#line 327 "./mate_grammar.lemon"
{
	yygotominor.yy63 = new_transform_elem(yymsp[-3].minor.yy222,yymsp[-1].minor.yy222,yymsp[-4].minor.yy14,yymsp[-2].minor.yy15);
}
#line 2101 "mate_grammar.c"
  yy_destructor(32,&yymsp[-5].minor);
  yy_destructor(48,&yymsp[0].minor);
        break;
      case 12:
        YYTRACE("transform_blk ::= MATCH_KW match_mode avpl SEMICOLON")
#line 331 "./mate_grammar.lemon"
{
	yygotominor.yy63 = new_transform_elem(yymsp[-1].minor.yy222,new_avpl(""),yymsp[-2].minor.yy14,AVPL_INSERT);
}
#line 2111 "mate_grammar.c"
  yy_destructor(32,&yymsp[-3].minor);
  yy_destructor(48,&yymsp[0].minor);
        break;
      case 13:
        YYTRACE("transform_blk ::= MATCH_KW avpl action_mode avpl SEMICOLON")
#line 335 "./mate_grammar.lemon"
{
	yygotominor.yy63 = new_transform_elem(yymsp[-3].minor.yy222,yymsp[-1].minor.yy222,AVPL_STRICT,yymsp[-2].minor.yy15);
}
#line 2121 "mate_grammar.c"
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(48,&yymsp[0].minor);
        break;
      case 14:
        YYTRACE("transform_blk ::= action_mode avpl SEMICOLON")
#line 339 "./mate_grammar.lemon"
{
	yygotominor.yy63 = new_transform_elem(new_avpl(""),yymsp[-1].minor.yy222,AVPL_NO_MATCH,yymsp[-2].minor.yy15);
}
#line 2131 "mate_grammar.c"
  yy_destructor(48,&yymsp[0].minor);
        break;
      case 15:
        YYTRACE("transform_blk ::= MATCH_KW avpl SEMICOLON")
#line 343 "./mate_grammar.lemon"
{
	yygotominor.yy63 = new_transform_elem(yymsp[-1].minor.yy222,new_avpl(""),AVPL_STRICT,AVPL_INSERT);
}
#line 2140 "mate_grammar.c"
  yy_destructor(32,&yymsp[-2].minor);
  yy_destructor(48,&yymsp[0].minor);
        break;
      case 16:
        YYTRACE("match_mode ::= STRICT_KW")
#line 347 "./mate_grammar.lemon"
{ yygotominor.yy14 = AVPL_STRICT; }
#line 2148 "mate_grammar.c"
  yy_destructor(54,&yymsp[0].minor);
        break;
      case 17:
        YYTRACE("match_mode ::= EVERY_KW")
#line 348 "./mate_grammar.lemon"
{ yygotominor.yy14 = AVPL_EVERY; }
#line 2155 "mate_grammar.c"
  yy_destructor(14,&yymsp[0].minor);
        break;
      case 18:
        YYTRACE("match_mode ::= LOOSE_KW")
#line 349 "./mate_grammar.lemon"
{ yygotominor.yy14 = AVPL_LOOSE; }
#line 2162 "mate_grammar.c"
  yy_destructor(31,&yymsp[0].minor);
        break;
      case 19:
        YYTRACE("action_mode ::= REPLACE_KW")
#line 351 "./mate_grammar.lemon"
{ yygotominor.yy15 = AVPL_REPLACE; }
#line 2169 "mate_grammar.c"
  yy_destructor(47,&yymsp[0].minor);
        break;
      case 20:
        YYTRACE("action_mode ::= INSERT_KW")
#line 352 "./mate_grammar.lemon"
{ yygotominor.yy15 = AVPL_INSERT; }
#line 2176 "mate_grammar.c"
  yy_destructor(27,&yymsp[0].minor);
        break;
      case 21:
        YYTRACE("pdu_decl ::= PDU_KW NAME PROTO_KW field TRANSPORT_KW proto_stack pdu_setup SEMICOLON")
#line 357 "./mate_grammar.lemon"
{
	mate_cfg_pdu* cfg  = new_pducfg(yymsp[-6].minor.yy0);
	extraction_t *extraction, *next_extraction;
	GPtrArray* transport_stack = g_ptr_array_new();
	int i;
	
	if (! cfg ) configuration_error(mc,"could not create Pdu %s.",yymsp[-6].minor.yy0);

	cfg->hfid_proto = yymsp[-4].minor.yy42->id;

	cfg->last_extracted = (yymsp[-1].minor.yy207->flags) ? yymsp[-1].minor.yy207->flags->last_extracted : mc->defaults.pdu.last_extracted;
	cfg->discard = (yymsp[-1].minor.yy207->flags) ? yymsp[-1].minor.yy207->flags->discard : mc->defaults.pdu.discard;
	cfg->drop_unassigned = (yymsp[-1].minor.yy207->flags) ? yymsp[-1].minor.yy207->flags->drop_unassigned : mc->defaults.pdu.drop_unassigned;
	
	g_string_sprintfa(mc->protos_filter,"||%s",yymsp[-4].minor.yy42->abbrev);

	/* flip the transport_stack */
	for (i = yymsp[-2].minor.yy199->len - 1; yymsp[-2].minor.yy199->len; i--) {
		g_ptr_array_add(transport_stack,g_ptr_array_remove_index(yymsp[-2].minor.yy199,i));
	}
	
	g_ptr_array_free(yymsp[-2].minor.yy199,FALSE);
	
	cfg->transport_ranges = transport_stack;
	cfg->payload_ranges = yymsp[-1].minor.yy207->payload;
	
	if (yymsp[-1].minor.yy207->criteria) {
		cfg->criterium = yymsp[-1].minor.yy207->criteria->criterium_avpl;
		cfg->criterium_match_mode = yymsp[-1].minor.yy207->criteria->criterium_match_mode;
		cfg->criterium_accept_mode = yymsp[-1].minor.yy207->criteria->criterium_accept_mode;
	}
	
	cfg->transforms = yymsp[-1].minor.yy207->transforms ? yymsp[-1].minor.yy207->transforms : g_ptr_array_new();
	
	for (extraction = yymsp[-1].minor.yy207->extraction; extraction; extraction = next_extraction) {
		next_extraction = extraction->next;
		
		if ( ! add_hfid(extraction->hfi, extraction->as, cfg->hfids_attr) ) {
			configuration_error(mc,"MATE: failed to create extraction rule '%s'",extraction->as);
		}
		
		g_free(extraction);
	}
}
#line 2226 "mate_grammar.c"
  yy_destructor(41,&yymsp[-7].minor);
  yy_destructor(44,&yymsp[-5].minor);
  yy_destructor(56,&yymsp[-3].minor);
  yy_destructor(48,&yymsp[0].minor);
        break;
      case 22:
        YYTRACE("pdu_setup ::= OPEN_BRACE pdu_statements CLOSE_BRACE")
#line 402 "./mate_grammar.lemon"
{ yygotominor.yy207 = yymsp[-1].minor.yy207; }
#line 2236 "mate_grammar.c"
  yy_destructor(38,&yymsp[-2].minor);
  yy_destructor(5,&yymsp[0].minor);
        break;
      case 23:
        YYTRACE("pdu_statements ::= payload_statement pdu_flag_statements extraction_statements pdu_criteria_statement transform_list_statement")
#line 405 "./mate_grammar.lemon"
{ yygotominor.yy207 = do_pdu_statements(yymsp[-4].minor.yy199,yymsp[-3].minor.yy187,yymsp[-2].minor.yy135,yymsp[-1].minor.yy45,yymsp[0].minor.yy199); }
#line 2244 "mate_grammar.c"
        break;
      case 24:
        YYTRACE("pdu_statements ::= payload_statement pdu_flag_statements extraction_statements pdu_criteria_statement")
#line 406 "./mate_grammar.lemon"
{ yygotominor.yy207 = do_pdu_statements(yymsp[-3].minor.yy199,yymsp[-2].minor.yy187,yymsp[-1].minor.yy135,yymsp[0].minor.yy45,NULL); }
#line 2250 "mate_grammar.c"
        break;
      case 25:
        YYTRACE("pdu_statements ::= payload_statement pdu_flag_statements extraction_statements transform_list_statement")
#line 407 "./mate_grammar.lemon"
{ yygotominor.yy207 = do_pdu_statements(yymsp[-3].minor.yy199,yymsp[-2].minor.yy187,yymsp[-1].minor.yy135,NULL,yymsp[0].minor.yy199); }
#line 2256 "mate_grammar.c"
        break;
      case 26:
        YYTRACE("pdu_statements ::= payload_statement pdu_flag_statements extraction_statements")
#line 408 "./mate_grammar.lemon"
{ yygotominor.yy207 = do_pdu_statements(yymsp[-2].minor.yy199,yymsp[-1].minor.yy187,yymsp[0].minor.yy135,NULL,NULL); }
#line 2262 "mate_grammar.c"
        break;
      case 27:
        YYTRACE("pdu_statements ::= payload_statement extraction_statements pdu_criteria_statement transform_list_statement")
#line 409 "./mate_grammar.lemon"
{ yygotominor.yy207 = do_pdu_statements(yymsp[-3].minor.yy199,NULL,yymsp[-2].minor.yy135,yymsp[-1].minor.yy45,yymsp[0].minor.yy199); }
#line 2268 "mate_grammar.c"
        break;
      case 28:
        YYTRACE("pdu_statements ::= payload_statement extraction_statements pdu_criteria_statement")
#line 410 "./mate_grammar.lemon"
{ yygotominor.yy207 = do_pdu_statements(yymsp[-2].minor.yy199,NULL,yymsp[-1].minor.yy135,yymsp[0].minor.yy45,NULL); }
#line 2274 "mate_grammar.c"
        break;
      case 29:
        YYTRACE("pdu_statements ::= payload_statement extraction_statements transform_list_statement")
#line 411 "./mate_grammar.lemon"
{ yygotominor.yy207 = do_pdu_statements(yymsp[-2].minor.yy199,NULL,yymsp[-1].minor.yy135,NULL,yymsp[0].minor.yy199); }
#line 2280 "mate_grammar.c"
        break;
      case 30:
        YYTRACE("pdu_statements ::= payload_statement extraction_statements")
#line 412 "./mate_grammar.lemon"
{ yygotominor.yy207 = do_pdu_statements(yymsp[-1].minor.yy199,NULL,yymsp[0].minor.yy135,NULL,NULL); }
#line 2286 "mate_grammar.c"
        break;
      case 31:
        YYTRACE("pdu_statements ::= pdu_flag_statements extraction_statements pdu_criteria_statement transform_list_statement")
#line 413 "./mate_grammar.lemon"
{ yygotominor.yy207 = do_pdu_statements(NULL,yymsp[-3].minor.yy187,yymsp[-2].minor.yy135,yymsp[-1].minor.yy45,yymsp[0].minor.yy199); }
#line 2292 "mate_grammar.c"
        break;
      case 32:
        YYTRACE("pdu_statements ::= pdu_flag_statements extraction_statements pdu_criteria_statement")
#line 414 "./mate_grammar.lemon"
{ yygotominor.yy207 = do_pdu_statements(NULL,yymsp[-2].minor.yy187,yymsp[-1].minor.yy135,yymsp[0].minor.yy45,NULL); }
#line 2298 "mate_grammar.c"
        break;
      case 33:
        YYTRACE("pdu_statements ::= pdu_flag_statements extraction_statements transform_list_statement")
#line 415 "./mate_grammar.lemon"
{ yygotominor.yy207 = do_pdu_statements(NULL,yymsp[-2].minor.yy187,yymsp[-1].minor.yy135,NULL,yymsp[0].minor.yy199); }
#line 2304 "mate_grammar.c"
        break;
      case 34:
        YYTRACE("pdu_statements ::= pdu_flag_statements extraction_statements")
#line 416 "./mate_grammar.lemon"
{ yygotominor.yy207 = do_pdu_statements(NULL,yymsp[-1].minor.yy187,yymsp[0].minor.yy135,NULL,NULL); }
#line 2310 "mate_grammar.c"
        break;
      case 35:
        YYTRACE("pdu_statements ::= extraction_statements pdu_criteria_statement transform_list_statement")
#line 417 "./mate_grammar.lemon"
{ yygotominor.yy207 = do_pdu_statements(NULL,NULL,yymsp[-2].minor.yy135,yymsp[-1].minor.yy45,yymsp[0].minor.yy199); }
#line 2316 "mate_grammar.c"
        break;
      case 36:
        YYTRACE("pdu_statements ::= extraction_statements pdu_criteria_statement")
#line 418 "./mate_grammar.lemon"
{ yygotominor.yy207 = do_pdu_statements(NULL,NULL,yymsp[-1].minor.yy135,yymsp[0].minor.yy45,NULL); }
#line 2322 "mate_grammar.c"
        break;
      case 37:
        YYTRACE("pdu_statements ::= extraction_statements transform_list_statement")
#line 419 "./mate_grammar.lemon"
{ yygotominor.yy207 = do_pdu_statements(NULL,NULL,yymsp[-1].minor.yy135,NULL,yymsp[0].minor.yy199); }
#line 2328 "mate_grammar.c"
        break;
      case 38:
        YYTRACE("pdu_statements ::= extraction_statements")
#line 420 "./mate_grammar.lemon"
{ yygotominor.yy207 = do_pdu_statements(NULL,NULL,yymsp[0].minor.yy135,NULL,NULL); }
#line 2334 "mate_grammar.c"
        break;
      case 39:
        YYTRACE("pdu_flag_statements ::= drop_unassigned_statement discard_pdu_data_statement last_extracted_statement")
#line 422 "./mate_grammar.lemon"
{
	yygotominor.yy187 = g_malloc(sizeof(pdu_flags_t));
	
	yygotominor.yy187->drop_unassigned = yymsp[-2].minor.yy32;
	yygotominor.yy187->discard = yymsp[-1].minor.yy32;
	yygotominor.yy187->last_extracted = yymsp[0].minor.yy32;
}
#line 2346 "mate_grammar.c"
        break;
      case 40:
        YYTRACE("pdu_flag_statements ::= drop_unassigned_statement discard_pdu_data_statement")
#line 430 "./mate_grammar.lemon"
{
	yygotominor.yy187 = g_malloc(sizeof(pdu_flags_t));
	
	yygotominor.yy187->drop_unassigned = yymsp[-1].minor.yy32;
	yygotominor.yy187->discard = yymsp[0].minor.yy32;
	yygotominor.yy187->last_extracted = mc->defaults.pdu.last_extracted;
}
#line 2358 "mate_grammar.c"
        break;
      case 41:
        YYTRACE("pdu_flag_statements ::= drop_unassigned_statement last_extracted_statement")
#line 438 "./mate_grammar.lemon"
{
	yygotominor.yy187 = g_malloc(sizeof(pdu_flags_t));
	
	yygotominor.yy187->drop_unassigned = yymsp[-1].minor.yy32;
	yygotominor.yy187->discard = mc->defaults.pdu.discard;
	yygotominor.yy187->last_extracted = yymsp[0].minor.yy32;
}
#line 2370 "mate_grammar.c"
        break;
      case 42:
        YYTRACE("pdu_flag_statements ::= discard_pdu_data_statement last_extracted_statement")
#line 446 "./mate_grammar.lemon"
{
	yygotominor.yy187 = g_malloc(sizeof(pdu_flags_t));
	
	yygotominor.yy187->drop_unassigned = mc->defaults.pdu.drop_unassigned;
	yygotominor.yy187->discard = yymsp[-1].minor.yy32;
	yygotominor.yy187->last_extracted = yymsp[0].minor.yy32;
}
#line 2382 "mate_grammar.c"
        break;
      case 43:
        YYTRACE("pdu_flag_statements ::= last_extracted_statement")
#line 454 "./mate_grammar.lemon"
{
	yygotominor.yy187 = g_malloc(sizeof(pdu_flags_t));
	
	yygotominor.yy187->drop_unassigned = mc->defaults.pdu.drop_unassigned;
	yygotominor.yy187->discard = mc->defaults.pdu.discard;
	yygotominor.yy187->last_extracted = yymsp[0].minor.yy32;
}
#line 2394 "mate_grammar.c"
        break;
      case 44:
        YYTRACE("pdu_flag_statements ::= discard_pdu_data_statement")
#line 462 "./mate_grammar.lemon"
{
	yygotominor.yy187 = g_malloc(sizeof(pdu_flags_t));
	
	yygotominor.yy187->drop_unassigned = mc->defaults.pdu.drop_unassigned;
	yygotominor.yy187->discard = yymsp[0].minor.yy32;
	yygotominor.yy187->last_extracted = mc->defaults.pdu.last_extracted;
}
#line 2406 "mate_grammar.c"
        break;
      case 45:
        YYTRACE("pdu_flag_statements ::= drop_unassigned_statement")
#line 470 "./mate_grammar.lemon"
{
	yygotominor.yy187 = g_malloc(sizeof(pdu_flags_t));
	
	yygotominor.yy187->drop_unassigned = yymsp[0].minor.yy32;
	yygotominor.yy187->discard = mc->defaults.pdu.discard;
	yygotominor.yy187->last_extracted = mc->defaults.pdu.last_extracted;
}
#line 2418 "mate_grammar.c"
        break;
      case 46:
        YYTRACE("payload_statement ::= PAYLOAD_KW proto_stack SEMICOLON")
#line 479 "./mate_grammar.lemon"
{ yygotominor.yy199 = yymsp[-1].minor.yy199; }
#line 2424 "mate_grammar.c"
  yy_destructor(40,&yymsp[-2].minor);
  yy_destructor(48,&yymsp[0].minor);
        break;
      case 47:
        YYTRACE("pdu_criteria_statement ::= CRITERIA_KW accept_mode match_mode avpl SEMICOLON")
#line 481 "./mate_grammar.lemon"
{
	yygotominor.yy45 = g_malloc(sizeof(pdu_criteria_t));
	yygotominor.yy45->criterium_avpl = yymsp[-1].minor.yy222;
	yygotominor.yy45->criterium_match_mode = yymsp[-2].minor.yy14;
	yygotominor.yy45->criterium_accept_mode = yymsp[-3].minor.yy102;
}
#line 2437 "mate_grammar.c"
  yy_destructor(9,&yymsp[-4].minor);
  yy_destructor(48,&yymsp[0].minor);
        break;
      case 48:
        YYTRACE("accept_mode ::= ACCEPT_KW")
#line 488 "./mate_grammar.lemon"
{ yygotominor.yy102 = ACCEPT_MODE; }
#line 2445 "mate_grammar.c"
  yy_destructor(1,&yymsp[0].minor);
        break;
      case 49:
        YYTRACE("accept_mode ::= REJECT_KW")
#line 489 "./mate_grammar.lemon"
{ yygotominor.yy102 = REJECT_MODE; }
#line 2452 "mate_grammar.c"
  yy_destructor(46,&yymsp[0].minor);
        break;
      case 50:
        YYTRACE("extraction_statements ::= extraction_statements extraction_statement")
#line 491 "./mate_grammar.lemon"
{
	yygotominor.yy135 = yymsp[-1].minor.yy135;
	yygotominor.yy135->last->next = yymsp[0].minor.yy135;
	yygotominor.yy135->last = yymsp[0].minor.yy135;
}
#line 2463 "mate_grammar.c"
        break;
      case 51:
        YYTRACE("extraction_statements ::= extraction_statement")
#line 497 "./mate_grammar.lemon"
{
	yygotominor.yy135 = yymsp[0].minor.yy135;
	yygotominor.yy135->last = yygotominor.yy135;
}
#line 2472 "mate_grammar.c"
        break;
      case 52:
        YYTRACE("extraction_statement ::= EXTRACT_KW NAME FROM_KW field SEMICOLON")
#line 502 "./mate_grammar.lemon"
{
	yygotominor.yy135 = g_malloc(sizeof(extraction_t));
	yygotominor.yy135->as = yymsp[-3].minor.yy0;
	yygotominor.yy135->hfi = yymsp[-1].minor.yy42;
	yygotominor.yy135->next = yygotominor.yy135->last = NULL;
}
#line 2483 "mate_grammar.c"
  yy_destructor(16,&yymsp[-4].minor);
  yy_destructor(21,&yymsp[-2].minor);
  yy_destructor(48,&yymsp[0].minor);
        break;
      case 53:
        YYTRACE("drop_unassigned_statement ::= DROP_UNASSIGNED_KW true_false SEMICOLON")
#line 510 "./mate_grammar.lemon"
{ yygotominor.yy32 = yymsp[-1].minor.yy32; }
#line 2492 "mate_grammar.c"
  yy_destructor(13,&yymsp[-2].minor);
  yy_destructor(48,&yymsp[0].minor);
        break;
      case 54:
        YYTRACE("discard_pdu_data_statement ::= DISCARD_PDU_DATA_KW true_false SEMICOLON")
#line 512 "./mate_grammar.lemon"
{ yygotominor.yy32 = yymsp[-1].minor.yy32; }
#line 2500 "mate_grammar.c"
  yy_destructor(10,&yymsp[-2].minor);
  yy_destructor(48,&yymsp[0].minor);
        break;
      case 55:
        YYTRACE("last_extracted_statement ::= LAST_PDU_KW true_false SEMICOLON")
#line 514 "./mate_grammar.lemon"
{ yygotominor.yy32 = yymsp[-1].minor.yy32; }
#line 2508 "mate_grammar.c"
  yy_destructor(29,&yymsp[-2].minor);
  yy_destructor(48,&yymsp[0].minor);
        break;
      case 56:
        YYTRACE("proto_stack ::= proto_stack SLASH field")
#line 516 "./mate_grammar.lemon"
{
	int* hfidp = g_malloc(sizeof(int));

	g_string_sprintfa(mc->fields_filter,"||%s",yymsp[0].minor.yy42->abbrev);
	
	*hfidp = yymsp[0].minor.yy42->id;
	g_ptr_array_add(yymsp[-2].minor.yy199,hfidp);
	yygotominor.yy199 = yymsp[-2].minor.yy199;
}
#line 2524 "mate_grammar.c"
  yy_destructor(51,&yymsp[-1].minor);
        break;
      case 57:
        YYTRACE("proto_stack ::= field")
#line 526 "./mate_grammar.lemon"
{
	int* hfidp = g_malloc(sizeof(int));
	*hfidp = yymsp[0].minor.yy42->id;
	
	g_string_sprintfa(mc->fields_filter,"||%s",yymsp[0].minor.yy42->abbrev);

	yygotominor.yy199 = g_ptr_array_new();
	g_ptr_array_add(yygotominor.yy199,hfidp);
}
#line 2539 "mate_grammar.c"
        break;
      case 58:
        YYTRACE("field ::= NAME")
#line 536 "./mate_grammar.lemon"
{
	yygotominor.yy42 = proto_registrar_get_byname(yymsp[0].minor.yy0);
}
#line 2547 "mate_grammar.c"
        break;
      case 59:
        YYTRACE("gop_decl ::= GOP_KW NAME ON_KW pdu_name MATCH_KW avpl gop_setup SEMICOLON")
#line 545 "./mate_grammar.lemon"
{
	mate_cfg_gop* cfg;
	
	if (g_hash_table_lookup(mc->gopcfgs,yymsp[-6].minor.yy0)) configuration_error(mc,"yygotominor.yy0 Gop Named '%s' exists already.",yymsp[-6].minor.yy0);
	if (g_hash_table_lookup(mc->gops_by_pduname,yymsp[-4].minor.yy208) ) configuration_error(mc,"Gop for Pdu '%s' exists already",yymsp[-4].minor.yy208);

	cfg = new_gopcfg(yymsp[-6].minor.yy0);
	g_hash_table_insert(mc->gops_by_pduname,yymsp[-4].minor.yy208,cfg);
	g_hash_table_insert(mc->gopcfgs,cfg->name,cfg);
	cfg->on_pdu = yymsp[-4].minor.yy208;

	cfg->drop_unassigned = (yymsp[-1].minor.yy1->options && yymsp[-1].minor.yy1->options->tree_sts) ? yymsp[-1].minor.yy1->options->tree_sts->drop_unassigned : mc->defaults.gop.drop_unassigned;
	cfg->show_times = (yymsp[-1].minor.yy1->options && yymsp[-1].minor.yy1->options->tree_sts) ? yymsp[-1].minor.yy1->options->tree_sts->show_times : mc->defaults.gop.show_times;
	cfg->pdu_tree_mode = (yymsp[-1].minor.yy1->options && yymsp[-1].minor.yy1->options->tree_sts) ? yymsp[-1].minor.yy1->options->tree_sts->pdu_tree_mode : mc->defaults.gop.pdu_tree_mode;
	
	cfg->expiration = (yymsp[-1].minor.yy1->options && yymsp[-1].minor.yy1->options->timer_sts) ? yymsp[-1].minor.yy1->options->timer_sts->expiration : mc->defaults.gop.expiration;
	cfg->idle_timeout = (yymsp[-1].minor.yy1->options && yymsp[-1].minor.yy1->options->timer_sts) ? yymsp[-1].minor.yy1->options->timer_sts->idle_timeout : mc->defaults.gop.idle_timeout;
	cfg->lifetime = (yymsp[-1].minor.yy1->options && yymsp[-1].minor.yy1->options->timer_sts) ? yymsp[-1].minor.yy1->options->timer_sts->lifetime : mc->defaults.gop.lifetime;
	
	cfg->start = yymsp[-1].minor.yy1->control ? yymsp[-1].minor.yy1->control->start : NULL;
	cfg->stop = yymsp[-1].minor.yy1->control ? yymsp[-1].minor.yy1->control->stop : NULL;
	cfg->key = yymsp[-2].minor.yy222;
	
	cfg->transforms = (yymsp[-1].minor.yy1->transforms) ? yymsp[-1].minor.yy1->transforms : g_ptr_array_new();
	
	if (yymsp[-1].minor.yy1->control && yymsp[-1].minor.yy1->control->extras) {
		merge_avpl(cfg->extra,yymsp[-1].minor.yy1->control->extras,TRUE);
		delete_avpl(yymsp[-1].minor.yy1->control->extras,TRUE);
	}
	
	if (yymsp[-1].minor.yy1->control) g_free(yymsp[-1].minor.yy1->control);
	
	if (yymsp[-1].minor.yy1->options) {
		if (yymsp[-1].minor.yy1->options->tree_sts) g_free(yymsp[-1].minor.yy1->options->tree_sts);
		if (yymsp[-1].minor.yy1->options->timer_sts) g_free(yymsp[-1].minor.yy1->options->timer_sts);
		if (yymsp[-1].minor.yy1->options) g_free(yymsp[-1].minor.yy1->options);
	}
	
	g_free(yymsp[-1].minor.yy1);
}
#line 2592 "mate_grammar.c"
  yy_destructor(24,&yymsp[-7].minor);
  yy_destructor(37,&yymsp[-5].minor);
  yy_destructor(32,&yymsp[-3].minor);
  yy_destructor(48,&yymsp[0].minor);
        break;
      case 60:
        YYTRACE("gop_decl ::= GOP_KW NAME ON_KW pdu_name MATCH_KW avpl SEMICOLON")
#line 587 "./mate_grammar.lemon"
{
	mate_cfg_gop* cfg;
	
	if (g_hash_table_lookup(mc->gopcfgs,yymsp[-5].minor.yy0)) configuration_error(mc,"yygotominor.yy0 Gop Named '%s' exists already.",yymsp[-5].minor.yy0);
	if (g_hash_table_lookup(mc->gops_by_pduname,yymsp[-3].minor.yy208) ) configuration_error(mc,"Gop for Pdu '%s' exists already",yymsp[-3].minor.yy208);
	
	cfg = new_gopcfg(yymsp[-5].minor.yy0);
	g_hash_table_insert(mc->gops_by_pduname,yymsp[-3].minor.yy208,cfg);
	g_hash_table_insert(mc->gopcfgs,cfg->name,cfg);
	
	cfg->drop_unassigned =  mc->defaults.gop.drop_unassigned;
	cfg->show_times = mc->defaults.gop.show_times;
	cfg->pdu_tree_mode = mc->defaults.gop.pdu_tree_mode;
	
	cfg->expiration = mc->defaults.gop.expiration;
	cfg->idle_timeout = mc->defaults.gop.idle_timeout;
	cfg->lifetime = mc->defaults.gop.lifetime;
	
	cfg->start = NULL;
	cfg->stop = NULL;
	cfg->key = yymsp[-1].minor.yy222;
	
	cfg->transforms = g_ptr_array_new();
}
#line 2625 "mate_grammar.c"
  yy_destructor(24,&yymsp[-6].minor);
  yy_destructor(37,&yymsp[-4].minor);
  yy_destructor(32,&yymsp[-2].minor);
  yy_destructor(48,&yymsp[0].minor);
        break;
      case 61:
        YYTRACE("gop_setup ::= OPEN_BRACE gop_statements CLOSE_BRACE")
#line 612 "./mate_grammar.lemon"
{
	yygotominor.yy1 = yymsp[-1].minor.yy1;
}
#line 2637 "mate_grammar.c"
  yy_destructor(38,&yymsp[-2].minor);
  yy_destructor(5,&yymsp[0].minor);
        break;
      case 62:
        YYTRACE("gop_statements ::= gop_control_statements gop_option_statements transform_list_statement")
#line 616 "./mate_grammar.lemon"
{
  yygotominor.yy1 = g_malloc(sizeof(gop_statement));
  
  yygotominor.yy1->control = yymsp[-2].minor.yy173;
  yygotominor.yy1->options = yymsp[-1].minor.yy201;
  yygotominor.yy1->transforms = yymsp[0].minor.yy199;
}
#line 2651 "mate_grammar.c"
        break;
      case 63:
        YYTRACE("gop_statements ::= gop_option_statements transform_list_statement")
#line 624 "./mate_grammar.lemon"
{
  yygotominor.yy1 = g_malloc(sizeof(gop_statement));
  
  yygotominor.yy1->control = NULL;
  yygotominor.yy1->options = yymsp[-1].minor.yy201;
  yygotominor.yy1->transforms = yymsp[0].minor.yy199;
}
#line 2663 "mate_grammar.c"
        break;
      case 64:
        YYTRACE("gop_statements ::= gop_control_statements transform_list_statement")
#line 632 "./mate_grammar.lemon"
{
  yygotominor.yy1 = g_malloc(sizeof(gop_statement));
  
  yygotominor.yy1->control = yymsp[-1].minor.yy173;
  yygotominor.yy1->options = NULL;
  yygotominor.yy1->transforms = yymsp[0].minor.yy199;
}
#line 2675 "mate_grammar.c"
        break;
      case 65:
        YYTRACE("gop_statements ::= gop_control_statements gop_option_statements")
#line 640 "./mate_grammar.lemon"
{
  yygotominor.yy1 = g_malloc(sizeof(gop_statement));
  
  yygotominor.yy1->control = yymsp[-1].minor.yy173;
  yygotominor.yy1->options = yymsp[0].minor.yy201;
  yygotominor.yy1->transforms = NULL;
}
#line 2687 "mate_grammar.c"
        break;
      case 66:
        YYTRACE("gop_statements ::= gop_option_statements")
#line 649 "./mate_grammar.lemon"
{
  yygotominor.yy1 = g_malloc(sizeof(gop_statement));
  
  yygotominor.yy1->control = NULL;
  yygotominor.yy1->options = yymsp[0].minor.yy201;
  yygotominor.yy1->transforms = NULL;
}
#line 2699 "mate_grammar.c"
        break;
      case 67:
        YYTRACE("gop_statements ::= gop_control_statements")
#line 657 "./mate_grammar.lemon"
{
  yygotominor.yy1 = g_malloc(sizeof(gop_statement));
  
  yygotominor.yy1->control = yymsp[0].minor.yy173;
  yygotominor.yy1->options = NULL;
  yygotominor.yy1->transforms = NULL;
}
#line 2711 "mate_grammar.c"
        break;
      case 68:
        YYTRACE("gop_statements ::= transform_list_statement")
#line 665 "./mate_grammar.lemon"
{
  yygotominor.yy1 = g_malloc(sizeof(gop_statement));
  
  yygotominor.yy1->control = NULL;
  yygotominor.yy1->options = NULL;
  yygotominor.yy1->transforms = yymsp[0].minor.yy199;
}
#line 2723 "mate_grammar.c"
        break;
      case 69:
        YYTRACE("gop_control_statements ::= gop_start_statement gop_stop_statement extra_statement")
#line 676 "./mate_grammar.lemon"
{
	yygotominor.yy173 = g_malloc(sizeof(gop_control_statement));
	
	yygotominor.yy173->start = yymsp[-2].minor.yy222;
	yygotominor.yy173->stop = yymsp[-1].minor.yy222;
    yygotominor.yy173->extras = yymsp[0].minor.yy222;
}
#line 2735 "mate_grammar.c"
        break;
      case 70:
        YYTRACE("gop_control_statements ::= gop_stop_statement extra_statement")
#line 685 "./mate_grammar.lemon"
{
	yygotominor.yy173 = g_malloc(sizeof(gop_control_statement));
	
	yygotominor.yy173->start = NULL;
	yygotominor.yy173->stop = yymsp[-1].minor.yy222;
    yygotominor.yy173->extras = yymsp[0].minor.yy222;
}
#line 2747 "mate_grammar.c"
        break;
      case 71:
        YYTRACE("gop_control_statements ::= gop_start_statement extra_statement")
#line 693 "./mate_grammar.lemon"
{
	yygotominor.yy173 = g_malloc(sizeof(gop_control_statement));
	
	yygotominor.yy173->start = yymsp[-1].minor.yy222;
	yygotominor.yy173->stop = NULL;
    yygotominor.yy173->extras = yymsp[0].minor.yy222;
}
#line 2759 "mate_grammar.c"
        break;
      case 72:
        YYTRACE("gop_control_statements ::= gop_start_statement gop_stop_statement")
#line 701 "./mate_grammar.lemon"
{
	yygotominor.yy173 = g_malloc(sizeof(gop_control_statement));
	
	yygotominor.yy173->start = yymsp[-1].minor.yy222;
	yygotominor.yy173->stop = yymsp[0].minor.yy222;
    yygotominor.yy173->extras = NULL;
}
#line 2771 "mate_grammar.c"
        break;
      case 73:
        YYTRACE("gop_control_statements ::= gop_start_statement")
#line 710 "./mate_grammar.lemon"
{
	yygotominor.yy173 = g_malloc(sizeof(gop_control_statement));
	
	yygotominor.yy173->start = yymsp[0].minor.yy222;
	yygotominor.yy173->stop = NULL;
    yygotominor.yy173->extras = NULL;
}
#line 2783 "mate_grammar.c"
        break;
      case 74:
        YYTRACE("gop_control_statements ::= gop_stop_statement")
#line 718 "./mate_grammar.lemon"
{
	yygotominor.yy173 = g_malloc(sizeof(gop_control_statement));
	
	yygotominor.yy173->start = NULL;
	yygotominor.yy173->stop = yymsp[0].minor.yy222;
    yygotominor.yy173->extras = NULL;
}
#line 2795 "mate_grammar.c"
        break;
      case 75:
        YYTRACE("gop_control_statements ::= extra_statement")
#line 726 "./mate_grammar.lemon"
{
	yygotominor.yy173 = g_malloc(sizeof(gop_control_statement));
	
	yygotominor.yy173->start = NULL;
	yygotominor.yy173->stop = NULL;
    yygotominor.yy173->extras = yymsp[0].minor.yy222;
}
#line 2807 "mate_grammar.c"
        break;
      case 76:
        YYTRACE("gop_option_statements ::= gop_timer_statements gop_tree_statements")
#line 737 "./mate_grammar.lemon"
{
	yygotominor.yy201 = g_malloc(sizeof(gop_control_statement));
	
	yygotominor.yy201->timer_sts = yymsp[-1].minor.yy145;
	yygotominor.yy201->tree_sts = yymsp[0].minor.yy8;
}
#line 2818 "mate_grammar.c"
        break;
      case 77:
        YYTRACE("gop_option_statements ::= gop_timer_statements")
#line 744 "./mate_grammar.lemon"
{
	yygotominor.yy201 = g_malloc(sizeof(gop_timer_statement));
	
	yygotominor.yy201->timer_sts = yymsp[0].minor.yy145;
	yygotominor.yy201->tree_sts = NULL;

}
#line 2830 "mate_grammar.c"
        break;
      case 78:
        YYTRACE("gop_option_statements ::= gop_tree_statements")
#line 752 "./mate_grammar.lemon"
{
	yygotominor.yy201 = g_malloc(sizeof(gop_timer_statement));
	
	yygotominor.yy201->tree_sts = yymsp[0].minor.yy8;
	yygotominor.yy201->timer_sts =  NULL;

}
#line 2842 "mate_grammar.c"
        break;
      case 79:
        YYTRACE("gop_timer_statements ::= expiration_statement idle_timeout_statement lifetime_statement")
#line 762 "./mate_grammar.lemon"
{
	yygotominor.yy145 = g_malloc(sizeof(gop_timer_statement));
	
	yygotominor.yy145->expiration = yymsp[-2].minor.yy59;
	yygotominor.yy145->idle_timeout = yymsp[-1].minor.yy59;
	yygotominor.yy145->lifetime = yymsp[0].minor.yy59;
}
#line 2854 "mate_grammar.c"
        break;
      case 80:
        YYTRACE("gop_timer_statements ::= expiration_statement idle_timeout_statement")
#line 771 "./mate_grammar.lemon"
{
	yygotominor.yy145 = g_malloc(sizeof(gop_timer_statement));
	
	yygotominor.yy145->expiration = yymsp[-1].minor.yy59;
	yygotominor.yy145->idle_timeout = yymsp[0].minor.yy59;
	yygotominor.yy145->lifetime = mc->defaults.gop.lifetime;
}
#line 2866 "mate_grammar.c"
        break;
      case 81:
        YYTRACE("gop_timer_statements ::= expiration_statement lifetime_statement")
#line 779 "./mate_grammar.lemon"
{
	yygotominor.yy145 = g_malloc(sizeof(gop_timer_statement));
	
	yygotominor.yy145->expiration = yymsp[-1].minor.yy59;
	yygotominor.yy145->idle_timeout = mc->defaults.gop.lifetime;
	yygotominor.yy145->lifetime = yymsp[0].minor.yy59;
}
#line 2878 "mate_grammar.c"
        break;
      case 82:
        YYTRACE("gop_timer_statements ::= idle_timeout_statement lifetime_statement")
#line 787 "./mate_grammar.lemon"
{
	yygotominor.yy145 = g_malloc(sizeof(gop_timer_statement));
	
	yygotominor.yy145->expiration = mc->defaults.gop.lifetime;
	yygotominor.yy145->idle_timeout = yymsp[-1].minor.yy59;
	yygotominor.yy145->lifetime = yymsp[0].minor.yy59;
}
#line 2890 "mate_grammar.c"
        break;
      case 83:
        YYTRACE("gop_timer_statements ::= expiration_statement")
#line 795 "./mate_grammar.lemon"
{
	yygotominor.yy145 = g_malloc(sizeof(gop_timer_statement));
	
	yygotominor.yy145->expiration = yymsp[0].minor.yy59;
	yygotominor.yy145->idle_timeout = mc->defaults.gop.lifetime;
	yygotominor.yy145->lifetime = mc->defaults.gop.lifetime;
}
#line 2902 "mate_grammar.c"
        break;
      case 84:
        YYTRACE("gop_timer_statements ::= idle_timeout_statement")
#line 803 "./mate_grammar.lemon"
{
	yygotominor.yy145 = g_malloc(sizeof(gop_timer_statement));
	
	yygotominor.yy145->expiration = mc->defaults.gop.lifetime;
	yygotominor.yy145->idle_timeout = yymsp[0].minor.yy59;
	yygotominor.yy145->lifetime = mc->defaults.gop.lifetime;
}
#line 2914 "mate_grammar.c"
        break;
      case 85:
        YYTRACE("gop_timer_statements ::= lifetime_statement")
#line 811 "./mate_grammar.lemon"
{
	yygotominor.yy145 = g_malloc(sizeof(gop_timer_statement));
	
	yygotominor.yy145->expiration = mc->defaults.gop.lifetime;
	yygotominor.yy145->idle_timeout = mc->defaults.gop.lifetime;
	yygotominor.yy145->lifetime = yymsp[0].minor.yy59;
}
#line 2926 "mate_grammar.c"
        break;
      case 86:
        YYTRACE("gop_tree_statements ::= drop_unassigned_statement show_goptree_statement show_times_statement")
#line 822 "./mate_grammar.lemon"
{
	yygotominor.yy8 = g_malloc(sizeof(gop_tree_statement));
	
	yygotominor.yy8->drop_unassigned = yymsp[-2].minor.yy32;
	yygotominor.yy8->pdu_tree_mode = yymsp[-1].minor.yy125;
	yygotominor.yy8->show_times = yymsp[0].minor.yy32;
}
#line 2938 "mate_grammar.c"
        break;
      case 87:
        YYTRACE("gop_tree_statements ::= drop_unassigned_statement show_goptree_statement")
#line 830 "./mate_grammar.lemon"
{
	yygotominor.yy8 = g_malloc(sizeof(gop_tree_statement));
	
	yygotominor.yy8->drop_unassigned = yymsp[-1].minor.yy32;
	yygotominor.yy8->pdu_tree_mode = yymsp[0].minor.yy125;
	yygotominor.yy8->show_times = mc->defaults.gop.show_times;
}
#line 2950 "mate_grammar.c"
        break;
      case 88:
        YYTRACE("gop_tree_statements ::= drop_unassigned_statement show_times_statement")
#line 838 "./mate_grammar.lemon"
{
	yygotominor.yy8 = g_malloc(sizeof(gop_tree_statement));
	
	yygotominor.yy8->drop_unassigned = yymsp[-1].minor.yy32;
	yygotominor.yy8->pdu_tree_mode = mc->defaults.gop.pdu_tree_mode;
	yygotominor.yy8->show_times = yymsp[0].minor.yy32;
}
#line 2962 "mate_grammar.c"
        break;
      case 89:
        YYTRACE("gop_tree_statements ::= show_goptree_statement show_times_statement")
#line 846 "./mate_grammar.lemon"
{
	yygotominor.yy8 = g_malloc(sizeof(gop_tree_statement));
	
	yygotominor.yy8->drop_unassigned = mc->defaults.gop.drop_unassigned;
	yygotominor.yy8->pdu_tree_mode = yymsp[-1].minor.yy125;
	yygotominor.yy8->show_times = yymsp[0].minor.yy32;
}
#line 2974 "mate_grammar.c"
        break;
      case 90:
        YYTRACE("gop_tree_statements ::= drop_unassigned_statement")
#line 854 "./mate_grammar.lemon"
{
	yygotominor.yy8 = g_malloc(sizeof(gop_tree_statement));
	
	yygotominor.yy8->drop_unassigned = yymsp[0].minor.yy32;
	yygotominor.yy8->pdu_tree_mode = mc->defaults.gop.pdu_tree_mode;
	yygotominor.yy8->show_times = mc->defaults.gop.show_times;
}
#line 2986 "mate_grammar.c"
        break;
      case 91:
        YYTRACE("gop_tree_statements ::= show_goptree_statement")
#line 862 "./mate_grammar.lemon"
{
	yygotominor.yy8 = g_malloc(sizeof(gop_tree_statement));
	
	yygotominor.yy8->drop_unassigned = mc->defaults.gop.drop_unassigned;
	yygotominor.yy8->pdu_tree_mode = yymsp[0].minor.yy125;
	yygotominor.yy8->show_times = mc->defaults.gop.show_times;
}
#line 2998 "mate_grammar.c"
        break;
      case 92:
        YYTRACE("gop_tree_statements ::= show_times_statement")
#line 870 "./mate_grammar.lemon"
{
	yygotominor.yy8 = g_malloc(sizeof(gop_tree_statement));
	
	yygotominor.yy8->drop_unassigned = mc->defaults.gop.drop_unassigned;
	yygotominor.yy8->pdu_tree_mode = mc->defaults.gop.pdu_tree_mode;
	yygotominor.yy8->show_times = yymsp[0].minor.yy32;
}
#line 3010 "mate_grammar.c"
        break;
      case 93:
        YYTRACE("gop_start_statement ::= START_KW avpl SEMICOLON")
#line 879 "./mate_grammar.lemon"
{ yygotominor.yy222 = yymsp[-1].minor.yy222; }
#line 3016 "mate_grammar.c"
  yy_destructor(52,&yymsp[-2].minor);
  yy_destructor(48,&yymsp[0].minor);
        break;
      case 94:
        YYTRACE("gop_stop_statement ::= STOP_KW avpl SEMICOLON")
#line 881 "./mate_grammar.lemon"
{ yygotominor.yy222 = yymsp[-1].minor.yy222; }
#line 3024 "mate_grammar.c"
  yy_destructor(53,&yymsp[-2].minor);
  yy_destructor(48,&yymsp[0].minor);
        break;
      case 95:
        YYTRACE("show_goptree_statement ::= SHOW_TREE_KW gop_tree_mode SEMICOLON")
#line 883 "./mate_grammar.lemon"
{ yygotominor.yy125 = yymsp[-1].minor.yy125; }
#line 3032 "mate_grammar.c"
  yy_destructor(50,&yymsp[-2].minor);
  yy_destructor(48,&yymsp[0].minor);
        break;
      case 96:
        YYTRACE("show_times_statement ::= SHOW_TIMES_KW true_false SEMICOLON")
#line 885 "./mate_grammar.lemon"
{ yygotominor.yy32 = yymsp[-1].minor.yy32; }
#line 3040 "mate_grammar.c"
  yy_destructor(49,&yymsp[-2].minor);
  yy_destructor(48,&yymsp[0].minor);
        break;
      case 97:
        YYTRACE("expiration_statement ::= EXPIRATION_KW time_value SEMICOLON")
#line 887 "./mate_grammar.lemon"
{ yygotominor.yy59 = yymsp[-1].minor.yy59; }
#line 3048 "mate_grammar.c"
  yy_destructor(15,&yymsp[-2].minor);
  yy_destructor(48,&yymsp[0].minor);
        break;
      case 98:
        YYTRACE("idle_timeout_statement ::= IDLE_TIMEOUT_KW time_value SEMICOLON")
#line 889 "./mate_grammar.lemon"
{ yygotominor.yy59 = yymsp[-1].minor.yy59; }
#line 3056 "mate_grammar.c"
  yy_destructor(26,&yymsp[-2].minor);
  yy_destructor(48,&yymsp[0].minor);
        break;
      case 99:
        YYTRACE("lifetime_statement ::= LIFETIME_KW time_value SEMICOLON")
#line 891 "./mate_grammar.lemon"
{ yygotominor.yy59 = yymsp[-1].minor.yy59; }
#line 3064 "mate_grammar.c"
  yy_destructor(30,&yymsp[-2].minor);
  yy_destructor(48,&yymsp[0].minor);
        break;
      case 100:
        YYTRACE("gop_tree_mode ::= NO_TREE_KW")
#line 893 "./mate_grammar.lemon"
{ yygotominor.yy125 = GOP_NO_TREE; }
#line 3072 "mate_grammar.c"
  yy_destructor(35,&yymsp[0].minor);
        break;
      case 101:
        YYTRACE("gop_tree_mode ::= PDU_TREE_KW")
#line 894 "./mate_grammar.lemon"
{ yygotominor.yy125 = GOP_PDU_TREE; }
#line 3079 "mate_grammar.c"
  yy_destructor(42,&yymsp[0].minor);
        break;
      case 102:
        YYTRACE("gop_tree_mode ::= FRAME_TREE_KW")
#line 895 "./mate_grammar.lemon"
{ yygotominor.yy125 = GOP_FRAME_TREE; }
#line 3086 "mate_grammar.c"
  yy_destructor(20,&yymsp[0].minor);
        break;
      case 103:
        YYTRACE("gop_tree_mode ::= BASIC_TREE_KW")
#line 896 "./mate_grammar.lemon"
{ yygotominor.yy125 = GOP_BASIC_PDU_TREE; }
#line 3093 "mate_grammar.c"
  yy_destructor(4,&yymsp[0].minor);
        break;
      case 104:
        YYTRACE("true_false ::= TRUE_KW")
#line 898 "./mate_grammar.lemon"
{ yygotominor.yy32 = TRUE; }
#line 3100 "mate_grammar.c"
  yy_destructor(57,&yymsp[0].minor);
        break;
      case 105:
        YYTRACE("true_false ::= FALSE_KW")
#line 899 "./mate_grammar.lemon"
{ yygotominor.yy32 = FALSE; }
#line 3107 "mate_grammar.c"
  yy_destructor(18,&yymsp[0].minor);
        break;
      case 106:
        YYTRACE("pdu_name ::= NAME")
#line 901 "./mate_grammar.lemon"
{
	mate_cfg_pdu* c;
	if (( c =  g_hash_table_lookup(mc->pducfgs,yymsp[0].minor.yy0) )) {
		yygotominor.yy208 = c->name;
	} else {
		configuration_error(mc,"No such Pdu: '%s'",yymsp[0].minor.yy0);
	}
}
#line 3121 "mate_grammar.c"
        break;
      case 107:
        YYTRACE("time_value ::= FLOATING")
#line 911 "./mate_grammar.lemon"
{
	yygotominor.yy59 = (float) strtod(yymsp[0].minor.yy0,NULL);
}
#line 3129 "mate_grammar.c"
        break;
      case 108:
        YYTRACE("time_value ::= INTEGER")
#line 915 "./mate_grammar.lemon"
{
	yygotominor.yy59 = (float) strtod(yymsp[0].minor.yy0,NULL);
}
#line 3137 "mate_grammar.c"
        break;
      case 109:
        YYTRACE("gog_decl ::= GOG_KW NAME OPEN_BRACE gog_statements CLOSE_BRACE SEMICOLON")
#line 922 "./mate_grammar.lemon"
{
	mate_cfg_gog* cfg = NULL;
	
	if ( g_hash_table_lookup(mc->gogcfgs,yymsp[-4].minor.yy0) ) {
		configuration_error(mc,"Gog '%s' exists already ",yymsp[-4].minor.yy0);
	}
	
	cfg = new_gogcfg(yymsp[-4].minor.yy0);

	cfg->expiration = yymsp[-2].minor.yy91->expiration;
	cfg->gop_tree_mode = yymsp[-2].minor.yy91->gop_tree_mode;
	cfg->transforms = yymsp[-2].minor.yy91->transform_list ? yymsp[-2].minor.yy91->transform_list : g_ptr_array_new();
	cfg->keys = yymsp[-2].minor.yy91->current_gogkeys;
	
	if (yymsp[-2].minor.yy91->extras) {
		merge_avpl(cfg->extra,yymsp[-2].minor.yy91->extras,TRUE);
		delete_avpl(yymsp[-2].minor.yy91->extras,TRUE);
	}
	
	g_free(yymsp[-2].minor.yy91);
}
#line 3163 "mate_grammar.c"
  yy_destructor(23,&yymsp[-5].minor);
  yy_destructor(38,&yymsp[-3].minor);
  yy_destructor(5,&yymsp[-1].minor);
  yy_destructor(48,&yymsp[0].minor);
        break;
      case 110:
        YYTRACE("gog_statements ::= expiration_statement gog_goptree_statement gog_key_statements extra_statement transform_list_statement")
#line 944 "./mate_grammar.lemon"
{
	yygotominor.yy91 = g_malloc(sizeof(gog_statement_t));
	
	yygotominor.yy91->expiration = yymsp[-4].minor.yy59;
	yygotominor.yy91->gop_tree_mode = yymsp[-3].minor.yy125;
	yygotominor.yy91->current_gogkeys = yymsp[-2].minor.yy219;
	yygotominor.yy91->extras = yymsp[-1].minor.yy222;
	yygotominor.yy91->transform_list = yymsp[0].minor.yy199;
}
#line 3181 "mate_grammar.c"
        break;
      case 111:
        YYTRACE("gog_statements ::= expiration_statement gog_goptree_statement gog_key_statements transform_list_statement")
#line 954 "./mate_grammar.lemon"
{
	yygotominor.yy91 = g_malloc(sizeof(gog_statement_t));
	
	yygotominor.yy91->expiration = yymsp[-3].minor.yy59;
	yygotominor.yy91->gop_tree_mode = yymsp[-2].minor.yy125;
	yygotominor.yy91->current_gogkeys = yymsp[-1].minor.yy219;
	yygotominor.yy91->extras = new_avpl("");
	yygotominor.yy91->transform_list = yymsp[0].minor.yy199;
}
#line 3195 "mate_grammar.c"
        break;
      case 112:
        YYTRACE("gog_statements ::= expiration_statement gog_key_statements extra_statement transform_list_statement")
#line 964 "./mate_grammar.lemon"
{
	yygotominor.yy91 = g_malloc(sizeof(gog_statement_t));
	
	yygotominor.yy91->expiration = yymsp[-3].minor.yy59;
	yygotominor.yy91->gop_tree_mode = mc->defaults.gog.gop_tree_mode;
	yygotominor.yy91->current_gogkeys = yymsp[-2].minor.yy219;
	yygotominor.yy91->extras = yymsp[-1].minor.yy222;
	yygotominor.yy91->transform_list = yymsp[0].minor.yy199;
}
#line 3209 "mate_grammar.c"
        break;
      case 113:
        YYTRACE("gog_statements ::= expiration_statement gog_key_statements transform_list_statement")
#line 974 "./mate_grammar.lemon"
{
	yygotominor.yy91 = g_malloc(sizeof(gog_statement_t));
	
	yygotominor.yy91->expiration = yymsp[-2].minor.yy59;
	yygotominor.yy91->gop_tree_mode = mc->defaults.gog.gop_tree_mode;
	yygotominor.yy91->current_gogkeys = yymsp[-1].minor.yy219;
	yygotominor.yy91->extras = new_avpl("");
	yygotominor.yy91->transform_list = yymsp[0].minor.yy199;
}
#line 3223 "mate_grammar.c"
        break;
      case 114:
        YYTRACE("gog_statements ::= gog_goptree_statement gog_key_statements extra_statement transform_list_statement")
#line 984 "./mate_grammar.lemon"
{
	yygotominor.yy91 = g_malloc(sizeof(gog_statement_t));
	
	yygotominor.yy91->expiration = mc->defaults.gog.expiration;
	yygotominor.yy91->gop_tree_mode = yymsp[-3].minor.yy125;
	yygotominor.yy91->current_gogkeys = yymsp[-2].minor.yy219;
	yygotominor.yy91->extras = yymsp[-1].minor.yy222;
	yygotominor.yy91->transform_list = yymsp[0].minor.yy199;
}
#line 3237 "mate_grammar.c"
        break;
      case 115:
        YYTRACE("gog_statements ::= gog_goptree_statement gog_key_statements transform_list_statement")
#line 994 "./mate_grammar.lemon"
{
	yygotominor.yy91 = g_malloc(sizeof(gog_statement_t));
	
	yygotominor.yy91->expiration = mc->defaults.gog.expiration;
	yygotominor.yy91->gop_tree_mode = yymsp[-2].minor.yy125;
	yygotominor.yy91->current_gogkeys = yymsp[-1].minor.yy219;
	yygotominor.yy91->extras = new_avpl("");
	yygotominor.yy91->transform_list = yymsp[0].minor.yy199;
}
#line 3251 "mate_grammar.c"
        break;
      case 116:
        YYTRACE("gog_statements ::= gog_key_statements extra_statement transform_list_statement")
#line 1004 "./mate_grammar.lemon"
{
	yygotominor.yy91 = g_malloc(sizeof(gog_statement_t));
	
	yygotominor.yy91->expiration = mc->defaults.gog.expiration;
	yygotominor.yy91->gop_tree_mode = mc->defaults.gog.gop_tree_mode;
	yygotominor.yy91->current_gogkeys = yymsp[-2].minor.yy219;
	yygotominor.yy91->extras = yymsp[-1].minor.yy222;
	yygotominor.yy91->transform_list = yymsp[0].minor.yy199;
}
#line 3265 "mate_grammar.c"
        break;
      case 117:
        YYTRACE("gog_statements ::= gog_key_statements transform_list_statement")
#line 1014 "./mate_grammar.lemon"
{
	yygotominor.yy91 = g_malloc(sizeof(gog_statement_t));
	
	yygotominor.yy91->expiration = mc->defaults.gog.expiration;
	yygotominor.yy91->gop_tree_mode = mc->defaults.gog.gop_tree_mode;
	yygotominor.yy91->current_gogkeys = yymsp[-1].minor.yy219;
	yygotominor.yy91->extras = new_avpl("");
	yygotominor.yy91->transform_list = yymsp[0].minor.yy199;
}
#line 3279 "mate_grammar.c"
        break;
      case 118:
        YYTRACE("gog_statements ::= expiration_statement gog_goptree_statement gog_key_statements extra_statement")
#line 1025 "./mate_grammar.lemon"
{
	yygotominor.yy91 = g_malloc(sizeof(gog_statement_t));
	
	yygotominor.yy91->expiration = yymsp[-3].minor.yy59;
	yygotominor.yy91->gop_tree_mode = yymsp[-2].minor.yy125;
	yygotominor.yy91->current_gogkeys = yymsp[-1].minor.yy219;
	yygotominor.yy91->extras = yymsp[0].minor.yy222;
	yygotominor.yy91->transform_list = NULL;
}
#line 3293 "mate_grammar.c"
        break;
      case 119:
        YYTRACE("gog_statements ::= expiration_statement gog_goptree_statement gog_key_statements")
#line 1035 "./mate_grammar.lemon"
{
	yygotominor.yy91 = g_malloc(sizeof(gog_statement_t));
	
	yygotominor.yy91->expiration = yymsp[-2].minor.yy59;
	yygotominor.yy91->gop_tree_mode = yymsp[-1].minor.yy125;
	yygotominor.yy91->current_gogkeys = yymsp[0].minor.yy219;
	yygotominor.yy91->extras = new_avpl("");
	yygotominor.yy91->transform_list = NULL;
}
#line 3307 "mate_grammar.c"
        break;
      case 120:
        YYTRACE("gog_statements ::= expiration_statement gog_key_statements extra_statement")
#line 1045 "./mate_grammar.lemon"
{
	yygotominor.yy91 = g_malloc(sizeof(gog_statement_t));
	
	yygotominor.yy91->expiration = yymsp[-2].minor.yy59;
	yygotominor.yy91->gop_tree_mode = mc->defaults.gog.gop_tree_mode;
	yygotominor.yy91->current_gogkeys = yymsp[-1].minor.yy219;
	yygotominor.yy91->extras = yymsp[0].minor.yy222;
	yygotominor.yy91->transform_list = NULL;
}
#line 3321 "mate_grammar.c"
        break;
      case 121:
        YYTRACE("gog_statements ::= expiration_statement gog_key_statements")
#line 1055 "./mate_grammar.lemon"
{
	yygotominor.yy91 = g_malloc(sizeof(gog_statement_t));
	
	yygotominor.yy91->expiration = yymsp[-1].minor.yy59;
	yygotominor.yy91->gop_tree_mode = mc->defaults.gog.gop_tree_mode;
	yygotominor.yy91->current_gogkeys = yymsp[0].minor.yy219;
	yygotominor.yy91->extras = new_avpl("");
	yygotominor.yy91->transform_list = NULL;
}
#line 3335 "mate_grammar.c"
        break;
      case 122:
        YYTRACE("gog_statements ::= gog_goptree_statement gog_key_statements extra_statement")
#line 1066 "./mate_grammar.lemon"
{
	yygotominor.yy91 = g_malloc(sizeof(gog_statement_t));
	
	yygotominor.yy91->expiration = mc->defaults.gog.expiration;
	yygotominor.yy91->gop_tree_mode = yymsp[-2].minor.yy125;
	yygotominor.yy91->current_gogkeys = yymsp[-1].minor.yy219;
	yygotominor.yy91->extras = yymsp[0].minor.yy222;
	yygotominor.yy91->transform_list = NULL;
}
#line 3349 "mate_grammar.c"
        break;
      case 123:
        YYTRACE("gog_statements ::= gog_goptree_statement gog_key_statements")
#line 1076 "./mate_grammar.lemon"
{
	yygotominor.yy91 = g_malloc(sizeof(gog_statement_t));
	
	yygotominor.yy91->expiration = mc->defaults.gog.expiration;
	yygotominor.yy91->gop_tree_mode = yymsp[-1].minor.yy125;
	yygotominor.yy91->current_gogkeys = yymsp[0].minor.yy219;
	yygotominor.yy91->extras = new_avpl("");
	yygotominor.yy91->transform_list = NULL;
}
#line 3363 "mate_grammar.c"
        break;
      case 124:
        YYTRACE("gog_statements ::= gog_key_statements extra_statement")
#line 1086 "./mate_grammar.lemon"
{
	yygotominor.yy91 = g_malloc(sizeof(gog_statement_t));
	
	yygotominor.yy91->expiration = mc->defaults.gog.expiration;
	yygotominor.yy91->gop_tree_mode = mc->defaults.gog.gop_tree_mode;
	yygotominor.yy91->current_gogkeys = yymsp[-1].minor.yy219;
	yygotominor.yy91->extras = yymsp[0].minor.yy222;
	yygotominor.yy91->transform_list = NULL;
}
#line 3377 "mate_grammar.c"
        break;
      case 125:
        YYTRACE("gog_statements ::= gog_key_statements")
#line 1096 "./mate_grammar.lemon"
{
	yygotominor.yy91 = g_malloc(sizeof(gog_statement_t));
	
	yygotominor.yy91->expiration = mc->defaults.gog.expiration;
	yygotominor.yy91->gop_tree_mode = mc->defaults.gog.gop_tree_mode;
	yygotominor.yy91->current_gogkeys = yymsp[0].minor.yy219;
	yygotominor.yy91->extras = new_avpl("");
	yygotominor.yy91->transform_list = NULL;
}
#line 3391 "mate_grammar.c"
        break;
      case 126:
        YYTRACE("gog_goptree_statement ::= GOP_TREE_KW gop_tree_type SEMICOLON")
#line 1106 "./mate_grammar.lemon"
{ yygotominor.yy125 = yymsp[-1].minor.yy125; }
#line 3397 "mate_grammar.c"
  yy_destructor(25,&yymsp[-2].minor);
  yy_destructor(48,&yymsp[0].minor);
        break;
      case 127:
        YYTRACE("gop_tree_type ::= NULL_TREE")
#line 1108 "./mate_grammar.lemon"
{ yygotominor.yy125 = GOP_NULL_TREE; }
#line 3405 "mate_grammar.c"
  yy_destructor(36,&yymsp[0].minor);
        break;
      case 128:
        YYTRACE("gop_tree_type ::= FULL_TREE")
#line 1109 "./mate_grammar.lemon"
{ yygotominor.yy125 = GOP_FULL_TREE; }
#line 3412 "mate_grammar.c"
  yy_destructor(22,&yymsp[0].minor);
        break;
      case 129:
        YYTRACE("gop_tree_type ::= BASIC_TREE")
#line 1110 "./mate_grammar.lemon"
{ yygotominor.yy125 = GOP_BASIC_TREE; }
#line 3419 "mate_grammar.c"
  yy_destructor(3,&yymsp[0].minor);
        break;
      case 130:
        YYTRACE("gog_key_statements ::= gog_key_statements gog_key_statement")
#line 1113 "./mate_grammar.lemon"
{
	loal_append(yymsp[-1].minor.yy219,yymsp[0].minor.yy222);
	yygotominor.yy219 = yymsp[-1].minor.yy219;
}
#line 3429 "mate_grammar.c"
        break;
      case 131:
        YYTRACE("gog_key_statements ::= gog_key_statement")
#line 1118 "./mate_grammar.lemon"
{
	yygotominor.yy219 = new_loal("");
	loal_append(yygotominor.yy219,yymsp[0].minor.yy222);
}
#line 3438 "mate_grammar.c"
        break;
      case 132:
        YYTRACE("gog_key_statement ::= MEMBER_KW gop_name avpl SEMICOLON")
#line 1124 "./mate_grammar.lemon"
{
	rename_avpl(yymsp[-1].minor.yy222,yymsp[-2].minor.yy208);
	yygotominor.yy222 = yymsp[-1].minor.yy222;
}
#line 3447 "mate_grammar.c"
  yy_destructor(33,&yymsp[-3].minor);
  yy_destructor(48,&yymsp[0].minor);
        break;
      case 133:
        YYTRACE("gop_name ::= NAME")
#line 1129 "./mate_grammar.lemon"
{
	mate_cfg_gop* c;
	if (( c = g_hash_table_lookup(mc->gopcfgs,yymsp[0].minor.yy0) )) {
		yygotominor.yy208 = c->name;
	} else {
		configuration_error(mc,"No Gop called '%s' has been already declared",yymsp[0].minor.yy0);
	}
}
#line 3462 "mate_grammar.c"
        break;
      case 134:
        YYTRACE("extra_statement ::= EXTRA_KW avpl SEMICOLON")
#line 1141 "./mate_grammar.lemon"
{ yygotominor.yy222 = yymsp[-1].minor.yy222; }
#line 3468 "mate_grammar.c"
  yy_destructor(17,&yymsp[-2].minor);
  yy_destructor(48,&yymsp[0].minor);
        break;
      case 135:
        YYTRACE("transform_list_statement ::= TRANSFORM_KW transform_list SEMICOLON")
#line 1143 "./mate_grammar.lemon"
{ yygotominor.yy199 = yymsp[-1].minor.yy199; }
#line 3476 "mate_grammar.c"
  yy_destructor(55,&yymsp[-2].minor);
  yy_destructor(48,&yymsp[0].minor);
        break;
      case 136:
        YYTRACE("transform_list ::= transform_list COMMA transform")
#line 1145 "./mate_grammar.lemon"
{ 
	yygotominor.yy199 = yymsp[-2].minor.yy199;
	g_ptr_array_add(yymsp[-2].minor.yy199,yymsp[0].minor.yy63);
}
#line 3487 "mate_grammar.c"
  yy_destructor(8,&yymsp[-1].minor);
        break;
      case 137:
        YYTRACE("transform_list ::= transform")
#line 1150 "./mate_grammar.lemon"
{
	yygotominor.yy199 = g_ptr_array_new();
	g_ptr_array_add(yygotominor.yy199,yymsp[0].minor.yy63);
}
#line 3497 "mate_grammar.c"
        break;
      case 138:
        YYTRACE("transform ::= NAME")
#line 1155 "./mate_grammar.lemon"
{
	AVPL_Transf* t;
	
	if (( t = g_hash_table_lookup(mc->transfs,yymsp[0].minor.yy0) )) {
		yygotominor.yy63 = t;
	} else {
		configuration_error(mc,"There's no such Transformation: %s",yymsp[0].minor.yy0);
	}	
}
#line 3511 "mate_grammar.c"
        break;
      case 139:
        YYTRACE("avpl ::= OPEN_PARENS avps CLOSE_PARENS")
#line 1165 "./mate_grammar.lemon"
{ yygotominor.yy222 = yymsp[-1].minor.yy222; }
#line 3517 "mate_grammar.c"
  yy_destructor(39,&yymsp[-2].minor);
  yy_destructor(6,&yymsp[0].minor);
        break;
      case 140:
        YYTRACE("avpl ::= OPEN_PARENS CLOSE_PARENS")
#line 1166 "./mate_grammar.lemon"
{ yygotominor.yy222 = new_avpl(""); }
#line 3525 "mate_grammar.c"
  yy_destructor(39,&yymsp[-1].minor);
  yy_destructor(6,&yymsp[0].minor);
        break;
      case 141:
        YYTRACE("avps ::= avps COMMA avp")
#line 1168 "./mate_grammar.lemon"
{ yygotominor.yy222 = yymsp[-2].minor.yy222; if ( ! insert_avp(yymsp[-2].minor.yy222,yymsp[0].minor.yy6) ) delete_avp(yymsp[0].minor.yy6); }
#line 3533 "mate_grammar.c"
  yy_destructor(8,&yymsp[-1].minor);
        break;
      case 142:
        YYTRACE("avps ::= avp")
#line 1169 "./mate_grammar.lemon"
{ yygotominor.yy222 = new_avpl(""); if ( ! insert_avp(yygotominor.yy222,yymsp[0].minor.yy6) ) delete_avp(yymsp[0].minor.yy6); }
#line 3540 "mate_grammar.c"
        break;
      case 143:
        YYTRACE("avp ::= NAME AVP_OPERATOR value")
#line 1171 "./mate_grammar.lemon"
{ yygotominor.yy6 = new_avp(yymsp[-2].minor.yy0,yymsp[0].minor.yy208,*yymsp[-1].minor.yy0); }
#line 3546 "mate_grammar.c"
        break;
      case 144:
        YYTRACE("avp ::= NAME")
#line 1172 "./mate_grammar.lemon"
{ yygotominor.yy6 = new_avp(yymsp[0].minor.yy0,"",'?'); }
#line 3552 "mate_grammar.c"
        break;
      case 145:
        YYTRACE("avp ::= NAME OPEN_BRACE avp_oneoff CLOSE_BRACE")
#line 1173 "./mate_grammar.lemon"
{ yygotominor.yy6 = new_avp(yymsp[-3].minor.yy0,yymsp[-1].minor.yy208,'|'); }
#line 3558 "mate_grammar.c"
  yy_destructor(38,&yymsp[-2].minor);
  yy_destructor(5,&yymsp[0].minor);
        break;
      case 146:
        YYTRACE("avp_oneoff ::= avp_oneoff PIPE value")
#line 1175 "./mate_grammar.lemon"
{ yygotominor.yy208 = g_strdup_printf("%s|%s",yymsp[-2].minor.yy208,yymsp[0].minor.yy208); }
#line 3566 "mate_grammar.c"
  yy_destructor(43,&yymsp[-1].minor);
        break;
      case 147:
        YYTRACE("avp_oneoff ::= value")
#line 1176 "./mate_grammar.lemon"
{ yygotominor.yy208 = g_strdup(yymsp[0].minor.yy208); }
#line 3573 "mate_grammar.c"
        break;
      case 148:
        YYTRACE("value ::= QUOTED")
#line 1178 "./mate_grammar.lemon"
{ yygotominor.yy208 = g_strdup(yymsp[0].minor.yy0); }
#line 3579 "mate_grammar.c"
        break;
      case 149:
        YYTRACE("value ::= NAME")
#line 1179 "./mate_grammar.lemon"
{ yygotominor.yy208 = g_strdup(yymsp[0].minor.yy0); }
#line 3585 "mate_grammar.c"
        break;
      case 150:
        YYTRACE("value ::= FLOATING")
#line 1180 "./mate_grammar.lemon"
{ yygotominor.yy208 = g_strdup(yymsp[0].minor.yy0); }
#line 3591 "mate_grammar.c"
        break;
      case 151:
        YYTRACE("value ::= INTEGER")
#line 1181 "./mate_grammar.lemon"
{ yygotominor.yy208 = g_strdup(yymsp[0].minor.yy0); }
#line 3597 "mate_grammar.c"
        break;
      case 152:
        YYTRACE("value ::= DOTED_IP")
#line 1182 "./mate_grammar.lemon"
{ yygotominor.yy208 = g_strdup(yymsp[0].minor.yy0); }
#line 3603 "mate_grammar.c"
        break;
      case 153:
        YYTRACE("value ::= COLONIZED")
#line 1183 "./mate_grammar.lemon"
{ yygotominor.yy208 = recolonize(mc,yymsp[0].minor.yy0); }
#line 3609 "mate_grammar.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->idx -= yysize;
  yypParser->top -= yysize;
  yyact = yy_find_parser_action(yypParser,yygoto);
  if( yyact < YYNSTATE ){
    yy_shift(yypParser,yyact,yygoto,&yygotominor);
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser MateParserARGDECL);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
  MateParserANSIARGDECL              /* Extra arguments (if any) */
){
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->idx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
#line 220 "./mate_grammar.lemon"

	configuration_error(mc,"Parse Error");

#line 3643 "mate_grammar.c"
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser _U_,       /* The parser */
  int yymajor _U_,               /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
  MateParserANSIARGDECL _U_           /* Extra arguments (if any) */
){
#define TOKEN (yyminor.yy0)
#line 216 "./mate_grammar.lemon"

	configuration_error(mc,"Syntax Error before %s",yyminor);

#line 3660 "mate_grammar.c"
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
  MateParserANSIARGDECL _U_          /* Extra arguments (if any) */
){
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->idx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "MateParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void MateParser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  MateParserTOKENTYPE yyminor       /* The value for the token */
  MateParserANSIARGDECL
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->idx<0 ){
    if( yymajor==0 ) return;
    yypParser->idx = 0;
    yypParser->errcnt = -1;
    yypParser->top = &yypParser->stack[0];
    yypParser->top->stateno = 0;
    yypParser->top->major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_parser_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->errcnt--;
      if( yyendofinput && yypParser->idx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE MateParserARGDECL);
    }else if( yyact == YY_ERROR_ACTION ){
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->errcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion MateParserARGDECL);
      }
      if( yypParser->top->major==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->idx >= 0 &&
          yypParser->top->major != YYERRORSYMBOL &&
          (yyact = yy_find_parser_action(yypParser,YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->idx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser MateParserARGDECL);
          yymajor = YYNOCODE;
        }else if( yypParser->top->major!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->errcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->errcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion MateParserARGDECL);
      }
      yypParser->errcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser MateParserARGDECL);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser MateParserARGDECL);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->idx>=0 );
  return;
}
