/* packet-ftam.h
*
* Routine to dissect OSI ISO 8571 FTAM Protocol packets
*
* $Id: packet-ftam.h 13966 2005-03-29 12:36:40Z sahlberg $
*
* Yuriy Sidelnikov <YSidelnikov@hotmail.com>
*
* Ethereal - Network traffic analyzer
* By Gerald Combs <gerald@ethereal.com>
* Copyright 1998 Gerald Combs
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#define PROTO_STRING_FTAM "OSI ISO 8571 FTAM Protocol"
#define PROTO_STRING_FTAM_INFO "OSI ISO 8571 FTAM Protocol"

/* asn.1 definitions   */
#define	ASN1_CLASS_UNIVERSAL				0x00
#define	ASN1_CLASS_APPLICATION				0x40
#define	ASN1_CLASS_CONTEXT_SPECIFIC			0x80
#define	ASN1_CLASS_Private					0xc0
#define	ASN1_CLASS_PC						0x20

#define	INTEGER_ITEM						0x01
#define	BOOLEAN_ITEM						0x01

#define	NBS9_OID							0x2b

#define SEQUENCE							0x30

/*    sequence top   */
#define TAG_00									0
#define TAG_01									1

enum
{
FTAM_F_INITIALIZE_REQUEST = 0xa0,
FTAM_F_INITIALIZE_RESPONSE,
FTAM_F_TERMINATE_REQUEST,
FTAM_F_TERMINATE_RESPONSE,
FTAM_F_U_ABORT_REQUEST,
FTAM_F_P_ABORT_REQUEST,
FTAM_F_SELECT_REQUEST,
FTAM_F_SELECT_RESPONSE,
FTAM_F_DESELECT_REQUEST,
FTAM_F_DESELECT_RESPONSE,
FTAM_F_CREATE_REQUEST,
FTAM_F_CREATE_RESPONSE,
FTAM_F_DELETE_REQUEST,
FTAM_F_DELETE_RESPONSE,
FTAM_F_READ_ATTRIB_REQUEST,
FTAM_F_READ_ATTRIB_RESPONSE,
FTAM_F_CHANGE_ATTRIB_REQUEST,
FTAM_F_CHANGE_ATTRIB_RESPONSE,
FTAM_F_OPEN_REQUEST,
FTAM_F_OPEN_RESPONSE,
FTAM_F_CLOSE_REQUEST,
FTAM_F_CLOSE_RESPONSE,
FTAM_F_BEGIN_GROUP_REQUEST,
FTAM_F_BEGIN_GROUP_RESPONSE,
FTAM_F_END_GROUP_REQUEST,
FTAM_F_END_GROUP_RESPONSE,
FTAM_F_RECOVER_REQUEST,
FTAM_F_RECOVER_RESPONSE,
FTAM_F_LOCATE_REQUEST,
FTAM_F_LOCATE_RESPONSE,
FTAM_F_ERASE_REQUEST,
FTAM_F_ERASE_RESPONSE
};
enum
{
FTAM_F_READ_REQUEST=0x20,
FTAM_F_WRITE_REQUEST,
FTAM_F_DATA_END_REQUEST,
FTAM_F_TRANSFER_END_REQUEST,
FTAM_F_TRANSFER_END_RESPONSE,
FTAM_F_CANCEL_REQUEST,
FTAM_F_CANCEL_RESPONSE,
FTAM_F_REASTART_REQUEST,
FTAM_F_REASTART_RESPONSE
};
enum
{
FTAM_PROTOCOL_VERSION,
FTAM_IMPLEMENTATION_INFORMATION,
FTAM_PRESENTATION_CONTEXT_MANAGEMENT,
FTAM_SERVICE_CLASS,
FTAM_FUNCTIONAL_UNITS,
FTAM_ATTRIBUTE_GROUPS,
FTAM_QUALITY_OF_SERVICE,
FTAM_CONTENTS_TYPE_LIST
};
/* pseudo value   */
#define FTAM_CHECKPOINT_WINDOW           55
#define	FTAM_CHARGING						9
enum
{
FTAM_DIAGNOSTIC_TYPE=0x80,
FTAM_ERROR_IDENTIFIER,
FTAM_ERROR_OBSERVER,
FTAM_ERROR_SOURCE,
FTAM_SUGGESTED_DELAY,
FTAM_FURTHER_DETAILS
};
enum
{
FTAM_NO_CATEGORIZATION_POSSIBLE,
FTAM_INITIATING_FILE_SERVICE_USER,
FTAM_INITIATING_FILE_PROTOCOL_MASHINE,
FTAM_SERVICE_SUPPORTING_THE_FILE_PROTOCOL_MACHINE,
FTAM_RESPONDING_FILE_PROTOCOL_MASHINE,
FTAM_RESPONDING_FILE_SERVICE_USER
};
enum
{
FTAM_DIAGNOSTIC_INFORMATIVE,
FTAM_DIAGNOSTIC_TRANSIENT,
FTAM_DIAGNOSTIC_PERMANENT
};
enum
{
FTAM_RESPONSE_STATE_SUCCESS,
FTAM_RESPONSE_STATE_FAILURE
};
enum
{
FTAM_RESPONSE_ACTION_RESULT_SUCCESS,
FTAM_RESPONSE_ACTION_RESULT_TRANSIENT_ERROR,
FTAM_RESPONSE_ACTION_RESULT_PERMANENT_ERROR
};
enum
{
FTAM_PROCESSING_MODE,
FTAM_CONTENTS_TYPE,
FTAM_CONCURENCY_CONTROL,
FTAM_ENABLE_FADU_LOCKING,
FTAM_ACTIVITY_IDENTIFIER,
FTAM_RECOVERY_MODE,
FTAM_REMOTE_CONTEXTS,
FTAM_DEFINE_CONTEXTS
};
enum
{
FTAM_CONTENTS_TYPE_UNKNOWN,
FTAM_CONTENTS_TYPE_PROPOSED
};
enum
{
FTAM_CONTENTS_TYPE_PROPOSED_DOCUMENT_TYPE,
FTAM_CONTENTS_TYPE_PROPOSED_CONSTRAINT_SET
};
enum
{
FTAM_CREATE_FAILURE,
FTAM_SELECT_OLD_FILE,
FTAM_DELETE_AND_CREATE_WITH_OLD_ATTRIBUTES,
FTAM_DELETE_AND_CREATE_WITH_NEW_ATTRIBUTES
};
enum
{
FTAM_FADU_FIRST_LAST,
FTAM_FADU_RELATIVE,
FTAM_FADU_BEGIN_END,
FTAM_FADU_SINGLE_NAME,
FTAM_FADU_NAME_LIST,
FTAM_FADU_FADU_NUMBER
};
enum
{
FTAM_FADU_FIRST,
FTAM_FADU_LAST
};
enum
{
FTAM_FADU_PREVIOUS,
FTAM_FADU_CURRENT,
FTAM_FADU_NEXT
};
enum
{
FTAM_FADU_BEGIN,
FTAM_FADU_END
};
enum
{
FTAM_HIERARCHICAL_ALL_DATA_UNITS,
FTAM_HIERARCHICAL_NO_DATA_UNITS,
FTAM_ALL_DATA_UNITS,
FTAM_ONE_LEVEL_DATA_UNITS,
FTAM_SINGLE_DATA_UNITS,
FTAM_UNSTRUCTURED_ALL_DATA_UNITS,
FTAM_UNSTRUCTURED_SINGLE_DATA_UNITS
};
enum
{
FTAM_ACCESS_INSERT,
FTAM_ACCESS_REPLACE,
FTAM_ACCESS_EXTEND
};
enum
{
FTAM_UNIVERSAL_CLASS_NUMBER,
FTAM_MAXIMUM_STRING_LENGTH,
FTAM_STRING_SIGNIFICANCE
};
enum
{
FTAM_VARIABLE,
FTAM_FIXED,
FTAM_NOT_SIGNIFICANT
};
enum
{
FTAM_READ_ATTRIBUTE_FILENAME,
FTAM_READ_ATTRIBUTE_PERMITTED_ACTIONS,
FTAM_READ_ATTRIBUTE_CONTENTS_TYPE,
FTAM_READ_ATTRIBUTE_STORAGE_ACCOUNT,
FTAM_READ_ATTRIBUTE_DATA_AND_TIME_OF_CREATION,
FTAM_READ_ATTRIBUTE_DATA_AND_TIME_OF_LAST_MODIFICATION,
FTAM_READ_ATTRIBUTE_DATA_AND_TIME_OF_LAST_READ_ACCESS,
FTAM_READ_ATTRIBUTE_DATA_AND_TIME_OF_LAST_ATTRIBUTE_MODIFICATION,
FTAM_READ_ATTRIBUTE_IDENTITY_OF_CREATOR,
FTAM_READ_ATTRIBUTE_IDENTITY_OF_LAST_MODIFIER,
FTAM_READ_ATTRIBUTE_IDENTITY_OF_LAST_READER,
FTAM_READ_ATTRIBUTE_IDENTITY_OF_LAST_ATTRIBUTE_MODIFIER,
FTAM_READ_ATTRIBUTE_FILE_AVAILABILITY,
FTAM_READ_ATTRIBUTE_FILESIZE,
FTAM_READ_ATTRIBUTE_FUTURE_FILESIZE,
FTAM_READ_ATTRIBUTE_ACCESS_CONTROL,
FTAM_READ_ATTRIBUTE_LEGAL_QUALIFICATION,
FTAM_READ_ATTRIBUTE_PRIVATE_USE
};


#define			FTAM_DATE_AND_TIME_NO_VALUE_AVAILABLE						0x00
#define			FTAM_DATE_AND_TIME_ACTUAL_VALUE								0x01

#define			FTAM_DATE_IDENTITY_NO_VALUE_AVAILABLE						0x00
#define			FTAM_DATE_IDENTITY_ACTUAL_VALUE								0x01


#define			FTAM_USER_IDENTITY											22

#define		FTAM_PRINTABLE_LENGTH					19
#define		FTAM_GRAPHIC_STRING						25
#define		FTAM_TELEX_STRING						20
#define		FTAM_VIDEO_STRING						21
#define		FTAM_IA5_STRING							22
#define		FTAM_VISIBLE_STRING						26
#define		FTAM_GENERAL_STRING						27
#define		FTAM_OCTET_STRING						04
#define		FTAM_PRINTABLE_STRING					05
#define		FTAM_NODE_DESCRIPTOR_DATA_ELEMENT						0xa0
#define		FTAM_ENTER_SUBTREE_DATA_ELEMENT							0xa1
#define		FTAM_EXIT_SUBTREE_DATA_ELEMENT							0xa2
#define		FTAM_DATATYPE_NBS9										0xe2

#define		FTAM_CONTENTS_TYPE_PROPOSED_DOCUMENT_TYPE_NAME					14
#define		FTAM_CONTENTS_TYPE_PROPOSED_DOCUMENT_TYPE_PARAMETER				0

#define FTAM_PROCESSING_MODE_READ				0x0080
#define FTAM_PROCESSING_MODE_REPLACE			0x0040
#define FTAM_PROCESSING_MODE_INSERT				0x0020
#define FTAM_PROCESSING_MODE_EXTEND				0x0010
#define FTAM_PROCESSING_MODE_ERASE				0x0008


#define FTAM_NBS9_READ_FILENAME											0x8000
#define FTAM_NBS9_READ_PERMITTED_ACTIONS								0x4000
#define FTAM_NBS9_READ_CONTENTS_TYPE									0x2000
#define FTAM_NBS9_READ_STORAGE_ACCOUNT									0x1000
#define FTAM_NBS9_READ_DATE_AND_TIME_OF_CREATION						0x0800
#define FTAM_NBS9_READ_DATE_AND_TIME_OF_LAST_MODIFICATION				0x0400
#define FTAM_NBS9_READ_DATE_AND_TIME_OF_LAST_READ_ACCESS				0x0200
#define FTAM_NBS9_READ_DATE_AND_TIME_OF_LAST_ATTRIBUTE_MODIFICATION		0x0100
#define FTAM_NBS9_READ_IDENTITY_OF_CREATOR								0x0080
#define FTAM_NBS9_READ_IDENTITY_OF_LAST_MODIFIER						0x0040
#define FTAM_NBS9_READ_IDENTITY_OF_LAST_READER							0x0020
#define FTAM_NBS9_READ_IDENTITY_OF_LAST_ATTRIBUTE_MODIFIER				0x0010
#define FTAM_NBS9_READ_FILE_AVAILABILITY								0x0008
#define FTAM_NBS9_READ_FILESIZE											0x0004
#define FTAM_NBS9_READ_FUTURE_FILESIZE									0x0002
#define FTAM_NBS9_READ_ACCESS_CONTROL									0x0001
#define FTAM_NBS9_READ_LEGAL_QUALIFICATIONS								0x80
#define FTAM_NBS9_READ_PRIVATE_USE										0x40



#define FTAM_SELECT_ATTRIBUTES							19
#define FTAM_CREATE_ATTRIBUTES							12
#define FTAM_ACCESS_REQUEST								3
#define FTAM_ACCSESS_PASSWORDS							2 
#define FTAM_OVERRIDE									0

#define FTAM_ACCSESS_PASSWORDS							2 

#define FTAM_READ_ATTRIBUTES							18



#define FTAM_CREATE_FILENAME_ATTRIBUTES					0
#define FTAM_CREATE_PERMITTED_ACTIONS_ATTRIBUTE			1
#define FTAM_CREATE_CONTENTS_TYPE						2
#define FTAM_CREATE_ACCOUNT_ATTRIBUTE					3
#define FTAM_CREATE_FILE_AVAILABILITY_ATTRIBUTE			12
#define FTAM_CREATE_FILESIZE_ATTRIBUTE					14
#define FTAM_CREATE_ACCESS_CONTROL_ATTRIBUTE			15
#define FTAM_CREATE_ACCESS_LEGAL_AUALIFICATION_ATTRIBUTE	16
#define FTAM_CREATE_ACCESS_PRIVATE_USE_ATTRIBUTE		17

#define FTAM_FILE_ACCESS_DATA_UNIT_IDENTITY				15
#define FTAM_FILE_ACCESS_CONTEXT						1
#define FTAM_FILE_FADU_LOCK								16
#define FTAM_FILE_ACCESS_DATA_UNIT_OPERATION			0
#define FTAM_PERMITTED_ACTION_ATTRIBUTE_READ					0x8000
#define FTAM_PERMITTED_ACTION_ATTRIBUTE_INSERT					0x4000
#define FTAM_PERMITTED_ACTION_ATTRIBUTE_REPLACE					0x2000
#define FTAM_PERMITTED_ACTION_ATTRIBUTE_EXTEND					0x1000
#define FTAM_PERMITTED_ACTION_ATTRIBUTE_ERASE					0x0800
#define FTAM_PERMITTED_ACTION_ATTRIBUTE_READ_ATTRIBUTE			0x0400
#define FTAM_PERMITTED_ACTION_ATTRIBUTE_CHANGE_ATTRIBUTE		0x0200
#define FTAM_PERMITTED_ACTION_ATTRIBUTE_DELETE_FILE				0x0100
#define FTAM_PERMITTED_ACTION_ATTRIBUTE_TRAVERSAL				0x0080
#define FTAM_PERMITTED_ACTION_ATTRIBUTE_REVERSE_TRAVERSAL		0x0040
#define FTAM_PERMITTED_ACTION_ATTRIBUTE_RANDOM_ORDER			0x0020


#define			FTAM_ACCOUNT							8
#define			FTAM_FILESTORE_PASSWORD					17
#define			FTAM_SHARED_ASE_INFORMATION				20
#define			FTAM_INITIATOR_IDENTIFY					22
#define			FTAM_DOCUMENT_TYPE						0x4e

#define			FTAM_ABSTRACT_SYNTAX_NAME				0x40


/*  filename attributes   */
#define			FTAM_FILENAME_ATTRIBUTE_READ					0x0080
#define			FTAM_FILENAME_ATTRIBUTE_INSERT					0x0040
#define			FTAM_FILENAME_ATTRIBUTE_REPLACE					0x0020
#define			FTAM_FILENAME_ATTRIBUTE_EXTEND					0x0010
#define			FTAM_FILENAME_ATTRIBUTE_ERASE					0x0008
#define			FTAM_FILENAME_ATTRIBUTE_READ_ATTRIBUTE			0x0004
#define			FTAM_FILENAME_ATTRIBUTE_CHANGE_ATTRIBUTE		0x0002
#define			FTAM_FILENAME_ATTRIBUTE_DELETE_FILE				0x0001



#define		IMPLEMENTATION_INFORMATION				29
#define		USER_INFORMATION						30

#define		ftam_EXTERNAL							8

#define		FTAM_RESPONSE_STATE_RESULT					21
/* dummy entry */
#define		FTAM_RESPONSE_ACTION_RESULT					555
#define		FTAM_RESPONSE_SHARED_ASE_INFORMATION		20
#define		FTAM_RESPONSE_DIAGNOSTIC					13

/*   definition list **/
#define   PRESENTATION_CONTEXT_IDENTIFIER		 2
#define   ABSTRACT_SYNTAX_NAME					 6
#define   TRANSFER_SYNTAX_NAMES					 0x30
/*   result    list */
#define   PRESENTATION_RESULT								0x80
#define   PRESENTATION_RESULT_TRANSFER_SYNTAX_NAME			0x81
#define   PRESENTATION_RESULT_INTEGER						0x82

/*     result  values  */
#define   PRESENTATION_RESULT_ACCEPTANCE		 0
#define   PRESENTATION_RESULT_USER_REJECTION	 1
#define   PRESENTATION_RESULT_PROVIDER_REJECTION 2


/*  user data   */
#define   SIMPLY_ENCODED_DATA											0x60
#define   FULLY_ENCODED_DATA											0x61



#define			FTAM_PROTOCOL_VERGION									0x0080

/*   functional units  */
#define			FTAM_FUNCTIONAL_UNIT_READ								0x2000
#define			FTAM_FUNCTIONAL_UNIT_WRITE								0x1000
#define			FTAM_FUNCTIONAL_UNIT_FILE_ACCESS						0x0800
#define			FTAM_FUNCTIONAL_UNIT_LIMITED_FILE_MANAGEMENT			0x0400
#define			FTAM_FUNCTIONAL_UNIT_ENHANCED_FILE_MANAGEMENT			0x0200
#define			FTAM_FUNCTIONAL_UNIT_GROUPING							0x0100
#define			FTAM_FUNCTIONAL_FADU_LOCKING							0x0080
#define			FTAM_FUNCTIONAL_UNIT_RECOVERY							0x0040
#define			FTAM_FUNCTIONAL_UNIT_RESTART_DATA_TRANSFER				0x0020

/*    service classes   */
#define			FTAM_FUNCTIONAL_UNIT_UNCONSTRAINED_CLASS				0x80
#define			FTAM_FUNCTIONAL_UNIT_MANAGEMENT_CLASS					0x40
#define			FTAM_FUNCTIONAL_UNIT_TRANSFER_CLASS						0x20
#define			FTAM_FUNCTIONAL_UNIT_TRANSFER_AND_MANAGEMENT_CLASS		0x10
#define			FTAM_FUNCTIONAL_UNIT_ACESS_CLASS						0x08

/*     attribute  group  */
#define			FTAM_ATTRIBUTE_GROUPS_STORAGE							0x80
#define			FTAM_ATTRIBUTE_GROUPS_SECURITY							0x40
#define			FTAM_ATTRIBUTE_GROUPS_PRIVATE							0x20

#define			DATA_BULK_PDU											0xbf
#define			MAXSTRING												256
#define			ABORT_REASON_LEN			3



#define			GRAPHIC_STRING				"Graphic string"
enum
{
ERROR_MESSAGE_FTAM_NO_REASON,
ERROR_MESSAGE_FTAM_RESPONDER_ERROR,
ERROR_MESSAGE_FTAM_SYSTEM_SHUTDOWN,
ERROR_MESSAGE_FTAM_MANAGEMENT_PROBLEM_U,
ERROR_MESSAGE_FTAM_MANAGEMENT_PROBLEM_BA,
ERROR_MESSAGE_FTAM_MANAGEMENT_PROBLEM_SC,
ERROR_MESSAGE_DELAY_MAYBE_ENCOUNTERED,
ERROR_MESSAGE_INITIATOR_ERROR,
ERROR_MESSAGE_SUBSEQUENT_ERROR,
ERROR_MESSAGE_TEMPORAL_INSUFFICIENCY_OF_RESOURCES,
ERROR_MESSAGE_ACCESS_REQUEST_VIOLATES_VFS_SECURITY,
ERROR_MESSAGE_ACCESS_REQUEST_VIOLATES_LOCAL_SECURITY
};
enum
{
ERROR_MESSAGE_CONFLICTING_PARAMETER_VALUE=1000,
ERROR_MESSAGE_UNSUPPORTED_PARAMETER_VALUE,
ERROR_MESSAGE_MANDATORY_PARAMETER_NOT_SET,
ERROR_MESSAGE_UNSUPPORTED_PARAMETER,
ERROR_MESSAGE_DUBLICATED_PARAMETER,
ERROR_MESSAGE_ILLEGAL_PARAMETER_TYPE,
ERROR_MESSAGE_UNSUPPORTED_PARAMETER_TYPE,
ERROR_MESSAGE_FTAM_PROTOCOL_ERROR_U,
ERROR_MESSAGE_FTAM_PROTOCOL_ERROR_PE,
ERROR_MESSAGE_FTAM_PROTOCOL_ERROR_FUE,
ERROR_MESSAGE_FTAM_PROTOCOL_ERROR_CE,
ERROR_MESSAGE_FTAM_LOWER_LAYER_FAILURE,
ERROR_MESSAGE_FTAM_LOWER_ADDRESING_ERROR,
ERROR_MESSAGE_FTAM_TIMEOUT,
ERROR_MESSAGE_FTAM_SYSTEM_SHUTDOWN_,
ERROR_MESSAGE_FTAM_ILLEGAL_GROUPING_SEQUENCE,
ERROR_MESSAGE_GROUPING_THRESHHOLD_VIOLATION,
ERROR_MESSAGE_SPECIFIC_PDU_REQUEST_INCONSISTENT
};
enum
{
ERROR_MESSAGE_ASSOCIATION_WITH_USER_NOT_ALLOWED=2000,
ERROR_MESSAGE_NOT_ASSIGNED,
ERROR_MESSAGE_UNSUPPORTED_SERVICE_CLASS,
ERROR_MESSAGE_UNSUPPORTED_FUNCTIONAL_UNIT,
ERROR_MESSAGE_ATTRIBUTE_GROUP_ERROR,
ERROR_MESSAGE_ATTRIBUTE_GROUP_NOT_ALLOWED,
ERROR_MESSAGE_BAD_ACCOUNT,
ERROR_MESSAGE_ASSOC_MANAGEMENT,
ERROR_MESSAGE_ASSOC_MANAGEMENT_BA,
ERROR_MESSAGE_ASSOC_MANAGEMENT_BAC,
ERROR_MESSAGE_CHECKPOINT_W_E_TL,
ERROR_MESSAGE_CHECKPOINT_W_E_TS,
ERROR_MESSAGE_CHECKPOINT_W_E_UN,
ERROR_MESSAGE_COMMUNICATION_QOS_NOT_SUPPORTED,
ERROR_MESSAGE_INITIATOR_IDENTITY_UNACCEPTABLE,
ERROR_MESSAGE_CONTEXT_MANAGEMENT_REFUSED,
ERROR_MESSAGE_ROLLBACK_NOT_AVAILABLE,
ERROR_MESSAGE_CONTENTS_TYPE_LIST_CUT_BY_R,
ERROR_MESSAGE_CONTENTS_TYPE_LIST_CUT_BY_P,
ERROR_MESSAGE_INVALID_FILESTORE_PASSWORD,
ERROR_MESSAGE_INCOMPATABLE_SERVICE_CLASS
};
enum
{
ERROR_MESSAGE_FILENAME_NOT_FOUND=3000,
ERROR_MESSAGE_SELECTION_ATTRIBUTES_NOT_MATCHED,
ERROR_MESSAGE_INITIAL_ATTRIBUTES_NOT_POSSIBLE,
ERROR_MESSAGE_BAD_ATTRIBUTE_NAME,
ERROR_MESSAGE_NON_EXISTENT_FILE,
ERROR_MESSAGE_FILE_ALREADY_EXISTS,
ERROR_MESSAGE_FILE_CANNOT_BE_CREATED,
ERROR_MESSAGE_FILE_CANNOT_BE_DELETED,
ERROR_MESSAGE_CONCURRENCY_CONTROL_NOT_AVAILABLE,
ERROR_MESSAGE_CONCURRENCY_CONTROL_NOT_SUPPORTED,
ERROR_MESSAGE_CONCURRENCY_CONTROL_NOT_POSSIBLE,
ERROR_MESSAGE_MORE_RESTRICTIVE_LOCK,
ERROR_MESSAGE_FILE_BUSY,
ERROR_MESSAGE_ACCESS_CONTROL_NOT_AVAILABLE,
ERROR_MESSAGE_ACCESS_CONTROL_NOT_SUPPORTED,
ERROR_MESSAGE_ACCESS_CONTROL_INCONSISTENT,
ERROR_MESSAGE_FILENAME_TRUNCATED,
ERROR_MESSAGE_INITIAL_ATTRIBUTES_ALTERED,
ERROR_MESSAGE_BAD_ACCOUNT_,
ERROR_MESSAGE_OVERRIDE_SELECTED_EXISTING_FILE,
ERROR_MESSAGE_OVERRIDE_DELETED_AND_RECREATED_FILE_OLD,
ERROR_MESSAGE_OVERRIDE_DELETED_AND_RECREATED_FILE_NEW,
ERROR_MESSAGE_CREATE_OVERRIDE_NOT_POSSIBLE,
ERROR_MESSAGE_AMBIGUOUS_FILE_SPECIFICATION,
ERROR_MESSAGE_INVALID_CREATE_PASSWORD,
ERROR_MESSAGE_INVALID_DELETE_PASSWORD,
ERROR_MESSAGE_BAD_ATTRIBUTE_VALUE,
ERROR_MESSAGE_REQUESTED_ACCESS_VIOLATES_PERMITTED_ACTIONS,
ERROR_MESSAGE_REQUESTED_FUNCTIONAL_UNIT_NOT_AVAILABLE,
ERROR_MESSAGE_REQUESTED_FILE_CREATED_BUT_NOT_SELECTED
};
enum
{
ERROR_MESSAGE_ATTRIBUTE_NON_EXISTENT=4000,
ERROR_MESSAGE_ATTRIBUTE_CANNOT_BE_READ,
ERROR_MESSAGE_ATTRIBUTE_CANNOT_BE_CHANGED,
ERROR_MESSAGE_ATTRIBUTE_NOT_SUPPORTED,
ERROR_MESSAGE_BAD_ATTRIBUTE_NAME_,
ERROR_MESSAGE_BAD_ATTRIBUTE_VALUE_,
ERROR_MESSAGE_ATTRIBUTE_PARTIALLY_SUPPORTED,
ERROR_MESSAGE_ADDITIONAL_SET_ATTRIBUTE_
};
enum
{
ERROR_MESSAGE_ARD_BAD_FADU_U = 5000,
ERROR_MESSAGE_ARD_BAD_FADU_SIZE_ERROR,
ERROR_MESSAGE_ARD_BAD_FADU_TYPE_ERROR,
ERROR_MESSAGE_ARD_BAD_FADU_POORLY_SPECIFIED,
ERROR_MESSAGE_ARD_BAD_FADU_BAD_LOCATION,
ERROR_MESSAGE_ARD_FADU_DOES_NOT_EXIST,
ERROR_MESSAGE_ARD_FADU_NOT_AVAILABLE_U,
ERROR_MESSAGE_ARD_FADU_NOT_AVAILABLE_R,
ERROR_MESSAGE_ARD_FADU_NOT_AVAILABLE_W,
ERROR_MESSAGE_ARD_FADU_NOT_AVAILABLE_L,
ERROR_MESSAGE_ARD_FADU_NOT_AVAILABLE_E,
ERROR_MESSAGE_ARD_FADU_CAN_NOT_BE_INSERTED,
ERROR_MESSAGE_ARD_FADU_CAN_NOT_BE_REPLACED,
ERROR_MESSAGE_ARD_FADU_CAN_NOT_BE_LOCATED,
ERROR_MESSAGE_ARD_BAD_DATA_ELEMENT_TYPE,
ERROR_MESSAGE_ARD_OPERATION_NOT_AVAILABLE,
ERROR_MESSAGE_ARD_OPERATION_NOT_SUPPORTED,
ERROR_MESSAGE_ARD_OPERATION_NOT_INCONSISTENT,
ERROR_MESSAGE_ARD_CONCURENCY_CONTROL_NOT_AVAILABLE,
ERROR_MESSAGE_ARD_CONCURENCY_CONTROL_NOT_SUPPORTED,
ERROR_MESSAGE_ARD_CONCURENCY_CONTROL_NOT_INCONSISTENT,
ERROR_MESSAGE_ARD_PROCESSING_MODE_NOT_AVAILABLE,
ERROR_MESSAGE_ARD_PROCESSING_MODE_NOT_SUPPORTED,
ERROR_MESSAGE_ARD_PROCESSING_MODE_NOT_INCONSISTENT,
ERROR_MESSAGE_ARD_ACCESS_CONTEXT_NOT_AVAILABLE,
ERROR_MESSAGE_ARD_ACCESS_CONTEXT_NOT_SUPPORTED,
ERROR_MESSAGE_ARD_BAD_WRITE_U,
ERROR_MESSAGE_ARD_BAD_READ_U,
ERROR_MESSAGE_ARD_LOCAL_FAILURE_U,
ERROR_MESSAGE_ARD_LOCAL_FAILURE_FE,
ERROR_MESSAGE_ARD_LOCAL_FAILURE_DC,
ERROR_MESSAGE_ARD_LOCAL_FAILURE_DF,
ERROR_MESSAGE_ARD_FUTURE_FILE_SIZE_EXCEEDED,
ERROR_MESSAGE_ARD_FUTURE_FILE_SIZE_INCREASED,
ERROR_MESSAGE_ARD_FUNCTIONAL_UNIT_INVALID,
ERROR_MESSAGE_ARD_CONTENTS_TYPE_INCONSISTENT,
ERROR_MESSAGE_ARD_CONTENTS_TYPE_SIMPLIFIED,
ERROR_MESSAGE_ARD_DUBLICATE_FADU_NAME,
ERROR_MESSAGE_ARD_DAMAGE_TO_SO,
ERROR_MESSAGE_ARD_FADU_LOCKING_NOT_A,
ERROR_MESSAGE_ARD_FADU_LOCKED_BY_ANOTHER_USER
};
enum
{
ERROR_MESSAGE_RR_BAD_CHECKPOINT=6000,
ERROR_MESSAGE_RR_ACTIVITY_NOT_UNIQUE,
ERROR_MESSAGE_RR_CHECKPOINT_OUTSIDE_WINDOW,
ERROR_MESSAGE_RR_ACTIVITY_NO_LONGER_EXISTS,
ERROR_MESSAGE_RR_ACTIVITY_NO_LONGER_RECOGNIZED,
ERROR_MESSAGE_RR_ACTIVITY_NO_DOCKET,
ERROR_MESSAGE_RR_ACTIVITY_CORRUPT_DOCKET,
ERROR_MESSAGE_RR_FILE_WAITING_RESTART,
ERROR_MESSAGE_RR_BAD_RECOVERY_POINT,
ERROR_MESSAGE_RR_NON_EXISTENT_RECOVERY_POINT,
ERROR_MESSAGE_RR_RECOVERY_MODE_NOT_AVAILABLE,
ERROR_MESSAGE_RR_RECOVERY_MODE_INCONSISTENT,
ERROR_MESSAGE_RR_RECOVERY_MODE_REDUCE,
ERROR_MESSAGE_RR_ACCESS_CONTROL_NOT_A,
ERROR_MESSAGE_RR_ACCESS_CONTROL_NOT_S,
ERROR_MESSAGE_RR_ACCESS_CONTROL_I,
ERROR_MESSAGE_RR_CONTENTS_TYPE_I,
ERROR_MESSAGE_RR_CONTENTS_TYPE_S
};




