#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <unistd.h>
#include <locale.h>

#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <gdk-pixbuf/gdk-pixdata.h>

#include <gtk/gtk.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include <libxfcegui4/libxfcegui4.h>
#include <libxfce4mcs/mcs-client.h>
#include <libxfcegui4/netk-screen.h>
#include <libxfcegui4/netk-window.h>
#include <libxfce4util/libxfce4util.h>

#include "ls_iconboxconf.h"

#define CHANNEL "xfibx"
#define LS_PLUGIN_NAME "xfibx"
#define LS_PLUGIN_CAPTION N_("Lil' Star - Iconbox")

static void run_dialog(McsPlugin *pmcsPlugin);
/*static gboolean write_options(McsPlugin *pmcsPlugin);*/
McsPluginInitResult mcs_plugin_init(McsPlugin *pmcsPlugin);

static gboolean bIsRunning = FALSE;

static void response(
  GtkWidget 	*pWidget,
  gint		nResponseId
) {
  switch(nResponseId)
  {
    case GTK_RESPONSE_HELP:
      break;
    case GTK_RESPONSE_APPLY:
      break;
    case GTK_RESPONSE_CLOSE:
      bIsRunning = FALSE;
      gtk_widget_destroy(pWidget);
      break;
    default:
      DBG("this should not happen!");
  };
};

McsPluginInitResult mcs_plugin_init(McsPlugin *pmcsPlugin)
{
  /* This is required for UTF-8 at least - Please don't remove it  */
  xfce_textdomain(GETTEXT_PACKAGE, LOCALEDIR, "UTF-8");

  ls_iconboxconf_read(NULL, pmcsPlugin->manager);
  pmcsPlugin->plugin_name = g_strdup(LS_PLUGIN_NAME);
  pmcsPlugin->caption = g_strdup(_(LS_PLUGIN_CAPTION));
  pmcsPlugin->run_dialog = run_dialog;
  pmcsPlugin->icon = xfce_themed_icon_load ("xfce4-iconbox.png", 48);
  mcs_manager_notify(pmcsPlugin->manager, CHANNEL);

  return (MCS_PLUGIN_INIT_OK);
};

static void run_dialog(McsPlugin *pmcsPlugin)
{
  LSIconBoxConf *plsibwc;
 
  if(bIsRunning) 
  {
    DBG("bIsRunning return!");
    return;
  }

  bIsRunning = TRUE;
  
  /* This is required for UTF-8 at least - Please don't remove it  */
  xfce_textdomain(GETTEXT_PACKAGE, LOCALEDIR, "UTF-8");

  plsibwc = ls_iconboxconf_create_configwin((LSIconBoxWin *)NULL);
  ls_iconboxconf_set_mcsmanager(plsibwc, pmcsPlugin->manager);
  plsibwc->priv->pmcsPlugin = pmcsPlugin;
  ls_iconboxconf_re_evaluate_settings(plsibwc);
  ls_iconboxconf_connect_signals(plsibwc);
  
  g_signal_connect(G_OBJECT(plsibwc->priv->pWindow), "response",
     G_CALLBACK(response), pmcsPlugin);
  gtk_widget_show_all(GTK_WIDGET(plsibwc->priv->pWindow));
};

/* macro defined in manager-plugin.h						*/
MCS_PLUGIN_CHECK_INIT
