/*
 * SCIM Bridge
 *
 * Copyright (c) 2006 Ryo Dairiki <ryo-dairiki@users.sourceforge.net>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.*
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
 * GNU Lesser General Public License for more details.*
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */

#ifndef SCIMBRIDGECLIENT_H_
#define SCIMBRIDGECLIENT_H_

#include "scim-bridge.h"
#include "scim-bridge-key-event.h"
#include "scim-bridge-client-imcontext.h"

#ifdef __cplusplus
extern "C"
{
#endif

    /**
     * Initialize the client.
     *
     * @return RETVAL_SUCCEEDED if succeeded, otherwise it returns RETVAL_FAILED.
     */
    retval_t scim_bridge_client_initialize ();

    /**
     * Finalize the client.
     *
     * @return RETVAL_SUCCEEDED if succeeded, otherwise it returns RETVAL_FAILED.
     */
    void scim_bridge_client_finalize ();

    /**
     * Check if the client is active.
     *
     * @return TRUE if it's active, otherwise it returns FALSE.
     */
    boolean scim_bridge_client_is_active ();

    /**
     * Get the socket file discriptor of the client.
     *
     * @return The socket file descriptor of the client.
     */
    int scim_bridge_client_get_socket_fd ();

    /**
     * Read a message from the socket, and dispatch it.
     * If no message is available, it returns immediately.
     *
     * @return RETVAL_SUCCEEDED if no error has occured, otherwise it returns RETVAL_FAILED.
     */
    retval_t scim_bridge_client_read_and_dispatch ();

    /**
     * Alloc an imcontext.
     *
     * @param imcontext The pointer to initialize as an imcontext.
     * @return RETVAIL_SUCCEDED if succeeded, otherwise it returns RETVAIL_FAILED.
     */
    retval_t scim_bridge_client_alloc_imcontext (ScimBridgeClientIMContext *imcontext);

    /**
     * Free an imcontext.
     *
     * @param imcontext The imcontext to free.
     * @return RETVAIL_SUCCEDED if succeeded, otherwise it returns RETVAIL_FAILED.
     */
    retval_t scim_bridge_client_free_imcontext (ScimBridgeClientIMContext *imcontext);

    /**
     * Reset an imcontext.
     *
     * @param imcontext The imcontext.
     * @return RETVAIL_SUCCEDED if succeeded, otherwise it returns RETVAIL_FAILED.
     */
    retval_t scim_bridge_client_reset_imcontext (const ScimBridgeClientIMContext *imcontext);

    retval_t scim_bridge_client_focus_changed (const ScimBridgeClientIMContext *imcontext, boolean focus_in);

    retval_t scim_bridge_client_key_event_occured (const ScimBridgeClientIMContext *imcontext, const ScimBridgeKeyEvent *key_event, boolean *consumed);
    retval_t scim_bridge_client_cursor_location_changed (const ScimBridgeClientIMContext *imcontext, int x, int y);
    retval_t scim_bridge_client_set_preedit_enabled (const ScimBridgeClientIMContext *imcontext, boolean enabled);

#ifdef __cplusplus
}
#endif
#endif                                            /*SCIMBRIDGECLIENT_H_*/
