/*
 * SCIM Bridge
 *
 * Copyright (c) 2006 Ryo Dairiki <ryo-dairiki@users.sourceforge.net>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.*
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
 * GNU Lesser General Public License for more details.*
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */

#include <alloca.h>
#include <stdarg.h>
#include <stdio.h>
#include <string.h>

#include "scim-bridge-debug.h"
#include "scim-bridge-output.h"

/* Implementations */
void scim_bridge_println (const char *string,...)
{
    va_list ap;
    const size_t str_length = strlen (string);
    char *format = alloca (sizeof (char) * (str_length + 2));
    strcpy (format, string);
    format[str_length] = '\n';
    format[str_length + 1] = '\0';
    va_start (ap, string);
    vfprintf (stdout, format, ap);
    va_end (ap);
}


void scim_bridge_perrorln (const char *string,...)
{
    va_list ap;
    const size_t str_length = strlen (string);
    char *format = alloca (sizeof (char) * (str_length + 2));
    strcpy (format, string);
    format[str_length] = '\n';
    format[str_length + 1] = '\0';
    va_start (ap, string);
    vfprintf (stderr, format, ap);
    va_end (ap);
}


void scim_bridge_pdebugln (scim_bridge_debug_flag_t flag, scim_bridge_debug_level_t level, const char *string,...)
{
    if ((flag & scim_bridge_debug_get_flags ()) && ((10 - level) <= scim_bridge_debug_get_level ())) {
        va_list ap;
        va_start (ap, string);
        const size_t str_length = strlen (string);
        char *format = alloca (sizeof (char) * (str_length + 2));
        strcpy (format, string);
        format[str_length] = '\n';
        format[str_length + 1] = '\0';
        vfprintf (stdout, format, ap);
        va_end (ap);
    }
}


void scim_bridge_print (const char *string,...)
{
    va_list ap;
    va_start (ap, string);
    vfprintf (stdout, string, ap);
    va_end (ap);
}


void scim_bridge_perror (const char *string,...)
{
    va_list ap;
    va_start (ap, string);
    vfprintf (stderr, string, ap);
    va_end (ap);
}


void scim_bridge_pdebug (scim_bridge_debug_flag_t flag, scim_bridge_debug_level_t level, const char *string,...)
{
    if ((flag & scim_bridge_debug_get_flags ()) && ((10 - level) <= scim_bridge_debug_get_level ())) {
        va_list ap;
        va_start (ap, string);
        vfprintf (stdout, string, ap);
        va_end (ap);
    }
}
