/*
 * SCIM Bridge
 *
 * Copyright (c) 2006 Ryo Dairiki <ryo-dairiki@users.sourceforge.net>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.*
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
 * GNU Lesser General Public License for more details.*
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */

#ifndef SCIMBRIDGEAGENTEVENTCLIENT_H_
#define SCIMBRIDGEAGENTEVENTCLIENT_H_

#include <pthread.h>
#include <semaphore.h>

#include <list>

#include "scim-bridge.h"

#include "scim-bridge-agent-event.h"
#include "scim-bridge-agent-event-server.h"

typedef int scim_bridge_agent_event_client_id_t;

class ScimBridgeAgentEventServer;

class ScimBridgeAgentEventClient
{

    public:

        virtual ~ScimBridgeAgentEventClient ();

        void close_event_client ();

        void push_event (const ScimBridgeAgentEvent *event);
        const ScimBridgeAgentEvent *poll_response ();

        ScimBridgeAgentEventServer *get_event_server ();
        void set_event_server (ScimBridgeAgentEventServer *server);

        scim_bridge_agent_event_client_id_t get_event_client_id () const;
        void set_event_client_id (scim_bridge_agent_event_client_id_t id);

    protected:

        ScimBridgeAgentEventClient ();

        virtual void do_close_event_client () = 0;

        const ScimBridgeAgentEvent *poll_event ();
        void push_response (const ScimBridgeAgentEvent *event);

    private:

        ScimBridgeAgentEventServer *event_server;

        scim_bridge_agent_event_client_id_t event_client_id;

        std::list<const ScimBridgeAgentEvent*> events;
        std::list<const ScimBridgeAgentEvent*> responses;

        pthread_mutex_t mutex;
        sem_t semaphore;

};
#endif                                            /*SCIMBRIDGEAGENTEVENTCLIENT_H_*/
