/*
 * SCIM Bridge
 *
 * Copyright (c) 2006 Ryo Dairiki <ryo-dairiki@users.sourceforge.net>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.*
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
 * GNU Lesser General Public License for more details.*
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */

#ifndef SCIMBRIDGEAGENTSURROUNDINGTEXTGOTTENEVENT_H_
#define SCIMBRIDGEAGENTSURROUNDINGTEXTGOTTENEVENT_H_

#include <scim.h>

#include "scim-bridge-agent-event.h"
#include "scim-bridge-message.h"

class ScimBridgeAgentSurroundingTextGottenEvent: public ScimBridgeAgentEvent
{

    public:

        ScimBridgeAgentSurroundingTextGottenEvent (scim_bridge_message_response_id_t new_id, const scim::WideString &new_string, int caret, bool new_ret);
        ~ScimBridgeAgentSurroundingTextGottenEvent ();

        scim_bridge_message_response_id_t get_response_id () const;

        const scim::WideString &get_surrounding_text () const;

        int get_cursor_position () const;

        bool get_retval () const;

    private:

        scim_bridge_message_response_id_t response_id;

        const scim::WideString surrounding_text;

        int cursor_position;

        bool retval;

};
#endif                                            /*SCIMBRIDGEAGENTSURROUNDINGTEXTGOTTENEVENT_H_*/
