/*
 * SCIM Bridge
 *
 * Copyright (c) 2006 Ryo Dairiki <ryo-dairiki@users.sourceforge.net>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.*
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
 * GNU Lesser General Public License for more details.*
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */

#include "scim-bridge-agent-surrounding-text-deleted-event.h"

using namespace scim;

ScimBridgeAgentSurroundingTextDeletedEvent::ScimBridgeAgentSurroundingTextDeletedEvent (scim_bridge_message_response_id_t new_id, bool new_ret, bool reset):
ScimBridgeAgentEvent (SURROUNDING_TEXT_DELETED_EVENT), response_id (new_id), retval (new_ret), reset_needed (reset)
{
}


ScimBridgeAgentSurroundingTextDeletedEvent::~ScimBridgeAgentSurroundingTextDeletedEvent ()
{
}


scim_bridge_message_response_id_t ScimBridgeAgentSurroundingTextDeletedEvent::get_response_id () const
{
    return response_id;
}


bool ScimBridgeAgentSurroundingTextDeletedEvent::get_retval () const
{
    return retval;
}


bool ScimBridgeAgentSurroundingTextDeletedEvent::is_reset_needed () const
{
    return reset_needed;
}
