#include "scim-bridge-agent-filter-key-event.h"

using namespace scim;

ScimBridgeAgentFilterKeyEvent::ScimBridgeAgentFilterKeyEvent (scim_bridge_imcontext_id_t new_id, const KeyEvent &new_key_event, ScimBridgeAgentClientListener *new_client_listener):
ScimBridgeAgentEvent (FILTER_KEY_EVENT),
imcontext_id (new_id), key_event (new_key_event), client_listener (new_client_listener)
{
}


ScimBridgeAgentFilterKeyEvent::~ScimBridgeAgentFilterKeyEvent ()
{
}


scim_bridge_imcontext_id_t ScimBridgeAgentFilterKeyEvent::get_imcontext_id () const
{
    return imcontext_id;
}


const KeyEvent &ScimBridgeAgentFilterKeyEvent::get_key_event () const
{
    return key_event;
}


ScimBridgeAgentClientListener *ScimBridgeAgentFilterKeyEvent::get_client_listener () const
{
    return client_listener;
}
