/* -*- c-file-style: "ruby"; indent-tabs-mode: nil -*- */
/************************************************

  rbgtkselection.c -

  $Author: mutoh $
  $Date: 2004/06/01 17:33:19 $

  Copyright (C) 2002,2003 Masao Mutoh

  This file is devided from rbgtkwidget.c.
  rbgtkwidget.c -
  Copyright (C) 1998-2000 Yukihiro Matsumoto,
                          Daisuke Kanda,
                          Hiroshi Igarashi
************************************************/
#include "global.h"

#define RVAL2WIDGET(w) (GTK_WIDGET(RVAL2GOBJ(w)))

static VALUE
gtkdrag_selection_owner_set(argc, argv, self)
    int argc;
    VALUE* argv;
    VALUE self;
{
    gboolean ret;

    if (argc == 3){
        VALUE widget, selection, time;
        rb_scan_args(argc, argv, "30", &widget, &selection, &time);
        ret = gtk_selection_owner_set(RVAL2WIDGET(widget), 
                                      RVAL2ATOM(selection), NUM2INT(time));
    } else {
#if GTK_CHECK_VERSION(2,2,0)
        VALUE display, widget, selection, time;
        rb_scan_args(argc, argv, "40", &display, &widget, &selection, &time);
        ret = gtk_selection_owner_set_for_display(GDK_DISPLAY_OBJECT(RVAL2GOBJ(display)),
                                                  RVAL2WIDGET(widget), 
                                                  RVAL2ATOM(selection), NUM2INT(time));
#else
        rb_raise(rb_eArgError, "Wrong number of arguments: %d", argc);
#endif
    }
    return CBOOL2RVAL(ret);
}

static VALUE
gtkdrag_selection_add_target(self, widget, selection, target, info)
    VALUE self, widget, selection, target, info;
{
    gtk_selection_add_target(RVAL2WIDGET(widget), RVAL2ATOM(selection),
                             RVAL2ATOM(target), NUM2INT(info));
    return self;
}

static VALUE
gtkdrag_selection_add_targets(self, widget, selection, targets)
    VALUE self, widget, selection, targets;
{
    gtk_selection_add_targets(RVAL2WIDGET(widget), 
                              RVAL2ATOM(selection),
                              rbgtk_get_target_entry(targets), RARRAY(targets)->len);
    return self;
}

static VALUE
gtkdrag_selection_clear_targets(self, widget, selection)
    VALUE self, widget, selection;
{
    gtk_selection_clear_targets(RVAL2WIDGET(widget), RVAL2ATOM(selection));
    return self;
}

static VALUE
gtkdrag_selection_convert(self, widget, selection, target, time)
    VALUE self, widget, selection, target, time;
{
    gboolean ret = gtk_selection_convert(RVAL2WIDGET(widget), 
                                         RVAL2ATOM(selection), RVAL2ATOM(target),
                                         NUM2INT(time));
    return ret ? Qtrue : Qfalse;
}

static VALUE
gtkdrag_selection_remove_all(self, widget)
    VALUE self, widget;
{
    gtk_selection_remove_all(RVAL2WIDGET(widget));
    return self;
}

void
Init_gtk_selection()
{
    VALUE mSelection =  rb_define_module_under(mGtk, "Selection");

    rb_define_module_function(mSelection, "owner_set", gtkdrag_selection_owner_set, 3);
    rb_define_module_function (mSelection, "add_target", gtkdrag_selection_add_target, 4);
    rb_define_module_function(mSelection, "add_targets", gtkdrag_selection_add_targets, 3);
    rb_define_module_function(mSelection, "clear_targets", gtkdrag_selection_clear_targets, 2);
    rb_define_module_function(mSelection, "convert", gtkdrag_selection_convert, 4);
    rb_define_module_function(mSelection, "remove_all", gtkdrag_selection_remove_all, 1);
}
