/**
 * # CHAPTER #
 * ============================================================================
 * MUSASHIѤ뽸״Ϣδؿ
 * ============================================================================
 */
#include <musashi/mssBase.h>
#include <musashi/mssAgg.h>
#include <musashi/mssValue.h>
#include <musashi/mssOption.h>
#include <musashi/mssInput.h>
#include <musashi/mssOutput.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>

static MssValue *getAggValMem(enum MssAggType aggType, int fc);

/**
 * Хѿ
 */
extern struct mssGlobalVariables mssGV;

static MssOptKEY *OptKey;           /*-kѥ᡼*/
static MssOptFLD *OptFld;           /*-fѥ᡼*/
static int  FldCnt;              /*פܿ*/
static enum MssAggType AGGType;  /*ˡ("sum","avg",...)*/
static char fname[MssFileNameMaxLen]; /*ե̾*/
static char readEnd[2]={0xff,0}; /*ʼ*/

/**
 * # SECTION #
 * ----------------------------------------------------------------------------
 * ֹ(Red Black Tree)
 * ----------------------------------------------------------------------------
 * ʸ: إǡ¤ȥ르ꥺٶΩ,2000,64.
 * p.224 9ܤϸ!!
 * ) if (v == NULL ) return(1) -> ) if (v == NULL ) return(0)
 */

/**
 * # FUNCTION #
 */
static int RBAGhasLeftNode(struct RBAGnode *v)
{
  if(v->left->rank !=0){
    return(1);
  }
  return(0);
}

/**
 * # FUNCTION #
 */
static int RBAGisExternalNode(struct RBAGnode *v)
{
  if(v->rank==0)
    return(1);
  return(0);
}

/**
 * # FUNCTION #
 */
static int RBAGisTopNode(struct RBAGnode *v)
{
  if(v->parent->rank==0){
    return(1);
  }
  return(0);
}

/**
 * # FUNCTION #
 */
static int RBAGisLeftNode(struct RBAGnode *v)
{
  if(v==v->parent->left)
    return(1);
  return(0);
}

/**
 * # FUNCTION #
 */
static int RBAGisRedNode(struct RBAGnode *v)
{
  if(v==NULL) return(0);
  if(v->rank == v->parent->rank)
    return(1);
  return(0);
}

/**
 * # FUNCTION #
 */
static struct RBAGnode *RBAGfindMax(struct RBAGnode *v)
{
  while(!RBAGisExternalNode(v->right))
    v=v->right;
  return(v);
}

/**
 * # FUNCTION #
 */
static struct RBAGnode *RBAGfind_brother(struct RBAGnode *v)
{
  if(RBAGisLeftNode(v))
    return(v->parent->right);
  return(v->parent->left);
}

/**
 * # FUNCTION #
 */
static struct RBAGnode *RBAGmakeNode(void)
{
  struct RBAGnode *new;
  struct RBAGkey  *key;
  new=(struct RBAGnode *)mssMalloc(sizeof(struct RBAGnode),"RBAGmkNode");
  key=(struct RBAGkey  *)mssMalloc(sizeof(struct RBAGkey) ,"RBAGmkNode");
  new->key=key;
  /*new->key.str[0]='\0';*/
  new->key->str=NULL;
  new->rank = 0;
  new->left=new->right=NULL;
  return new;
}

/**
 * # FUNCTION #
 */
static void RBAGfreeKey(struct RBAGkey *key)
{
  mssFree(key->str);
  mssFree(key->fld);
  mssFree(key->val);
  mssFree(key->bkt);
  mssFree(key);
}

/**
 * # FUNCTION #
 */
static void RBAGfreeNode(struct RBAGnode *v)
{
  if(RBAGisExternalNode(v)){
    mssFree(v->key);
    mssFree(v);
    return;
  }else{
    RBAGfreeKey(v->key);
    mssFree(v);
    return;
  }
}

/**
 * # FUNCTION #
 */
static void RBAGfreeAllNode(struct RBAGnode *v)
{
  if(RBAGisExternalNode(v)){
    mssFree(v->key);
    mssFree(v);
    return;
  }else{
    RBAGfreeAllNode(v->left);
    RBAGfreeAllNode(v->right);
    RBAGfreeNode(v);
    return;
  }
}

/**
 * # FUNCTION #
 */
static int keyCmp(struct mssFldRec *fr, struct RBAGnode *v)
{
  int i;
  int cmp;

  for(i=0; i<OptKey->flds->cnt; i++){
    if( 0 != ( cmp=strcmp( *(fr->pnt+MssFlds2num(OptKey->flds,i)),
                           *(v->key->fld+MssFlds2num(OptKey->flds,i)) )) ){
      return(cmp);
    }
  }
  return(0); /*Ʊ!!*/
}

/**
 * # FUNCTION #
 */
static struct RBAGnode *RBAGmember(struct mssFldRec *fr, struct RBAGnode *v)
{
  struct RBAGnode *vv;

  if(RBAGisExternalNode(v)) return(v);

  if( 0 > keyCmp(fr, v) ){
    vv=RBAGmember(fr,v->left);
  }else if( 0 < keyCmp(fr, v) ){
    vv=RBAGmember(fr,v->right);
  }else{
    return(v);
  }
  return(vv);
}

/**
 * # FUNCTION #
 */
static void RBAGaddExternalNodes(struct RBAGnode *n)
{
  n->left = RBAGmakeNode();
  n->right= RBAGmakeNode();
  n->left->parent =n;
  n->right->parent=n;
}

/**
 * # FUNCTION #
 */
static void RBAGsingleRotate(struct RBAGnode *v)
{
  struct RBAGnode *p, *pp,*ppp;

  p  =v->parent;
  pp =p->parent;
  ppp=pp->parent;

  if(RBAGisLeftNode(pp)){
    ppp->left=p;
  }else{
    ppp->right=p;
  }
  if(RBAGisLeftNode(v)){
    pp->left=p->right;
    pp->left->parent=pp;
    p->right=pp;
    pp->parent=p;
  }else{
    pp->right = p->left;
    pp->right->parent = pp;
    p->left = pp;
    pp->parent = p;
  }
  p->parent=ppp;
}

/**
 * # FUNCTION #
 */
static void RBAGdouble_rotate(struct RBAGnode *v)
{
  struct RBAGnode *p;
  p=v->parent;
  if(RBAGisLeftNode(v)){
    RBAGsingleRotate(v->left);
    RBAGsingleRotate(p);
  }else{
    RBAGsingleRotate(v->right);
    RBAGsingleRotate(p);
  }
}

/**
 * # FUNCTION #
 */
static void RBAGrebalanceOnInsert(struct RBAGnode *v)
{
  struct RBAGnode *w, *p, *pp;
  int p_is_left;
  
  p=v->parent;
  pp=p->parent;
  if(RBAGisTopNode(p)){
    return;
  }
  if(RBAGisRedNode(p)){
    p_is_left=0;   
    if((p_is_left=RBAGisLeftNode(p))){  
      w=pp->right;
    }else{
      w=pp->left;
    }
    if(RBAGisRedNode(w)){   
      (pp->rank)++;
      if(!RBAGisTopNode(pp) && RBAGisRedNode(pp->parent)){
        RBAGrebalanceOnInsert(pp);
      }
    }else{
      if(RBAGisLeftNode(v)){
        if(p_is_left){
          RBAGsingleRotate(v);
        }else{
          RBAGdouble_rotate(v);
        }
      }else{
        if(p_is_left){
          RBAGdouble_rotate(v);
        }else{
          RBAGsingleRotate(v);
        }
      }
    }
  }
}

/**
 * # FUNCTION #
 */
static void RBAGdetermineAB(struct RBAGnode **a, struct RBAGnode **b, struct RBAGnode *v, struct RBAGnode *u)
{
  if(RBAGisLeftNode(v)){
    *a=u->right;
    *b=u->left;
  }else{
    *a=u->left;
    *b=u->right;
  }
}

/**
 * # FUNCTION #
 */
static void RBAGrebalanceOnDelete(struct RBAGnode *v)
{
  struct RBAGnode *p,*u,*a,*b;
  int v_is_left, p_was_red;

  p=v->parent;
  if(v->rank+1 >= p->rank)
    return;
  u=RBAGfind_brother(v);
  RBAGdetermineAB(&a,&b,v,u);
  v_is_left=RBAGisLeftNode(v);
  p_was_red=RBAGisRedNode(p);
  if(RBAGisRedNode(u)){
    if(RBAGisRedNode(a) || RBAGisRedNode(b))
      return;
    RBAGsingleRotate(a);
    RBAGrebalanceOnDelete(v);
  }else{
    if(!RBAGisRedNode(a)){
      if(!RBAGisRedNode(b)){
        (p->rank)--;
        if(!p_was_red)
          RBAGrebalanceOnDelete(p);
      }else{
        RBAGdouble_rotate(b);
        (b->rank)++;
        (p->rank)--;
      }
    }else{
      RBAGsingleRotate(a);
      (u->rank)++;
      (u->rank)--;
    }
  }
}


/**
 * # FUNCTION #
 */
static void RBAGptree(struct RBAGnode *p,int h)
{
  int i,j;

  if(!RBAGisExternalNode(p)){
    RBAGptree(p->left, h+1);
    if(0 == strcmp(p->key->str,readEnd) ){
      for(i=1; i<=h; i++) fprintf(stderr,"    ");
      printf("key='EOF' ");
      /*printf(" bktCnt=%d bkt=",p->key->bktCnt);*/
      for(j=0; j<PWayA; j++){
        if(*(p->key->bkt+j) == 1)
        printf("%d ",j);
      }
      printf("\n");
    }else{
      for(i=0; i<h; i++) printf("  ");
      printf("key='");
      for(j=0; j<OptKey->flds->cnt; j++){
        printf("%s ",*(p->key->fld+MssFlds2num(OptKey->flds,j)));
      }
      printf("' fld=");
      for(j=0; j<OptFld->flds->cnt; j++){
        printf("%g ",(p->key->val+j)->v.d);
      }

      /*printf(" bktCnt=%d bkt=",p->key->bktCnt);*/
      for(j=0; j<PWayA; j++){
        if(*(p->key->bkt+j) == 1)
        printf("%d ",j);
      }
      /*for(j=0; j<p->key->bktCnt; j++){*/
      /*  printf("%d ",*(p->key->bkt+j));*/
      /*}*/
      printf("\n");
    }   
    RBAGptree(p->right,h+1);
  }
}

/**
 * # FUNCTION #
 * RBAGcpKeyδؿǳݤ줿̤η׻
 */
static int RBAGcpKeyMemCnt(struct mssFldRec *fr)
{

  int memCnt=0;

  if(fr->eof==1){ /*EOF*/
    /*ʸȤʼƤ*/
    memCnt+=2*sizeof(char);

    /*ܤΥɥ쥹ʼꤹ*/
    memCnt+=FldCnt*sizeof(char *);

    /*sortAGǤϰʲbktѿѤƤʤmergeRBAGѡ*/
    memCnt+=(sizeof(int)*PWayA);

    /*ߡǺäƤ(freeΤ)*/
    memCnt+=(sizeof(MssValue));

  }else{

    /*frܤޤ뤴ȥԡ*/
    memCnt+=fr->chrCnt*sizeof(char);

    /*ܤΥɥ쥹׻ˤꥻå*/
    memCnt+=FldCnt*sizeof(char *);

    switch(AGGType){
    case aggSUM:
    case aggCNT:
    case aggMIN:
    case aggMAX:
      memCnt=sizeof(MssValue)*(OptFld->flds->cnt)*1;
      break;
    case aggAVG:
    case aggAVG2:
      memCnt=sizeof(MssValue)*(OptFld->flds->cnt)*2;
      break;
    case aggSTD:
    case aggSTDP:
    case aggVAR:
    case aggVARP:
      memCnt=sizeof(MssValue)*(OptFld->flds->cnt)*3;
      break;
    }

    /*sortAGǤϰʲbktѿѤƤʤmergeRBAGѡ*/
    memCnt+=(sizeof(int)*PWayA);
  }
  return(memCnt);
}

/**
 * # FUNCTION #
 */
static void RBAGcpKey(struct RBAGnode *v, struct mssFldRec *fr, int bkt, MssValue *val)
{

  int i;

  if(fr->eof==1){ /*EOF*/
    /*ʸȤʼƤ*/
    v->key->str = mssMalloc(2*sizeof(char),"RBAGAGtree1");
    memcpy(v->key->str, readEnd, 2);

    /*ܤΥɥ쥹ʼꤹ*/
    v->key->fld = mssMalloc(FldCnt*sizeof(char *),"RBAGAGtree2");
    for(i=0; i<FldCnt; i++){
      *(v->key->fld+i) = v->key->str;
    }

    /*sortAGǤϰʲbktѿѤƤʤmergeRBAGѡ*/
    v->key->bkt    = mssCalloc(sizeof(int)*PWayA, "RBAGtree");
    *(v->key->bkt+bkt) = 1;
    /**v->key->bkt    = bkt;*/
    /*v->key->bktCnt = 1;*/

    /*ߡǺäƤ(freeΤ)*/
    v->key->val = mssMalloc(sizeof(MssValue),"RBAGAGtree3");

  }else{

    /*frܤޤ뤴ȥԡ*/
    v->key->str = mssMalloc(fr->chrCnt*sizeof(char),"RBAGAGtree4");
    memcpy(v->key->str, *fr->pnt, fr->chrCnt); 

    /*ܤΥɥ쥹׻ˤꥻå*/
    v->key->fld = mssMalloc(FldCnt*sizeof(char *),"RBAGAGtree5");
    for(i=0; i<FldCnt; i++){
      *(v->key->fld+i) = v->key->str + (*(fr->pnt+i) - *fr->pnt);
    }

    /*ΰγ*/
    v->key->val=getAggValMem(AGGType, OptFld->flds->cnt);

    /*ͤη׻*/
    mssCalAggVal(v->key->val, AGGType, val);

    /*sortAGǤϰʲbktѿѤƤʤmergeRBAGѡ*/
    v->key->bkt    = mssCalloc(sizeof(int)*PWayA, "RBAGtree");
    *(v->key->bkt+bkt) = 1;
  }
}

/**
 * # FUNCTION #
 * ΥΡɤFldRec¤ΤΥǡǹ
 */
static void RBAGupdate(struct RBAGnode *v, struct mssFldRec *fr, int bkt, MssValue *val)
{
  /*ХåֹХåȥե饰˹*/
  *(v->key->bkt+bkt) = 1;

  if(fr->eof!=1){ /*not EOF*/
    /*ͤη׻*/
    mssCalAggVal(v->key->val, AGGType, val);
  }
}

/**
 * # FUNCTION #
 * RBtreeFldRec¤ΤΥǡɲ
 * ˥¸ߤRBAGupdateͤ򹹿
 */
static int RBAGinsert(struct RBAGnode *v, struct mssFldRec *fr, int bkt, MssValue *val)
{
  int memCnt=0;

  v = RBAGmember(fr, v);

  /*¸ߤʤɲ*/
  if(RBAGisExternalNode(v)){
    RBAGcpKey(v, fr, bkt, val);
    memCnt=RBAGcpKeyMemCnt(fr);
    v->rank=1;
    RBAGaddExternalNodes(v);
    RBAGrebalanceOnInsert(v);
    memCnt+=sizeof(struct RBAGnode)*2;
    memCnt+=sizeof(struct RBAGkey )*2;

  /*¸ߤй*/
  }else{
    RBAGupdate(v, fr, bkt,val);
  }

  return(memCnt);
}


/**
 * # FUNCTION #
 * ΥΡɤ
 */
static void RBAGdeleteNode(struct RBAGnode *v)
{
  struct RBAGnode *w,*x;

  if(RBAGisExternalNode(v)){
    fprintf(stderr,"Not found such node\n");
    return;
  }
  if(RBAGhasLeftNode(v)){
    w=RBAGfindMax(v->left);
    if(w->parent != v){
      w->parent->right = w->left;
      w->left->parent  = w->parent;
    }
    x=w->left;
    RBAGfreeNode(w->right);
    /*free(w->right->key);*/
    /*free(w->right);*/

    if(RBAGisLeftNode(v)){
      v->parent->left=w;
    }else{
      v->parent->right=w;
    }
    if(w->parent != v){
      w->left = v->left;
      w->left->parent = w;
    }
    w->rank = v->rank;
    w->parent = v->parent;
    w->right = v->right;
    w->right->parent=w;
    RBAGfreeNode(v);
    /*free(v->key);*/
    /*free(v);*/
  }else{
    w=v->right;
    if(RBAGisLeftNode(v)){
      v->parent->left=w;
    }else{
      v->parent->right=w;
    }
    w->parent=v->parent;
    RBAGfreeNode(v->left);
    RBAGfreeNode(v);
    /*free(v->left->key);*/
    /*free(v->left);*/
    /*free(v->key);*/
    /*free(v);*/
    x=w;
  }

  RBAGrebalanceOnDelete(x);
}

/**
 * # FUNCTION #
 * RBtreeͥԤΥΡɥɥ쥹֤
 * νǥΡɤϤʤƤӽФ¦RBAGdeleteNode(node)¹
 */
static struct RBAGnode *RBAGpop(struct RBAGnode *v)
{
  struct RBAGnode *vv;

  if(RBAGisExternalNode(v)){
    return(NULL);
  }else{
    vv=v;
    while(!RBAGisExternalNode(vv)){
      vv=vv->left; /*rightéк硢leftϺǾ*/
    }
    return(vv->parent);
  }
}

/**
 * # FUNCTION #
 * RBtreeĥ꡼Ȥƽ񤭽Ф(ǥХå)
 */
void RBAGprintTree(char *s,struct RBAGnode *pp)
{
  printf("%s\n",s);
  RBAGptree(pp,0);
}

/**
 * # FUNCTION #
 * ΥΡɤԤȤƽ񤭽Ф
 */
static void RBAGwriteNode(struct RBAGnode *p, int valCnt, struct mssFPW *fpw, FILE *valFile)
{
  int i;

  /*ǡƥȤν*/
  for(i=0; i<FldCnt-1; i++){
    mssWriteStr(*(p->key->fld+i),fpw); mssWriteDlm(fpw);
  }
    mssWriteStr(*(p->key->fld+i),fpw); mssWriteRet(fpw);

  fwrite(p->key->val,sizeof(MssValue),valCnt,valFile);
}

/**
 * # FUNCTION #
 * RBtreeƹԤȤƽ񤭽Ф
 */
static void RBAGwriteAllNode(struct RBAGnode *p, int valCnt, struct mssFPW *fpw, FILE *valFile)
{
  
  if(!RBAGisExternalNode(p)){
    RBAGwriteAllNode(p->left,valCnt,fpw,valFile);
    RBAGwriteNode(p,valCnt,fpw,valFile);
    RBAGwriteAllNode(p->right,valCnt,fpw,valFile);
  }
}

/**
 * # FUNCTION #
 * RBtreeΥΰ
 */
static void RBAGfree(struct RBAGnode *v)
{

  RBAGfreeAllNode(v->left);
  mssFree(v->key);
  mssFree(v);
}

/**
 * # FUNCTION #
 * RBnodeν(Ρɺ)
 */
static struct RBAGnode *RBAGinit(struct RBAGnode *rb)
{
  /*ֹڤν*/
  rb               = RBAGmakeNode();
  rb->parent       = rb;
  rb->right        = NULL;
  rb->rank         = 0;
  rb->left         = RBAGmakeNode();
  rb->left->parent = rb;
  return(rb);
}

/**
 * # SECTION #
 * ----------------------------------------------------------------------------
 * ץ̤α黻
 * ----------------------------------------------------------------------------
 */

/**
 * # FUNCTION #
 * ׽
 */
static void aggSum(MssValue *val, MssValue *val2)
{
  int i;
  for(i=0; i<OptFld->flds->cnt; i++){
    *(val+i)=mssVadd(*(val+i), *(val2+i));
  }
}

/**
 * # FUNCTION #
 * 
 */
static void aggCnt(MssValue *val, MssValue *val2)
{
  int i;

  for(i=0; i<OptFld->flds->cnt; i++){
    if((val2+i)->nul!=1){
      *(val+i)=mssVcntUp(*(val+i));
    }
  }
}

/**
 * # FUNCTION #
 * ʿѽ
 */
static void aggAvg(MssValue *val, MssValue *val2)
{
  int i;
  for(i=0; i<OptFld->flds->cnt; i++){
    *(val+i)=mssVadd(*(val+i), *(val2+i));
    if((val2+i)->nul!=1){
      *(val+OptFld->flds->cnt+i)=mssVcntUp(*(val+OptFld->flds->cnt+i));
    }
  }
}

/**
 * # FUNCTION #
 * ʿѽף
 */
static void aggAvg2(MssValue *val, MssValue *val2)
{
  int i;
  for(i=0; i<OptFld->flds->cnt; i++){
    *(val+i)=mssVadd(*(val+i), *(val2+i));
    *(val+OptFld->flds->cnt+i)=mssVadd(*(val+OptFld->flds->cnt+i), *(val2+OptFld->flds->cnt+i));
  }
}

/**
 * # FUNCTION #
 * Ǿͽ
 */
static void aggMin(MssValue *val, MssValue *val2)
{
  int i;
  for(i=0; i<OptFld->flds->cnt; i++){
    *(val+i)=mssVmin(*(val+i), *(val2+i));
  }
}

/**
 * # FUNCTION #
 * ͽ
 */
static void aggMax(MssValue *val, MssValue *val2)
{
  int i;
  for(i=0; i<OptFld->flds->cnt; i++){
    *(val+i)=mssVmax(*(val+i), *(val2+i));
  }
}

/**
 * # FUNCTION #
 * ʬ
 */
static void aggVar(MssValue *val, MssValue *x)
{
  int i;
  MssValue *n;
  MssValue *s1;
  MssValue *s2;
  MssValue const1;

  mssVinit(&const1,DBL);
  const1.v.d=1;

  /*x   :ʿѤȤκ(x)*/
  /*n :Ŀ(n)*/
  /*s1:ʿ(s1)*/
  /*s2:ʿ(s2)*/
  n =val;
  s1=val+OptFld->flds->cnt;
  s2=val+OptFld->flds->cnt*2;
  for(i=0; i<OptFld->flds->cnt; i++){
    if((x+i)->nul!=1){
      *(n+i)=mssVcntUp(*(n+i));
    }
    *(x+i)=mssVsub(*(x+i), *(s1+i));
    *(s1+i)=mssVadd(*(s1+i), mssVdiv(*(x+i), *(n+i)));
    *(s2+i)=mssVadd(
      *(s2+i),
      mssVdiv(
        mssVmul(
          mssVsub( *(n+i), const1),
          mssVmul(*(x+i),*(x+i))
        ),
        *(n+i)
      )
    );
  }
}

/**
 * # FUNCTION #
 * ʻˤϽˡѤΤ
 *˶뤳
 */
static enum MssAggType chgAggType(enum MssAggType aggType)
{
  switch(aggType){
  case aggSUM:
    return(aggSUM);
    break;
  case aggCNT:
    return(aggSUM);
    break;
  case aggMIN:
    return(aggMIN);
    break;
  case aggMAX:
    return(aggMAX);
    break;
  case aggAVG:
    return(aggAVG2);
    break;
  case aggSTD:
  case aggSTDP:     /*ꤨʤٹ򤱤뤿*/
    return(aggSTD);
    break;
  case aggVAR:
  case aggVARP:     /*ꤨʤٹ򤱤뤿*/
    return(aggVAR);
    break;
  case aggAVG2:     /*ѥٹɤ*/
    return(aggAVG2);
    break;
  }
  return(aggType);
}


/**
 * # SECTION #
 * ----------------------------------------------------------------------------
 * ״Ϣؿ
 * ----------------------------------------------------------------------------
 */

/**
 * # FUNCTION #
 * ե̾μ
 */
static char *getFname(char *prefix, int number)
{
  /*fnameϥХѿ*/
  sprintf(fname,"%s%d",prefix,number);
  return(fname);
}

/**
 * # FUNCTION #
 * mssFldRec¤Τ˰ɤ߹(ʼ)
 */
static void readRBAGkey( struct mssFPR *fp, struct mssFldRec *fr)
{
  int i;

  if(EOF==mssReadFldRec(fp,fr)){
    for(i=0; i<fr->fldCnt; i++)
      *(fr->pnt+i)=readEnd; /*EOFλʼ*/
  }
}

/**
 * # FUNCTION #
 * ƥХåȤκǽιԤRB塼ɤ߹
 * mergeRB,preSortƤӽФ
 * iFromiToޤǤΥեƬԤRB塼
 * ad   : iFile,rb򥻥åȤ
 * iFrom: ϥեֹ
 * iTo  : λեֹ
 */
static void setFirstLineRBAG(struct mssAggDat *ad, int iFrom, int iTo)
{
  int bkt;                /*߽ΥХåֹ(0Ϥޤ)*/
  int i;

  /*ad->bktCnt=iTo-iFrom+1; Хåȿ*/

  /*ץ饤ƥ塼ν*/
  ad->rb=RBAGinit(ad->rb);
  bkt=0;
  for(i=iFrom; i<=iTo; i++){
    ad->fr[bkt]=mssInitFldRec(FldCnt);

    ad->iFile[bkt]=mssOpenFPR(getFname(ad->prefixTxt,i),4);
    ad->vFile[bkt]=fopen(getFname(ad->prefixVal,i),"rb");

    /*(Ƭ)ɤ߹*/
    readRBAGkey(ad->iFile[bkt],ad->fr[bkt]);
    fread(ad->val, sizeof(MssValue), ad->valCnt, ad->vFile[bkt]);

    /*ֹڤ(ʪŪ˥ԡ)*/
    RBAGinsert(ad->rb->left,ad->fr[bkt],bkt, ad->val);
    bkt++;
  }
}

/**
 * # FUNCTION #
 *RB塼ѤPWayޡ
 * ¤ѤäƤХå(iCnt)ʻ礷Ƥ
 * ǸΰĤˤʤޤʻϤʤ
 * PWayAĤ꾯ʤʤäȤʻߤ
 */
static void mergeRBAG(struct mssAggDat *ad)
{
  int    bkt[PWayA];       /*PwayʻRBtreepopǡΥХåNo*/
  int    bktCnt;           /*ΥХåȿ*/
  struct RBAGnode *node;   /*popˤƼΡɤǼ*/

  struct mssFPW *oFile;       /*ϥեݥ*/
  FILE       *vFile;       /*ϥեݥ*/

  int    iStart;           /*ϥեγֹ(ե̾ΰ)*/
  int    iEnd;             /*ϥեνλֹ(ե̾ΰ)*/
  int    oStart;           /*ϥեγֹ(ե̾ΰ)*/
  int    oEnd;             /*ϥեνλֹ(ե̾ΰ)*/
  int    iFrom,iTo;        /*ʻ礹Υեֹ*/
  int    k;
  int    i;

  /*Υ롼פin,outswapΤǡǤϵդ*/
  iStart=ad->iEnd+1;
  iEnd  =ad->iEnd+1;
  oStart=ad->iStart;
  oEnd  =ad->iEnd;

  /*եʻ礹롼 iCntPWayAĤ礭ޤ³*/
  while(1){
    mssSwapInt(&iStart,&oStart);
    mssSwapInt(&iEnd  ,&oEnd  );
    oEnd=oStart;

    /*ϥեPWayAʲʤнλ*/
    if(iEnd-iStart+1 <= PWayA){
      ad->iStart = iStart;
      ad->iEnd   = iEnd;
      break;
    }

    /*PwayĤiFileĤoFile˽񤭽Ф"򷫤֤롼*/
    k=0;
    while(1){
      /*ƥХåȤκǽԤ򥭥塼*/
      iFrom= k   *PWayA+iStart;    /*PWayA=3ǰե뤬0,1,2,3,4,5,6λ*/
      iTo  =(k+1)*PWayA+iStart-1;  /* iFrom: 0 3 6*/
      if(iTo>iEnd) iTo=iEnd;       /* iTo  : 2 5 6*/
      setFirstLineRBAG(ad, iFrom,iTo);

      /*ϥե륪ץ*/
      oFile=mssOpenFPW(getFname(ad->prefixTxt,oEnd),0,0);
      vFile=fopen(getFname(ad->prefixVal,oEnd),"wb");

      /*ƥХåȤԤŤɤ߹߽񤭽Ф롼*/
      while(1) {
        node=RBAGpop(ad->rb->left);          /*塼ԼФ*/
        if(strcmp(node->key->str,readEnd)==0)/*readEnd(ʼ)Ф齪λ*/
          break;
        RBAGwriteNode(node,ad->valCnt,oFile,vFile);  /*Խ񤭽Ф*/
        bktCnt=0;                   /*popǼФkeyͤΥХåȿ*/
        for(i=0; i<PWayA; i++){
          if(*(node->key->bkt+i) == 1)
          bkt[bktCnt++]=i;          /*Хåֹ򥻥å*/
        } 
        RBAGdeleteNode(node);              /*ФΡɤκ*/

        /*popХåȤ鿷ɤߤRBtree*/
        for(i=0; i<bktCnt; i++){
          readRBAGkey(ad->iFile[bkt[i]],ad->fr[bkt[i]]);
          fread(ad->val,sizeof(MssValue),ad->valCnt,ad->vFile[bkt[i]]);
          RBAGinsert(ad->rb->left,ad->fr[bkt[i]],bkt[i],ad->val);
        }
      }
      RBAGfree(ad->rb);                    /*塼γ*/
      for(i=0; i<=iTo-iFrom; i++){         /*ϥեΥ*/
        mssCloseFPR(ad->iFile[i]);
        fclose(ad->vFile[i]);
        mssFreeFldRec(ad->fr[i]);
      }
      mssCloseFPW(oFile);                  /*ϥեΥ*/
      fclose(vFile);                       /*ϥեΥ*/
      if(iTo==iEnd)break;                  /*ǸΥХåȤޤǤнλ*/
      oEnd++;                              /*ϥեֹ楫ȥå*/
      k++;                                 /*ʻȥå*/
    }
    for(i=iStart; i<=iEnd; i++){
      unlink(getFname(ad->prefixTxt,i));      /*ϥեκ*/
      unlink(getFname(ad->prefixVal,i));      /*ϥեκ*/
    }
  }
}

/**
 * # FUNCTION #
 *פʤsortؿ(uniq,sum,avg,max,min,cnt,stdev,var...)
 *פʤֹڤ
 * MAXۤե˽񤭽Ф
 */
static void sortAG(struct mssAggDat *ad, struct mssFPR *fpr)
{
  struct mssFldRec *fr;    /*ϥե򥭡¤ٴ뤿ΥХåե*/
  int    pid;              /*ץID(ե̾ΰ)*/
  int    oNum;             /*եֹΥȥåѿ*/
  int    memCnt;           /**/

  struct RBAGnode *rb=NULL; /*ֹ*/
  struct mssFPW *outFile;      /*ϰե*/
  FILE       *valFile;      /*ϰե*/

  fr=mssInitFldRec(FldCnt);/*FldRecν*/
  rb=RBAGinit(rb);          /*RBAGtreeν*/

  /*ե̾Υץեå*/
  pid=getpid();
  if(strlen(ad->tmpDir) > MssFileNameMaxLen - 50 ) {
    mssShowErrMsg("length of path name must be less than %d",MssFileNameMaxLen-50);
    exit(mssErrorNoDefault);
  }
  sprintf(ad->prefixTxt,"%s/xt##%d-PreAggTxt-",ad->tmpDir,pid);
  sprintf(ad->prefixVal,"%s/xt##%d-PreAggVal-",ad->tmpDir,pid);

  memCnt=0; /*ꥫ󥿤Υꥢ*/
  oNum=0;   /*ϥեֹ*/
  while(1){
    /*ǡɤ߹*/
    mssReadFldRec(fpr,fr);
    (*ad->inCnt)++;

    /*ֹڤΥMaxۤ ⤷ ǽԤ򸡽Ф*/
    /*եؽ񤭽Ф*/
    if( memCnt >= MaxMemA || fr->eof==1){
      outFile=mssOpenFPW(getFname(ad->prefixTxt,oNum),0,0);/*ϥե륪ץ*/
      valFile=fopen(getFname(ad->prefixVal,oNum),"wb"); /*ϥե륪ץ*/
      RBAGwriteAllNode(rb->left,ad->valCnt, outFile,valFile);/*RBtreeƽ*/
      mssCloseFPW(outFile);                          /*ϥեΥ*/
      fclose(valFile);                            /*ϥեΥ*/
      oNum++;                                     /*ϥեcountUp*/
      RBAGfree(rb);   /*RBAGtreeΰ*/
      if(fr->eof==1){ /*ǽԤǽλ*/
        (*ad->inCnt)--;
        break;
      }
      rb=RBAGinit(rb);    /*RBAGtreeν*/
      memCnt=0;           /*ꥫ󥿤Υꥢ*/
    }

    /*ֹڤ(ʪŪ˥ԡ)򥫥ȥå*/
    mssSetAggVal(ad->val, fr->pnt);
    memCnt += RBAGinsert(rb->left,fr,1,ad->val);
  }
  mssFreeFldRec(fr);/*FldRecν*/

  ad->iStart = 0;
  ad->iEnd   = oNum-1;
}

/**
 * # FUNCTION #
 * ʸȤƤνˡ("sum","avg","min"..)enumAGtypeǤѴ
 */
static enum MssAggType setAggType(char *str)
{
       if( 0==strcmp("sum",str) ){
    return(aggSUM);
  }else if( 0==strcmp("avg",str) ){
    return(aggAVG);
  }else if( 0==strcmp("cnt",str) ){
    return(aggCNT);
  }else if( 0==strcmp("max",str) ){
    return(aggMAX);
  }else if( 0==strcmp("min",str) ){
    return(aggMIN);
  }else if( 0==strcmp("std",str) ){
    return(aggSTD);
  }else if( 0==strcmp("stdp",str) ){
    return(aggSTDP);
  }else if( 0==strcmp("var",str) ){
    return(aggVAR);
  }else if( 0==strcmp("varp",str) ){
    return(aggVARP);
  }

  mssShowErrMsg("Invalid aggregation method:'%s'",str);
  exit(mssErrorNoDefault);

  return(-1); /*ѥwarningå򤱤뤿*/
}

/**
 * # FUNCTION #
 * ܿ(fc)Ƚץפ˱ƽΰǳݤMssValueο֤
 */
static int getAggValCnt(enum MssAggType aggType, int fc)
{
  switch(aggType){
  case aggSUM:
  case aggCNT:
  case aggMIN:
  case aggMAX:
    return(fc);
    break;
  case aggAVG:
  case aggAVG2:
    return(fc*2);
    break;
  case aggSTD:
  case aggSTDP:
  case aggVAR:
  case aggVARP:
    return(fc*3);
    break;
  }
  return(fc);
}

/**
 * # FUNCTION #
 * ܿ(fc)Ƚץפ˱ƽΰݤ롣
 */
static MssValue *getAggValMem(enum MssAggType aggType, int fc)
{
  MssValue *val;
  switch(aggType){
  case aggSUM:
  case aggCNT:
  case aggMIN:
  case aggMAX:
    val = mssMalloc(sizeof(MssValue)*fc  ,"RBAGAGtree6");
    break;
  case aggAVG:
  case aggAVG2:
    val = mssMalloc(sizeof(MssValue)*fc*2,"RBAGAGtree6");
    break;
  case aggSTD:
  case aggSTDP:
  case aggVAR:
  case aggVARP:
    val = mssMalloc(sizeof(MssValue)*fc*3,"RBAGAGtree6");
    break;
  default:
    val = NULL;
  }
  mssClearAggVal(val, aggType, fc);
  return(val);
}

/**
 * # FUNCTION #
 * ܿ(fc)Ƚץפ˱ƽΰ(val)򥯥ꥢ롣
 */
void mssClearAggVal(MssValue *val, enum MssAggType aggType, int fc)
{
  int i;
  switch(aggType){
  case aggSUM:
  case aggCNT:
    for(i=0; i<fc;   i++) mssVinit(val+i,DBL);
    break;
  case aggMIN:
    for(i=0; i<fc;   i++) {mssVinit(val+i,DBL); mssVclearMax( val+i );}
    break;
  case aggMAX:
    for(i=0; i<fc;   i++) {mssVinit(val+i,DBL); mssVclearMin( val+i );}
    break;
  case aggAVG:
  case aggAVG2:
    for(i=0; i<fc*2; i++) mssVinit(val+i,DBL);
    break;
  case aggSTD:
  case aggSTDP:
  case aggVAR:
  case aggVARP:
    for(i=0; i<fc*3; i++) mssVinit(val+i,DBL);
    break;
  }
}

/**
 * # FUNCTION #
 * ץפ˱ơ(val)򿷤(val2)ˤäƹ롣
 */
void mssCalAggVal(MssValue *val, enum MssAggType aggType, MssValue *val2)
{
  /*val2:f= val:׻*/
  switch(aggType){
  case aggSUM:
    aggSum( val ,val2);
    break;
  case aggCNT:
    aggCnt( val ,val2);
    break;
  case aggAVG:
    aggAvg( val ,val2);
    break;
  case aggAVG2:
    aggAvg2( val ,val2);
    break;
  case aggMIN:
    aggMin( val ,val2);
    break;
  case aggMAX:
    aggMax( val ,val2);
    break;
  case aggSTD:
  case aggSTDP:
  case aggVAR:
  case aggVARP:
    aggVar( val ,val2);
    break;
  }
}

/**
 * # FUNCTION #
 * ץפ˱ơǽ̤׻ԽϤ롣
 */
void mssWriteAggFld( char **fld, MssValue *val, enum MssAggType aggType, struct mssFPW *fpw)
{
  MssValue const1;
  int i;

  mssVinit(&const1,DBL);
  const1.v.d=1;

  switch(aggType){
  case aggSUM:
    break;
  case aggCNT:
    break;
  case aggMIN:
    break;
  case aggMAX:
    break;
  case aggAVG: /*̵̣ѥ륨顼򤱤뤿*/
  case aggAVG2:
    for(i=0; i<OptFld->flds->cnt; i++){
      *(val+i)=mssVdiv(*(val+i), *(val+OptFld->flds->cnt+i) );
    }
    break;
  case aggVAR:
    for(i=0; i<OptFld->flds->cnt; i++){
      *(val+i)=mssVdiv(*(val+OptFld->flds->cnt*2+i), mssVsub(*(val+i),const1) );
    }
    break;
  case aggVARP:
    for(i=0; i<OptFld->flds->cnt; i++){
      *(val+i)=mssVdiv(*(val+OptFld->flds->cnt*2+i), *(val+i) );
    }
    break;
  case aggSTD:
    for(i=0; i<OptFld->flds->cnt; i++){
      *(val+i)=mssVsqrt(mssVdiv(*(val+OptFld->flds->cnt*2+i), mssVsub(*(val+i),const1)));
    }
    break;
  case aggSTDP:
    for(i=0; i<OptFld->flds->cnt; i++){
      *(val+i)=mssVsqrt(mssVdiv(*(val+OptFld->flds->cnt*2+i), *(val+i)));
    }
    break;
  }

  for(i=0; i<FldCnt-1; i++){
    if(*(OptFld->fldNo2optNo+i)==-1){
      mssWriteStr(*(fld+i),fpw);
    }else{
      mssVwriteDbl(*(val+*(OptFld->fldNo2optNo+i)), fpw);
    }
    mssWriteDlm(fpw);
  }
    if(*(OptFld->fldNo2optNo+i)==-1){
      mssWriteStr(*(fld+i),fpw);
    }else{
      mssVwriteDbl(*(val+*(OptFld->fldNo2optNo+i)), fpw);
    }
    mssWriteRet(fpw);
}

/**
 * # FUNCTION #
 * ץפ˱ơǽ̤׻ԽϤ롣
 *ʸȤƤιܤvalѴؿ
 *valrbtree뤿ΰŪʤ
 */
void mssSetAggVal(MssValue *val, char **str)
{
  int i;
  for(i=0; i<OptFld->flds->cnt; i++){
    if( MssIsNull(*(str+MssFlds2num(OptFld->flds,i))) ){
      MssVnull(*(val+i));
    }else{
      (val+i)->nul=0;
      (val+i)->v.d=atof(*(str+MssFlds2num(OptFld->flds,i)));
    }
  }
}

/**
 * # FUNCTION #
 * RB塼Ѥڤʬɤ߹
 * ¤ѤäƤХå(ad->iStartad->iEnd)򽸷פʤ
 * ʻ礷Ƥ
 * եθĿϴPWayAʲˤʤäƤ뤳Ȥ
 */
int mssReadWriteAgg(struct mssAggDat *ad, struct mssFPW *oFile)
{
  struct RBAGnode *node;     /*popˤƼΡɤǼ*/
  int              bkt[PWayA];/*PwayʻRBtreepopǡΥХåNo*/
  int              bktCnt;   /*ΥХåȿ*/
  int i;

  node=RBAGpop(ad->rb->left);           /*塼ԼФ*/
  if(strcmp(node->key->str,readEnd)==0) /*readEnd(ʼ)Ф齪λ*/
    return(EOF);

  /*Խ񤭽Ф*/
  mssWriteAggFld(node->key->fld,node->key->val,AGGType,oFile);

  bktCnt=0;                      /*popǼФkeyͤΥХåȿ*/
  for(i=0; i<PWayA; i++){
    if(*(node->key->bkt+i) == 1)
      bkt[bktCnt++]=i;           /*Хåȥե饰򥻥å*/
  } 
  RBAGdeleteNode(node);          /*ФΡɤκ*/

  /*popХåȤ鿷ɤߤRBtree*/
  for(i=0; i<bktCnt; i++){
    readRBAGkey(ad->iFile[bkt[i]],ad->fr[bkt[i]]);
    fread(ad->val,sizeof(MssValue),ad->valCnt,ad->vFile[bkt[i]]);
    RBAGinsert(ad->rb->left,ad->fr[bkt[i]],bkt[i],ad->val);
  }
  return(1); /*Ȥꤢ*/
}

/**
 * # FUNCTION #
 *ֹڤʤ齸סܽפʤPWayޡ
 */
void mssPreAgg(struct mssAggDat *ad, struct mssFPR *iFile)
{
  /*ʥϥɥ*/
  mssGV.usedTempFileFlg=1;
  mssSetSignalHandler();

  sortAG(ad,iFile);
  AGGType=chgAggType(AGGType);
  mergeRBAG(ad);
  setFirstLineRBAG(ad, ad->iStart,ad->iEnd);
}

/**
 * # FUNCTION #
 * mssAggDat¤ΤΥݥ󥿤֤
 */
struct mssAggDat *mssInitAggDat(int fldCnt, MssOptKEY *optKey, MssOptFLD *optFld, char *aggType, char *tmpDir, int *inCnt)
{
  struct mssAggDat *aggDat;
  aggDat=mssMalloc(sizeof(struct mssAggDat),"initAggDat");

  aggDat->fldCnt  = fldCnt;
  aggDat->optKey  = optKey;
  aggDat->optFld  = optFld;
  aggDat->aggType = setAggType(aggType);
  aggDat->tmpDir  = tmpDir;
  aggDat->inCnt   = inCnt;
  aggDat->val     = getAggValMem(aggDat->aggType, aggDat->optFld->flds->cnt);
  aggDat->valCnt  = getAggValCnt(aggDat->aggType, aggDat->optFld->flds->cnt);
  aggDat->aggVal  = getAggValMem(aggDat->aggType, aggDat->optFld->flds->cnt);

  /*Хѿ*/
  FldCnt  = aggDat->fldCnt;
  OptKey  = aggDat->optKey;
  OptFld  = aggDat->optFld;
  AGGType = aggDat->aggType;
  
  return(aggDat);
}

/**
 * # FUNCTION #
 * mssAggDat¤Τγ
 */
void mssFreeAggDat(struct mssAggDat *ad)
{
  int i;

  if(ad->procType==1){
    /*ХåեΤˡϥեϤǽƥ*/
    for(i=0; i<=ad->iEnd-ad->iStart; i++){
      mssCloseFPR(ad->iFile[i]);
      mssFreeFldRec(ad->fr[i]);
    }

    /*եκ*/
    for(i=ad->iStart; i<=ad->iEnd; i++){
      unlink(getFname(ad->prefixTxt,i));
      unlink(getFname(ad->prefixVal,i));
    }

    /*ΰ賫*/
    RBAGfree(ad->rb);
  }
  mssFree(ad->val);
  mssFree(ad->aggVal);
  mssFree(ad);
}
