/**
 * # CHAPTER #
 * ============================================================================
 * xtclassifyѤǡɤ߹ߴϢδؿ
 * ============================================================================
 */

#include <musashi.h>
#include <readData.h>
#include <bonsai.h>
#include <string.h>
#include <iconv.h>
#include <libxml/xmlerror.h>

/* ############ Хѿ ##############*/
/*ѥ顼᡼*/
extern MssOptFLD optPAT;
extern MssOptFLD optCAT;
extern MssOptSTR optDLM;
extern MssOptINT optSIZ;

extern struct mssFields *fpat; /*ѥ*/
extern struct mssFields *fnum; /*͹*/
extern struct mssFields *fcat; /*ƥ*/
extern struct mssFields *fcls; /*饹*/

extern int ClassSize;          /*饹Υ*/
extern iconv_t *icid;          /*Encoding*/
extern char mssXmlDomErrMsg[]; /*ɤ߹߻Υ顼å*/

/**
 * # FUNCTION #
 * ǡ򥫥Ȥؿ
 */
int countDat(struct mssFPR *fpr){
  struct mssRec *rec=NULL; /*ԥХåե¤*/
  int i=0;

  rec=mssInitRec();
  mssSeekTopFPR(fpr);
  while(EOF != mssReadRec(fpr,rec)) i++;
  mssFreeRec(rec);

  return(i);
}

/**
 * # FUNCTION #
 * 饹ʸ(str)顢ֹ֤ؿ
 */
static char getClassNum(struct Class *cls, char *str){
  int i;

  for(i=0; i<ClassSize; i++){
    if(0==strcmp(cls->str[i],str)) return(i);
  }
  return(-1);
}

/**
 * # FUNCTION #
 * ǡǻȤƤ륯饹ͤ򥻥åȤ
 * Ǥϡȥ졼˥󥰤ȥƥȤξꤦ륯饹ͤ
 */
struct Class *setClass(struct mssFPR *trn, struct mssFPR *tst, struct mssHeader *hd){

  struct Class *cls;     /*饹ʸ-ֹ湽¤*/
  struct mssFldRec *fr;  /*бΥ쥳ɥХåե*/
  char *str;
  int flg;
  int i;
  int recCnt;

  cls=mssCalloc(sizeof(struct Class), "setClass");
  cls->cnt=0;
  cls->chr=NULL;

  /*ȥ졼˥󥰤Υ饹*/
  fr=mssInitFldRec(hd->flds->cnt);
  mssSeekTopFPR(trn);
  recCnt=0;
  while( EOF != mssReadFldRec(trn,fr) ){

    /*饹ܤͤ򥻥å*/
    str=*(fr->pnt+MssFlds2num(fcls,0));

    if( MssIsNull(str) ){
      mssShowErrMsg("class field cannot have a NULL value");
      mssEnd(mssErrorNoDefault);
    }

    /*ϿƤ륯饹ܤʸ򸡺ʤflg=1*/
    flg=1;
    for(i=0; i<cls->cnt; i++){
      if(0==strcmp(cls->str[i],str)){ flg=0; break; }
    }

    /*Ͽ*/
    if(flg){
      cls->str[cls->cnt]=mssMalloc(sizeof(char)*(strlen(str)+1),"setClass");
      strcpy(cls->str[cls->cnt],str);
      cls->cnt++;
    }
  }
  mssFreeFldRec(fr);

  /*ƥȤΥ饹*/
  fr=mssInitFldRec(hd->flds->cnt);
  mssSeekTopFPR(tst);
  recCnt=0;
  while( EOF != mssReadFldRec(tst,fr) ){

    /*饹ܤͤ򥻥å*/
    str=*(fr->pnt+MssFlds2num(fcls,0));

    /*ϿƤ륯饹ܤʸ򸡺ʤflg=1*/
    flg=1;
    for(i=0; i<cls->cnt; i++){
      if(0==strcmp(cls->str[i],str)){ flg=0; break; }
    }

    /*Ͽ*/
    if(flg){
      cls->str[cls->cnt]=mssMalloc(sizeof(char)*(strlen(str)+1),"setClass");
      strcpy(cls->str[cls->cnt],str);
      cls->cnt++;
    }
  }
  mssFreeFldRec(fr);

  /* 饹ɽ(for debug) */
  /*
  for(i=0; i<cls->cnt; i++){
    printf("cls%d = %s\n",i,cls->str[i]);
  }
  */
  return(cls);
}

/**
 * # FUNCTION #
 * Class¤ΰγ
 */
void freeClass(struct Class *cls){
  int i;
  for(i=0; i<cls->cnt; i++){
    mssFree(cls->str[i]);
  }
  mssFree(cls);
}

/**
 * # FUNCTION #
 * ȥեɤ߹
 *
 * <?xml version="1.0" encoding="euc-jp"?>
 * <missClassificationCost>
 *   <cost class="ͥ" predict="ͥ" value="9"/>
 *   <cost class="ͥ" predict="ͥ" value="2.1"/>
 * </missClassificationCost>
 *
 * ͥɤΥͥɤͽ¬줿ȤΥȤ9
 * ͥɤΥͥɤͽ¬줿ȤΥȤ2.1
 *
 * ǥեȤΥ
 * ƱͤƱͤͽ¬ȤΥȤ0
 * ͤ㤦ͤͽ¬ȤΥȤ1
 */
struct Cost *readCost(char *fname,struct Class *cls){
        xmlDocPtr doc;
        xmlNodePtr cur;
        xmlChar *att1,*att2,*att3;
        iconv_t *icid;
  int clsNo;
  int prdNo;

  struct Cost *cost;

  int i,j;

  /*ȤǥեͤǺ*/
  cost=mssCalloc(sizeof(struct Cost),"readCost");
  for(i=0; i<ClassSize; i++){
    for(j=0; j<ClassSize; j++){
      if(i==j) cost->tbl[i][j]=0;
      else     cost->tbl[i][j]=1;
    }
    cost->actTtl[i] = ClassSize-1;
  }
  /*Class򥻥å*/
  cost->cls=cls;

  /*ե̾ꤵƤʤХǥեȥȤ֤*/
  if(fname==NULL) return(cost);

  /*encoding*/
  icid=iconv_open("EUC-JP","UTF-8");

  /*顼ؿ*/
  mssXmlDomErrMsg[0]='\0';
  xmlSetGenericErrorFunc(NULL,mssXmlDomErrHandler);

  /*ȥեparse*/
  doc = xmlParseFile(fname);

  if (doc == NULL ) {
    mssShowErrMsg(mssEncoding(mssXmlDomErrMsg,icid));
    exit(mssErrorNoDefault);
  }

  /*ȥåץΡɤΥå*/
  cur = xmlDocGetRootElement(doc);

  /*ɥȥå*/
  if (cur == NULL) {
    xmlFreeDoc(doc);
    mssShowErrMsg("empty document");
    exit(mssErrorNoDefault);
  }

  /*롼ȥ̾(missClassificationCost)å*/
  if (xmlStrcmp(cur->name, (const xmlChar *) "missClassificationCost")) {
    xmlFreeDoc(doc);
    mssShowErrMsg("root tag must be '<missClassificationCost>'");
    exit(mssErrorNoDefault);
  }

  /*<cost>Ǥɤ߹*/
  cur = cur->xmlChildrenNode;
  while (cur != NULL) {
    if((0==xmlStrcmp(cur->name, (const xmlChar *)"cost"))){
      att1 = xmlGetProp(cur,"class");
      att2 = xmlGetProp(cur,"predict");
      att3 = xmlGetProp(cur,"value");
      clsNo=getClassNum(cls,mssEncoding(att1,icid));
      prdNo=getClassNum(cls,mssEncoding(att2,icid));
      if(clsNo<0 || prdNo<0){
        mssShowErrMsg("invalid value on class or predict attribute");
        exit(mssErrorNoDefault);
      }
      cost->tbl[clsNo][prdNo] = atof(att3);
      xmlFree(att1);
      xmlFree(att2);
      xmlFree(att3);
    }
    cur = cur->next;
  }
  xmlFreeDoc(doc);

  /*actClassΥȡ륳Ȥ׻*/
  for(i=0; i<ClassSize; i++){
    for(j=0; j<ClassSize; j++){
      cost->actTtl[i]+=cost->tbl[i][j];
    }
  }

  return(cost);
}


/**
 * # FUNCTION #
 * ȥǡɽ
 */
void showCost(struct Cost *cost, struct mssFPW *fpw){
  int i,j;

  if(cost==NULL) return;

  mssWriteStr("[Cost]\n",fpw);

  for(i=0; i<ClassSize; i++){
    for(j=0; j<ClassSize; j++){
      if(i==j) continue;
      mssWriteStr("If class \"",fpw);
      mssWriteStr(cost->cls->str[i],fpw);
      mssWriteStr("\" is predicted as \"",fpw);
      mssWriteStr(cost->cls->str[j],fpw);
      mssWriteStr("\", then cost=",fpw);
      mssWriteDbl(cost->tbl[i][j],fpw);
      mssWriteRet(fpw);
    }
  }
}


/**
 * # FUNCTION #
 * ͥѥξ硢ե٥åȤ򸵤οͤˤä¤ٴ
 */
static void sortAlp(struct Map *map){
  struct mssHashNode *node;
  int i,j;
  int n;
  char *x;
  char **a;

  a=map->numAlp;
  n=map->alpSiz;

  for(i=0; i<n; i++){
    x=a[i];
    for(j=i-1; j>=0 && atof(a[j])>atof(x); j--){
      a[j+1]=a[j];
    }
    a[j+1]=x;
  }

  for(i=0; i<n; i++){
    node=(struct mssHashNode *)mssHashMember(map->alpOrg,a[i]);
    node->val.v.usi=(usint)(i+1);
  }
}

/**
 * # FUNCTION #
 * alphabetֹ梪alphabetѴΰ٤Ͽ
 * alpOrgϥåɽΤϿ줿ʸؤΥݥ
 */
static char **setNumAlp( struct Map *map ){
  struct mssHashNode *node;
  char **tbl;
  int i;

  tbl=mssMalloc(sizeof(char *)*map->alpSiz,"setNumAlp");

  for(i=0; i<map->alpOrg->hashVal; i++){
    if( NULL != (node=*(map->alpOrg->node+i)) ){
      while(node!=NULL){
        *(tbl+node->val.v.usi-1)=node->str;
        node=node->next;
      }
    }
  }
  return(tbl);
}

/**
 * # FUNCTION #
 * ѥܤǥߥ(dlm)ǥȡʬ䤷ʸ֤
 * ǥߥ'\0'ξϡХȤalphabetȤƥåȤ롣
 */
static char **tokByChr(char *str,char dlm,int *cnt){
  char **list;
  char *buf;
  int i;
  int len;

  if(dlm=='\0'){
    len=strlen(str);
    buf=mssMalloc(sizeof(char)*len*2,"tokByChr");
    list=mssMalloc(sizeof(char *)*len,"tokByChr");
    for(i=0; i<len; i++){
      *(buf+i*2  )=*(str+i);
      *(buf+i*2+1)='\0';
      *(list+i)=buf+i*2;
    }
    *cnt=len;
  }else{
    list=mssTokByChr(str,dlm,cnt,1);
  }
  return(list);
}

/**
 * # FUNCTION #
 * ǡǻȤƤѥͤĴMap¤Τ˥åȤ
 * Ǥϡȥ졼˥󥰤ȥƥȤξꤦalphabet
 * NULLͤФ
 */
struct Map **setMapAlp(
  struct mssFPR *trn,
  struct mssFPR *tst,
  struct mssHeader *hd){

  struct mssFldRec *fr;  /*бΥ쥳ɥХåե*/
  char         *str; /*ѥȤΰŪݥ*/
  int i,j;
  struct Map **map;
  struct Map *mapi;
  MssValue *alpNum;
  char **list;
  int cnt;

  if(fpat->cnt==0)return(NULL);

  map=mssMalloc(sizeof(struct Map *)*fpat->cnt,"setMapAlp");
  for(i=0; i<fpat->cnt; i++){
    *(map+i)=mssCalloc(sizeof(struct Map),"setMapAlp");
    (*(map+i))->alpOrg=mssInitHash(1001);
    (*(map+i))->alp=NULL;
    (*(map+i))->idx=NULL;
    (*(map+i))->alpSiz=0;
  }

  alpNum=mssMalloc(sizeof(MssValue)*fpat->cnt,"setMapAlp");
  for(i=0; i<fpat->cnt; i++){
    mssVinit(alpNum+i,USI);
    (alpNum+i)->v.usi=1;
  }

  /*ȥ졼˥󥰤Υե٥åȤ*/
  fr=mssInitFldRec(hd->flds->cnt);
  mssSeekTopFPR(trn);
  while( EOF != mssReadFldRec(trn,fr) ){
    for(i=0; i<fpat->cnt; i++){
      str=*(fr->pnt+MssFlds2num(fpat,i));
      if(MssIsNull(str)) continue;
      list=tokByChr(str,*optDLM.str,&cnt);
      mapi=*(map+i);
      for(j=0;j<cnt;j++){
        if( NULL != mssHashInsert((*(map+i))->alpOrg, *(list+j), *(alpNum+i)) ){
          mapi->alpSiz++;
          mapi->alp=mssRealloc(mapi->alp,
                      sizeof(usint)*mapi->alpSiz,"setMapAlp");
          *(mapi->alp+mapi->alpSiz-1)=(alpNum+i)->v.usi;
          (alpNum+i)->v.usi++;
        }
      }
      mssFree(*list); mssFree(list);
    }
  }
  mssFreeFldRec(fr);

  /*ƥȤΥե٥åȤ*/
  fr=mssInitFldRec(hd->flds->cnt);
  mssSeekTopFPR(tst);
  while( EOF != mssReadFldRec(tst,fr) ){
    for(i=0; i<fpat->cnt; i++){
      str=*(fr->pnt+MssFlds2num(fpat,i));
      if(MssIsNull(str)) continue;
      list=tokByChr(str,*optDLM.str,&cnt);
      mapi=*(map+i);
      for(j=0;j<cnt;j++){
        if( NULL != mssHashInsert((*(map+i))->alpOrg, *(list+j), *(alpNum+i)) ){
          mapi->alpSiz++;
          mapi->alp=mssRealloc(mapi->alp,
                      sizeof(usint)*mapi->alpSiz,"setMapAlp");
          *(mapi->alp+mapi->alpSiz-1)=(alpNum+i)->v.usi;
          (alpNum+i)->v.usi++;
        }
      }
      mssFree(*list); mssFree(list);
    }
  }
  mssFreeFldRec(fr);

  for(i=0; i<fpat->cnt; i++){
    /*ǥåΰ*/
    (*(map+i))->idx=mssCalloc(sizeof(usint)*((*(map+i))->alpSiz+1), "setMapAlp");

    /*ե٥åȤ˥ߥ͡ɲ*/
    (*(map+i))->alp=
      mssRealloc((*(map+i))->alp,
        sizeof(usint)*((*(map+i))->alpSiz+1),"setMapAlp");
    *((*(map+i))->alp+(*(map+i))->alpSiz)=0;

    /*hashϿ줿alphabet(ʸ->Ϳ)ͤǤȤ
      Ͽ*/
    (*(map+i))->numAlp=setNumAlp( *(map+i) );

    /*ͥѥξ硢ե٥åȤͽ¤ٴ*/
    if(mssIsFldOptOn(&optPAT,0,'n')){
      sortAlp(*(map+i));
    }

    /*ǥåĴ*/
    if(optSIZ.val>(*(map+i))->alpSiz) (*(map+i))->idxSiz=(*(map+i))->alpSiz;
    else                              (*(map+i))->idxSiz=optSIZ.val;
  }

  mssFree(alpNum);

  return(map);
}

/**
 * # FUNCTION #
 * Map¤Τΰ賫
 */
void freeMap(struct Map **map){
  int i;
  if(map==NULL)return;
  for(i=0; i<fpat->cnt; i++){
    mssFreeHash((*(map+i))->alpOrg);
    mssFree((*(map+i))->alp);
    mssFree((*(map+i))->idx);
    mssFree((*(map+i))->numAlp);
    mssFree(*(map+i));
  }
  mssFree(map);
}

/**
 * # FUNCTION #
 * ǡǻȤƤ륫ƥ꡼°ͤĴhashɽ˥åȤ
 * Ǥϡȥ졼˥󥰤ȥƥȤξꤦͤ򥻥åȤ
 * NULLͤФ
 */
struct Category *setCatHash(
  struct mssFPR *trn,
  struct mssFPR *tst,
  struct mssHeader *hd){

  struct Category *cat;
  struct Category *cat_i;
  struct mssFldRec *fr;  /*бΥ쥳ɥХåե*/
  int i;
  char *fldStr;
  MssValue val;

  mssVinit(&val,INT);

  /*ƥ°λ̵꤬NULL֤*/
  if(!optCAT.set) return(NULL);

  cat = mssMalloc(sizeof(struct Category)*fcat->cnt,"setCatHash");
  for(i=0; i<fcat->cnt; i++){
   (cat+i)->val     = NULL; /*ǤvalϥåȤsetDatǥå*/
   (cat+i)->name    = mssInitHash(101);
   (cat+i)->cnt     = 0;
   (cat+i)->valName = NULL;
  }

  /*ȥ졼˥󥰤category°*/
  fr=mssInitFldRec(hd->flds->cnt);
  mssSeekTopFPR(trn);
  while( EOF != mssReadFldRec(trn,fr) ){
    for(i=0; i<fcat->cnt; i++){
      cat_i=cat+i;
      fldStr=*(fr->pnt+MssFlds2num(fcat,i));

      /*ͤhashơ֥˥å*/
      mssVclear(&val);
      val.v.i=cat_i->cnt;
      /*hashơ֥줿ʤ,-(հ)ɽϿ&cnt++*/
      if(NULL != mssHashInsert(cat_i->name,fldStr,val) ){
        cat_i->valName=mssRealloc(cat_i->valName,
          sizeof(char *)*(cat_i->cnt+1),"setCatHash2");
        *(cat_i->valName+cat_i->cnt)=mssHashMemberAdd(cat_i->name,fldStr);
        cat_i->cnt++;
      }
    }
  }
  mssFreeFldRec(fr);

  /*ƥȤcategory°*/
  fr=mssInitFldRec(hd->flds->cnt);
  mssSeekTopFPR(tst);
  while( EOF != mssReadFldRec(tst,fr) ){
    for(i=0; i<fcat->cnt; i++){
      cat_i=cat+i;
      fldStr=*(fr->pnt+MssFlds2num(fcat,i));

      /*ͤhashơ֥˥å*/
      mssVclear(&val);
      val.v.i=cat_i->cnt;
      /*hashơ֥줿ʤ,-(հ)ɽϿ&cnt++*/
      if(NULL != mssHashInsert(cat_i->name,fldStr,val) ){
        cat_i->valName=mssRealloc(cat_i->valName,
          sizeof(char *)*(cat_i->cnt+1),"setCatHash2");
        *(cat_i->valName+cat_i->cnt)=mssHashMemberAdd(cat_i->name,fldStr);
        cat_i->cnt++;
      }
    }
  }
  mssFreeFldRec(fr);


  return(cat);
}

/**
 * # FUNCTION #
 * ǡ򥻥åȤ
 */
struct Data *setDat(
  struct mssFPR *fpr,
  struct mssHeader *hd,
  struct Class  *cls,   /*饹ʸ-Τ*/
  int            cnt,   /*ǡ*/
  struct Map   **map,   /*ƥѥ°Υޥå*/
  struct Category *cat){

  struct mssFldRec *fr;  /*бΥ쥳ɥХåե*/
  int i,j,k;
  struct Data *dat;
  char *fldStr;
  MssValue val;
  char **list;
  int    listCnt;
  struct mssHashNode *node;
  usint alpha[MaxPatLen];

  mssVinit(&val,INT);
  dat=mssCalloc(sizeof(struct Data),"setDat");

  /*饹ΰγݤȡ饹ʸ-Υԡ*/
  dat->cls=mssCalloc(sizeof(struct Class),"setDat");
  for(i=0; i<cls->cnt; i++) dat->cls->str[i]=cls->str[i];
  dat->cls->cnt=cls->cnt;
  dat->cls->chr=mssCalloc(sizeof(char)*cnt,"setDat1");

  /*°ΰγ*/
  dat->numCnt=fnum->cnt;
  dat->num    =mssCalloc(sizeof(double *)*dat->numCnt,"setDat2");
  dat->numNull=mssCalloc(sizeof(char   *)*dat->numCnt,"setDat2");
  for(i=0; i<dat->numCnt; i++){
    *(dat->num+i)     = mssCalloc(sizeof(double)*cnt,"setDat3" );
    *(dat->numNull+i) = mssCalloc(sizeof(char  )*cnt,"setDat3" );
  }

  /*ƥ꡼°ǡΰγ*/
  dat->catCnt=fcat->cnt;
  dat->cat    =mssCalloc(sizeof(struct Category)*dat->catCnt,"setDat5" );
  dat->catNull=mssCalloc(sizeof(char          *)*dat->catCnt,"setDat5");
  for(i=0; i<dat->catCnt; i++){
    (dat->cat+i)->name   =(cat+i)->name;
    (dat->cat+i)->valName=(cat+i)->valName;
    (dat->cat+i)->cnt    =(cat+i)->cnt;
    (dat->cat+i)->val = mssCalloc(sizeof(int)*cnt,"setDat5" );
   *(dat->catNull+i)  = mssCalloc(sizeof(char  )*cnt,"setDat5" );
  }

  /*ѥ°ΰγݤmapΥԡ*/
  dat->patCnt=fpat->cnt;
  dat->pat    =mssCalloc(sizeof(struct Pattern)*dat->patCnt ,"setDat6" );
  dat->patNull=mssCalloc(sizeof(char         *)*dat->patCnt ,"setDat6" );
  for(i=0; i<dat->patCnt; i++){
    /*mapΥå*/
    (dat->pat+i)->map=*(map+i);
    /*ͥѥǤ뤫ɤΥå*/
    (dat->pat+i)->numPat=mssIsFldOptOn(&optPAT,0,'n');
    /*¥ǡΰν*/
    (dat->pat+i)->patAlp=initStrListUSI();
    (dat->pat+i)->patIdx=initStrListUSI();
    /*ǥåη*/
    if(optSIZ.val > (*(map+i))->alpSiz || optSIZ.val==0 )
      (dat->pat+i)->map->idxSiz=(*(map+i))->alpSiz;
    else
      (dat->pat+i)->map->idxSiz=optSIZ.val;
   *(dat->patNull+i)  = mssCalloc(sizeof(char  )*cnt,"setDat6" );

  }    

  /*¥ǡ˳Ǽ*/
  i=0;
  fr=mssInitFldRec(hd->flds->cnt);
  mssSeekTopFPR(fpr);
  while( EOF != mssReadFldRec(fpr,fr) ){

    /*饹ܤͤ򥻥å*/
    /*饹ܤNULLǤ뤳ȤϤʤ(setClassǥå)*/
    *(dat->cls->chr+i)=getClassNum(cls,*(fr->pnt+MssFlds2num(fcls,0)));

    /*°γǼ*/
    for(j=0; j<fnum->cnt; j++){

      /*ܤ(ʸ)Υɥ쥹򥻥å*/
      fldStr = *(fr->pnt+MssFlds2num(fnum,j));

      if( MssIsNull(fldStr) ){
        *(*(dat->numNull+j)+i)=1;
      }else{
        *(*(dat->numNull+j)+i)=0;
        *(*(dat->num+j)+i)=atof(fldStr);
      }
    }

    /*ƥ꡼°γǼ*/
    for(j=0; j<dat->catCnt; j++){

      /*ܤ(ʸ)Υɥ쥹򥻥å*/
      fldStr = *(fr->pnt+MssFlds2num(fcat,j));

      if( MssIsNull(fldStr) ){
        *(*(dat->catNull+j)+i)=1;
      }else{
        *(*(dat->catNull+j)+i)=0;

        /*쥳ɤΥǡͤȤϿ*/
        mssVclear(&val);
        val=mssHashMemberVal( (dat->cat+j)->name, fldStr );
        if(val.nul) *((dat->cat+j)->val + i) = 0;
        else        *((dat->cat+j)->val + i) = val.v.i;
      }
    }

    /*ѥγǼ*/
    for(j=0; j<fpat->cnt; j++){
      /*ܤ(ʸ)Υɥ쥹򥻥å*/
      fldStr=*(fr->pnt+MssFlds2num(fpat,j));

      if( MssIsNull(fldStr) ){
        *(*(dat->patNull+j)+i)=1;
        alpha[0]=0;
        putStrListUSI((dat->pat+j)->patAlp,alpha);
      }else{
        *(*(dat->patNull+j)+i)=0;
 
        list=tokByChr(fldStr,*optDLM.str,&listCnt);
        /*k(ex.1024)ۤ饨顼ˤ*/
        for(k=0;k<listCnt;k++){
          node=(struct mssHashNode *)mssHashMember((*(map+j))->alpOrg,*(list+k));
          if( NULL == node ){
            mssShowErrMsg("internal error1");
            exit(mssErrorNoDefault);
          }else{
            alpha[k]=node->val.v.usi;
          }
        }
        mssFree(*list); mssFree(list);
        alpha[k]=0; /*ߥ͡*/
        putStrListUSI((dat->pat+j)->patAlp,alpha);
      }
    }

    /*ȥå*/
    i++;
  }
  mssFreeFldRec(fr);

  /*եݥ󥿤Υԡ*/
  dat->fpr=fpr;

  /*ǡΥå*/
  dat->cnt=cnt;

  return(dat);
}

/**
 * # FUNCTION #
 * ǡɽ(debug)
 * Map¤Τΰ賫
 */
void showDat( struct Data *dat){

  int i,j,k;

  printf("=========================================\n");
  printf(" Data of \"%s\"\n",dat->fpr->fName);
  printf("=========================================\n");
  printf(" number of lines  : %d\n",dat->cnt);
  printf(" number of patFld : %d\n",dat->patCnt);
  printf(" number of numFld : %d\n",dat->numCnt);
  printf(" number of catFld : %d\n",dat->catCnt);
  for(i=0; i<ClassSize; i++){
    printf(" cls[%d]=%s, ",i,dat->cls->str[i]);
  }
  printf("\n");
  for(i=0; i<dat->patCnt; i++){
    printf(" alphabet on pattern field[%d] numFlg=%d : ",i,(dat->pat+i)->numPat)
;

    if( (dat->pat+i)->map->idxSiz==0){
      prnstrUSI((dat->pat+i)->map->alp);
      printf("\n");
    }else{
      prnstrUSI((dat->pat+i)->map->alp);
      printf("(");
      prnstrUSI((dat->pat+i)->map->idx);
      printf(")\n");
    }
  }
  printf("-----------------------------------------\n");
  for(i=0; i<dat->cnt; i++){
    /*ѥ*/
    for(j=0; j<dat->patCnt; j++){
      if(*(*(dat->patNull+j)+i)==1){
        printf("NULL ");
      }else{
        if((dat->pat+j)->patIdx->lineCnt==0){
          prnstrUSI(getStrListUSI((dat->pat+j)->patAlp,i));
        }else{
          prnstrUSI(getStrListUSI((dat->pat+j)->patAlp,i));
          printf("(");
          prnstrUSI(getStrListUSI((dat->pat+j)->patIdx,i));
          printf(")");
        }
      }
    }
    /*͹*/
    for(j=0; j<dat->numCnt; j++){
      if(*(*(dat->numNull+j)+i)==1){
        printf("NULL ");
      }else{
        printf("%g ",*(*(dat->num+j)+i) );
      }
    }
    /*ƥ꡼*/
    for(j=0; j<dat->catCnt; j++){
      if(*(*(dat->catNull+j)+i)==1){
        printf("NULL ");
      }else{ 
        printf("%s(%d) ",*((dat->cat+j)->valName+*((dat->cat+j)->val+i)),
                         *((dat->cat+j)->val+i) );
      }
    }
    /*饹*/
    printf("cls=%d\n",(int)*(dat->cls->chr+i) );
  }
  
  /*ѥν*/
  if(dat->pat->regTbl!=NULL){
    printf("-----------------------------------------\n");
    for(i=0; i<dat->patCnt; i++){
      printf("pattern #%d\n",i);
      for(j=0; j<(dat->pat+i)->regTbl->cnt; j++){
        printf("#%02d=",j);
        prnstrUSI(((dat->pat+i)->regTbl->reg+j)->str);
        printf("(%g)\n", ((dat->pat+i)->regTbl->reg+j)->objVal);
      }
    }
  }

  
  /*ѥ°Ȥǡν*/
  if(dat->pat->attCnt!=0){
    printf("-----------------------------------------\n");
    for(i=0; i<dat->patCnt; i++){ /*ѥܿ*/
      printf("----- pat #%d\n",i);
      for(j=0; j<dat->cnt; j++){ /*ץǡ*/
        for(k=0; k<(dat->pat+i)->attCnt; k++){ /*ɽ*/
          if(*((dat->pat+i)->att[k]+j) ) printf("1");
          else                           printf("0");
        }
        printf("cls=%d\n",*(dat->cls->chr+j) );
      }
    }
  }
  printf("=========================================\n");
}

/**
 * # FUNCTION #
 * ǡΰ
 */
void freeDat(struct Data *dat){
  int i;
  if(dat==NULL)return;
  for(i=0; i<dat->patCnt; i++){
    mssFree(*(dat->patNull+i));
    freeStrListUSI((dat->pat+i)->patAlp);
    freeStrListUSI((dat->pat+i)->patIdx);
  }
  mssFree(dat->patNull);
  mssFree(dat->pat);

  for(i=0; i<dat->catCnt; i++){
    mssFree(*(dat->catNull+i));
    mssFree((dat->cat+i)->val);
  }
  mssFree(dat->catNull);
  mssFree(dat->cat);

  for(i=0; i<dat->numCnt; i++){
    mssFree(*(dat->numNull+i));
    mssFree(*(dat->num+i));
  }
  mssFree(dat->numNull);
  mssFree(dat->num);

  mssFree(dat->cls->chr);
  mssFree(dat->cls);
  mssFree(dat);
}
