/*
 * Decompiled with CFR 0.152.
 */
package viewer.first;

import java.awt.Window;
import java.io.File;
import java.util.List;
import javax.swing.JTextField;
import logformat.slog2.input.InputLog;
import viewer.common.Dialogs;
import viewer.common.LogFileChooser;
import viewer.common.Parameters;
import viewer.common.PreferenceFrame;
import viewer.common.SwingWorker;
import viewer.common.TopWindow;
import viewer.convertor.ConvertorDialog;
import viewer.legends.LegendFrame;
import viewer.timelines.TimelineFrame;

public class LogFileOperations {
    private LogFileChooser file_chooser;
    private InputLog slog_ins;
    private PreferenceFrame pptys_frame;
    private LegendFrame legend_frame;
    private TimelineFrame timeline_frame;

    public LogFileOperations(boolean bl) {
        this.file_chooser = new LogFileChooser(bl);
        this.slog_ins = null;
        this.legend_frame = null;
        this.timeline_frame = null;
    }

    public void init() {
        Parameters.initSetupFile();
        Parameters.readFromSetupFile(TopWindow.First.getWindow());
        Parameters.initStaticClasses();
        this.pptys_frame = new PreferenceFrame();
        this.pptys_frame.setVisible(false);
    }

    private static InputLog createInputLog(Window window, String string) {
        String string2 = string.trim();
        if (string2 != null && string2.length() > 0) {
            File file = new File(string2);
            if (!file.exists()) {
                Dialogs.error(window, "File Not Found when initializing " + string2 + ".");
                return null;
            }
            if (file.isDirectory()) {
                Dialogs.error(window, string2 + " is a directory.");
                return null;
            }
            if (!file.canRead()) {
                Dialogs.error(window, "File " + string2 + " cannot be read.");
                return null;
            }
            InputLog inputLog = null;
            try {
                inputLog = new InputLog(string2);
            }
            catch (NullPointerException nullPointerException) {
                Dialogs.error(window, "NullPointerException when initializing " + string2 + "!");
                return null;
            }
            catch (Exception exception) {
                Dialogs.error(window, "EOFException when initializing " + string2 + "!");
                return null;
            }
            return inputLog;
        }
        Dialogs.error(window, "Null pathname!");
        return null;
    }

    public void disposeLogFileAndResources() {
        if (this.slog_ins != null) {
            TopWindow.Legend.disposeAll();
            this.slog_ins.close();
            this.slog_ins = null;
            this.legend_frame = null;
            this.timeline_frame = null;
        }
    }

    public String selectLogFile() {
        int n = this.file_chooser.showOpenDialog(TopWindow.First.getWindow());
        if (n == 0) {
            File file = this.file_chooser.getSelectedFile();
            if (file != null) {
                File file2 = file.getParentFile();
                if (file2 != null) {
                    this.file_chooser.setCurrentDirectory(file2);
                }
                return file.getPath();
            }
        } else {
            Dialogs.info(TopWindow.First.getWindow(), "No file chosen", null);
        }
        return null;
    }

    public String convertLogFile(String string) {
        return ConvertorDialog.convertLogFile(TopWindow.First.getWindow(), this.file_chooser, string);
    }

    public List openLogFile(JTextField jTextField) {
        String string = jTextField.getText();
        this.slog_ins = LogFileOperations.createInputLog(TopWindow.First.getWindow(), string);
        if (this.slog_ins == null) {
            Dialogs.error(TopWindow.First.getWindow(), "Null InputLog!");
            return null;
        }
        if (!this.slog_ins.isSLOG2()) {
            this.slog_ins = null;
            if (Dialogs.confirm(TopWindow.First.getWindow(), string + " is NOT a SLOG-2 file!\n" + "Do you want to convert it to SLOG-2 format " + "readable by this viewer?")) {
                String string2 = ConvertorDialog.convertLogFile(TopWindow.First.getWindow(), this.file_chooser, string);
                jTextField.setText(string2);
                return this.openLogFile(jTextField);
            }
            return null;
        }
        String string3 = null;
        string3 = this.slog_ins.getCompatibleHeader();
        if (string3 != null && !Dialogs.confirm(TopWindow.First.getWindow(), string3 + "Check the following version history " + "for compatibility.\n\n" + "- Version SLOG 2.0.0's node employs\n  decreasing endtime ordering.\n- Version SLOG 2.0.1's node employs\n  increasing starttime ordering.\n- Version SLOG 2.0.2 added preview data\n  in legend order to shadow states.\n- Version SLOG 2.0.3 changed preview data\n  from legend to inclusive ratio order.\n- Version SLOG 2.0.4 removed unused\n  category objects.\n- Version SLOG 2.0.5 expanded preview data\n  to include inclusive & exclusive ratios.\n  \n- 2.0.1 viewer draws 2.0.0 logfile's\n  state nesting stack incorrectly!\n- 2.0.2 viewer cannot read 2.0.1 logfile.\n- 2.0.3 viewer draws 2.0.2 logfile's\n  preview weight incorrectly.\n- 2.0.4 viewer supports JOIN method and\n  can display 2.0.3 logfile correctly.\n- 2.0.5 viewer cannot read 2.0.4 logfile.\n" + "\n" + "Do you still want to continue reading " + "the logfile ?")) {
            this.slog_ins = null;
            return null;
        }
        this.slog_ins.initialize();
        this.legend_frame = new LegendFrame(this.slog_ins);
        this.legend_frame.pack();
        TopWindow.layoutIdealLocations();
        this.legend_frame.setVisible(true);
        return this.slog_ins.getLineIDMapList();
    }

    public void createTimelineWindow(final int n) {
        if (this.slog_ins != null && n >= 0) {
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    LogFileOperations.this.timeline_frame = new TimelineFrame(LogFileOperations.this.slog_ins, n);
                    return null;
                }

                public void finished() {
                    LogFileOperations.this.timeline_frame.pack();
                    TopWindow.layoutIdealLocations();
                    LogFileOperations.this.timeline_frame.setVisible(true);
                    LogFileOperations.this.timeline_frame.init();
                }
            };
            swingWorker.start();
        }
    }

    public void showLegendWindow() {
        if (this.slog_ins != null && this.legend_frame != null) {
            this.legend_frame.pack();
            TopWindow.layoutIdealLocations();
            this.legend_frame.setVisible(true);
        }
    }

    public void showPreferenceWindow() {
        if (this.pptys_frame != null) {
            this.pptys_frame.pack();
            TopWindow.layoutIdealLocations();
            this.pptys_frame.setVisible(true);
            this.pptys_frame.toFront();
        }
    }
}

