/* swfbitmap.c	- SWFBitmap class
 * $Id: swfbitmap.c,v 1.3 2004/11/07 17:34:22 ikegami Exp $
 *
 * Copyright (C) 2004 IKEGAMI Daisuke <ikegami at madscientist dot jp>
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 * 
 */

#include <ming.h>
#include "ruby.h"
#include "mingc.h"

VALUE rb_cSWFBitmap;

void
rb_free_SWFBitmap(p)
	 struct RSWFBitmap *p;
{
  FILE *fp = p->option;

  fclose(fp);
  /* destroySWFBitmap(p->this); */ 
  
  return;  
}

static VALUE
rb_SWFBitmap_s_new(self, filename)
     VALUE self, filename;
{
  struct RSWFBitmap *b = ALLOC(struct RSWFBitmap);
  FILE *fp;
  VALUE obj;

  /* fp should be closed when this object is destroyed! */
  fp = fopen(STR2CSTR(filename), "rb");
  b->this = newSWFBitmap_fromInput(newSWFInput_file(fp));
  b->table = ALLOC(struct References);
  init_references(b->table);
  b->option = fp;

  obj = Data_Wrap_Struct(rb_cSWFCharacter, 0, rb_free_SWFCharacter, b);
  return obj;
}

static VALUE
rb_SWFBitmap_get_width(self)
     VALUE self;
{
  struct RSWFBitmap *b;

  Data_Get_Struct(self, struct RSWFBitmap, b);

  return INT2NUM(SWFBitmap_getWidth(b->this));
}

static VALUE
rb_SWFBitmap_get_height(self)
	 VALUE self;
{
  struct RSWFBitmap *b;

  Data_Get_Struct(self, struct RSWFBitmap, b);

  return INT2NUM(SWFBitmap_getHeight(b->this));
}

void Init_swfbitmap()
{
  rb_cSWFBitmap = rb_define_class_under(rb_mMing, "SWFBitmap", rb_cObject);

  rb_define_singleton_method(rb_cSWFBitmap, "new",
			     rb_SWFBitmap_s_new, 1);

  rb_define_method(rb_cSWFBitmap, "get_width",
		   rb_SWFBitmap_get_width, 0);
  rb_define_method(rb_cSWFBitmap, "get_height",
		   rb_SWFBitmap_get_height, 0);
  return;
}
