/*  Window monitor for GNOME and KDE
 *  Copyright (C) 2004 UCHINO Satoshi.  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

#include "windowmonitor.h"

char *programName;
WnckScreen *thisScreen;

static void window_opened_callback            (WnckScreen      *screen,
                                               WnckWindow      *window,
                                               gpointer         data);
static void window_closed_callback            (WnckScreen      *screen,
                                               WnckWindow      *window,
                                               gpointer         data);

int
main(int argc, char **argv)
{
  int i;

  programName = argv[0];

  /* initialize GTK */
  gtk_init(&argc, &argv);

  /* Interpret resource specs and process any remaining command-line arguments
     (i.e. the VNC server name).  If the server name isn't specified on the
     command line, getArgsAndResources() will pop up a dialog box and wait
     for one to be entered. */

  GetArgsAndResources(argc, argv);

  /* initialize clipboard */
  initClipboard();

  /* Initialize launcher */
  initLauncher();

  /* Initialize our capability lists */

  InitCapabilities();

  /* Make a TCP connection to the given VNC server */

  if (!ConnectToRFBServer(vncServerHost, vncServerPort)) exit(1);

  /* Initialise the VNC connection, including reading the password */

  if (!InitialiseRFBConnection()) exit(1);

  /* Associate GTK events with callbacks */
  thisScreen = wnck_screen_get (0);

  g_signal_connect (G_OBJECT (thisScreen), "window_opened",
                    G_CALLBACK (window_opened_callback),
                    NULL);
  g_signal_connect (G_OBJECT (thisScreen), "window_closed",
                    G_CALLBACK (window_closed_callback),
                    NULL);

  /* send initial state
   */
  /*sendAllWindowStatus(thisScreen);*/ /* callbacks will take care */
  sendAllLaunchers();

  /* Now enter the main loop, processing VNC messages.  GTK events will
     automatically be processed whenever the VNC connection is idle. */

  while (1) {
    if (!HandleRFBServerMessage())
      break;
  }

  return 0;
}

static void window_name_changed_callback      (WnckWindow      *window,
                                               gpointer         data);
static void window_state_changed_callback     (WnckWindow      *window,
                                               WnckWindowState  changed,
                                               WnckWindowState  new,
                                               gpointer         data);

int get_vnc_window_state(WnckWindowState state)
{
  int vwstate = rfbWindowStateRunning;
  if (state & WNCK_WINDOW_STATE_MINIMIZED)
    vwstate |= rfbWindowStateMinimized;
  if ((state & WNCK_WINDOW_STATE_MAXIMIZED_HORIZONTALLY) &&
      (state & WNCK_WINDOW_STATE_MAXIMIZED_VERTICALLY))
    vwstate |= rfbWindowStateMaximized;
  return vwstate;
}

static void
window_opened_callback            (WnckScreen    *screen,
                                   WnckWindow    *window,
                                   gpointer       data)
{
  DEBUG_PRINTF(("Window '%s'(0x%X) opened (pid=%d session_id=%s xid=0x%X state=0x%X application '%s')\n",
           wnck_window_get_name (window), window,
           wnck_window_get_pid (window),
           wnck_window_get_session_id (window) ?
           wnck_window_get_session_id (window) : "none",
           wnck_window_get_xid (window),
           wnck_window_get_state(window),
           wnck_application_get_name(wnck_window_get_application(window))));
  
  g_signal_connect (G_OBJECT (window), "name_changed",
                    G_CALLBACK (window_name_changed_callback),
                    NULL);
  g_signal_connect (G_OBJECT (window), "state_changed",
                    G_CALLBACK (window_state_changed_callback),
                    NULL);

  if (!wnck_window_is_skip_tasklist(window))   /* ignore if skip_tasklist */
    SendWindowState(wnck_window_get_xid (window),
                    get_vnc_window_state (wnck_window_get_state (window)),
                    wnck_window_get_name (window));
}

static void
window_closed_callback            (WnckScreen    *screen,
                                   WnckWindow    *window,
                                   gpointer       data)
{
  DEBUG_PRINTF(("Window '%s'(0x%X) closed\n",
           wnck_window_get_name (window), window));

  SendWindowState(wnck_window_get_xid (window),
                  rfbWindowStateClosed, NULL);
}

static void
window_name_changed_callback (WnckWindow    *window,
                              gpointer       data)
{
  DEBUG_PRINTF(("Name changed on window '%s'(xid=0x%X)\n",
           wnck_window_get_name (window),
           wnck_window_get_xid (window)));

  if (!wnck_window_is_skip_tasklist(window))   /* ignore if skip_tasklist */
    SendWindowState(wnck_window_get_xid (window),
                    get_vnc_window_state (wnck_window_get_state (window)),
                    wnck_window_get_name (window));
}

static void
window_state_changed_callback (WnckWindow     *window,
                               WnckWindowState changed,
                               WnckWindowState new,
                               gpointer        data)
{
  DEBUG_PRINTF(("State changed on window '%s'(xid=0x%X)\n",
           wnck_window_get_name (window),
           wnck_window_get_xid (window)));

  if (!wnck_window_is_skip_tasklist(window))   /* ignore if skip_tasklist */
    SendWindowState(wnck_window_get_xid (window),
                    get_vnc_window_state (wnck_window_get_state (window)),
                    wnck_window_get_name (window));
}
