/*  Window monitor / RFB message handler
 *  Copyright (C) 2004 UCHINO Satoshi.  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

#include "windowmonitor.h"

static void sendAllWindowStatus(WnckScreen *screen);

void windowControl(int id, int control)
{
  WnckWindow *window = wnck_window_get(id);

  DEBUG_PRINTF(("+windowControl id=0x%X, control=%d\n", id, control));
  switch (control) {
  case rfbWindowControlNone:
    sendAllWindowStatus(thisScreen);
    sendAllLaunchers();
    break;
  case rfbWindowControlLaunch:
    launch(id);
    break;
  case rfbWindowControlClose:
    DEBUG_PRINTF(("closing window '%s'(xid=0x%X)\n", wnck_window_get_name(window), id));
    /*wnck_window_close(window);*/
    wnck_window_close(window, 0/*XXX timestamp*/);
    break;
  case rfbWindowControlRestore:
    DEBUG_PRINTF(("restoring window '%s'(xid=0x%X)\n", wnck_window_get_name(window), id));
    wnck_window_unminimize(window);
    wnck_window_unmaximize(window);
    break;
  case rfbWindowControlMinimize:
    DEBUG_PRINTF(("minimizing window '%s'(xid=0x%X)\n", wnck_window_get_name(window), id));
    wnck_window_minimize(window);
    break;
  case rfbWindowControlMaximize:
    DEBUG_PRINTF(("maximizing window '%s'(xid=0x%X)\n", wnck_window_get_name(window), id));
    wnck_window_maximize(window);
    break;
  default:
    DEBUG_PRINTF(("windowControl: unsupported control %d\n"));
    break;
  }
  DEBUG_PRINTF(("-windowControl id=0x%X, control=%d\n"));
}

static void
sendAllWindowStatus(WnckScreen *screen)
{
  GList *glist;
  
  for (glist = wnck_screen_get_windows(screen); glist; glist = glist->next) {
    WnckWindow *window = glist->data;
    DEBUG_PRINTF(("window '%s'(xid=0x%X)\n",
             wnck_window_get_name(window),
             wnck_window_get_xid(window)));
    if (!wnck_window_is_skip_tasklist(window))   /* ignore if skip_tasklist */
      SendWindowState(wnck_window_get_xid(window),
                      get_vnc_window_state(wnck_window_get_state(window)),
                      wnck_window_get_name(window));
  }
}
