/*
 *  Copyright (C) 2004 UCHINO Satoshi.  All Rights Reserved.
 *  Copyright (C) 2002-2003 Constantin Kaplinsky.  All Rights Reserved.
 *  Copyright (C) 1999 AT&T Laboratories Cambridge.  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

/*
 * argsresources.c - deal with command-line args and resources.
 */

#include "windowmonitor.h"

/*
 * vncServerHost and vncServerPort are set either from the command line or
 * from a dialog box.
 */

char vncServerHost[256];
int vncServerPort = 0;


/*
 * appData is our application-specific data which can be set by the user with
 * application resource specs.  The AppData structure is defined in the header
 * file.
 */

AppData appData;

/*
 * removeArgs() is used to remove some of command line arguments.
 */

void
removeArgs(int *argc, char** argv, int idx, int nargs)
{
  int i;
  if ((idx+nargs) > *argc) return;
  for (i = idx+nargs; i < *argc; i++) {
    argv[i-nargs] = argv[i];
  }
  *argc -= nargs;
}

/*
 * usage() prints out the usage message.
 */

void
usage(void)
{
  fprintf(stderr,
	  "Window Monitor version 0.1\n"
	  "\n"
	  "Usage: %s [<OPTIONS>]\n"
	  "       %s -help\n"
	  "\n"
	  "<OPTIONS> are standard GTK options, or:\n"
	  "        -passwd <PASSWD-FILENAME> (standard VNC authentication)\n"
	  "        -user <USERNAME> (Unix login authentication)\n"
	  "        -launcher <LAUNCHER-CONFIG-FILE>\n"
	  "\n", programName, programName);
  exit(1);
}


/*
 * GetArgsAndResources() deals with resources and any command-line arguments
 * not already processed by XtVaAppInitialize().  It sets vncServerHost and
 * vncServerPort and all the fields in appData.
 */

void
GetArgsAndResources(int argc, char **argv)
{
  char *vncServerName = NULL, *colonPos;
  int i, len, portOffset;
  Display *dpy;			/* X connection */

  /* clear */
  memset(&appData, 0, sizeof(appData));

  /* parameters */
  for (i = 1; i < argc; i++) {
    if (argv[i][0] == '-') {
      if (strcmp(argv[i], "-passwd") == 0 && i + 1 <argc) {
        appData.passwordFile = argv[++i];
      } else if (strcmp(argv[i], "-user") == 0 && i + 1 <argc) {
        appData.userLogin    = argv[++i];
      } else if (strcmp(argv[i], "-launcher") == 0 && i + 1 <argc) {
        appData.launcherFile = argv[++i];
      } else if (strcmp(argv[i], "-debug") == 0) {
        appData.debug = TRUE;
      } else {
        usage(); /* never returns */
      }
    } else {
      usage(); /* never returns */
    }
  }

  /* set up host name */
  dpy = XOpenDisplay(NULL);
  vncServerName = DisplayString(dpy);
  DEBUG_PRINTF(("display name = %s\n", vncServerName));
  colonPos = strchr(vncServerName, ':');
  if (colonPos == NULL) {
    /* No colon -- use default port number */
    strcpy(vncServerHost, vncServerName);
    vncServerPort = SERVER_PORT_OFFSET;
  } else {
    if (colonPos > vncServerName) {
      memcpy(vncServerHost, vncServerName, colonPos - vncServerName);
      vncServerHost[colonPos - vncServerName] = '\0';
    } else {
      strcpy(vncServerHost, "localhost");
    }
    len = strlen(colonPos + 1);
    portOffset = SERVER_PORT_OFFSET;
    vncServerPort = atoi(colonPos + 1) + portOffset;
  }
  XCloseDisplay (dpy);
  DEBUG_PRINTF(("vncServerHost = %s vncServerPort = %d\n", vncServerHost, vncServerPort));
}
