.TH SPTTRS l "15 June 2000" "LAPACK version 3.0" ")"
.SH NAME
SPTTRS - solve a tridiagonal system of the form A * X = B using the L*D*L' factorization of A computed by SPTTRF
.SH SYNOPSIS
.TP 19
SUBROUTINE SPTTRS(
N, NRHS, D, E, B, LDB, INFO )
.TP 19
.ti +4
INTEGER
INFO, LDB, N, NRHS
.TP 19
.ti +4
REAL
B( LDB, * ), D( * ), E( * )
.SH PURPOSE
SPTTRS solves a tridiagonal system of the form A * X = B using the L*D*L' factorization of A computed by SPTTRF. D is a diagonal matrix specified in the vector D, L is a unit bidiagonal
matrix whose subdiagonal is specified in the vector E, and X and B
are N by NRHS matrices.
.br

.SH ARGUMENTS
.TP 8
N       (input) INTEGER
The order of the tridiagonal matrix A.  N >= 0.
.TP 8
NRHS    (input) INTEGER
The number of right hand sides, i.e., the number of columns
of the matrix B.  NRHS >= 0.
.TP 8
D       (input) REAL array, dimension (N)
The n diagonal elements of the diagonal matrix D from the
L*D*L' factorization of A.
.TP 8
E       (input) REAL array, dimension (N-1)
The (n-1) subdiagonal elements of the unit bidiagonal factor
L from the L*D*L' factorization of A.  E can also be regarded
as the superdiagonal of the unit bidiagonal factor U from the
factorization A = U'*D*U.
.TP 8
B       (input/output) REAL array, dimension (LDB,NRHS)
On entry, the right hand side vectors B for the system of
linear equations.
On exit, the solution vectors, X.
.TP 8
LDB     (input) INTEGER
The leading dimension of the array B.  LDB >= max(1,N).
.TP 8
INFO    (output) INTEGER
= 0: successful exit
.br
< 0: if INFO = -k, the k-th argument had an illegal value
