.TH CLAR1V l "15 June 2000" "LAPACK version 3.0" ")"
.SH NAME
CLAR1V - compute the (scaled) r-th column of the inverse of the sumbmatrix in rows B1 through BN of the tridiagonal matrix L D L^T - sigma I
.SH SYNOPSIS
.TP 19
SUBROUTINE CLAR1V(
N, B1, BN, SIGMA, D, L, LD, LLD, GERSCH, Z,
ZTZ, MINGMA, R, ISUPPZ, WORK )
.TP 19
.ti +4
INTEGER
B1, BN, N, R
.TP 19
.ti +4
REAL
MINGMA, SIGMA, ZTZ
.TP 19
.ti +4
INTEGER
ISUPPZ( * )
.TP 19
.ti +4
REAL
D( * ), GERSCH( * ), L( * ), LD( * ), LLD( * ),
WORK( * )
.TP 19
.ti +4
COMPLEX
Z( * )
.SH PURPOSE
CLAR1V computes the (scaled) r-th column of the inverse of the sumbmatrix in rows B1 through BN of the tridiagonal matrix L D L^T - sigma I. The following steps accomplish this computation : (a) Stationary qd transform,  L D L^T - sigma I = L(+) D(+) L(+)^T,
(b) Progressive qd transform, L D L^T - sigma I = U(-) D(-) U(-)^T,
(c) Computation of the diagonal elements of the inverse of
    L D L^T - sigma I by combining the above transforms, and choosing
    r as the index where the diagonal of the inverse is (one of the)
    largest in magnitude.
.br
(d) Computation of the (scaled) r-th column of the inverse using the
    twisted factorization obtained by combining the top part of the
    the stationary and the bottom part of the progressive transform.

.SH ARGUMENTS
.TP 9
N        (input) INTEGER
The order of the matrix L D L^T.
.TP 9
B1       (input) INTEGER
First index of the submatrix of L D L^T.
.TP 9
BN       (input) INTEGER
Last index of the submatrix of L D L^T.
.TP 9
SIGMA    (input) REAL
The shift. Initially, when R = 0, SIGMA should be a good
approximation to an eigenvalue of L D L^T.
.TP 9
L        (input) REAL array, dimension (N-1)
The (n-1) subdiagonal elements of the unit bidiagonal matrix
L, in elements 1 to N-1.
.TP 9
D        (input) REAL array, dimension (N)
The n diagonal elements of the diagonal matrix D.
.TP 9
LD       (input) REAL array, dimension (N-1)
The n-1 elements L(i)*D(i).
.TP 9
LLD      (input) REAL array, dimension (N-1)
The n-1 elements L(i)*L(i)*D(i).
.TP 9
GERSCH   (input) REAL array, dimension (2*N)
The n Gerschgorin intervals. These are used to restrict
the initial search for R, when R is input as 0.
.TP 9
Z        (output) COMPLEX array, dimension (N)
The (scaled) r-th column of the inverse. Z(R) is returned
to be 1.
.TP 9
ZTZ      (output) REAL
The square of the norm of Z.
.TP 9
MINGMA   (output) REAL
The reciprocal of the largest (in magnitude) diagonal
element of the inverse of L D L^T - sigma I.
.TP 9
R        (input/output) INTEGER
Initially, R should be input to be 0 and is then output as
the index where the diagonal element of the inverse is
largest in magnitude. In later iterations, this same value
of R should be input.
.TP 9
ISUPPZ   (output) INTEGER array, dimension (2)
The support of the vector in Z, i.e., the vector Z is
nonzero only in elements ISUPPZ(1) through ISUPPZ( 2 ).
.TP 9
WORK     (workspace) REAL array, dimension (4*N)
.SH FURTHER DETAILS
Based on contributions by
.br
   Inderjit Dhillon, IBM Almaden, USA
.br
   Osni Marques, LBNL/NERSC, USA
.br
   Ken Stanley, Computer Science Division, University of
.br
     California at Berkeley, USA
.br

