/***************************************************************************
 *            cxp-cmd-progress-dialog.c
 *
 *  Thu Oct 13 19:46:34 JST 2005
 *  Copyright  2005  Yasumichi Akahoshi
 *  yasumichi@users.sourceforge.jp
 ***************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <sys/types.h>
#include <sys/wait.h>
#include <cxp-cmd-progress-dialog.h>

static void cxp_cmd_progress_dialog_class_init (CxpCmdProgressDialogClass *
						klass);
static void cxp_cmd_progress_dialog_init (CxpCmdProgressDialog * sp);
static void cxp_cmd_progress_dialog_finalize (GObject * object);
static void cxp_cmd_progress_dialog_set_property (GObject * object,
						  guint property_id,
						  const GValue * value,
						  GParamSpec * pspec);
static void cxp_cmd_progress_dialog_get_property (GObject * object,
						  guint property_id,
						  GValue * value,
						  GParamSpec * pspec);
static void cxp_cmd_progress_dialog_on_show (GtkWidget * widget,
					     gpointer user_data);
static void cxp_cmd_progress_dialog_child_watch (GPid pid, gint status, gpointer data);
static gboolean cxp_cmd_progress_dialog_can_read_sout (GIOChannel *source, GIOCondition condition, gpointer data);
static gboolean cxp_cmd_progress_dialog_can_read_serr (GIOChannel *source, GIOCondition condition, gpointer data);

#define CXP_CMD_PROGRESS_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CXP_TYPE_CMD_PROGRESS_DIALOG, CxpCmdProgressDialogPrivate))

struct CxpCmdProgressDialogPrivate
{
	gchar *command;
	GIOChannel *ochannel;
	GIOChannel *echannel;
	GPid pid;
	GtkWidget *label;
	GtkWidget *scrwin;
	GtkWidget *treeview;
	/* Place Private Members Here */
};

typedef enum
{
	/* Place Signal Types Here */
	SIGNAL_TYPE_EXAMPLE,
	LAST_SIGNAL
} CxpCmdProgressDialogSignalType;

typedef struct
{
	CxpCmdProgressDialog *object;
} CxpCmdProgressDialogSignal;

enum
{
	COL_STOCK_ID,
	COL_MESSAGE,
	COL_COUNT
};

enum
{
	PROPERTY_COMMAND = 1,
};

static guint cxp_cmd_progress_dialog_signals[LAST_SIGNAL] = { 0 };
static GObjectClass *parent_class = NULL;

GType cxp_cmd_progress_dialog_get_type ()
{
	static GType type = 0;

	if (type == 0)
	{
		static const GTypeInfo our_info = {
			sizeof (CxpCmdProgressDialogClass),
			NULL,
			NULL,
			(GClassInitFunc) cxp_cmd_progress_dialog_class_init,
			NULL,
			NULL,
			sizeof (CxpCmdProgressDialog),
			0,
			(GInstanceInitFunc) cxp_cmd_progress_dialog_init,
		};

		type = g_type_register_static (GTK_TYPE_DIALOG,
					       "CxpCmdProgressDialog",
					       &our_info, 0);
	}

	return type;
}

static void
cxp_cmd_progress_dialog_class_init (CxpCmdProgressDialogClass * klass)
{
	GObjectClass *object_class = G_OBJECT_CLASS (klass);
	GParamSpec *pspec;

	parent_class = g_type_class_peek_parent (klass);
	object_class->finalize = cxp_cmd_progress_dialog_finalize;
	object_class->set_property = cxp_cmd_progress_dialog_set_property;
	object_class->get_property = cxp_cmd_progress_dialog_get_property;

	g_type_class_add_private (klass, sizeof (CxpCmdProgressDialogPrivate));
	/* Create signals here:
	   cxp_cmd_progress_dialog_signals[SIGNAL_TYPE_EXAMPLE] = g_signal_new(...)
	 */

	pspec = g_param_spec_string ("command", "executable command",
				     "Set command", NULL,
				     G_PARAM_CONSTRUCT_ONLY |
				     G_PARAM_READWRITE);
	g_object_class_install_property (object_class, PROPERTY_COMMAND, pspec);
}

static void cxp_cmd_progress_dialog_init (CxpCmdProgressDialog * obj)
{
	CxpCmdProgressDialogPrivate *priv =
		CXP_CMD_PROGRESS_DIALOG_GET_PRIVATE (obj);
	GtkTreeModel *model;
	GtkTreeViewColumn *column;
	GtkCellRenderer *renderer;

	/* Initialize private members, etc. */
	priv->label = gtk_label_new ("command");
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (obj)->vbox), priv->label,
			    FALSE, TRUE, 2);
	gtk_label_set_selectable (GTK_LABEL(priv->label), TRUE);
	gtk_misc_set_alignment (GTK_MISC(priv->label), 0.0, 0.0);
	gtk_widget_show (priv->label);

	priv->scrwin = gtk_scrolled_window_new (NULL, NULL);
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (obj)->vbox), priv->scrwin, TRUE,
			    TRUE, 2);
	gtk_widget_show (priv->scrwin);

	model = GTK_TREE_MODEL (gtk_list_store_new
				(COL_COUNT, G_TYPE_STRING, G_TYPE_STRING));
	priv->treeview = gtk_tree_view_new_with_model (model);
	gtk_container_add (GTK_CONTAINER (priv->scrwin), priv->treeview);
	column = gtk_tree_view_column_new ();
	gtk_tree_view_column_set_title (column, "Messages");
	renderer = gtk_cell_renderer_pixbuf_new ();
	gtk_tree_view_column_pack_start (column, renderer, FALSE);
	gtk_tree_view_column_set_attributes (column, renderer, "stock-id",
					     COL_STOCK_ID, NULL);
	renderer = gtk_cell_renderer_text_new ();
	gtk_tree_view_column_pack_start (column, renderer, FALSE);
	gtk_tree_view_column_set_attributes (column, renderer, "text",
					     COL_MESSAGE, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (priv->treeview), column);
	gtk_widget_set_size_request (priv->treeview, 500, 400);
	gtk_widget_show (priv->treeview);

	gtk_dialog_add_button (GTK_DIALOG(obj), GTK_STOCK_OK, GTK_RESPONSE_OK);
	gtk_dialog_set_response_sensitive (GTK_DIALOG(obj), GTK_RESPONSE_OK, FALSE);

	g_signal_connect (obj, "show",
			  G_CALLBACK (cxp_cmd_progress_dialog_on_show), NULL);
}

static void cxp_cmd_progress_dialog_finalize (GObject * object)
{
	CxpCmdProgressDialogPrivate *priv =
		CXP_CMD_PROGRESS_DIALOG_GET_PRIVATE (object);

	/* Free private members, etc. */

	G_OBJECT_CLASS (parent_class)->finalize (object);
}

static void cxp_cmd_progress_dialog_set_property (GObject * object,
						  guint property_id,
						  const GValue * value,
						  GParamSpec * pspec)
{
	CxpCmdProgressDialogPrivate *priv =
		CXP_CMD_PROGRESS_DIALOG_GET_PRIVATE (object);

	switch (property_id)
	{
	case PROPERTY_COMMAND:
		g_free (priv->command);
		priv->command = g_value_dup_string (value);
		break;
	default:
		/* We don't have any other property... */
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void cxp_cmd_progress_dialog_get_property (GObject * object,
						  guint property_id,
						  GValue * value,
						  GParamSpec * pspec)
{
	CxpCmdProgressDialogPrivate *priv =
		CXP_CMD_PROGRESS_DIALOG_GET_PRIVATE (object);

	switch (property_id)
	{
	case PROPERTY_COMMAND:
		g_value_set_string (value, priv->command);
		break;
	default:
		/* We don't have any other property... */
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void cxp_cmd_progress_dialog_on_show (GtkWidget * widget,
					     gpointer user_data)
{
	CxpCmdProgressDialogPrivate *priv =
		CXP_CMD_PROGRESS_DIALOG_GET_PRIVATE (widget);
	GError *gerror = NULL;
	const gchar *encoding;
	gchar *command_utf8;
	gchar **argv;
	gint sout;
	gint serr;
	GtkTreeModel *model;
	GtkTreeIter iter;

	if (g_utf8_validate(priv->command, -1, NULL))
	{
		command_utf8 = g_strdup (priv->command);
	}
	else
	{
		command_utf8 = g_locale_to_utf8 (priv->command, -1, NULL, NULL, NULL);
	}
	gtk_label_set_text (GTK_LABEL (priv->label), command_utf8);
	g_free (command_utf8);

	if (g_shell_parse_argv(priv->command, NULL, &argv, &gerror))
	{
		if (g_spawn_async_with_pipes(NULL, argv, NULL, G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD, NULL, widget, &priv->pid, NULL, &sout, &serr, &gerror))
		{
			g_child_watch_add (priv->pid, cxp_cmd_progress_dialog_child_watch, widget);
			priv->ochannel = g_io_channel_unix_new (sout);
			priv->echannel = g_io_channel_unix_new (serr);
			if (g_get_charset (&encoding) == FALSE)
			{
				g_io_channel_set_encoding (priv->ochannel, encoding, NULL);
				g_io_channel_set_encoding (priv->echannel, encoding, NULL);
			}
			g_io_add_watch (priv->ochannel, G_IO_IN, cxp_cmd_progress_dialog_can_read_sout, widget);
			g_io_add_watch (priv->echannel, G_IO_IN, cxp_cmd_progress_dialog_can_read_serr, widget);
		}
		else
		{
			model = gtk_tree_view_get_model (GTK_TREE_VIEW (priv->treeview));
			gtk_list_store_append (GTK_LIST_STORE (model), &iter);
			gtk_list_store_set (GTK_LIST_STORE (model), &iter, COL_STOCK_ID,
					GTK_STOCK_CANCEL, COL_MESSAGE, gerror->message, -1);
		}
	}
	else
	{
		model = gtk_tree_view_get_model (GTK_TREE_VIEW (priv->treeview));
		gtk_list_store_append (GTK_LIST_STORE (model), &iter);
		gtk_list_store_set (GTK_LIST_STORE (model), &iter, COL_STOCK_ID,
				GTK_STOCK_CANCEL, COL_MESSAGE, gerror->message, -1);
	}

}

static gboolean cxp_cmd_progress_dialog_can_read_sout (GIOChannel *source, GIOCondition condition, gpointer data)
{
	CxpCmdProgressDialogPrivate *priv =
		CXP_CMD_PROGRESS_DIALOG_GET_PRIVATE (data);
	GtkAdjustment* vadj;
	GtkTreeModel *model;
	GtkTreeIter iter;
	gchar *str;

	g_io_channel_read_line (source, &str, NULL, NULL, NULL);
	g_strchomp (str);
	model = gtk_tree_view_get_model (GTK_TREE_VIEW (priv->treeview));
	gtk_list_store_append (GTK_LIST_STORE (model), &iter);
	gtk_list_store_set (GTK_LIST_STORE (model), &iter, COL_STOCK_ID,
			GTK_STOCK_APPLY, COL_MESSAGE, str, -1);
	vadj = gtk_scrolled_window_get_vadjustment (GTK_SCROLLED_WINDOW(priv->scrwin));
	gtk_adjustment_set_value (vadj, vadj->upper);
	while (gtk_events_pending())
		gtk_main_iteration();

	g_free (str);

	return	TRUE;
}

static gboolean cxp_cmd_progress_dialog_can_read_serr (GIOChannel *source, GIOCondition condition, gpointer data)
{
	CxpCmdProgressDialogPrivate *priv =
		CXP_CMD_PROGRESS_DIALOG_GET_PRIVATE (data);
	GtkAdjustment* vadj;
	GtkTreeModel *model;
	GtkTreeIter iter;
	gchar *str;

	g_io_channel_read_line (source, &str, NULL, NULL, NULL);
	g_strchomp (str);
	model = gtk_tree_view_get_model (GTK_TREE_VIEW (priv->treeview));
	gtk_list_store_append (GTK_LIST_STORE (model), &iter);
	gtk_list_store_set (GTK_LIST_STORE (model), &iter, COL_STOCK_ID,
			GTK_STOCK_CANCEL, COL_MESSAGE, str, -1);
	vadj = gtk_scrolled_window_get_vadjustment (GTK_SCROLLED_WINDOW(priv->scrwin));
	gtk_adjustment_set_value (vadj, vadj->upper);
	while (gtk_events_pending())
		gtk_main_iteration();

	g_free (str);

	return	TRUE;
}

static void cxp_cmd_progress_dialog_child_watch (GPid pid, gint status, gpointer data)
{
	CxpCmdProgressDialogPrivate *priv =
		CXP_CMD_PROGRESS_DIALOG_GET_PRIVATE (data);

	g_spawn_close_pid(pid);

	gtk_dialog_set_response_sensitive (GTK_DIALOG(data), GTK_RESPONSE_OK, TRUE);
}

GtkWidget *cxp_cmd_progress_dialog_new (const gchar * command)
{
	GtkWidget *obj;

	obj = GTK_WIDGET (g_object_new
			  (CXP_TYPE_CMD_PROGRESS_DIALOG, "command", command,
			   NULL));

	return obj;
}
