    /***************************************************************************
                         undodialog.cpp  -  description
                             -------------------
    begin                : Mon Mai 27 20:08:19 CEST 2002
    copyright            : (C) 2001 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "undodialog.h"

// Qt includes
#include <qlabel.h>
#include <qlayout.h>

// KDE includes
#include <kfiledialog.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kprocess.h>
#include <ktextbrowser.h>
#include <kurlrequester.h>

UndoDialog::UndoDialog( QWidget* parent )
    : KDialogBase( KDialogBase::Plain, i18n("Undo Renaming"),
      KDialogBase::User1 | KDialogBase::Close, KDialogBase::User1, parent, 0, false, true )
{
    UndoDialogLayout = new QVBoxLayout( plainPage(), 11, 6, "UndoDialogLayout");

    TextLabel1 = new QLabel( plainPage(), "TextLabel1" );
    TextLabel1->setText( i18n( "Undo script:" ) );
    UndoDialogLayout->addWidget( TextLabel1 );

    scriptname = new KURLRequester( plainPage(), "KURLRequester1" );
    scriptname->setMode( KFile::File | KFile::LocalOnly  );
    scriptname->fileDialog()->setOperationMode( KFileDialog::Opening );

    scriptname->setFilter( i18n("*.krename|KRename undo scripts (*.krename)\n"
                                   "*|All Files (*)") );
    UndoDialogLayout->addWidget( scriptname );

    TextLabel2 = new QLabel( plainPage(), "TextLabel2" );
    TextLabel2->setText( i18n( "<qt>Undo Scripts are normal shell scripts which can also be executed manually from the command line.</qt>" ) );
    UndoDialogLayout->addWidget( TextLabel2 );

    browser = new KTextBrowser( plainPage());
    browser->setWordWrap( QTextEdit::NoWrap );
    browser->setTextFormat( Qt::RichText );

    UndoDialogLayout->addWidget( browser );

    setButtonText( KDialogBase::User1, i18n( "&Start" ) );

    connect( this, SIGNAL( user1Clicked() ), this, SLOT( start() ) );
    connect( scriptname, SIGNAL( textChanged( const QString & ) ), this, SLOT( enableControls() ) );

    enableControls();
}

UndoDialog::~UndoDialog()
{ }

void UndoDialog::start()
{
    if( scriptname->url().right( 8 ) != ".krename" ) // EXTENSION
        if( KMessageBox::warningContinueCancel( this, i18n("This script does not seem "
                                        "to be a Krename undo script. Execution of this "
                                        "script can be dangerous. Continue ?") )
            == KMessageBox::Cancel )
            return;

    KProcess *proc = new KProcess;
    *proc << scriptname->url() << "--krename";

    enableButton( KDialogBase::User1, false );

    if( !proc->start( KProcess::NotifyOnExit, KProcess::AllOutput ) ) {
        KMessageBox::sorry( this, i18n("Unable to start the given undo script!") );
        enableButton( KDialogBase::User1, true );
        delete proc;
        return;
    }
    proc->resume();
    connect( proc, SIGNAL( receivedStdout( KProcess*, char*, int) ), this, SLOT( receive( KProcess*, char*, int ) ) );
    connect( proc, SIGNAL( receivedStderr( KProcess*, char*, int) ), this, SLOT( receiveErr( KProcess*, char*, int ) ) );
    connect( proc, SIGNAL( processExited( KProcess* ) ), this, SLOT( finished( KProcess* ) ) );
}

void UndoDialog::receive( KProcess*, char* buffer, int len )
{
    QString text;
    for( int i = 0; i < len; i++ )
        text.append( buffer[i] );

    browser->setText( browser->text() + text + "<br>");
}

void UndoDialog::receiveErr( KProcess*, char* buffer, int len )
{
    QString text = "<b>";
    for( int i = 0; i < len; i++ )
        text.append( buffer[i] );

    browser->setText( browser->text() + text + "</b><br>");
}

void UndoDialog::finished( KProcess* p )
{
    delete p;
    KMessageBox::information( this, i18n("Finished successfully") );
    enableControls();
}

void UndoDialog::enableControls()
{
    QFileInfo fi( scriptname->url() );
    bool b = !scriptname->url().isEmpty() && fi.exists() && fi.isExecutable();
    enableButton( KDialogBase::User1, b );
}

void UndoDialog::setUndoScript( const QString & filename )
{
    scriptname->setURL( filename );
}
    



