/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KKDDATABASE_H_
#define _KKDDATABASE_H_

#include "kkdtextbase.h"

namespace KKDesigner
{
	/**
	 * @author SUZUKI Tasuku
	 */
	class KKDDataBase : public KKDTextBase
	{
		Q_OBJECT
		Q_PROPERTY( DataType dataType READ dataType WRITE setDataType )
		Q_ENUMS( DataType )
	public:
		enum DataType
		{
			Receiver,
			Sender,
		};
		
		KKDDataBase( const QPoint& l
				   , const QSize& s
				   , const QFont& f
				   , const QColor& c
				   , Orientation o
				   , DataType t
				   , QObject* parent = 0
				   );
		KKDDataBase( QDomElement e, QObject* parent = 0 );
		KKDDataBase( const KKDDataBase* item, QObject* parent = 0 );
		~KKDDataBase();

		QDomElement toElement( QDomDocument& doc, const QString& t = QString::null );
		
		//BEGIN Properties
		DataType dataType() const { return m_type; }
		//END   Properties

	public slots:
		//BEGIN Properties
		void setDataType( DataType t );
		//END   Properties

	signals:
		//BEGIN Properties
		void dataTypeChanged();
		//END   Properties

	private:
		//BEGIN Properties
		DataType m_type;
		//END   Properties
	};
}

#endif /* _KKDDATABASE_H_ */
