/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkawidget.h"

#include "kkatreeview.h"
#include "kkalistview.h"
#include "kkadetailview.h"
#include "kkagroup.h"
#include "kkaperson.h"
#include "kkacontactxml.h"
#include "kkakabc.h"

#include "../kkdesigner/kkddoc.h"
#include "../kkdesigner/kkdview.h"

#include <qhbox.h>

#include <klistview.h>
#include <kurl.h>
#include <kdebug.h>
#include <kaction.h>
#include <kconfig.h>
#include <klocale.h>
#include <kapplication.h>
#include <kfiledialog.h>
#include <kmessagebox.h>
#include <kiconloader.h>

using namespace KKAddressBook;

KKAWidget::KKAWidget( KCommandHistory* cmdHistory, QWidget* parent, const char* name )
	: KKWidgetBase( cmdHistory, parent, name )
{
	m_data = NULL;
	m_sender = NULL;
	
	m_doc = NULL;
	m_tvwGroup = new KKATreeView( this );
	m_spl = new QSplitter( Qt::Vertical, this );
	m_lvwPerson = new KKAListView( m_spl );
	m_hbox = new QSplitter( m_spl );
	m_dvwPerson = new KKADetailView( true, m_hbox );
	m_preview = NULL;
	
	if( m_tvwGroup->currentItem() )
	{
		m_lvwPerson->groupChanged( m_tvwGroup->currentItem() );
	}
	if( m_lvwPerson->currentItem() )
	{
		m_dvwPerson->setData( m_lvwPerson->currentItem() );
		setContactData( m_lvwPerson->currentItem() );
	}
	connect( m_tvwGroup, SIGNAL( currentChanged( QListViewItem* ) ), this, SLOT( groupChanged( QListViewItem* ) ) );
	groupChanged( m_tvwGroup->currentItem() );

	connect( m_dvwPerson, SIGNAL( nameChanged( const QString& ) ), m_lvwPerson, SLOT( setName( const QString& ) ) );
	
	KActionMenu* actm = new KActionMenu( i18n( "&Import" ), "fileimport", actionCollection(), "import" );
	KAction* act = new KAction( i18n( "&ContactXML..." ), "contactxml", KShortcut(), this, SLOT( importContactXML() ), actionCollection() );
	actm->insert( act );
	act = new KAction( i18n( "&KAddressBook" ), "kaddressbook", KShortcut(), this, SLOT( importKAddressBook() ), actionCollection() );
	actm->insert( act );

	new KToggleAction( i18n( "&Preview" ), "", KShortcut(), this, SLOT( togglePreview() ), actionCollection(), "address_preview" );
}

KKAWidget::~KKAWidget()
{
	m_lvwPerson->groupChanged( NULL );
}

void KKAWidget::readConfig( KConfig* conf )
{
	conf->setGroup("AddressBook");

	if( conf->hasKey( "HSplit" ) )
	{
		setSizes( conf->readIntListEntry( "HSplit" ) );
	}

	if( conf->readBoolEntry( "Preview" ) )
	{
		((KToggleAction*)action( "address_preview" ))->setChecked( true );
		togglePreview();
	}
	
	if( conf->hasKey( "VSplit" ) )
	{
		m_spl->setSizes( conf->readIntListEntry( "VSplit" ) );
	}
}

void KKAWidget::saveConfig( KConfig* conf )
{
	conf->setGroup("AddressBook");
	conf->writeEntry( "HSplit", sizes() );
	conf->writeEntry( "VSplit", m_spl->sizes() );
	conf->writeEntry( "Preview", ((KToggleAction*)action( "address_preview" ))->isChecked() );
}

bool KKAWidget::closable()
{
	return true;
}

void KKAWidget::tabChanged( bool enabled )
{
	QStringList actions;
	actions << "file_print"
			;

	for( QStringList::ConstIterator it = actions.begin(); it != actions.end(); ++it )
	{
		setActionEnabled( *it, enabled );
	}
}

void KKAWidget::groupChanged( QListViewItem* g )
{
	disconnect( m_lvwPerson, SIGNAL( currentChanged( QListViewItem* ) ), m_dvwPerson, SLOT( setData( QListViewItem* ) ) );
	disconnect( m_lvwPerson, SIGNAL( currentChanged( QListViewItem* ) ), this, SLOT( setContactData( QListViewItem* ) ) );
	m_lvwPerson->groupChanged( g );
	connect( m_lvwPerson, SIGNAL( currentChanged( QListViewItem* ) ), m_dvwPerson, SLOT( setData( QListViewItem* ) ) );
	connect( m_lvwPerson, SIGNAL( currentChanged( QListViewItem* ) ), this, SLOT( setContactData( QListViewItem* ) ) );
	if( m_lvwPerson->firstChild() )
	{
		m_lvwPerson->setSelected( m_lvwPerson->firstChild(), true );
	}
	m_dvwPerson->setData( m_lvwPerson->firstChild() );
	setContactData( m_lvwPerson->firstChild() );
}

void KKAWidget::setContactData( QListViewItem* d )
{
	if( m_preview )
	{
		m_preview->setContactData( d ? ((KKAPerson*)d)->data() : NULL );
	}
	m_data = d;
}

QPtrList<KKAContactData> KKAWidget::printData()
{
	KKAGroup* group = (KKAGroup*)m_tvwGroup->currentItem();
	if( group )
	{
		group->cache( m_lvwPerson );
	}
	return m_tvwGroup->printData();
}

void KKAWidget::importContactXML()
{
	KKAContactXML::doImport( m_tvwGroup );
}

void KKAWidget::exportContactXML()
{
	KKAContactXML::doExport( m_tvwGroup );
}

void KKAWidget::importKAddressBook()
{
	KKAKABC::doImport( m_tvwGroup );
}

void KKAWidget::exportKAddressBook()
{
	KKAKABC::doExport( m_tvwGroup );
}

void KKAWidget::togglePreview()
{
	if( ((KToggleAction*)action( "address_preview" ))->isChecked() )
	{
		if( !m_preview )
		{
			m_preview = new KKDesigner::KKDView( KKDesigner::KKDItemBase::AddressMode, m_doc, m_hbox );
			m_preview->documentChanged();
			setContactData( m_data );
			setSender( m_sender );
		}
		m_preview->show();
	}
	else
	{
		m_preview->hide();
	}
}

void KKAWidget::setSender( const KKAddressBook::KKAContactData* s )
{
	m_sender = s;
	if( m_preview ) m_preview->setSender( s );
}
