/***************************************************************************
*   Copyright (C) 2004 by  ͤ                                            *
*   tasuku@linux-life.net                                                 *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#include "word.h"
#include <kdebug.h>
#include <qregexp.h>
#include "cannadic.h"

Word::Word( QString str )
{
	QRegExp regexp( "^(.*)\t(.*)\t(.*)\t(.*)$", false, false );
	if( regexp.search( str ) == -1 ){
		kdError() << str << endl;
	}else{
		from = regexp.cap( 1 );
		to = regexp.cap( 2 );
		type = CannaDic::instance().code2type( regexp.cap( 3 ) );
		freq = regexp.cap( 4 ).toInt();
	}
}

QString Word::toString()
{
	return QString( "%1\t%2\t%3\t%4" ).arg( from ).arg( to ).arg( type.code ).arg( freq );
}

bool Word::operator==( Word word )
{
	return from == word.from
		&& to == word.to
		&& type == word.type
		&& freq == word.freq;
}

bool Word::operator<( Word word )
{
	if( from != word.from ){
		return from < word.from;
	}
	if( type != word.type ){
		return type < word.type;
	}
	if( to != word.to ){
		return to < word.to;
	}
	if( freq != word.freq ){
		return freq < word.freq;
	}
	return true;
}
