/***************************************************************************
*   Copyright (C) 2004 by  ͤ                                            *
*   tasuku@linux-life.net                                                 *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#include "pastecommand.h"
#include "cannadic.h"

#include <qapplication.h>
#include <qcursor.h>
#include <qregexp.h>

PasteCommand::PasteCommand( KListView* parent, QString str )
{
	m_parent = parent;
	QRegExp regexp( "^(.*)\t(.*)\t(.*)\t(.*)$", false, false );
	QStringList lines = QStringList::split( "\n", str );
	for( QStringList::iterator it = lines.begin(); it != lines.end(); ++it ){
		m_item.append( new WordItem( parent, Word( *it ) ) );
	}
	m_succeed = true;
}

bool PasteCommand::succeed()
{
	return m_succeed;
}

QString PasteCommand::name() const
{
	return i18n( "deleted %1 word(s)" ).arg( m_item.count() );
}

void PasteCommand::execute()
{
	QApplication::setOverrideCursor( QCursor(Qt::WaitCursor) );
	m_parent->clearSelection();
	for( WordItem* item = m_item.first(); item; item=m_item.next() ){
		m_parent->insertItem( item );
		m_parent->setSelected( item, true );
	}
	QApplication::restoreOverrideCursor();
}

void PasteCommand::unexecute()
{
	QApplication::setOverrideCursor( QCursor(Qt::WaitCursor) );
	m_parent->clearSelection();
	for( WordItem* item = m_item.first(); item; item=m_item.next() ){
		m_parent->takeItem( item );
	}
	m_parent->ensureItemVisible( m_item.at(m_item.count()-1) );
	QApplication::restoreOverrideCursor();
}
