/***************************************************************************
 *   Copyright (C) 2004 by  ͤ                                            *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef IMPORTMSIMECOMMAND_H
#define IMPORTMSIMECOMMAND_H

#include "worditem.h"

#include <kcommand.h>
#include <qstring.h>
#include <klocale.h>
#include <kdebug.h>
#include <qptrlist.h>
#include <klistview.h>

struct Trans{
	QString from;
	QString to;
};

static struct Trans trans_ime2canna[] = {
	{"Ը", "#W5"}
	,{"Ը", "#K5"}
	,{"Ը", "#G5"}
	,{"Ը", "#S5"}
	,{"Ը", "#T5"}
	,{"ʹԸ", "#N5"}
	,{"йԸ", "#B5"}
	,{"޹Ը", "#M5"}
	,{"Ը", "#R5"}
	,{"ư", "#KS"}
	,{"ƻ", "#KY"}
	,{"ư", "#T15"}
	,{"̾", "#T35"}
	,{"̾", "#JN"}
	,{"", "#JNS"}
	,{"̾", "#JNM"}
	,{"̾¾", "#CN"}
	,{"ͭ̾", "#KK"}
	,{"ư̾", "#T05"}
	,{"Ū̾", "#T35"}
	,{"ѷư̾", "#T00"}
	,{"", "#F04"}
	,{"ư", "#CJ"}
	,{"³", "#CJ"}
	,{"Ϣλ", "#RT"}
	,{"Ѷ", "#T35"}
	,{"¾Ω", "#KJ"}
	,{"Ƭ", "#PRE"}
	,{"", "#SUC"}
	,{"", "#JS"}
	,{"ʸ", "#KJ"}
};

class ImportMSIMECommand : public KCommand
{
public:
    ImportMSIMECommand( KListView* parent );

	void execute();
	void unexecute();
	QString name() const;
	bool succeed();
private:
	QString win2canna( QString from );
	QPtrList<WordItem> m_item;
	bool m_succeed;
	KListView* m_parent;
};

#endif //IMPORTMSIMECOMMAND_H
