/***************************************************************************
 *   Copyright (C) 2004 by  ͤ                                            *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "anthy.h"
#include "word.h"
#include "worditem.h"
#include "cannadic.h"

#include <dlfcn.h>
#include <stdio.h>
#include <stdlib.h>
#include <kdebug.h>
#include <qtextstream.h>
#include <qtextcodec.h>
#include <klocale.h>

#define BUFSIZE 1024

Anthy::Anthy( QString name )
	: Dictionary()
{
	char phon[100], desc[100], cclass_code[100];
	int ret = 0;

	m_dicname = name.local8Bit();

	m_libanthy = dlopen( "libanthydic.so.0", RTLD_GLOBAL |RTLD_NOW );

	AnthyFunc.util_init = (void (*)(void))dlsym( m_libanthy, "anthy_dic_util_init" );
	AnthyFunc.priv_dic_select_first_entry = (int (*)(void))dlsym( m_libanthy, "anthy_priv_dic_select_first_entry" );
	AnthyFunc.priv_dic_select_next_entry = (int (*)(void))dlsym( m_libanthy, "anthy_priv_dic_select_next_entry" );
	AnthyFunc.priv_dic_get_index = (char *(*)(char *, int))dlsym( m_libanthy, "anthy_priv_dic_get_index" );
	AnthyFunc.priv_dic_get_freq = (int (*)(void))dlsym( m_libanthy, "anthy_priv_dic_get_freq" );
	AnthyFunc.priv_dic_get_wtype = (char *(*)(char *, int))dlsym( m_libanthy, "anthy_priv_dic_get_wtype" );
	AnthyFunc.priv_dic_get_word = (char *(*)(char *, int))dlsym( m_libanthy, "anthy_priv_dic_get_word" );
	AnthyFunc.priv_dic_add_entry = (int (*)(const char *, const char *, const char *, int))dlsym( m_libanthy, "anthy_priv_dic_add_entry" );
	AnthyFunc.util_init();
	if(AnthyFunc.priv_dic_select_first_entry() == -1) {
		return;
	}
    while( !ret ) {
		if(AnthyFunc.priv_dic_get_index(phon, 100)
			&& AnthyFunc.priv_dic_get_wtype(cclass_code, 100)
			&& AnthyFunc.priv_dic_get_word(desc, 100)) {

			Word word;
			word.type = CannaDic::instance().code2type( cclass_code );
			word.from = QString::fromLocal8Bit( phon );
			word.to = QString::fromLocal8Bit( desc );
			word.freq = AnthyFunc.priv_dic_get_freq();
			push_back( word );
		}
		ret = AnthyFunc.priv_dic_select_next_entry();
    }
}


Anthy::~Anthy()
{
	if( m_libanthy != NULL ){
		dlclose( m_libanthy );
	}
}

bool Anthy::isAvailable()
{
	void *libanthy = dlopen( "libanthydic.so.0", RTLD_GLOBAL |RTLD_NOW );
	if( libanthy != NULL ){
		dlclose( libanthy );
		return true;
	}
	return false;
}

bool Anthy::expand( KListView* lvw )
{
	WordItem* word;
	m_count = size();
	m_counter = 0;
	m_progress = 0;
	for( iterator it = begin(); it != end(); ++it ){
		word = new WordItem( lvw, (*it) );
		lvw->insertItem( word );
		countup();
	}
	emit progress( 100 );
	return true;
}

void Anthy::countup()
{
	int percent = ++m_counter*100/m_count;
	if( percent > m_progress + 1 ){
		m_progress = percent;
		emit progress( percent );
	}
}

bool Anthy::save( KListView* lvw )
{
	QValueList<Word> view;
	QListViewItemIterator it( lvw );
	while( it.current() ){
		WordItem* word = (WordItem*)it.current();
		view.push_back( word->word() );
		++it;
	}
	qHeapSort( view );
	qHeapSort( *this );

	m_add.clear();
	m_del.clear();
	m_count = size() + view.size();
	m_counter = 0;
	m_progress = 0;
	iterator before, after;
	for( before = begin(), after = view.begin();
		before != end() && after != view.end();){
		if( *before == *after ){
			countup();
			++before;
			countup();
			++after;
			continue;
		}
		if( *before < *after ){
			delWord( *before );
			countup();
			++before;
		}else{
			addWord( *after );
			countup();
			++after;
		}
	}
	for(; before != end(); ++before ){
		delWord( *before );
		countup();
	}
	for(; after != view.end(); ++after ){
		addWord( *after );
		countup();
	}

	for( iterator it = m_del.begin(); it != m_del.end(); ++it )
	{
		remove( *it );
	}

	for( iterator it = m_add.begin(); it != m_add.end(); ++it )
	{
		push_back( *it );
	}
	return true;
}

bool Anthy::addWord( Word word )
{
	int ret;

	ret = AnthyFunc.priv_dic_add_entry( word.from.local8Bit(), word.to.local8Bit(), word.type.code.local8Bit(), word.freq );
//	if( !ret ){
//		kdDebug() << "addword error " << ret << '\t' << word.from << " > " << word.to << endl;
//		return false;
//	}

	m_add.push_back( word );
	return true;
}

bool Anthy::delWord( Word& word )
{
	int ret;
	ret = AnthyFunc.priv_dic_add_entry( word.from.local8Bit(), word.to.local8Bit(), word.type.code.local8Bit(), 0 );
	if( ret == 0 ){
		kdDebug() << "delword error " << ret << '\t' << word.toString() << endl;
		return false;
	}
	m_del.push_back( word );
	return true;
}
