/***************************************************************************
                           kaffeineapp.cpp
                             -------------------
    begin                : Die Mai 13 2003
    copyright            : (C) 2003-2005 by Jürgen Kofler
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kdebug.h>
#include <kurl.h>
#include <kwin.h>
#include <dcopref.h>
#include <kio/netaccess.h>

#include <qfile.h>
#include <qtimer.h>
#include <qdir.h>

#include "kaffeineapp.h"


KaffeineApp::KaffeineApp() : KUniqueApplication(), m_kaffeine(0)
{
}

KaffeineApp::~KaffeineApp()
{
	delete m_kaffeine;
}

int KaffeineApp::newInstance()
{
/*
* FIXME: session management make lot of troubles; because kaffeine starts more than one process?
* disabled for the moment...
*/

	if (isRestored()) {
		//RESTORE(Kaffeine);
		//return 0;
		exit(0);
	}

	/* parse command line options */
	KCmdLineArgs* args = KCmdLineArgs::parsedArgs();
	QStringList urls;QString url;
	QDir path;
	if (args->count())
	for (int i = 0; i < args->count(); i++ ) {
#if KDE_IS_VERSION(3,5,0)
		url = QFile::decodeName(args->arg(i));
		if ((url.left(1) != "/") && (!url.contains(":/")) && (url.lower() != "dvd") && (url.lower() != "vcd")
		&& (url.lower() != "audiocd") && (url.lower() != "cdda")) {
			KURL u = KIO::NetAccess::mostLocalURL(args->url(i), 0);
			if (u.isLocalFile())
				url = path.absFilePath(u.path());
			else
				url = u.url();
		}
#else
		url = QFile::decodeName(args->arg(i));
		// relative file names
		if ((url.left(1) != "/") && (!url.contains(":/")) && (url.lower() != "dvd") && (url.lower() != "vcd")
			&& (url.lower() != "audiocd") && (url.lower() != "cdda"))
			url = path.absFilePath(url);
#endif
		urls.append(url);
	}

	QString device = args->getOption("device");
	if (device == "default")
		device = QString::null;
	else if (device.startsWith("media:/") || device.startsWith("system:/media/")) {
		if (device.startsWith("system:/media/")) {
			device = device.mid(14);
			device = device.prepend("media:/");
		}
	}
	KURL devicePath(device);
	DCOPRef mediamanager("kded","mediamanager");
	DCOPReply reply = mediamanager.call("properties(QString)",devicePath.path(-1).mid(1));
	if (reply.isValid()) {
		QStringList properties = reply;
		device = properties[5];
		kdDebug() << "DEVICE : " << device << endl;
	}
	else
		device = QString::null;

	if (m_kaffeine) {  /* still running */
		kdDebug() << "KaffeineApp: Kaffeine is still running..." << endl;
		if (urls.count() > 0) { /* send urls to running instance */
			m_kaffeine->setDevice(device);
			m_kaffeine->loadTMP(urls);
			//QTimer::singleShot(300, m_kaffeine, SLOT(slotSwitchToPlayerWindow())); // delay for feeling only
		}
		m_kaffeine->show();
		KWin::activateWindow(m_kaffeine->winId());
		args->clear();
		return 0;
	}

	/* start kaffeine */
	QStringList engineParameters;
	if (args->getOption("audiodriver") != "default")
		engineParameters.append("audioDriver=\"" + args->getOption("audiodriver") + "\"");
	if (args->getOption("videodriver") != "default")
		engineParameters.append("videoDriver=\"" + args->getOption("videodriver") + "\"");
	if (args->isSet("verbose"))
		engineParameters.append("verbose=\"True\"");

	m_kaffeine = new Kaffeine(urls, engineParameters, device, args->isSet("play"), args->isSet("fullscreen"),
		args->isSet("wizard"), 0, "kaffeine_mainview");
	m_kaffeine->show();
	args->clear();
	return 0;
}
