/***************************************************************************
 *   Copyright (C) 2005-2006 by Christophe Thommeret <hftom@free.fr>
 *
****************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

#ifndef INPUTMANAGER_H
#define INPUTMANAGER_H

#include <qptrlist.h>
#include <qwidgetstack.h>
#include <qvbox.h>
#include <qstring.h>

class KaffeineInput;
class KMultiTabBar;
class Kaffeine;
class KKeyDialog;
class MRL;



class PlayerContainer : public QVBox
{
	Q_OBJECT

public:
	PlayerContainer(QWidget* parent = 0, const char* name = 0);
	virtual ~PlayerContainer()
	{}

signals:
	void signalURLDropEvent(const QStringList&);

protected:
	void dragEnterEvent (QDragEnterEvent*);
	void dropEvent(QDropEvent*);

};



class InputPlugin
{
public:
	InputPlugin( KaffeineInput *p, int ident, QString na );
	~InputPlugin();

	KaffeineInput *plug;
	int id;
	QString name;
};



class InputManager : public QObject
{
	Q_OBJECT
public:
	InputManager( Kaffeine *parent, QWidgetStack *ws, KMultiTabBar *mt );
	~InputManager();

	void add( KaffeineInput *p, const QPixmap &icon, const QString &name );
	void addPlayerWidget( QWidget *w, const QPixmap &icon, const QString &name );
	void addStartWindow( QWidget *w, const QPixmap &icon, const QString &name );
	void remove( KaffeineInput *p );
	void setPlayerContainer( PlayerContainer *pc );
	void fullscreen( bool b );
	QString activePlugin();
	void setActivePlugin( QString name );
	void addConfigKeys( KKeyDialog* kd );
	void toggleLayout( bool b );
	void showPlayer();
	void togglePlaylist();

	void playCurrentTrack();
	void playNextTrack();
	void playPreviousTrack();
	void playTrackNumber( int num );
	bool playbackFinished( MRL &mrl );
	void mergeMeta(const MRL&);
	bool close();
	QSize stackSize();
	QWidget* visibleWidget() const;

public slots:
	void execTarget( const QString& );

private slots:
	void show( int id );
	void play( const MRL&, KaffeineInput* );
	void statusBarMessage( const QString& );
	void setCurrentPlugin( KaffeineInput* );
	void stop();
	void pause();
	void showMe( KaffeineInput* );

private:
	void makeTargets( KaffeineInput*, bool );

	QWidgetStack *stack;
	KMultiTabBar *mtBar;
	QPtrList<InputPlugin> plugs;
	QWidget *playerWidget, *startWindow;
	QWidget *currentMainWidget;
	PlayerContainer *playerContainer;
	QWidget *oldMainWidget;
	KaffeineInput *currentPlugin;
	int nextId;
	Kaffeine *kaffeine;
};
#endif
