/***************************************************************************
                          kevents.h  -  description
                             -------------------
    begin                : Wed Jan 7 2004
    copyright            : (C) 2004-2005 by Christophe Thommeret
    email                : hftom@free.fr
    last modified        : $Date: 2005/07/31 19:04:48 $ by $Author: hftom $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KEVENTS_H
#define KEVENTS_H

#include <qtimer.h>
#include <qdialog.h>
#include <qdatetime.h>
#include <qtextbrowser.h>

#include <klistview.h>
#include <kpushbutton.h>

class EventDesc;
class DvbStream;
class DVBevents;
class ChannelDesc;



class EListViewItem : public KListViewItem
{

public:

	EListViewItem( QListView *parent, QString chanName, QString eBegin, QString eDuration, QString eTitle, EventDesc *desc );
	virtual int compare( QListViewItem *i, int col, bool ascending ) const;

	EventDesc *event;
};



class KEvents : public QDialog
{
	Q_OBJECT

public:

	KEvents( QPtrList<ChannelDesc> *chans, QPtrList<DvbStream> *d, QWidget *parent, QSize size );
	~KEvents();

private slots:

	void checkNewEvent();
	void mouseClickedSlot( int btn, QListViewItem *it, const QPoint &p, int c );
	void reset();
	void setMode( int m, QString name="" );
	void setCurrentNext();
	void zap( QListViewItem* it, const QPoint &p, int col );

private:

	QPtrList<DvbStream> *dvb;
	KListView *listView;
	KPushButton *resetBtn, *currentNextBtn;
	QPtrList<ChannelDesc> *channels;
	QTextBrowser *textBrow;
	int mode;
	ChannelDesc *chan;

signals:

	void addTimer( QString channel, QString name, QDateTime begin, QTime duration );
	void zapTo( const QString &channel );
};

#endif
