/***************************************************************************
                          dvbout.h  -  description
                             -------------------
    begin                : Sat Mar 6 2004
    copyright            : (C) 2004-2005 by Christophe Thommeret
    email                : hftom@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DVBOUT_H
#define DVBOUT_H

#include <qobject.h>
#include <qthread.h>
#include <qmutex.h>
#include <qstring.h>
#include <qfile.h>
#include <qtimer.h>
#include <qvaluelist.h>

#include "channeldesc.h"
#include "ts2pes.h"
#include "ts2rtp.h"
#include "gdvb.h"



class DVBout : public QObject, public QThread
{
	Q_OBJECT

public:

	DVBout( ChannelDesc chan, int anum, int tnum );
	~DVBout();
	void process( unsigned char *buf, int size );
	bool goLive( const QString &name, int napid );
	void preStopLive();
	void stopLive();
	bool goBroadcast( Ts2Rtp *r );
	void stopBroadcast();
	bool goRec( int type, const QString &name, RecTimer *t );
	bool hasRec() const;
	bool hasLive() const;
	bool hasBroadcast() const;
	bool hasInstantRec() const;
	bool timeShiftMode() const;
	bool doPause( const QString &name );
	int currentAudioPid() const;
	void changeTimer( int ms );

	ChannelDesc channel;
	QValueList<int> dmx;
	RecTimer *recTimer;

public slots:

	void stopRec();

private slots:

	void setPatPmt();

private:

	void writePmt();
	void writePat();
	void calculateCRC( unsigned char *p_begin, unsigned char *p_end );
	void renameFile( QString &name, const QString &ext );

	int pmtpid;
	int activeApid;
	bool patpmt, wpatpmt;
	int outType;
	bool timeShifting;
	QString pipeName;
	QFile outFile, liveFile;
	int fdPipe;
	Ts2Pes *tp, *tpShift;
	Ts2Rtp *rtp;
	unsigned char thBuf[188*100];
	unsigned char *wBuf;
	int wRead, wWrite, wDist;
	unsigned char tspat[188];
	unsigned char tspmt[188];
	unsigned int CRC32[256];
	int thWrite;
	bool beginLive;
	bool haveRec, haveLive, instantRec, haveBroadcast;
	QTimer stopRecTimer, timerPatPmt;
	QMutex mutex;

signals:

	void playDvb();
	void endRecord(DVBout*, RecTimer*, bool);
	void shifting(bool);

protected:

	virtual void run();

};

#endif
