/***************************************************************************
                           urllistview.h
                             -------------------
    begin                : Mon Apr 28 2003
    revision             : $Revision: 1.10 $
    last modified        : $Date: 2005/02/02 10:08:21 $ by $Author: juergenk $
    copyright            : (C) 2003-2005 by Jürgen Kofler
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef URLLISTVIEW_H
#define URLLISTVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <klistview.h>

class KPopupMenu;
class QWidget;
class QDragObject;
class PlaylistItem;
class MRL;

class UrlListView : public KListView
{
   Q_OBJECT
public:
 UrlListView(QWidget *parent=0, const char *name=0);
 ~UrlListView();

 void setCleared(bool);
 bool getCleared() const; /* was the playlist cleared or should we save it? */

public slots:
  virtual void clear();  /* reimplement slot */

signals:
  void signalPlayItem(QListViewItem* );  /* play selected in context menu */
  void signalCut();
  void signalCopy();
  void signalPaste();
  void signalSelectAll();
  void signalAddToQueue(MRL);
  void signalPlaylistFromSelected();

private slots:
  void slotShowContextMenu(QListViewItem*, const QPoint&, int);
  void slotCurrentChanged(QListViewItem *);
  void slotAddSubtitle();
  void slotShowInfo();
  void slotEditTitle();
  void slotPlayItem();
  void slotClicked(QListViewItem*, const QPoint&, int);
  void slotPlayNext();

protected:
  virtual bool acceptDrag(QDropEvent* event) const;
  virtual void resizeEvent(QResizeEvent*);
  virtual QDragObject* dragObject();

private:
  void enableSubEntry();
  void disableSubEntry();

private:
  bool m_listCleared;
  int m_column5Width;  /* width of the fifth column */
  int m_column4Track;  /* width of the fourth column */

  PlaylistItem* m_itemOfContextMenu;
  KPopupMenu* m_contextMenu;

};

#endif
