/*
 * LibSKK, a tiny Library to emulate SKK (Simple Kana Kanji Conversion)
 * 
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */

/* $Id: skkgadget.c,v 1.3 2002/04/11 02:19:04 famao Exp $ */

/* vi:set ts=4 sw=4: */


#include <time.h>
#include <errno.h>
#include <stdio.h>
#include "skkgadget.h"

gchar *
skk_gadget_get_jdate (void)
{
	time_t timeval;
	struct tm *ltime;
	gint n_year;
	gchar *s_year = NULL;
	gint i;
	gchar *day_tmp;
	gchar *ret = NULL;
	gchar *week_alist[] = {
		"","","","","","","",
	};
	SkkJDateNode jnode[] = {
		{ 1867, "" },
		{ 1911, "" },
		{ 1925, "" },
		{ 1988, "" },
		{    0, "ʿ" },
	};

	if ((time (&timeval) == (time_t)-1)) {
		fprintf (stderr, "iiimf-skk: skk_gadget_get_jdate (%s)",
				g_strerror (errno));
		return NULL;
	}
	ltime = localtime (&timeval);
	n_year = ltime->tm_year + 1900;

	for (i = 0; jnode[i].year != 0; i++) {
		if (n_year < jnode[i].year) {
			n_year -= (i > 0) ? jnode[i - 1].year : 0;
			s_year = jnode[i].y_name;
			break;
		}
	}
	if (!s_year) {
		s_year = jnode[i].y_name;
		n_year -= (i > 0) ? jnode[i - 1].year : 0;
	}
	day_tmp = g_strdup_printf ("%s%dǯ%d%d(%s)",
			s_year, n_year, ltime->tm_mon + 1, ltime->tm_mday, week_alist[ltime->tm_wday]);
#if 0
	ret = skkconv_get_jisx0208_latin_from_str (day_tmp, TRUE);
	g_free (day_tmp);
#else
	ret = day_tmp;
#endif
	return ret;
}

#ifdef SKKGADGET_DEBUG
int
main (void)
{
	g_message ("%s",skk_gadget_get_jdate ());
	return 0;
}
#endif
