/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: unixroot.h,v 1.2.4.1 2004/07/09 01:58:44 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _UNIXROOT_H
#define _UNIXROOT_H

#include "baseroot.h"
#include <X11/Xatom.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Intrinsic.h>
#include <X11/extensions/XShm.h>

class CUnixRootSurf : public CBaseRootSurface
{
public:
   CUnixRootSurf(IUnknown* pContext, CHXBaseSite* pSite );

   //Helpers....
   HX_RESULT Init();
   GC        GetGC();

   //public inherited stuff
   virtual HX_RESULT CreateScratchSurface(int nCompositionSurfaceCID, 
                                          HXxSize* pSize);
   virtual HX_RESULT ScratchLock(UCHAR** pBits, INT32* pPitch);
   virtual HX_RESULT ScratchUnlock(UCHAR* pBits);

   virtual HX_RESULT BeginOptimizedBlt(HXBitmapInfoHeader* pBitmapInfo);
   virtual HX_RESULT OptimizedBlt( UCHAR*   pImageBits,
                                   HXxRect& rDestRect,
                                   HXxRect& rSrcRect);
   virtual HX_RESULT EndOptimizedBlt(void);
   virtual HX_RESULT GetOptimizedFormat(HX_COMPRESSION_TYPE& ulType);
   virtual HX_RESULT GetPreferredFormat(HX_COMPRESSION_TYPE& ulType);

   XImage* _GetCompositionSurfaceDrawable();

   //Shared Memory helper func for the basesurf to use.
//     HX_RESULT _DetachSharedRegion();
//     HX_RESULT _CreateSharedRegion(INT32 nSize);
   
protected:

   //Smartly handle resizing of shm buffer.
   HX_RESULT _ResizeVideoBuffer(INT32 nSize);

   //Inherited from CBaseRootSurface....
   virtual void _BltFromScratchToComposition(HXxRect& rDestRect,
                                             HXxRect& rSrcRect);
   virtual HX_RESULT _DebugBlt( UCHAR*               pImageData,
                                HXBitmapInfoHeader* pBitmapInfo,
                                HXxRect&             rDestRect,
                                HXxRect&             rSrcRect);
   virtual void _GetYUVScratchWidthHeight(UINT32* pWidth, UINT32* pHeight);
   virtual void _CreateYUVScratchSurface(UINT32 width, UINT32 height);
   virtual void _GetYUVScratchSurfacePointer(UCHAR** pYUVBits, INT32* YUVPitch);
   virtual HX_RESULT _MinimalUnlock(HXxWindow* pWindow);
   virtual HX_RESULT _LockComposition(UCHAR** pBits, INT32* pPitch);
   virtual HX_RESULT _CreateCompositionSurface();
   virtual HX_RESULT _DestroyCompositionSurface();
   virtual void      _MinimalBlt(HXxRect& src, HXxRect& dest);

   
private:

   virtual ~CUnixRootSurf();
   PRIVATE_DESTRUCTORS_ARE_NOT_A_CRIME
   
   //Protect unintentional copy and default ctors.
   CUnixRootSurf();
   CUnixRootSurf( const CUnixRootSurf& );
   CUnixRootSurf& operator=( const CUnixRootSurf& it );

   //Shared memory members.
   BOOL            m_bUseShm;
   XShmSegmentInfo m_shmInfo;
   int             m_nShmId;

   //General display and GC stuff.
   Display*     m_pDisplay;
   GC           m_GC;
   int          m_nScreenNumber;
   XImage*      m_pXImage;
   Window       m_window;
   Visual*      m_pVisual;
   unsigned int m_unDepth;
   Screen*      m_pScreen;
   Colormap     m_colormap;
   int          m_nBitsPerPixel;

   //Bitmap stuff.
   UCHAR*         m_pYUVScratchBits;
   HXBitmapInfo  m_bmiYUVScratch;
   int            m_nYUVScratchPitch;
   UCHAR*         m_pScratchBits;
   HXBitmapInfo  m_bmiScratch;
   int            m_nScratchPitch;
   HXBitmapInfo  m_bmiSave;
   ULONG32        m_nCompositionSize;
};

#endif
