/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: group_info.cpp,v 1.3.4.1 2004/11/24 18:02:52 acolwell Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */
#include "group_info.h"
#include "codec_info.h"

COggGroupInfo::COggGroupInfo(ULONG32 ulStartPageOffset,
                             UINT32 uStartPageSize,
                             ULONG32 ulEndPageOffset,
                             const COggTimestamp& duration) :
    m_ulStartPageOffset(ulStartPageOffset),
    m_uStartPageSize(uStartPageSize),
    m_ulEndPageOffset(ulEndPageOffset),
    m_duration(duration),
    m_pSerialNums(NULL)
{}

COggGroupInfo::~COggGroupInfo()
{
    delete [] m_pSerialNums;
    m_pSerialNums = NULL;

    CHXMapLongToObj::Iterator itr = m_codecInfoMap.Begin();

    for (;itr != m_codecInfoMap.End(); ++itr)
    {
        COggCodecInfo* pInfo = (COggCodecInfo*)*itr;

        delete pInfo;
    }
    m_codecInfoMap.RemoveAll();
}

HX_RESULT 
COggGroupInfo::GetStartPageOffset(ULONG32& ulStartPageOffset) const
{
    ulStartPageOffset = m_ulStartPageOffset;

    return HXR_OK;
}

HX_RESULT 
COggGroupInfo::GetPageOffsetInfo(ULONG32& ulStartPageOffset, 
                                 UINT32& ulStartPageSize,
                                 ULONG32& ulEndPageOffset) const
{
    ulStartPageOffset = m_ulStartPageOffset;
    ulStartPageSize = m_uStartPageSize;
    ulEndPageOffset = m_ulEndPageOffset;

    return HXR_OK;
}

HX_RESULT 
COggGroupInfo::GetStartTime(COggTimestamp& startTime) const
{
    startTime = m_startTime;
    return HXR_OK;
}
    
HX_RESULT 
COggGroupInfo::GetDuration(COggTimestamp& duration) const
{
    duration = m_duration;
    return HXR_OK;
}

HX_RESULT 
COggGroupInfo::GetTimestamp(int serialNum, ogg_int64_t granulepos,
                            COggTimestamp& timestamp) const
{
    const COggCodecInfo* pCodecInfo = NULL;
    COggTimestamp startTime;

    HX_RESULT res = GetCodecInfo(serialNum, pCodecInfo);

    if (HXR_OK == res)
    {
        res = pCodecInfo->GetTimestamp(granulepos, timestamp);
    }

    return res;
}

UINT32 COggGroupInfo::StreamCount() const
{
    return (UINT32)m_codecInfoMap.GetCount();
}

HX_RESULT
COggGroupInfo::GetStreamSerialNum(UINT32 uStreamIndex, int& serialNum) const
{
    HX_RESULT res = HXR_INVALID_PARAMETER;

    if (uStreamIndex < StreamCount())
    {
        serialNum = m_pSerialNums[uStreamIndex];
        res = HXR_OK;
    }

    return res;
}

HX_RESULT 
COggGroupInfo::GetCodecInfo(int serialNum, 
                            const COggCodecInfo*& pCodecInfo) const
{
    HX_RESULT res = HXR_INVALID_PARAMETER;
    
    COggCodecInfo* pInfo = NULL;

    if (m_codecInfoMap.Lookup(serialNum, (void*&)pInfo) &&
        pInfo)
    {
        pCodecInfo = pInfo;
        res = HXR_OK;
    }

    return res;
}

void COggGroupInfo::SetStartTime(const COggTimestamp& startTime)
{
    m_startTime = startTime;

    CHXMapLongToObj::Iterator itr = m_codecInfoMap.Begin();

    for (;itr != m_codecInfoMap.End(); ++itr)
    {
        COggCodecInfo* pInfo = (COggCodecInfo*)*itr;

        if (pInfo)
        {
            pInfo->SetStartTimestamp(startTime);
        }
    }
}

HX_RESULT 
COggGroupInfo::AddCodecInfo(int serialNum, const COggCodecInfo* pCodecInfo)
{
    HX_RESULT res = HXR_INVALID_PARAMETER;
    const COggCodecInfo* pInfo = NULL;

    if (pCodecInfo && (HXR_OK != GetCodecInfo(serialNum, pInfo)))
    {
        int oldSize = StreamCount();
        int* pNewSerialNums = new int [oldSize + 1];

        pInfo = pCodecInfo->Clone();

        if (pInfo && pNewSerialNums && m_codecInfoMap.SetAt(serialNum, 
                                                            (void*)pInfo))
        {
            if (m_pSerialNums)
            {
                memcpy(pNewSerialNums, m_pSerialNums, sizeof(int) * oldSize);
                delete [] m_pSerialNums;
            }

            m_pSerialNums = pNewSerialNums;
            m_pSerialNums[oldSize] = serialNum;
            res = HXR_OK;
        }
        else
        {
            res = HXR_OUTOFMEMORY;

            delete pInfo;
            delete [] pNewSerialNums;
        }

    }

    return res;
}
