/***************************************************************************
 *   Copyright (C) 2005 by TAM(Teppei Tamra)                               *
 *   tam-t@par.odn.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "asciiplugin.h"

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif


#ifdef HAVE_GETTEXT
  #include <libintl.h>
  #define _(String) dgettext(GETTEXT_PACKAGE,String)
  #define N_(String) (String)
#else
  #define _(String) (String)
  #define N_(String) (String)
  #define bindtextdomain(Package,Directory)
  #define textdomain(domain)
  #define bind_textdomain_codeset(domain,codeset)
#endif

HonokaPluginRegister(AsciiPlugin);
HonokaPluginSetup(AsciiPlugin);

HonokaSetupCorePage *AsciiPlugin::setup()
{
    bindtextdomain (GETTEXT_PACKAGE, HONOKA_LOCALEDIR);
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
    HonokaSetupPage *p = new HonokaSetupPage(_("Ascii-plugin"),"","");
    HonokaSetup *s = new HonokaSetup("setup","","");
    HonokaSetupPage *page = new HonokaSetupPage(_("general setting"),"","");
    page->append(new HonokaSetupFileItem(
        _("Words _file: "),
        HONOKA_CONFIG_WORDSPREDICTION_FILE,
        _("input the path of Words file."),
        HONOKA_DEFAULT_WORDSPREDICTION_FILE
    ));
    page->append(new HonokaSetupBoolItem(
        _("_Add a space after word: "),
        String(HONOKA_CONFIG_WORDSPREDICTION_ADDSAW),
        _("At WordsPrediction, if you want to add a space after the committed word ,check it."),
        HONOKA_DEFAULT_WORDSPREDICTION_ADDSAW
    ));
    page->append(new HonokaSetupIntItem(
        _("_Limit of prediction results to display: "),
        String(HONOKA_CONFIG_WORDSPREDICTION_LIMIT),
        _("set the getting limit of prediction results. it doesn't display the results when the count of prediction results is more than this."),
        HONOKA_DEFAULT_WORDSPREDICTION_LIMIT,
        1,1000
    ));
    page->append(new HonokaSetupKeyItem(
        _("Low priority key: "),
        String(HONOKA_CONFIG_ASCIIINPUT_LOW_PRIORITY_KEY),
        _("set the key that lowers priority."),
        String(HONOKA_DEFAULT_ASCIIINPUT_LOW_PRIORITY_KEY)
    ));
    page->append(new HonokaSetupBoolItem(
        _("Use automatic committing: "),
        String(HONOKA_CONFIG_ASCIIINPUT_AUTO_COMMIT),
        _("if you want to commit the string when you press the specific key,check it."),
        HONOKA_DEFAULT_ASCIIINPUT_AUTO_COMMIT
    ));
    page->append(new HonokaSetupKeyItem(
        _("Automatic committing key: "),
        String(HONOKA_CONFIG_ASCIIINPUT_AUTO_COMMIT_KEY),
        _("set the key that commit the string automatic."),
        String(HONOKA_DEFAULT_ASCIIINPUT_AUTO_COMMIT_KEY)
    ));
    HonokaSetupPage *sc = new HonokaSetupPage(_("shortcut keys: "),"","");
    sc->append(new HonokaSetupKeyItem(
        _("Ascii Input: "),
        String(HONOKA_CONFIG_KEY_PREEDITOR_PREFIX) + String("/AsciiInput"),
        "",
        ""
    ));
    sc->append(new HonokaSetupKeyItem(
        _("Words Prediction: "),
        String(HONOKA_CONFIG_KEY_PREDICTOR_PREFIX) + String("/WordsPrediction"),
        "",
        ""
    ));
    page->append(sc);
    s->append(page);
    //p->append(s);
    
    //s = new HonokaSetup("setup","","");
    page = new HonokaSetupPage(_("key setting"),"","");
    page->append(new HonokaSetupKeyItem(
        _("Compose key: "),
        String(HONOKA_CONFIG_ASCIIINPUT_COMPOSE_KEY),
        _("set the Compose emulation key."),
        String(HONOKA_DEFAULT_ASCIIINPUT_COMPOSE_KEY)
    ));

    page->append(new HonokaSetupKeyItem(
        _("dead abovering key: "),
        String(HONOKA_CONFIG_ASCIIINPUT_ABOVERING_KEY),
        _("set the dead_abovering emulation key."),
        String(HONOKA_DEFAULT_ASCIIINPUT_ABOVERING_KEY)
    ));

    page->append(new HonokaSetupKeyItem(
        _("dead acute key: "),
        String(HONOKA_CONFIG_ASCIIINPUT_ACUTE_KEY),
        _("set the dead_acute emulation key."),
        String(HONOKA_DEFAULT_ASCIIINPUT_ACUTE_KEY)
    ));

    page->append(new HonokaSetupKeyItem(
        _("dead cedilla key: "),
        String(HONOKA_CONFIG_ASCIIINPUT_CEDILLA_KEY),
        _("set the dead_cedilla emulation key."),
        String(HONOKA_DEFAULT_ASCIIINPUT_CEDILLA_KEY)
    ));

    page->append(new HonokaSetupKeyItem(
        _("dead circumflex key: "),
        String(HONOKA_CONFIG_ASCIIINPUT_CIRCUMFLEX_KEY),
        _("set the dead_circumflex emulation key."),
        String(HONOKA_DEFAULT_ASCIIINPUT_CIRCUMFLEX_KEY)
    ));

    page->append(new HonokaSetupKeyItem(
        _("dead diaeresis key: "),
        String(HONOKA_CONFIG_ASCIIINPUT_DIAERESIS_KEY),
        _("set the dead_diaeresis emulation key."),
        String(HONOKA_DEFAULT_ASCIIINPUT_DIAERESIS_KEY)
    ));

    page->append(new HonokaSetupKeyItem(
        _("dead doubleacute key: "),
        String(HONOKA_CONFIG_ASCIIINPUT_DOUBLEACUTE_KEY),
        _("set the dead_doubleacute emulation key."),
        String(HONOKA_DEFAULT_ASCIIINPUT_DOUBLEACUTE_KEY)
    ));

    page->append(new HonokaSetupKeyItem(
        _("dead grave key: "),
        String(HONOKA_CONFIG_ASCIIINPUT_GRAVE_KEY),
        _("set the dead_grave emulation key."),
        String(HONOKA_DEFAULT_ASCIIINPUT_GRAVE_KEY)
    ));

    page->append(new HonokaSetupKeyItem(
        _("dead tilde key: "),
        String(HONOKA_CONFIG_ASCIIINPUT_TILDE_KEY),
        _("set the dead_tilde emulation key."),
        String(HONOKA_DEFAULT_ASCIIINPUT_TILDE_KEY)
    ));

    s->append(page);
    p->append(s);
    return p;
};

AsciiPlugin::AsciiPlugin(ConfigPointer cfg) : HonokaMultiplePluginBase(cfg)
{
    bindtextdomain (GETTEXT_PACKAGE, HONOKA_LOCALEDIR);
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
    predictor = new WordsPrediction(cfg);
    preeditor = new AsciiInput(cfg);
}


AsciiPlugin::~AsciiPlugin()
{
    delete predictor;
    delete preeditor;
}

/*!
    \fn AsciiPlugin::getPluginInstanceAt(int p)
 */
HonokaPluginBase * AsciiPlugin::getPluginInstanceAt(int p)
{
    switch(p) {
        case 0 : {
            return predictor;
            break;
        }
        case 1: {
            return preeditor;
            break;
        }
        default: {
            return 0;
        }
    }
    return 0;
}


/*!
    \fn AsciiPlugin::getPluginCount()
 */
int AsciiPlugin::getPluginCount()
{
    return 2;
}

/*!
    \fn AsciiPlugin::getName()
 */
String AsciiPlugin::getName()
{
    return String("AsciiPlugin");
}

