/*
 * Two-pane widget header
 *
 * This is one of components in twopane-view widget.
 * Show two files on two text widgets coloring the different portions.
 * Some interfaces such as show line numbers, are provided by basepane-widget.
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifndef __GDIFF_TWOPANE_H__
#define __GDIFF_TWOPANE_H__

#include "basepane-widget.h"
#include <gtk/gtktext.h>

#ifdef __cplusplus 
extern "C" {
#endif /* __cplusplus */

#define GDIFF_TYPE_TWOPANE				(gdiff_twopane_get_type())
#define GDIFF_TWOPANE(obj)				GTK_CHECK_CAST(obj, gdiff_twopane_get_type(), GdiffTwoPane)
#define GDIFF_TWOPANE_CLASS(klass)		GTK_CHECK_CLASS_CAST(klass, gdiff_twopane_get_type(), GdiffTwoPaneClass)
#define GDIFF_IS_TWOPANE(obj)			GTK_CHECK_TYPE(obj, gdiff_twopane_get_type())
#define GDIFF_IS_TWOPANE_CLASS(klass)	(GTK_CHECK_CLASS_TYPE((klass), GDIFF_TYPE_TWOPANE))

	
typedef struct _GdiffTwoPane       GdiffTwoPane;
typedef struct _GdiffTwoPaneClass  GdiffTwoPaneClass;

struct _GdiffTwoPane {
	GdiffBasePane basepane;

	GtkWidget *text[2];

	/* Two-pane specific internal data */
	/* DTextMap is internally related to GtkText widget */
	DTextMap *dtmap[2];
	
	/* Line number column */
	int n_col[2];	/* -1 implies that format hasn't been calculated */
	int ln_col_size[2];/* size including MARK */
	char format_common[32];					/* e.g. "%4d  " */
	char format_diff[2][32];/* e.g. "%4d< " and "%4d> " */

	/* These work as cache in a sense */
	/* Current line number for string search */
	int search_ln[2]; /* in buf */
	int search_tln[2];/* in text */
	/* Point in text widget */
	int search_tpoint[2];/* in text */
	/* Current index of the above line */
	int search_tindex[2];/* in text */
};

struct _GdiffTwoPaneClass {
	GdiffBasePaneClass parent_class;
};


GtkType gdiff_twopane_get_type(void);
GtkWidget* gdiff_twopane_new(DiffDir *diffdir, DiffFiles *dfiles);

#ifdef __cplusplus
} 
#endif /* __cplusplus */
 
#endif /* __GDIFF_TWOPANE_H__ */
