/*
 * Right-click menu for mergeview module
 *
 * Almost every callback function internally calls the related action routine
 * defined in actions.[ch].
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <gnome.h>
#include "diff.h"
#include "gui.h"
#include "actions.h"
#include "mergeview.h"


/* Private function declarations */
static void insert_remove_cb(GtkWidget *w, gpointer data);
static void merge_output_cb(GtkWidget *w, gpointer data);

/* for GnomeUIInfo merge_action_menu[] */
#include "merge-menu-d.h"

/**
 * merge_rmenu_create:
 * Create right-click menu for the file view, and return it.
 **/
GtkWidget*
merge_rmenu_create(GdiffMergeView *mergeview)
{
	GtkWidget *rmenu;

	rmenu = gnome_popup_menu_new(merge_action_menu);

	merge_menu_set_data();	/* Macro defined in merge-menu-d.h */

	if (GDIFF_MERGEVIEW_NUM_FILES(mergeview) == 2) {
		merge_menu_hide3();
	} else {
		merge_menu_show3();
	}
	return rmenu;
}


/* ---The followings are private functions--- */
static void
insert_remove_cb(GtkWidget *w, gpointer data)
{
	GdiffMergeView *mergeview = data;
	int index;
	WhichFile whichfile = 0;
	gboolean to_insert;
	gboolean to_all;

	index = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(w), MENUITEM_MERGE_KEY));
	if (index & MERGE_FIRST_FILE)
		whichfile = FIRST_FILE;
	else if (index & MERGE_SECOND_FILE)
		whichfile = SECOND_FILE;
	else if (index & MERGE_THIRD_FILE)
		whichfile = THIRD_FILE;
	
	to_insert = index & MERGE_INSERT_FILE ? TRUE : FALSE;
	to_all = index & MERGE_ALL_FILE ? TRUE : FALSE;

	if (to_all)
		act_merge_insert_remove_all(GTK_WIDGET(mergeview), whichfile, to_insert);
	else
		act_merge_insert_remove(GTK_WIDGET(mergeview), whichfile, to_insert);
}

static void
merge_output_cb(GtkWidget *w, gpointer data)
{
	GdiffMergeView *mergeview = data;

	act_merge_output_file(GTK_WIDGET(mergeview));
}
