/*
 * GUI front-end main header
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifndef __GDIFF_GUI_H__
#define __GDIFF_GUI_H__

#ifdef __cplusplus 
extern "C" {
#endif /* __cplusplus */

/*
 * Constant number
 */
#define APPNAME		"gtkdiff"

/* These values are written in ~/.gnome/gtkdiff file. */
typedef enum {
	NO_VIEW = (1 << 0),
	DIR_VIEW = (1 << 1),

	FILE_MASK_VIEW = (1 << 2),
	COMPARE2_MASK_VIEW = (1 << 3),
	COMPARE3_MASK_VIEW = (1 << 4),
	ONEPANE_MASK_VIEW = (1 << 5),
	MULTIPANE_MASK_VIEW = (1 << 6),
	MERGE_MASK_VIEW = (1 << 7),
	
	ONEPANE2_VIEW = (1 << 8) | FILE_MASK_VIEW | ONEPANE_MASK_VIEW | COMPARE2_MASK_VIEW,
	ONEPANE3_VIEW = (1 << 9) | FILE_MASK_VIEW | ONEPANE_MASK_VIEW | COMPARE3_MASK_VIEW,
	MULTIPANE2_VIEW = (1 << 10) |  FILE_MASK_VIEW | MULTIPANE_MASK_VIEW | COMPARE2_MASK_VIEW,
	MULTIPANE3_VIEW = (1 << 11) | FILE_MASK_VIEW | MULTIPANE_MASK_VIEW | COMPARE3_MASK_VIEW,
	MERGE2_VIEW = (1 << 12) | FILE_MASK_VIEW | MERGE_MASK_VIEW | COMPARE2_MASK_VIEW,
	MERGE3_VIEW = (1 << 13) | FILE_MASK_VIEW | MERGE_MASK_VIEW | COMPARE3_MASK_VIEW
} ViewType;

/* Move to a difference, such as next, previous, first or last. */	
typedef enum {
	MOVED_NEXT,
	MOVED_PREV,
	MOVED_FIRST,
	MOVED_LAST,
	MOVED_CURRENT,
	MOVED_CUR_NOSCROLL,	/* Same as MOVED_CURRENT but don't scroll */
	MOVED_REL_NEXT,
	MOVED_REL_PREV
} MoveDiff;

	
/* Row hide filter masks */
typedef enum {
	ROW_HIDE_EMACS = (1<<0),
	ROW_HIDE_OBJ = (1<<1)
} RowHideMask;


/* Forward declarations of types. */
typedef struct _GDiffWindow GDiffWindow;
typedef struct _Preference Preference;
typedef struct _WinPref WinPref;
typedef struct _DViewPref DViewPref;
typedef struct _FViewPref FViewPref;
typedef struct _DTextMap DTextMap;


/* Global function declarations */
/* filesel.c */ 
extern void filesel_open(GDiffWindow *gdwin);

/* statusbar.c */
extern void statusbar_create(GDiffWindow *gdwin);
extern void statusbar_update(GDiffWindow *gdwin, const char *msg);
extern char* sbar_create_msg(int num, const char **fnames, const int *begins, const int *ends);


#ifdef __cplusplus
} 
#endif /* __cplusplus */
 
#endif /* __GDIFF_GUI_H__ */
