/*
 * GUI window header
 *
 * Top level object that manages GUI views.
 * Currently, there are four kinds of view,
 * GdiffDirView, GdiffOnepView, GdiffTwopView, and GdiffMergeView.
 * From a GUI perspective, a view is a child widget of notebook widget,
 * but this is just a current implementation.
 * (hopefully, will be replaced with GNOME MDI)
 * This module provides various interfaces for managing views.
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifndef __GDIFF_GDWIN_H__
#define __GDIFF_GDWIN_H__

#ifdef __cplusplus 
extern "C" {
#endif /* __cplusplus */

	
#include "properties.h" /* for WinPref */
#include "searchbar.h"	/* for GdiffSearchBar */
	
/*
 * Data structure definitions
 */
/* Window(almost equivalent to GtkWindow) data
 * From an intuitive perspective, this is related to one toplevel window. */
struct _GDiffWindow {
	GnomeApp *app;
    GtkAccelGroup *accelg;
	GtkWidget *toolbar;
	GtkNotebook *notebook;
	GtkFileSelection *filesel;
	GdiffSearchBar *searchbar;
	
	GList *view_list;/* Doubly linked list of views */

	WinPref pref;/* Currently, it's always the same as g_pref's value. */
};


/* Global function declarations */
extern GDiffWindow* gdwin_new(const char *geometry_string);
extern void gdwin_delete(GDiffWindow *gdwin);

extern void gdwin_add_view(GDiffWindow *gdwin, GtkWidget *view);
extern void gdwin_remove_view(GDiffWindow *gdwin, GtkWidget *view);

extern GtkWidget* gdwin_current_view(const GDiffWindow *gdwin);
extern GtkWidget* gdwin_find_dirview_with_diffdir(const GDiffWindow *gdwin, const DiffDir *diffdir);
extern GtkWidget* gdwin_find_fview_with_diffdir(const GDiffWindow *gdwin, const DiffDir *diffdir);
extern GtkWidget* gdwin_find_fview_with_dfiles(const GDiffWindow *gdwin, const DiffFiles *dfiles, gboolean visible_only);
extern GtkWidget* gdwin_find_fview_with_vtype(const GDiffWindow *gdwin, const DiffFiles *dfiles, ViewType vtype);


#ifdef __cplusplus
} 
#endif /* __cplusplus */
 
#endif /* __GDIFF_GDWIN_H__ */
