
#==============================================================================#
# $Id: layer.rb,v 1.2 2004/01/16 14:37:33 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/layer.rb,v $
#==============================================================================#

require 'grb/image'

#==============================================================================#

module GRb

  class Layer < Image

    def initialize(target, opacity, bgcolor)
      @target  = target
      @opacity = opacity

      if (0..99) === @opacity
        if @target.truecolor?
          image = GD::Image.newTrueColor(@target.width, @target.height)
          cidx = image.colorAllocate(*bgcolor.rgb)
          image.filledRectangle(0, 0, @target.width - 1, @target.height - 1, cidx)
          image.transparent(cidx)
        else
          image = GD::Image.new(@target.width, @target.height)
          image.transparent(image.colorAllocate(*bgcolor.rgb))
        end
      else
        image = @target.image
      end

      super(image)
    end

    def merge
      if !self.image.equal?(@target.image) && @opacity > 0
        self.copy_merge(@target, 0, 0, 0, 0, self.width, self.height, @opacity)
      end
    end

  end # Layer

end # GRb

#==============================================================================#
#==============================================================================#
