
#==============================================================================#
# $Id: title.rb,v 1.2 2004/01/23 04:47:45 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/base/parts/title.rb,v $
#==============================================================================#

require 'grb/chart/base/utility/text'

#==============================================================================#

module GRb

  module Chart

    class Title

      def initialize(font, text)
        @text = Text.new(font, text, GRb::Font::ALIGN_FIT_LEFT, GRb::Font::VALIGN_FIT_TOP)
      end

      def draw(image, box)
        @text.draw(image, box)
      end

      def dx
        return @text.dx
      end

      def dy
        return @text.dy
      end

    end # Title

  end # Chart

end # GRb

#==============================================================================#

if $0 == __FILE__
end

#==============================================================================#
#==============================================================================#
