
#==============================================================================#
# $Id: picture.rb,v 1.2 2004/01/23 05:24:11 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/base/decorator/picture.rb,v $
#==============================================================================#

require 'grb/chart/base/decorator/singular_base'

#==============================================================================#

module GRb

  module Chart

    class PictureDecorator < SingularDecoratorBase

      def initialize(child = nil)
        super(child)

        @filepath = nil
        @opacity  = 100
      end

      attr_accessor :filepath, :opacity

      def draw_self(image, box)
        picture = GRb::Image.new_from_png_file(@filepath)

        x2 = [box.dx, picture.width].min
        y2 = [box.dy, picture.height].min

        if @opacity >= 100
          picture.copy(image, box.x, box.y, 0, 0, x2, y2)
        else
          picture.copy_merge(image, box.x, box.y, 0, 0, x2, y2, [[@opacity, 0].max, 100].min)
        end

        picture.destroy
      end

      def draw_child(image, box)
        @child.draw(image, box)
      end

    end # PictureDecorator

  end # Graph

end # GRb

#==============================================================================#
#==============================================================================#
