/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.26
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */


#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};
#endif

/***********************************************************************
 *
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 *
 ************************************************************************/

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
#  if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#    define SWIGTEMPLATEDISAMBIGUATOR template
#  else
#    define SWIGTEMPLATEDISAMBIGUATOR 
#  endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__) || defined(__ICC)
#   define SWIGUNUSED __attribute__ ((unused)) 
# else
#   define SWIGUNUSED 
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods for Windows DLLs */
#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   define SWIGEXPORT
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif 
#endif


/***********************************************************************
 * swigrun.swg
 *
 *     This file contains generic CAPI SWIG runtime support for pointer
 *     type checking.
 *
 ************************************************************************/

/* This should only be incremented when either the layout of swig_type_info changes,
   or for whatever reason, the runtime changes incompatibly */
#define SWIG_RUNTIME_VERSION "2"

/* define SWIG_TYPE_TABLE_NAME as "SWIG_TYPE_TABLE" */
#ifdef SWIG_TYPE_TABLE
# define SWIG_QUOTE_STRING(x) #x
# define SWIG_EXPAND_AND_QUOTE_STRING(x) SWIG_QUOTE_STRING(x)
# define SWIG_TYPE_TABLE_NAME SWIG_EXPAND_AND_QUOTE_STRING(SWIG_TYPE_TABLE)
#else
# define SWIG_TYPE_TABLE_NAME
#endif

/*
  You can use the SWIGRUNTIME and SWIGRUNTIMEINLINE macros for
  creating a static or dynamic library from the swig runtime code.
  In 99.9% of the cases, swig just needs to declare them as 'static'.
  
  But only do this if is strictly necessary, ie, if you have problems
  with your compiler or so.
*/

#ifndef SWIGRUNTIME
# define SWIGRUNTIME SWIGINTERN
#endif

#ifndef SWIGRUNTIMEINLINE
# define SWIGRUNTIMEINLINE SWIGRUNTIME SWIGINLINE
#endif

#include <string.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

/* Structure to store inforomation on one type */
typedef struct swig_type_info {
  const char             *name;			/* mangled name of this type */
  const char             *str;			/* human readable name of this type */
  swig_dycast_func        dcast;		/* dynamic cast function down a hierarchy */
  struct swig_cast_info  *cast;			/* linked list of types that can cast into this type */
  void                   *clientdata;		/* language specific type data */
} swig_type_info;

/* Structure to store a type and conversion function used for casting */
typedef struct swig_cast_info {
  swig_type_info         *type;			/* pointer to type that is equivalent to this type */
  swig_converter_func     converter;		/* function to cast the void pointers */
  struct swig_cast_info  *next;			/* pointer to next cast in linked list */
  struct swig_cast_info  *prev;			/* pointer to the previous cast */
} swig_cast_info;

/* Structure used to store module information
 * Each module generates one structure like this, and the runtime collects
 * all of these structures and stores them in a circularly linked list.*/
typedef struct swig_module_info {
  swig_type_info         **types;		/* Array of pointers to swig_type_info structures that are in this module */
  size_t                 size;		        /* Number of types in this module */
  struct swig_module_info *next;		/* Pointer to next element in circularly linked list */
  swig_type_info         **type_initial;	/* Array of initially generated type structures */
  swig_cast_info         **cast_initial;	/* Array of initially generated casting structures */
  void                    *clientdata;		/* Language specific module data */
} swig_module_info;


/* 
  Compare two type names skipping the space characters, therefore
  "char*" == "char *" and "Class<int>" == "Class<int >", etc.

  Return 0 when the two name types are equivalent, as in
  strncmp, but skipping ' '.
*/
SWIGRUNTIME int
SWIG_TypeNameComp(const char *f1, const char *l1,
		  const char *f2, const char *l2) {
  for (;(f1 != l1) && (f2 != l2); ++f1, ++f2) {
    while ((*f1 == ' ') && (f1 != l1)) ++f1;
    while ((*f2 == ' ') && (f2 != l2)) ++f2;
    if (*f1 != *f2) return (int)(*f1 - *f2);
  }
  return (l1 - f1) - (l2 - f2);
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
  Return 0 if not equal, 1 if equal
*/
SWIGRUNTIME int
SWIG_TypeEquiv(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = (SWIG_TypeNameComp(nb, ne, tb, te) == 0) ? 1 : 0;
    if (*ne) ++ne;
  }
  return equiv;
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
  Return 0 if equal, -1 if nb < tb, 1 if nb > tb
*/
SWIGRUNTIME int
SWIG_TypeCompare(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = (SWIG_TypeNameComp(nb, ne, tb, te) == 0) ? 1 : 0;
    if (*ne) ++ne;
  }
  return equiv;
}


/* think of this as a c++ template<> or a scheme macro */
#define SWIG_TypeCheck_Template(comparison, ty)         \
  if (ty) {                                             \
    swig_cast_info *iter = ty->cast;                    \
    while (iter) {                                      \
      if (comparison) {                                 \
        if (iter == ty->cast) return iter;              \
        /* Move iter to the top of the linked list */   \
        iter->prev->next = iter->next;                  \
        if (iter->next)                                 \
          iter->next->prev = iter->prev;                \
        iter->next = ty->cast;                          \
        iter->prev = 0;                                 \
        if (ty->cast) ty->cast->prev = iter;            \
        ty->cast = iter;                                \
        return iter;                                    \
      }                                                 \
      iter = iter->next;                                \
    }                                                   \
  }                                                     \
  return 0

/*
  Check the typename
*/
SWIGRUNTIME swig_cast_info *
SWIG_TypeCheck(const char *c, swig_type_info *ty) {
  SWIG_TypeCheck_Template(strcmp(iter->type->name, c) == 0, ty);
}

/* Same as previous function, except strcmp is replaced with a pointer comparison */
SWIGRUNTIME swig_cast_info *
SWIG_TypeCheckStruct(swig_type_info *from, swig_type_info *into) {
  SWIG_TypeCheck_Template(iter->type == from, into);
}

/*
  Cast a pointer up an inheritance hierarchy
*/
SWIGRUNTIMEINLINE void *
SWIG_TypeCast(swig_cast_info *ty, void *ptr) {
  return ((!ty) || (!ty->converter)) ? ptr : (*ty->converter)(ptr);
}

/* 
   Dynamic pointer casting. Down an inheritance hierarchy
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/*
  Return the name associated with this type
*/
SWIGRUNTIMEINLINE const char *
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/*
  Return the pretty name associated with this type,
  that is an unmangled type name in a form presentable to the user.
*/
SWIGRUNTIME const char *
SWIG_TypePrettyName(const swig_type_info *type) {
  /* The "str" field contains the equivalent pretty names of the
     type, separated by vertical-bar characters.  We choose
     to print the last name, as it is often (?) the most
     specific. */
  if (type->str != NULL) {
    const char *last_name = type->str;
    const char *s;
    for (s = type->str; *s; s++)
      if (*s == '|') last_name = s+1;
    return last_name;
  }
  else
    return type->name;
}

/* 
   Set the clientdata field for a type
*/
SWIGRUNTIME void
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_cast_info *cast = ti->cast;
  /* if (ti->clientdata == clientdata) return; */
  ti->clientdata = clientdata;
  
  while (cast) {
    if (!cast->converter) {
      swig_type_info *tc = cast->type;
      if (!tc->clientdata) {
	SWIG_TypeClientData(tc, clientdata);
      }
    }    
    cast = cast->next;
  }
}

/*
  Search for a swig_type_info structure only by mangled name
  Search is a O(log #types)
  
  We start searching at module start, and finish searching when start == end.  
  Note: if start == end at the beginning of the function, we go all the way around
  the circular list.
*/
SWIGRUNTIME swig_type_info *
SWIG_MangledTypeQueryModule(swig_module_info *start, 
                            swig_module_info *end, 
		            const char *name) {
  swig_module_info *iter = start;
  do {
    if (iter->size) {
      register size_t l = 0;
      register size_t r = iter->size - 1;
      do {
	/* since l+r >= 0, we can (>> 1) instead (/ 2) */
	register size_t i = (l + r) >> 1; 
	const char *iname = iter->types[i]->name;
	if (iname) {
	  register int compare = strcmp(name, iname);
	  if (compare == 0) {	    
	    return iter->types[i];
	  } else if (compare < 0) {
	    if (i) {
	      r = i - 1;
	    } else {
	      break;
	    }
	  } else if (compare > 0) {
	    l = i + 1;
	  }
	} else {
	  break; /* should never happen */
	}
      } while (l <= r);
    }
    iter = iter->next;
  } while (iter != end);
  return 0;
}

/*
  Search for a swig_type_info structure for either a mangled name or a human readable name.
  It first searches the mangled names of the types, which is a O(log #types)
  If a type is not found it then searches the human readable names, which is O(#types).
  
  We start searching at module start, and finish searching when start == end.  
  Note: if start == end at the beginning of the function, we go all the way around
  the circular list.
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeQueryModule(swig_module_info *start, 
                     swig_module_info *end, 
		     const char *name) {
  /* STEP 1: Search the name field using binary search */
  swig_type_info *ret = SWIG_MangledTypeQueryModule(start, end, name);
  if (ret) {
    return ret;
  } else {
    /* STEP 2: If the type hasn't been found, do a complete search
       of the str field (the human readable name) */
    swig_module_info *iter = start;
    do {
      register size_t i = 0;
      for (; i < iter->size; ++i) {
	if (iter->types[i]->str && (SWIG_TypeEquiv(iter->types[i]->str, name)))
	  return iter->types[i];
      }
      iter = iter->next;
    } while (iter != end);
  }
  
  /* neither found a match */
  return 0;
}


/* 
   Pack binary data into a string
*/
SWIGRUNTIME char *
SWIG_PackData(char *c, void *ptr, size_t sz) {
  static const char hex[17] = "0123456789abcdef";
  register const unsigned char *u = (unsigned char *) ptr;
  register const unsigned char *eu =  u + sz;
  for (; u != eu; ++u) {
    register unsigned char uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* 
   Unpack binary data from a string
*/
SWIGRUNTIME const char *
SWIG_UnpackData(const char *c, void *ptr, size_t sz) {
  register unsigned char *u = (unsigned char *) ptr;
  register const unsigned char *eu = u + sz;
  for (; u != eu; ++u) {
    register char d = *(c++);
    register unsigned char uu = 0;
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    else 
      return (char *) 0;
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    else 
      return (char *) 0;
    *u = uu;
  }
  return c;
}

/* 
   Pack 'void *' into a string buffer.
*/
SWIGRUNTIME char *
SWIG_PackVoidPtr(char *buff, void *ptr, const char *name, size_t bsz) {
  char *r = buff;
  if ((2*sizeof(void *) + 2) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,&ptr,sizeof(void *));
  if (strlen(name) + 1 > (bsz - (r - buff))) return 0;
  strcpy(r,name);
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackVoidPtr(const char *c, void **ptr, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      *ptr = (void *) 0;
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sizeof(void *));
}

SWIGRUNTIME char *
SWIG_PackDataName(char *buff, void *ptr, size_t sz, const char *name, size_t bsz) {
  char *r = buff;
  size_t lname = (name ? strlen(name) : 0);
  if ((2*sz + 2 + lname) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,ptr,sz);
  if (lname) {
    strncpy(r,name,lname+1);
  } else {
    *r = 0;
  }
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackDataName(const char *c, void *ptr, size_t sz, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      memset(ptr,0,sz);
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sz);
}

#ifdef __cplusplus
}
#endif

/*
 * $Header: /cvsroot/swig/SWIG/Lib/tcl/swigtcl8.swg,v 1.28 2005/06/17 23:15:51 marcelomatus Exp $
 * 
 * swigtcl8.swg
 */

#include <tcl.h>
#include <errno.h>
#include <stdlib.h>
#include <stdarg.h>
#include <ctype.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Constant table */

#define SWIG_TCL_INT     1
#define SWIG_TCL_FLOAT   2
#define SWIG_TCL_STRING  3
#define SWIG_TCL_POINTER 4
#define SWIG_TCL_BINARY  5

/* Flags for pointer conversion */
#define SWIG_POINTER_EXCEPTION     0x1
#define SWIG_POINTER_DISOWN        0x2

/* Swig fail macro */

#define SWIG_fail   goto fail

/* Constant information structure */
typedef struct swig_const_info {
    int type;
    char *name;
    long lvalue;
    double dvalue;
    void   *pvalue;
    swig_type_info **ptype;
} swig_const_info;

typedef int   (*swig_wrapper)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST []);
typedef int   (*swig_wrapper_func)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST []);
typedef char *(*swig_variable_func)(ClientData, Tcl_Interp *, char *, char *, int);
typedef void  (*swig_delete_func)(ClientData);

typedef struct swig_method {
  const char     *name;
  swig_wrapper   method;
} swig_method;

typedef struct swig_attribute {
  const char     *name;
  swig_wrapper   getmethod;
  swig_wrapper   setmethod;
} swig_attribute;

typedef struct swig_class {
  const char         *name;
  swig_type_info   **type;
  swig_wrapper       constructor;
  void              (*destructor)(void *);
  swig_method        *methods;
  swig_attribute     *attributes;
  struct swig_class **bases;
  char              **base_names;
  swig_module_info   *module;
} swig_class;

typedef struct swig_instance {
  Tcl_Obj       *thisptr;
  void          *thisvalue;
  swig_class   *classptr;
  int            destroy;
  Tcl_Command    cmdtok;
} swig_instance;

#define SWIG_NewPointerObj(ptr, type, flags) \
  SWIG_Tcl_NewPointerObj(ptr, type, flags)
#define SWIG_ConvertPtr(oc, ptr, ty, flags) \
  SWIG_Tcl_ConvertPtr(interp, oc, ptr, ty, flags)
#define SWIG_ConvertPtrFromString(c, ptr, ty, flags) \
  SWIG_Tcl_ConvertPtrFromString(interp, c, ptr, ty, flags)
#define SWIG_ConvertPacked(obj, ptr, sz, ty, flags) \
  SWIG_Tcl_ConvertPacked(interp, obj, ptr, sz, ty, flags)
#define SWIG_MakePtr(c, ptr, ty, flags) \
  SWIG_Tcl_MakePtr(c, ptr, ty, flags)
#define SWIG_NewPackedObj(ptr, sz, type, flags) \
  SWIG_Tcl_NewPackedObj(ptr, sz, type, flags)
#define SWIG_GetArgs SWIG_Tcl_GetArgs
#define SWIG_PointerTypeFromString(c) \
  SWIG_Tcl_PointerTypeFromString(c)
#define SWIG_Acquire(ptr) \
  SWIG_Tcl_Acquire(ptr)
#define SWIG_Disown(ptr) \
  SWIG_Tcl_Disown(ptr)
#define SWIG_Thisown(ptr) \
  SWIG_Tcl_Thisown(ptr)
#define SWIG_InstallConstants(interp, constants) \
  SWIG_Tcl_InstallConstants(interp, constants)
#define SWIG_GetConstant(key) \
  SWIG_Tcl_GetConstant(key)
#define SWIG_NewInstanceObj(thisvalue, type, flags) \
  SWIG_Tcl_NewInstanceObj(interp, thisvalue, type, flags)
#define SWIG_ObjectConstructor SWIG_Tcl_ObjectConstructor
#define SWIG_MethodCommand SWIG_Tcl_MethodCommand
#define SWIG_ObjectDelete SWIG_Tcl_ObjectDelete

/* Runtime API */
#define SWIG_GetModule(clientdata) SWIG_Tcl_GetModule((Tcl_Interp *) (clientdata))
#define SWIG_SetModule(clientdata, pointer) SWIG_Tcl_SetModule((Tcl_Interp *) (clientdata), pointer)
#define SWIG_MODULE_CLIENTDATA_TYPE Tcl_Interp *

/* Object support */
static Tcl_HashTable  swigobjectTable;
static int            swigobjectTableinit = 0;

/* Acquire ownership of a pointer */
static void
SWIG_Tcl_Acquire(void *ptr) {
  Tcl_HashEntry *entryPtr;
  int newobj;
  if (!swigobjectTableinit) {
    Tcl_InitHashTable(&swigobjectTable, TCL_ONE_WORD_KEYS);
    swigobjectTableinit = 1;
  }
  entryPtr = Tcl_CreateHashEntry(&swigobjectTable, (char *) ptr, &newobj);
}

/* Disown a pointer.  Returns 1 if we owned it to begin with */
static int
SWIG_Tcl_Disown(void *ptr) {
  Tcl_HashEntry *entryPtr;
  if (!swigobjectTableinit) return 0;
  entryPtr = Tcl_FindHashEntry(&swigobjectTable, (char *) ptr);
  if (entryPtr) {
    Tcl_DeleteHashEntry(entryPtr);
    return 1;
  }
  return 0;
}

static int
SWIG_Tcl_Thisown(void *ptr) {
  if (!swigobjectTableinit) return 0;
  if (Tcl_FindHashEntry(&swigobjectTable, (char *) ptr)) {
    return 1;
  }
  return 0;
}

/* Convert a pointer value */
static int
SWIG_Tcl_ConvertPtrFromString(Tcl_Interp *interp, const char *c, void **ptr, swig_type_info *ty, int flags) {
  swig_cast_info *tc;
  /* Pointer values must start with leading underscore */
  while (*c != '_') {
    *ptr = (void *) 0;
    if (strcmp(c,"NULL") == 0) return TCL_OK;
    /* Hmmm. It could be an object name. */
    if (Tcl_VarEval(interp,c," cget -this", (char *) NULL) == TCL_OK) {
      Tcl_Obj *result = Tcl_GetObjResult(interp);
      c = Tcl_GetStringFromObj(result, NULL);
      continue;
    }
    Tcl_ResetResult(interp);
    if (flags & SWIG_POINTER_EXCEPTION) 
      Tcl_SetResult(interp, (char *) "Type error. Expected a pointer", TCL_STATIC);
    return TCL_ERROR;
  }
  c++;
  c = SWIG_UnpackData(c,ptr,sizeof(void *));
  if (ty) {
    tc = SWIG_TypeCheck(c,ty);
    if ((!tc) && (flags & SWIG_POINTER_EXCEPTION)) {
      Tcl_SetResult(interp, (char *) "Type error. Expected ", TCL_STATIC);
      Tcl_AppendElement(interp, (char *) ty->name);
      return TCL_ERROR;
    } else if (!tc) {
      Tcl_ResetResult(interp);
      return TCL_ERROR;
    }
    if (flags & SWIG_POINTER_DISOWN) {
      SWIG_Disown((void *) *ptr);
    }
    *ptr = SWIG_TypeCast(tc,(void *) *ptr);
  }
  return TCL_OK;
}

/* Convert a pointer value */
static SWIGINLINE int
SWIG_Tcl_ConvertPtr(Tcl_Interp *interp, Tcl_Obj *oc, void **ptr, swig_type_info *ty, int flags) {
  return SWIG_Tcl_ConvertPtrFromString(interp, Tcl_GetStringFromObj(oc,NULL), ptr, ty, flags);
}

/* Convert a pointer value */
static char *
SWIG_Tcl_PointerTypeFromString(char *c) {
  char d;
  /* Pointer values must start with leading underscore. NULL has no type */
  if (*c != '_') {
    return 0;
  }
  c++;
  /* Extract hex value from pointer */
  while ((d = *c)) {
    if (!(((d >= '0') && (d <= '9')) || ((d >= 'a') && (d <= 'f')))) break;
    c++;
  }
  return c;
}

/* Convert a packed value value */
static int
SWIG_Tcl_ConvertPacked(Tcl_Interp *interp, Tcl_Obj *obj, void *ptr, int sz, swig_type_info *ty, int flags) {
  swig_cast_info *tc;
  const char  *c;

  if (!obj) goto type_error;
  c = Tcl_GetStringFromObj(obj,NULL);
  /* Pointer values must start with leading underscore */
  if (*c != '_') goto type_error;
  c++;
  c = SWIG_UnpackData(c,ptr,sz);
  if (ty) {
    tc = SWIG_TypeCheck(c,ty);
    if (!tc) goto type_error;
  }
  return TCL_OK;

type_error:

  if (flags) {
    if (ty) {
      Tcl_SetResult(interp, (char *) "Type error. Expected ", TCL_STATIC);
      Tcl_AppendElement(interp, (char *) ty->name);
      return TCL_ERROR;
    } else {
      Tcl_SetResult(interp, (char *) "Expected packed data.", TCL_STATIC);
      return TCL_ERROR;
    }
  }
  return TCL_ERROR;
}


/* Take a pointer and convert it to a string */
static void
SWIG_Tcl_MakePtr(char *c, void *ptr, swig_type_info *ty, int flags) {
  if (ptr) {
    *(c++) = '_';
    c = SWIG_PackData(c,&ptr,sizeof(void *));
    strcpy(c,ty->name);
  } else {
    strcpy(c,(char *)"NULL");
  }
  flags = 0;
}

/* Create a new pointer object */
static SWIGINLINE Tcl_Obj *
SWIG_Tcl_NewPointerObj(void *ptr, swig_type_info *type, int flags) {
  Tcl_Obj *robj;
  char result[512];
  SWIG_MakePtr(result,ptr,type,flags);
  robj = Tcl_NewStringObj(result,-1);
  return robj;
}

static Tcl_Obj *
SWIG_Tcl_NewPackedObj(void *ptr, int sz, swig_type_info *type, int flags) {
  char result[1024];
  char *r = result;
  if ((2*sz + 1 + strlen(type->name)) > 1000) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,ptr,sz);
  strcpy(r,type->name);
  flags = 0;
  return Tcl_NewStringObj(result,-1);
}

static Tcl_HashTable   swigconstTable;
static int             swigconstTableinit = 0;

/* Install Constants */
static void
SWIG_Tcl_InstallConstants(Tcl_Interp *interp, swig_const_info constants[]) {
  int i;
  Tcl_Obj *obj;
  Tcl_HashEntry *entryPtr;
  int            newobj;

  if (!swigconstTableinit) {
    Tcl_InitHashTable(&swigconstTable, TCL_STRING_KEYS);
    swigconstTableinit = 1;
  }
  for (i = 0; constants[i].type; i++) {
    switch(constants[i].type) {
    case SWIG_TCL_INT:
      obj = Tcl_NewIntObj(constants[i].lvalue);
      break;
    case SWIG_TCL_FLOAT:
      obj = Tcl_NewDoubleObj(constants[i].dvalue);
      break;
    case SWIG_TCL_STRING:
      obj = Tcl_NewStringObj((char *) constants[i].pvalue,-1);
      break;
    case SWIG_TCL_POINTER:
      obj = SWIG_NewPointerObj(constants[i].pvalue, *(constants[i]).ptype,0);
      break;
    case SWIG_TCL_BINARY:
      obj = SWIG_NewPackedObj(constants[i].pvalue, constants[i].lvalue, *(constants[i].ptype),0);
      break;
    default:
      obj = 0;
      break;
    }
    if (obj) {
      Tcl_ObjSetVar2(interp,Tcl_NewStringObj(constants[i].name,-1), NULL, obj, TCL_GLOBAL_ONLY);
      entryPtr = Tcl_CreateHashEntry(&swigconstTable, constants[i].name, &newobj);
      Tcl_SetHashValue(entryPtr, (ClientData) obj);
    }
  }
}

static Tcl_Obj *
SWIG_Tcl_GetConstant(const char *key) {
  Tcl_HashEntry *entryPtr;
  if (!swigconstTableinit) return 0;
  entryPtr = Tcl_FindHashEntry(&swigconstTable, key);
  if (entryPtr) {
    return (Tcl_Obj *) Tcl_GetHashValue(entryPtr);
  }
  return 0;
}

/* Get arguments */
static int
SWIG_Tcl_GetArgs(Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[], const char *fmt, ...) {
  int        argno = 0, opt = 0;
  long       tempi;
  double     tempd;
  const char *c;
  va_list    ap;
  void      *vptr;
  Tcl_Obj   *obj = 0;
  swig_type_info *ty;

  va_start(ap,fmt);
  for (c = fmt; (*c && (*c != ':') && (*c != ';')); c++,argno++) {
    if (*c == '|') {
      opt = 1;
      c++;
    }
    if (argno >= (objc-1)) {
      if (!opt) {
        Tcl_SetResult(interp, (char *) "Wrong # args. ", TCL_STATIC);
        goto argerror;
      } else {
        va_end(ap);
        return TCL_OK;
      }
    }

    vptr = va_arg(ap,void *);
    if (vptr) {
      if (isupper(*c)) {
        obj = SWIG_GetConstant(Tcl_GetStringFromObj(objv[argno+1],0));
        if (!obj) obj = objv[argno+1];
      } else {
        obj = objv[argno+1];
      }
      switch(*c) {
      case 'i': case 'I':
      case 'l': case 'L':
      case 'h': case 'H':
      case 'b': case 'B':
        if (Tcl_GetLongFromObj(interp,obj,&tempi) != TCL_OK) goto argerror;
        if ((*c == 'i') || (*c == 'I')) *((int *)vptr) = (int)tempi;
        else if ((*c == 'l') || (*c == 'L')) *((long *)vptr) = (long)tempi;
        else if ((*c == 'h') || (*c == 'H')) *((short*)vptr) = (short)tempi;
        else if ((*c == 'b') || (*c == 'B')) *((unsigned char *)vptr) = (unsigned char)tempi;
        break;
      case 'f': case 'F':
      case 'd': case 'D':
        if (Tcl_GetDoubleFromObj(interp,obj,&tempd) != TCL_OK) goto argerror;
        if ((*c == 'f') || (*c == 'F')) *((float *) vptr) = (float)tempd;
        else if ((*c == 'd') || (*c == 'D')) *((double*) vptr) = tempd;
        break;
      case 's': case 'S':
        if (*(c+1) == '#') {
          int *vlptr = (int *) va_arg(ap, void *);
          *((char **) vptr) = Tcl_GetStringFromObj(obj, vlptr);
          c++;
        } else {
          *((char **)vptr) = Tcl_GetStringFromObj(obj,NULL);
        }
        break;
      case 'c': case 'C':
        *((char *)vptr) = *(Tcl_GetStringFromObj(obj,NULL));
        break;
      case 'p': case 'P':
        ty = (swig_type_info *) va_arg(ap, void *);
        if (SWIG_Tcl_ConvertPtr(interp, obj, (void **) vptr, ty, SWIG_POINTER_EXCEPTION) == TCL_ERROR) goto argerror;
        break;
      case 'o': case 'O':
        *((Tcl_Obj **)vptr) = objv[argno+1];
        break;
      default:
        break;
      }
    }
  }

  if ((*c != ';') && ((objc-1) > argno)) {
    Tcl_SetResult(interp, (char *) "Wrong # args.", TCL_STATIC);
    goto argerror;
  }
  va_end(ap);
  return TCL_OK;

 argerror:
  {
    char temp[32];
    sprintf(temp,"%d", argno+1);
    c = strchr(fmt,':');
    if (!c) c = strchr(fmt,';');
    if (!c) c = (char *)"";
    Tcl_AppendResult(interp,c," argument ", temp, NULL);
    va_end(ap);
    return TCL_ERROR;
  }
}

static void
SWIG_Tcl_ObjectDelete(ClientData clientData) {
  swig_instance *si = (swig_instance *) clientData;
  if ((si) && (si->destroy) && (SWIG_Disown(si->thisvalue))) {
    if (si->classptr->destructor) {
      (si->classptr->destructor)(si->thisvalue);
    }
  }
  Tcl_DecrRefCount(si->thisptr);
  free(si);
}

/* Function to invoke object methods given an instance */
static int
SWIG_Tcl_MethodCommand(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  char *method,   *attrname;
  swig_instance   *inst = (swig_instance *) clientData;
  swig_method     *meth;
  swig_attribute  *attr;
  Tcl_Obj         *oldarg;
  Tcl_Obj         **objv;
  int              rcode;
  swig_class      *cls;
  swig_class      *cls_stack[64];
  int              cls_stack_bi[64];
  int              cls_stack_top = 0;
  int              numconf = 2;
  int              bi;

  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetResult(interp, (char *) "wrong # args.", TCL_STATIC);
    return TCL_ERROR;
  }
  method = Tcl_GetStringFromObj(objv[1],NULL);
  if (strcmp(method,"-acquire") == 0) {
    inst->destroy = 1;
    SWIG_Acquire(inst->thisvalue);
    return TCL_OK;
  }
  if (strcmp(method,"-disown") == 0) {
    if (inst->destroy) {
      SWIG_Disown(inst->thisvalue);
    }
    inst->destroy = 0;
    return TCL_OK;
  }
  if (strcmp(method,"-delete") == 0) {
    Tcl_DeleteCommandFromToken(interp,inst->cmdtok);
    return TCL_OK;
  }
  cls_stack[cls_stack_top] = inst->classptr;
  cls_stack_bi[cls_stack_top] = -1;
  cls = inst->classptr;
  while (1) {
    bi = cls_stack_bi[cls_stack_top];
    cls = cls_stack[cls_stack_top];
    if (bi != -1) {
      if (!cls->bases[bi] && cls->base_names[bi]) {
        /* lookup and cache the base class */
	swig_type_info *info = SWIG_TypeQueryModule(cls->module, cls->module, cls->base_names[bi]);
	if (info) cls->bases[bi] = (swig_class *) info->clientdata;
      }
      cls = cls->bases[bi];
      if (cls) {
        cls_stack_bi[cls_stack_top]++;
        cls_stack_top++;
        cls_stack[cls_stack_top] = cls;
        cls_stack_bi[cls_stack_top] = -1;
        continue;
      }
    }
    if (!cls) {
      cls_stack_top--;
      if (cls_stack_top < 0) break;
      else continue;
    }
    cls_stack_bi[cls_stack_top]++;

    meth = cls->methods;
    /* Check for methods */
    while (meth && meth->name) {
      if (strcmp(meth->name,method) == 0) {
        oldarg = objv[1];
        objv[1] = inst->thisptr;
        Tcl_IncrRefCount(inst->thisptr);
        rcode = (*meth->method)(clientData,interp,objc,objv);
        objv[1] = oldarg;
        Tcl_DecrRefCount(inst->thisptr);
        return rcode;
      }
      meth++;
    }
    /* Check class methods for a match */
    if (strcmp(method,"cget") == 0) {
      if (objc < 3) {
        Tcl_SetResult(interp, (char *) "wrong # args.", TCL_STATIC);
        return TCL_ERROR;
      }
      attrname = Tcl_GetStringFromObj(objv[2],NULL);
      attr = cls->attributes;
      while (attr && attr->name) {
        if ((strcmp(attr->name, attrname) == 0) && (attr->getmethod)) {
          oldarg = objv[1];
          objv[1] = inst->thisptr;
          Tcl_IncrRefCount(inst->thisptr);
          rcode = (*attr->getmethod)(clientData,interp,2, objv);
          objv[1] = oldarg;
          Tcl_DecrRefCount(inst->thisptr);
          return rcode;
        }
        attr++;
      }
      if (strcmp(attrname, "-this") == 0) {
        Tcl_SetObjResult(interp, Tcl_DuplicateObj(inst->thisptr));
        return TCL_OK;
      }
      if (strcmp(attrname, "-thisown") == 0) {
        if (SWIG_Thisown(inst->thisvalue)) {
          Tcl_SetResult(interp,(char*)"1",TCL_STATIC);
        } else {
          Tcl_SetResult(interp,(char*)"0",TCL_STATIC);
        }
        return TCL_OK;
      }
    } else if (strcmp(method, "configure") == 0) {
      int i;
      if (objc < 4) {
        Tcl_SetResult(interp, (char *) "wrong # args.", TCL_STATIC);
        return TCL_ERROR;
      }
      i = 2;
      while (i < objc) {
        attrname = Tcl_GetStringFromObj(objv[i],NULL);
        attr = cls->attributes;
        while (attr && attr->name) {
          if ((strcmp(attr->name, attrname) == 0) && (attr->setmethod)) {
            oldarg = objv[i];
            objv[i] = inst->thisptr;
            Tcl_IncrRefCount(inst->thisptr);
            rcode = (*attr->setmethod)(clientData,interp,3, &objv[i-1]);
            objv[i] = oldarg;
            Tcl_DecrRefCount(inst->thisptr);
            if (rcode != TCL_OK) return rcode;
            numconf += 2;
          }
          attr++;
        }
        i+=2;
      }
    }
  }
  if (strcmp(method,"configure") == 0) {
    if (numconf >= objc) {
      return TCL_OK;
    } else {
      Tcl_SetResult(interp,(char *) "Invalid attribute name.", TCL_STATIC);
      return TCL_ERROR;
    }
  }
  if (strcmp(method,"cget") == 0) {
      Tcl_SetResult(interp,(char *) "Invalid attribute name.", TCL_STATIC);
      return TCL_ERROR;
  }

  Tcl_SetResult(interp, (char *) "Invalid method. Must be one of: configure cget -acquire -disown -delete", TCL_STATIC);
  cls = inst->classptr;
  bi = 0;
  while (cls) {
    meth = cls->methods;
    while (meth && meth->name) {
      char *cr = (char *) Tcl_GetStringResult(interp);
      int meth_len = strlen(meth->name);
      char* where = strchr(cr,':');
      while(where) {
        where = strstr(where, meth->name);
        if(where) {
          if(where[-1] == ' ' && (where[meth_len] == ' ' || where[meth_len]==0)) {
            break;
          } else {
            where++;
          }
        }
      }

      if (!where)
        Tcl_AppendElement(interp, (char *) meth->name);
      meth++;
    }
    cls = inst->classptr->bases[bi++];
  }
  return TCL_ERROR;
}

/* Function to create objects */
static int
SWIG_Tcl_ObjectConstructor(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Tcl_Obj          *newObj = 0;
    void             *thisvalue = 0;
    swig_instance   *newinst = 0;
    swig_class      *classptr = (swig_class *) clientData;
    swig_wrapper     cons = 0;
    char             *name = 0;
    int               firstarg = 0;
    int               thisarg = 0;
    int               destroy = 1;

    if (!classptr) {
      Tcl_SetResult(interp, (char *) "swig: internal runtime error. No class object defined.", TCL_STATIC);
      return TCL_ERROR;
    }
    cons = classptr->constructor;
    if (objc > 1) {
      char *s = Tcl_GetStringFromObj(objv[1],NULL);
      if (strcmp(s,"-this") == 0) {
        thisarg = 2;
        cons = 0;
      } else if (strcmp(s,"-args") == 0) {
        firstarg = 1;
      } else if (objc == 2) {
        firstarg = 1;
        name = s;
      } else if (objc >= 3) {
        char *s1;
        name = s;
        s1 = Tcl_GetStringFromObj(objv[2],NULL);
        if (strcmp(s1,"-this") == 0) {
          thisarg = 3;
          cons = 0;
        } else {
          firstarg = 1;
        }
      }
    }
    if (cons) {
      int result;
      result = (*cons)(0, interp, objc-firstarg, &objv[firstarg]);
      if (result != TCL_OK) {
        return result;
      }
      newObj = Tcl_DuplicateObj(Tcl_GetObjResult(interp));
      if (!name) name = Tcl_GetStringFromObj(newObj,NULL);
    } else if (thisarg > 0) {
      if (thisarg < objc) {
        destroy = 0;
        newObj = Tcl_DuplicateObj(objv[thisarg]);
        if (!name) name = Tcl_GetStringFromObj(newObj,NULL);
      } else {
        Tcl_SetResult(interp, (char *) "wrong # args.", TCL_STATIC);
        return TCL_ERROR;
      }
    } else {
      Tcl_SetResult(interp, (char *) "No constructor available.", TCL_STATIC);
      return TCL_ERROR;
    }
    if (SWIG_Tcl_ConvertPtr(interp,newObj, (void **) &thisvalue, *(classptr->type), SWIG_POINTER_EXCEPTION) == TCL_ERROR) {
      Tcl_DecrRefCount(newObj);
      return TCL_ERROR;
    }
    newinst = (swig_instance *) malloc(sizeof(swig_instance));
    newinst->thisptr = newObj;
    Tcl_IncrRefCount(newObj);
    newinst->thisvalue = thisvalue;
    newinst->classptr = classptr;
    newinst->destroy = destroy;
    if (destroy) {
      SWIG_Acquire(thisvalue);
    }
    newinst->cmdtok = Tcl_CreateObjCommand(interp,name, (swig_wrapper) SWIG_MethodCommand, (ClientData) newinst, (swig_delete_func) SWIG_ObjectDelete);
    return TCL_OK;
}


/* This function takes the current result and turns it into an object command */
static Tcl_Obj *
SWIG_Tcl_NewInstanceObj(Tcl_Interp *interp, void *thisvalue, swig_type_info *type, int flags) {
  Tcl_Obj *robj = SWIG_NewPointerObj(thisvalue, type,0);
  /* Check to see if this pointer belongs to a class or not */
  if ((type->clientdata) && (interp)) {
    Tcl_CmdInfo    ci;
    char          *name;
    name = Tcl_GetStringFromObj(robj,NULL);
    if (!Tcl_GetCommandInfo(interp,name, &ci) || (flags)) {
      swig_instance *newinst = (swig_instance *) malloc(sizeof(swig_instance));
      newinst->thisptr = Tcl_DuplicateObj(robj);
      Tcl_IncrRefCount(newinst->thisptr);
      newinst->thisvalue = thisvalue;
      newinst->classptr = (swig_class *) type->clientdata;
      newinst->destroy = flags;
      newinst->cmdtok = Tcl_CreateObjCommand(interp, Tcl_GetStringFromObj(robj,NULL), (swig_wrapper_func) SWIG_MethodCommand, (ClientData) newinst, (swig_delete_func) SWIG_ObjectDelete);
      if (flags) {
        SWIG_Acquire(thisvalue);
      }
    }
  }
  return robj;
}

/* Structure for command table */
typedef struct {
  const char *name;
  int       (*wrapper)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST []);
  ClientData  clientdata;
} swig_command_info;

/* Structure for variable linking table */
typedef struct {
  const char *name;
  void *addr;
  char * (*get)(ClientData, Tcl_Interp *, char *, char *, int);
  char * (*set)(ClientData, Tcl_Interp *, char *, char *, int);
} swig_var_info;


/* Contract support */

#define SWIG_contract_assert(expr, msg)  if (!(expr)) { Tcl_SetResult(interp, (char *) msg, TCL_STATIC ); goto fail; } else

static swig_module_info * 
SWIG_Tcl_GetModule(Tcl_Interp *interp) {
  char *data;
  swig_module_info *ret = 0;
  
  /* first check if pointer already created */
  data = (char *) Tcl_GetVar(interp, "swig_runtime_data_type_pointer" SWIG_RUNTIME_VERSION SWIG_TYPE_TABLE_NAME, TCL_GLOBAL_ONLY);
  if (data) {
    SWIG_UnpackData(data, &ret, sizeof(swig_type_info **));
  }

  return ret;
}

static void
SWIG_Tcl_SetModule(Tcl_Interp *interp, swig_module_info *module) {
  char buf[512];
  char *data;

  /* create a new pointer */
  data = SWIG_PackData(buf, &module, sizeof(swig_type_info **));
  *data = 0;
  Tcl_SetVar(interp, "swig_runtime_data_type_pointer" SWIG_RUNTIME_VERSION SWIG_TYPE_TABLE_NAME, buf, 0);
}

#ifdef __cplusplus
}
#endif






/* -------- TYPES TABLE (BEGIN) -------- */

#define SWIGTYPE_p_Agedge_t swig_types[0]
#define SWIGTYPE_p_Agnode_t swig_types[1]
#define SWIGTYPE_p_Agraph_t swig_types[2]
#define SWIGTYPE_p_Agsym_t swig_types[3]
#define SWIGTYPE_p_FILE swig_types[4]
#define SWIGTYPE_p_p_void swig_types[5]
#define SWIGTYPE_ptrdiff_t swig_types[6]
#define SWIGTYPE_size_t swig_types[7]
static swig_type_info *swig_types[9];
static swig_module_info swig_module = {swig_types, 8, 0, 0, 0, 0};
#define SWIG_TypeQuery(name) SWIG_TypeQueryModule(&swig_module, &swig_module, name)
#define SWIG_MangledTypeQuery(name) SWIG_MangledTypeQueryModule(&swig_module, &swig_module, name)

/* -------- TYPES TABLE (END) -------- */

#define SWIG_init    Gv_Init
#define SWIG_name    "gv"
#define SWIG_prefix  "gv::"
#define SWIG_namespace "gv"

#define SWIG_version "0.0"


#ifdef __cplusplus
extern "C" {
#endif
#ifdef MAC_TCL
#pragma export on
#endif
SWIGEXPORT int SWIG_init(Tcl_Interp *);
#ifdef MAC_TCL
#pragma export off
#endif
#ifdef __cplusplus
}
#endif




/* some language headers (e.g. php.h, ruby.h) leave these defined */
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION
#undef PACKAGE_NAME

#include "gvc.h"


/** New graphs */
/*** New empty graph */
extern Agraph_t *graph(char *name);
extern Agraph_t *digraph(char *name);
extern Agraph_t *strictgraph(char *name);
extern Agraph_t *strictdigraph(char *name);
/*** New graph from a dot-syntax string or file */
extern Agraph_t *readstring(char *string);
extern Agraph_t *read(char *filename);
extern Agraph_t *read(FILE *f);	
/*** Add new subgraph to existing graph */
extern Agraph_t *graph(Agraph_t *g, char *name);

/** New nodes */
/*** Add new node to existing graph */
extern Agnode_t *node(Agraph_t *g, char *name);

/** New edges */
/*** Add new edge between existing nodes */
extern Agedge_t *edge(Agnode_t *t, Agnode_t *h);
/*** Add a new edge between an existing tail node, and a named head node which will be induced in the graph if it doesn't already exist */
extern Agedge_t *edge(Agnode_t *t, char *hname);
/*** Add a new edge between an existing head node, and a named tail node which will be induced in the graph if it doesn't already exist */
extern Agedge_t *edge(char *tname, Agnode_t *h);
/*** Add a new edge between named tail  and head nodes which will be induced in the graph if they don't already exist */
extern Agedge_t *edge(Agraph_t *g, char *tname, char *hname);

/** Setting attribute values */
/*** Set value of named attribute of graph/node/edge - creating attribute if necessary */
extern char *setv(Agraph_t *g, char *attr, char *val);
extern char *setv(Agnode_t *n, char *attr, char *val);
extern char *setv(Agedge_t *e, char *attr, char *val);

/*** Set value of existing attribute of graph/node/edge (using attribute handle) */
extern char *setv(Agraph_t *g, Agsym_t *a, char *val);
extern char *setv(Agnode_t *n, Agsym_t *a, char *val);
extern char *setv(Agedge_t *e, Agsym_t *a, char *val);

/** Getting attribute values */
/*** Get value of named attribute of graph/node/edge */
extern char *getv(Agraph_t *g, char *attr);
extern char *getv(Agnode_t *n, char *attr);
extern char *getv(Agedge_t *e, char *attr);

/*** Get value of attribute of graph/node/edge (using attribute handle) */
extern char *getv(Agraph_t *g, Agsym_t *a);
extern char *getv(Agnode_t *n, Agsym_t *a);
extern char *getv(Agedge_t *e, Agsym_t *a);

/** Obtain names from handles */
extern char *nameof(Agraph_t *g);
extern char *nameof(Agnode_t *n);
//extern char *nameof(Agedge_t *e);
extern char *nameof(Agsym_t *a);

/** Find handles from names */
extern Agraph_t *findsubg(Agraph_t *g, char *name);
extern Agnode_t *findnode(Agraph_t *g, char *name);
extern Agedge_t *findedge(Agnode_t *t, Agnode_t *h);

/** */
extern Agsym_t *findattr(Agraph_t *g, char *name);
extern Agsym_t *findattr(Agnode_t *n, char *name);
extern Agsym_t *findattr(Agedge_t *e, char *name);

/** Misc graph navigators returning handles */
extern Agnode_t *headof(Agedge_t *e);
extern Agnode_t *tailof(Agedge_t *e);
extern Agraph_t *graphof(Agraph_t *g);
extern Agraph_t *graphof(Agedge_t *e);
extern Agraph_t *graphof(Agnode_t *n);
extern Agraph_t *rootof(Agraph_t *g);

/** Obtain handles of proto node/edge for setting default attribute values */
extern Agnode_t *protonode(Agraph_t *g);
extern Agedge_t *protoedge(Agraph_t *g);

/** Iterators */
/*** Iteration termination tests */
extern bool ok(Agraph_t *g);
extern bool ok(Agnode_t *n);
extern bool ok(Agedge_t *e);
extern bool ok(Agsym_t *a);

/*** Iterate over subgraphs of a graph */
extern Agraph_t *firstsubg(Agraph_t *g);
extern Agraph_t *nextsubg(Agraph_t *g, Agraph_t *sg);

/*** Iterate over supergraphs of a graph (obscure and rarely useful) */
extern Agraph_t *firstsupg(Agraph_t *g);
extern Agraph_t *nextsupg(Agraph_t *g, Agraph_t *sg);

/*** Iterate over edges of a graph */
extern Agedge_t *firstedge(Agraph_t *g);
extern Agedge_t *nextedge(Agraph_t *g, Agedge_t *e);

/*** Iterate over outedges of a graph */
extern Agedge_t *firstout(Agraph_t *g);
extern Agedge_t *nextout(Agraph_t *g, Agedge_t *e);

/*** Iterate over edges of a node */
extern Agedge_t *firstedge(Agnode_t *n);
extern Agedge_t *nextedge(Agnode_t *n, Agedge_t *e);

/*** Iterate over out-edges of a node */
extern Agedge_t *firstout(Agnode_t *n);
extern Agedge_t *nextout(Agnode_t *n, Agedge_t *e);

/*** Iterate over head nodes reachable from out-edges of a node */
extern Agnode_t *firsthead(Agnode_t *n);
extern Agnode_t *nexthead(Agnode_t *n, Agnode_t *h);

/*** Iterate over in-edges of a graph */
extern Agedge_t *firstin(Agraph_t *g);
extern Agedge_t *nextin(Agnode_t *n, Agedge_t *e);

/*** Iterate over in-edges of a node */
extern Agedge_t *firstin(Agnode_t *n);
extern Agedge_t *nextin(Agraph_t *g, Agedge_t *e);

/*** Iterate over tail nodes reachable from in-edges of a node */
extern Agnode_t *firsttail(Agnode_t *n);
extern Agnode_t *nexttail(Agnode_t *n, Agnode_t *t);

/*** Iterate over nodes of a graph */
extern Agnode_t *firstnode(Agraph_t *g);
extern Agnode_t *nextnode(Agraph_t *g, Agnode_t *n);

/*** Iterate over nodes of an edge */
extern Agnode_t *firstnode(Agedge_t *e);
extern Agnode_t *nextnode(Agedge_t *e, Agnode_t *n);

/*** Iterate over attributes of a graph */
extern Agsym_t *firstattr(Agraph_t *g);
extern Agsym_t *nextattr(Agraph_t *g, Agsym_t *a);

/*** Iterate over attributes of an edge */
extern Agsym_t *firstattr(Agedge_t *e);
extern Agsym_t *nextattr(Agedge_t *e, Agsym_t *a);

/*** Iterate over attributes of a node */
extern Agsym_t *firstattr(Agnode_t *n);
extern Agsym_t *nextattr(Agnode_t *n, Agsym_t *a);

/** Remove graph objects */
extern void rm(Agraph_t *g);
extern void rm(Agnode_t *n);
extern void rm(Agedge_t *e);

/** Layout */
/*** Annotate a graph with layout attributes and values using a specific layout engine */
extern void layout(Agraph_t *g, char *engine);

/** Render */
/*** Render a layout into attributes of the graph */
extern void render(Agraph_t *g); 

/*** Render a layout in a specific format */
extern void render(Agraph_t *g, char *format);
extern void render(Agraph_t *g, char *format, char *filename);
extern void render(Agraph_t *g, char *format, FILE *f);
extern void render(Agraph_t *g, char *format, void **data);

#ifdef __cplusplus
extern "C" {
#endif
static int
_wrap_graph__SWIG_0(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    char *arg1 = (char *) 0 ;
    Agraph_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"s:gv::graphname ",&arg1) == TCL_ERROR) SWIG_fail;
    result = (Agraph_t *)graph(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agraph_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_digraph(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    char *arg1 = (char *) 0 ;
    Agraph_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"s:gv::digraphname ",&arg1) == TCL_ERROR) SWIG_fail;
    result = (Agraph_t *)digraph(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agraph_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_strictgraph(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    char *arg1 = (char *) 0 ;
    Agraph_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"s:gv::strictgraphname ",&arg1) == TCL_ERROR) SWIG_fail;
    result = (Agraph_t *)strictgraph(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agraph_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_strictdigraph(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    char *arg1 = (char *) 0 ;
    Agraph_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"s:gv::strictdigraphname ",&arg1) == TCL_ERROR) SWIG_fail;
    result = (Agraph_t *)strictdigraph(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agraph_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_readstring(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    char *arg1 = (char *) 0 ;
    Agraph_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"s:gv::readstringstring ",&arg1) == TCL_ERROR) SWIG_fail;
    result = (Agraph_t *)readstring(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agraph_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_read__SWIG_0(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    char *arg1 = (char *) 0 ;
    Agraph_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"s:gv::readfilename ",&arg1) == TCL_ERROR) SWIG_fail;
    result = (Agraph_t *)read(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agraph_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_read__SWIG_1(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    FILE *arg1 = (FILE *) 0 ;
    Agraph_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:gv::readf ",(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_FILE,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agraph_t *)read(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agraph_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_read(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Tcl_Obj *CONST *argv = objv+1;
    int argc = objc-1;
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_FILE, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_read__SWIG_1(clientData, interp, objc, objv);
        }
    }
    if (argc == 1) {
        int _v;
        {
            _v = 1;
        }
        if (_v) {
            return _wrap_read__SWIG_0(clientData, interp, objc, objv);
        }
    }
    
    Tcl_SetResult(interp,(char *) "No matching function for overloaded 'read'", TCL_STATIC);
    return TCL_ERROR;
}


static int
_wrap_graph__SWIG_1(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *arg2 = (char *) 0 ;
    Agraph_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"os:gv::graphg name ",(void *)0,&arg2) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agraph_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agraph_t *)graph(arg1,arg2);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agraph_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_graph(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Tcl_Obj *CONST *argv = objv+1;
    int argc = objc-1;
    if (argc == 1) {
        int _v;
        {
            _v = 1;
        }
        if (_v) {
            return _wrap_graph__SWIG_0(clientData, interp, objc, objv);
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = 1;
            }
            if (_v) {
                return _wrap_graph__SWIG_1(clientData, interp, objc, objv);
            }
        }
    }
    
    Tcl_SetResult(interp,(char *) "No matching function for overloaded 'graph'", TCL_STATIC);
    return TCL_ERROR;
}


static int
_wrap_node(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *arg2 = (char *) 0 ;
    Agnode_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"os:gv::nodeg name ",(void *)0,&arg2) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agraph_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agnode_t *)node(arg1,arg2);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agnode_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_edge__SWIG_0(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agnode_t *arg2 = (Agnode_t *) 0 ;
    Agedge_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oo:gv::edget h ",(void *)0,(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agnode_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[2], (void **) &arg2, SWIGTYPE_p_Agnode_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agedge_t *)edge(arg1,arg2);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agedge_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_edge__SWIG_1(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    char *arg2 = (char *) 0 ;
    Agedge_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"os:gv::edget hname ",(void *)0,&arg2) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agnode_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agedge_t *)edge(arg1,arg2);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agedge_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_edge__SWIG_2(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    char *arg1 = (char *) 0 ;
    Agnode_t *arg2 = (Agnode_t *) 0 ;
    Agedge_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"so:gv::edgetname h ",&arg1,(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[2], (void **) &arg2, SWIGTYPE_p_Agnode_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agedge_t *)edge(arg1,arg2);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agedge_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_edge__SWIG_3(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *arg2 = (char *) 0 ;
    char *arg3 = (char *) 0 ;
    Agedge_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oss:gv::edgeg tname hname ",(void *)0,&arg2,&arg3) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agraph_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agedge_t *)edge(arg1,arg2,arg3);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agedge_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_edge(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Tcl_Obj *CONST *argv = objv+1;
    int argc = objc-1;
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0) == TCL_ERROR) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                return _wrap_edge__SWIG_0(clientData, interp, objc, objv);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = 1;
            }
            if (_v) {
                return _wrap_edge__SWIG_1(clientData, interp, objc, objv);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            _v = 1;
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0) == TCL_ERROR) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                return _wrap_edge__SWIG_2(clientData, interp, objc, objv);
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = 1;
            }
            if (_v) {
                {
                    _v = 1;
                }
                if (_v) {
                    return _wrap_edge__SWIG_3(clientData, interp, objc, objv);
                }
            }
        }
    }
    
    Tcl_SetResult(interp,(char *) "No matching function for overloaded 'edge'", TCL_STATIC);
    return TCL_ERROR;
}


static int
_wrap_setv__SWIG_0(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *arg2 = (char *) 0 ;
    char *arg3 = (char *) 0 ;
    char *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oss:gv::setvg attr val ",(void *)0,&arg2,&arg3) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agraph_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (char *)setv(arg1,arg2,arg3);
    
    Tcl_SetObjResult(interp,Tcl_NewStringObj(result,-1));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_setv__SWIG_1(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    char *arg2 = (char *) 0 ;
    char *arg3 = (char *) 0 ;
    char *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oss:gv::setvn attr val ",(void *)0,&arg2,&arg3) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agnode_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (char *)setv(arg1,arg2,arg3);
    
    Tcl_SetObjResult(interp,Tcl_NewStringObj(result,-1));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_setv__SWIG_2(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    char *arg2 = (char *) 0 ;
    char *arg3 = (char *) 0 ;
    char *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oss:gv::setve attr val ",(void *)0,&arg2,&arg3) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agedge_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (char *)setv(arg1,arg2,arg3);
    
    Tcl_SetObjResult(interp,Tcl_NewStringObj(result,-1));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_setv__SWIG_3(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agsym_t *arg2 = (Agsym_t *) 0 ;
    char *arg3 = (char *) 0 ;
    char *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oos:gv::setvg a val ",(void *)0,(void *)0,&arg3) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agraph_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[2], (void **) &arg2, SWIGTYPE_p_Agsym_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (char *)setv(arg1,arg2,arg3);
    
    Tcl_SetObjResult(interp,Tcl_NewStringObj(result,-1));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_setv__SWIG_4(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agsym_t *arg2 = (Agsym_t *) 0 ;
    char *arg3 = (char *) 0 ;
    char *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oos:gv::setvn a val ",(void *)0,(void *)0,&arg3) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agnode_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[2], (void **) &arg2, SWIGTYPE_p_Agsym_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (char *)setv(arg1,arg2,arg3);
    
    Tcl_SetObjResult(interp,Tcl_NewStringObj(result,-1));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_setv__SWIG_5(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    Agsym_t *arg2 = (Agsym_t *) 0 ;
    char *arg3 = (char *) 0 ;
    char *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oos:gv::setve a val ",(void *)0,(void *)0,&arg3) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agedge_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[2], (void **) &arg2, SWIGTYPE_p_Agsym_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (char *)setv(arg1,arg2,arg3);
    
    Tcl_SetObjResult(interp,Tcl_NewStringObj(result,-1));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_setv(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Tcl_Obj *CONST *argv = objv+1;
    int argc = objc-1;
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Agsym_t, 0) == TCL_ERROR) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                {
                    _v = 1;
                }
                if (_v) {
                    return _wrap_setv__SWIG_3(clientData, interp, objc, objv);
                }
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Agsym_t, 0) == TCL_ERROR) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                {
                    _v = 1;
                }
                if (_v) {
                    return _wrap_setv__SWIG_4(clientData, interp, objc, objv);
                }
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agedge_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Agsym_t, 0) == TCL_ERROR) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                {
                    _v = 1;
                }
                if (_v) {
                    return _wrap_setv__SWIG_5(clientData, interp, objc, objv);
                }
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = 1;
            }
            if (_v) {
                {
                    _v = 1;
                }
                if (_v) {
                    return _wrap_setv__SWIG_0(clientData, interp, objc, objv);
                }
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = 1;
            }
            if (_v) {
                {
                    _v = 1;
                }
                if (_v) {
                    return _wrap_setv__SWIG_1(clientData, interp, objc, objv);
                }
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agedge_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = 1;
            }
            if (_v) {
                {
                    _v = 1;
                }
                if (_v) {
                    return _wrap_setv__SWIG_2(clientData, interp, objc, objv);
                }
            }
        }
    }
    
    Tcl_SetResult(interp,(char *) "No matching function for overloaded 'setv'", TCL_STATIC);
    return TCL_ERROR;
}


static int
_wrap_getv__SWIG_0(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *arg2 = (char *) 0 ;
    char *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"os:gv::getvg attr ",(void *)0,&arg2) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agraph_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (char *)getv(arg1,arg2);
    
    Tcl_SetObjResult(interp,Tcl_NewStringObj(result,-1));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_getv__SWIG_1(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    char *arg2 = (char *) 0 ;
    char *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"os:gv::getvn attr ",(void *)0,&arg2) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agnode_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (char *)getv(arg1,arg2);
    
    Tcl_SetObjResult(interp,Tcl_NewStringObj(result,-1));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_getv__SWIG_2(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    char *arg2 = (char *) 0 ;
    char *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"os:gv::getve attr ",(void *)0,&arg2) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agedge_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (char *)getv(arg1,arg2);
    
    Tcl_SetObjResult(interp,Tcl_NewStringObj(result,-1));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_getv__SWIG_3(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agsym_t *arg2 = (Agsym_t *) 0 ;
    char *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oo:gv::getvg a ",(void *)0,(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agraph_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[2], (void **) &arg2, SWIGTYPE_p_Agsym_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (char *)getv(arg1,arg2);
    
    Tcl_SetObjResult(interp,Tcl_NewStringObj(result,-1));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_getv__SWIG_4(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agsym_t *arg2 = (Agsym_t *) 0 ;
    char *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oo:gv::getvn a ",(void *)0,(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agnode_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[2], (void **) &arg2, SWIGTYPE_p_Agsym_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (char *)getv(arg1,arg2);
    
    Tcl_SetObjResult(interp,Tcl_NewStringObj(result,-1));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_getv__SWIG_5(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    Agsym_t *arg2 = (Agsym_t *) 0 ;
    char *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oo:gv::getve a ",(void *)0,(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agedge_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[2], (void **) &arg2, SWIGTYPE_p_Agsym_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (char *)getv(arg1,arg2);
    
    Tcl_SetObjResult(interp,Tcl_NewStringObj(result,-1));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_getv(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Tcl_Obj *CONST *argv = objv+1;
    int argc = objc-1;
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Agsym_t, 0) == TCL_ERROR) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                return _wrap_getv__SWIG_3(clientData, interp, objc, objv);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Agsym_t, 0) == TCL_ERROR) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                return _wrap_getv__SWIG_4(clientData, interp, objc, objv);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agedge_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Agsym_t, 0) == TCL_ERROR) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                return _wrap_getv__SWIG_5(clientData, interp, objc, objv);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = 1;
            }
            if (_v) {
                return _wrap_getv__SWIG_0(clientData, interp, objc, objv);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = 1;
            }
            if (_v) {
                return _wrap_getv__SWIG_1(clientData, interp, objc, objv);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agedge_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = 1;
            }
            if (_v) {
                return _wrap_getv__SWIG_2(clientData, interp, objc, objv);
            }
        }
    }
    
    Tcl_SetResult(interp,(char *) "No matching function for overloaded 'getv'", TCL_STATIC);
    return TCL_ERROR;
}


static int
_wrap_nameof__SWIG_0(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:gv::nameofg ",(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agraph_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (char *)nameof(arg1);
    
    Tcl_SetObjResult(interp,Tcl_NewStringObj(result,-1));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_nameof__SWIG_1(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    char *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:gv::nameofn ",(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agnode_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (char *)nameof(arg1);
    
    Tcl_SetObjResult(interp,Tcl_NewStringObj(result,-1));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_nameof__SWIG_2(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agsym_t *arg1 = (Agsym_t *) 0 ;
    char *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:gv::nameofa ",(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agsym_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (char *)nameof(arg1);
    
    Tcl_SetObjResult(interp,Tcl_NewStringObj(result,-1));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_nameof(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Tcl_Obj *CONST *argv = objv+1;
    int argc = objc-1;
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_nameof__SWIG_0(clientData, interp, objc, objv);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_nameof__SWIG_1(clientData, interp, objc, objv);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agsym_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_nameof__SWIG_2(clientData, interp, objc, objv);
        }
    }
    
    Tcl_SetResult(interp,(char *) "No matching function for overloaded 'nameof'", TCL_STATIC);
    return TCL_ERROR;
}


static int
_wrap_findsubg(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *arg2 = (char *) 0 ;
    Agraph_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"os:gv::findsubgg name ",(void *)0,&arg2) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agraph_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agraph_t *)findsubg(arg1,arg2);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agraph_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_findnode(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *arg2 = (char *) 0 ;
    Agnode_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"os:gv::findnodeg name ",(void *)0,&arg2) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agraph_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agnode_t *)findnode(arg1,arg2);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agnode_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_findedge(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agnode_t *arg2 = (Agnode_t *) 0 ;
    Agedge_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oo:gv::findedget h ",(void *)0,(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agnode_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[2], (void **) &arg2, SWIGTYPE_p_Agnode_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agedge_t *)findedge(arg1,arg2);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agedge_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_findattr__SWIG_0(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *arg2 = (char *) 0 ;
    Agsym_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"os:gv::findattrg name ",(void *)0,&arg2) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agraph_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agsym_t *)findattr(arg1,arg2);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agsym_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_findattr__SWIG_1(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    char *arg2 = (char *) 0 ;
    Agsym_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"os:gv::findattrn name ",(void *)0,&arg2) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agnode_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agsym_t *)findattr(arg1,arg2);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agsym_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_findattr__SWIG_2(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    char *arg2 = (char *) 0 ;
    Agsym_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"os:gv::findattre name ",(void *)0,&arg2) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agedge_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agsym_t *)findattr(arg1,arg2);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agsym_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_findattr(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Tcl_Obj *CONST *argv = objv+1;
    int argc = objc-1;
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = 1;
            }
            if (_v) {
                return _wrap_findattr__SWIG_0(clientData, interp, objc, objv);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = 1;
            }
            if (_v) {
                return _wrap_findattr__SWIG_1(clientData, interp, objc, objv);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agedge_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = 1;
            }
            if (_v) {
                return _wrap_findattr__SWIG_2(clientData, interp, objc, objv);
            }
        }
    }
    
    Tcl_SetResult(interp,(char *) "No matching function for overloaded 'findattr'", TCL_STATIC);
    return TCL_ERROR;
}


static int
_wrap_headof(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    Agnode_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:gv::headofe ",(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agedge_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agnode_t *)headof(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agnode_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_tailof(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    Agnode_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:gv::tailofe ",(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agedge_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agnode_t *)tailof(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agnode_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_graphof__SWIG_0(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agraph_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:gv::graphofg ",(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agraph_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agraph_t *)graphof(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agraph_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_graphof__SWIG_1(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    Agraph_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:gv::graphofe ",(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agedge_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agraph_t *)graphof(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agraph_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_graphof__SWIG_2(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agraph_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:gv::graphofn ",(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agnode_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agraph_t *)graphof(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agraph_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_graphof(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Tcl_Obj *CONST *argv = objv+1;
    int argc = objc-1;
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_graphof__SWIG_0(clientData, interp, objc, objv);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agedge_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_graphof__SWIG_1(clientData, interp, objc, objv);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_graphof__SWIG_2(clientData, interp, objc, objv);
        }
    }
    
    Tcl_SetResult(interp,(char *) "No matching function for overloaded 'graphof'", TCL_STATIC);
    return TCL_ERROR;
}


static int
_wrap_rootof(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agraph_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:gv::rootofg ",(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agraph_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agraph_t *)rootof(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agraph_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_protonode(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agnode_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:gv::protonodeg ",(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agraph_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agnode_t *)protonode(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agnode_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_protoedge(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agedge_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:gv::protoedgeg ",(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agraph_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agedge_t *)protoedge(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agedge_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_ok__SWIG_0(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    bool result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:gv::okg ",(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agraph_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (bool)ok(arg1);
    
    Tcl_SetObjResult(interp,Tcl_NewIntObj((long) result));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_ok__SWIG_1(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    bool result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:gv::okn ",(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agnode_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (bool)ok(arg1);
    
    Tcl_SetObjResult(interp,Tcl_NewIntObj((long) result));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_ok__SWIG_2(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    bool result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:gv::oke ",(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agedge_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (bool)ok(arg1);
    
    Tcl_SetObjResult(interp,Tcl_NewIntObj((long) result));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_ok__SWIG_3(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agsym_t *arg1 = (Agsym_t *) 0 ;
    bool result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:gv::oka ",(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agsym_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (bool)ok(arg1);
    
    Tcl_SetObjResult(interp,Tcl_NewIntObj((long) result));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_ok(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Tcl_Obj *CONST *argv = objv+1;
    int argc = objc-1;
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_ok__SWIG_0(clientData, interp, objc, objv);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_ok__SWIG_1(clientData, interp, objc, objv);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agedge_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_ok__SWIG_2(clientData, interp, objc, objv);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agsym_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_ok__SWIG_3(clientData, interp, objc, objv);
        }
    }
    
    Tcl_SetResult(interp,(char *) "No matching function for overloaded 'ok'", TCL_STATIC);
    return TCL_ERROR;
}


static int
_wrap_firstsubg(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agraph_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:gv::firstsubgg ",(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agraph_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agraph_t *)firstsubg(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agraph_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_nextsubg(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agraph_t *arg2 = (Agraph_t *) 0 ;
    Agraph_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oo:gv::nextsubgg sg ",(void *)0,(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agraph_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[2], (void **) &arg2, SWIGTYPE_p_Agraph_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agraph_t *)nextsubg(arg1,arg2);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agraph_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_firstsupg(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agraph_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:gv::firstsupgg ",(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agraph_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agraph_t *)firstsupg(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agraph_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_nextsupg(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agraph_t *arg2 = (Agraph_t *) 0 ;
    Agraph_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oo:gv::nextsupgg sg ",(void *)0,(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agraph_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[2], (void **) &arg2, SWIGTYPE_p_Agraph_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agraph_t *)nextsupg(arg1,arg2);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agraph_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_firstedge__SWIG_0(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agedge_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:gv::firstedgeg ",(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agraph_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agedge_t *)firstedge(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agedge_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_nextedge__SWIG_0(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agedge_t *arg2 = (Agedge_t *) 0 ;
    Agedge_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oo:gv::nextedgeg e ",(void *)0,(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agraph_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[2], (void **) &arg2, SWIGTYPE_p_Agedge_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agedge_t *)nextedge(arg1,arg2);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agedge_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_firstout__SWIG_0(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agedge_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:gv::firstoutg ",(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agraph_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agedge_t *)firstout(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agedge_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_nextout__SWIG_0(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agedge_t *arg2 = (Agedge_t *) 0 ;
    Agedge_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oo:gv::nextoutg e ",(void *)0,(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agraph_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[2], (void **) &arg2, SWIGTYPE_p_Agedge_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agedge_t *)nextout(arg1,arg2);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agedge_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_firstedge__SWIG_1(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agedge_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:gv::firstedgen ",(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agnode_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agedge_t *)firstedge(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agedge_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_firstedge(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Tcl_Obj *CONST *argv = objv+1;
    int argc = objc-1;
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_firstedge__SWIG_0(clientData, interp, objc, objv);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_firstedge__SWIG_1(clientData, interp, objc, objv);
        }
    }
    
    Tcl_SetResult(interp,(char *) "No matching function for overloaded 'firstedge'", TCL_STATIC);
    return TCL_ERROR;
}


static int
_wrap_nextedge__SWIG_1(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agedge_t *arg2 = (Agedge_t *) 0 ;
    Agedge_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oo:gv::nextedgen e ",(void *)0,(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agnode_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[2], (void **) &arg2, SWIGTYPE_p_Agedge_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agedge_t *)nextedge(arg1,arg2);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agedge_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_nextedge(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Tcl_Obj *CONST *argv = objv+1;
    int argc = objc-1;
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Agedge_t, 0) == TCL_ERROR) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                return _wrap_nextedge__SWIG_0(clientData, interp, objc, objv);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Agedge_t, 0) == TCL_ERROR) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                return _wrap_nextedge__SWIG_1(clientData, interp, objc, objv);
            }
        }
    }
    
    Tcl_SetResult(interp,(char *) "No matching function for overloaded 'nextedge'", TCL_STATIC);
    return TCL_ERROR;
}


static int
_wrap_firstout__SWIG_1(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agedge_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:gv::firstoutn ",(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agnode_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agedge_t *)firstout(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agedge_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_firstout(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Tcl_Obj *CONST *argv = objv+1;
    int argc = objc-1;
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_firstout__SWIG_0(clientData, interp, objc, objv);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_firstout__SWIG_1(clientData, interp, objc, objv);
        }
    }
    
    Tcl_SetResult(interp,(char *) "No matching function for overloaded 'firstout'", TCL_STATIC);
    return TCL_ERROR;
}


static int
_wrap_nextout__SWIG_1(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agedge_t *arg2 = (Agedge_t *) 0 ;
    Agedge_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oo:gv::nextoutn e ",(void *)0,(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agnode_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[2], (void **) &arg2, SWIGTYPE_p_Agedge_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agedge_t *)nextout(arg1,arg2);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agedge_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_nextout(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Tcl_Obj *CONST *argv = objv+1;
    int argc = objc-1;
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Agedge_t, 0) == TCL_ERROR) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                return _wrap_nextout__SWIG_0(clientData, interp, objc, objv);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Agedge_t, 0) == TCL_ERROR) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                return _wrap_nextout__SWIG_1(clientData, interp, objc, objv);
            }
        }
    }
    
    Tcl_SetResult(interp,(char *) "No matching function for overloaded 'nextout'", TCL_STATIC);
    return TCL_ERROR;
}


static int
_wrap_firsthead(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agnode_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:gv::firstheadn ",(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agnode_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agnode_t *)firsthead(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agnode_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_nexthead(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agnode_t *arg2 = (Agnode_t *) 0 ;
    Agnode_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oo:gv::nextheadn h ",(void *)0,(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agnode_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[2], (void **) &arg2, SWIGTYPE_p_Agnode_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agnode_t *)nexthead(arg1,arg2);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agnode_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_firstin__SWIG_0(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agedge_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:gv::firsting ",(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agraph_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agedge_t *)firstin(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agedge_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_nextin__SWIG_0(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agedge_t *arg2 = (Agedge_t *) 0 ;
    Agedge_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oo:gv::nextinn e ",(void *)0,(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agnode_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[2], (void **) &arg2, SWIGTYPE_p_Agedge_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agedge_t *)nextin(arg1,arg2);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agedge_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_firstin__SWIG_1(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agedge_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:gv::firstinn ",(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agnode_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agedge_t *)firstin(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agedge_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_firstin(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Tcl_Obj *CONST *argv = objv+1;
    int argc = objc-1;
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_firstin__SWIG_0(clientData, interp, objc, objv);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_firstin__SWIG_1(clientData, interp, objc, objv);
        }
    }
    
    Tcl_SetResult(interp,(char *) "No matching function for overloaded 'firstin'", TCL_STATIC);
    return TCL_ERROR;
}


static int
_wrap_nextin__SWIG_1(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agedge_t *arg2 = (Agedge_t *) 0 ;
    Agedge_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oo:gv::nexting e ",(void *)0,(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agraph_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[2], (void **) &arg2, SWIGTYPE_p_Agedge_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agedge_t *)nextin(arg1,arg2);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agedge_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_nextin(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Tcl_Obj *CONST *argv = objv+1;
    int argc = objc-1;
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Agedge_t, 0) == TCL_ERROR) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                return _wrap_nextin__SWIG_0(clientData, interp, objc, objv);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Agedge_t, 0) == TCL_ERROR) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                return _wrap_nextin__SWIG_1(clientData, interp, objc, objv);
            }
        }
    }
    
    Tcl_SetResult(interp,(char *) "No matching function for overloaded 'nextin'", TCL_STATIC);
    return TCL_ERROR;
}


static int
_wrap_firsttail(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agnode_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:gv::firsttailn ",(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agnode_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agnode_t *)firsttail(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agnode_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_nexttail(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agnode_t *arg2 = (Agnode_t *) 0 ;
    Agnode_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oo:gv::nexttailn t ",(void *)0,(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agnode_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[2], (void **) &arg2, SWIGTYPE_p_Agnode_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agnode_t *)nexttail(arg1,arg2);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agnode_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_firstnode__SWIG_0(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agnode_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:gv::firstnodeg ",(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agraph_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agnode_t *)firstnode(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agnode_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_nextnode__SWIG_0(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agnode_t *arg2 = (Agnode_t *) 0 ;
    Agnode_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oo:gv::nextnodeg n ",(void *)0,(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agraph_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[2], (void **) &arg2, SWIGTYPE_p_Agnode_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agnode_t *)nextnode(arg1,arg2);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agnode_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_firstnode__SWIG_1(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    Agnode_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:gv::firstnodee ",(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agedge_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agnode_t *)firstnode(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agnode_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_firstnode(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Tcl_Obj *CONST *argv = objv+1;
    int argc = objc-1;
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_firstnode__SWIG_0(clientData, interp, objc, objv);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agedge_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_firstnode__SWIG_1(clientData, interp, objc, objv);
        }
    }
    
    Tcl_SetResult(interp,(char *) "No matching function for overloaded 'firstnode'", TCL_STATIC);
    return TCL_ERROR;
}


static int
_wrap_nextnode__SWIG_1(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    Agnode_t *arg2 = (Agnode_t *) 0 ;
    Agnode_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oo:gv::nextnodee n ",(void *)0,(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agedge_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[2], (void **) &arg2, SWIGTYPE_p_Agnode_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agnode_t *)nextnode(arg1,arg2);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agnode_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_nextnode(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Tcl_Obj *CONST *argv = objv+1;
    int argc = objc-1;
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0) == TCL_ERROR) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                return _wrap_nextnode__SWIG_0(clientData, interp, objc, objv);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agedge_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0) == TCL_ERROR) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                return _wrap_nextnode__SWIG_1(clientData, interp, objc, objv);
            }
        }
    }
    
    Tcl_SetResult(interp,(char *) "No matching function for overloaded 'nextnode'", TCL_STATIC);
    return TCL_ERROR;
}


static int
_wrap_firstattr__SWIG_0(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agsym_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:gv::firstattrg ",(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agraph_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agsym_t *)firstattr(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agsym_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_nextattr__SWIG_0(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agsym_t *arg2 = (Agsym_t *) 0 ;
    Agsym_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oo:gv::nextattrg a ",(void *)0,(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agraph_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[2], (void **) &arg2, SWIGTYPE_p_Agsym_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agsym_t *)nextattr(arg1,arg2);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agsym_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_firstattr__SWIG_1(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    Agsym_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:gv::firstattre ",(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agedge_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agsym_t *)firstattr(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agsym_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_nextattr__SWIG_1(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    Agsym_t *arg2 = (Agsym_t *) 0 ;
    Agsym_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oo:gv::nextattre a ",(void *)0,(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agedge_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[2], (void **) &arg2, SWIGTYPE_p_Agsym_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agsym_t *)nextattr(arg1,arg2);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agsym_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_firstattr__SWIG_2(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agsym_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:gv::firstattrn ",(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agnode_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agsym_t *)firstattr(arg1);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agsym_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_firstattr(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Tcl_Obj *CONST *argv = objv+1;
    int argc = objc-1;
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_firstattr__SWIG_0(clientData, interp, objc, objv);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agedge_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_firstattr__SWIG_1(clientData, interp, objc, objv);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_firstattr__SWIG_2(clientData, interp, objc, objv);
        }
    }
    
    Tcl_SetResult(interp,(char *) "No matching function for overloaded 'firstattr'", TCL_STATIC);
    return TCL_ERROR;
}


static int
_wrap_nextattr__SWIG_2(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agsym_t *arg2 = (Agsym_t *) 0 ;
    Agsym_t *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oo:gv::nextattrn a ",(void *)0,(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agnode_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[2], (void **) &arg2, SWIGTYPE_p_Agsym_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (Agsym_t *)nextattr(arg1,arg2);
    
    Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) result, SWIGTYPE_p_Agsym_t, 0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_nextattr(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Tcl_Obj *CONST *argv = objv+1;
    int argc = objc-1;
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Agsym_t, 0) == TCL_ERROR) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                return _wrap_nextattr__SWIG_0(clientData, interp, objc, objv);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agedge_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Agsym_t, 0) == TCL_ERROR) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                return _wrap_nextattr__SWIG_1(clientData, interp, objc, objv);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Agsym_t, 0) == TCL_ERROR) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                return _wrap_nextattr__SWIG_2(clientData, interp, objc, objv);
            }
        }
    }
    
    Tcl_SetResult(interp,(char *) "No matching function for overloaded 'nextattr'", TCL_STATIC);
    return TCL_ERROR;
}


static int
_wrap_rm__SWIG_0(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:gv::rmg ",(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agraph_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    rm(arg1);
    
    
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_rm__SWIG_1(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:gv::rmn ",(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agnode_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    rm(arg1);
    
    
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_rm__SWIG_2(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:gv::rme ",(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agedge_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    rm(arg1);
    
    
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_rm(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Tcl_Obj *CONST *argv = objv+1;
    int argc = objc-1;
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_rm__SWIG_0(clientData, interp, objc, objv);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agnode_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_rm__SWIG_1(clientData, interp, objc, objv);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agedge_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_rm__SWIG_2(clientData, interp, objc, objv);
        }
    }
    
    Tcl_SetResult(interp,(char *) "No matching function for overloaded 'rm'", TCL_STATIC);
    return TCL_ERROR;
}


static int
_wrap_layout(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *arg2 = (char *) 0 ;
    
    if (SWIG_GetArgs(interp, objc, objv,"os:gv::layoutg engine ",(void *)0,&arg2) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agraph_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    layout(arg1,arg2);
    
    
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_render__SWIG_0(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:gv::renderg ",(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agraph_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    render(arg1);
    
    
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_render__SWIG_1(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *arg2 = (char *) 0 ;
    
    if (SWIG_GetArgs(interp, objc, objv,"os:gv::renderg format ",(void *)0,&arg2) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agraph_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    render(arg1,arg2);
    
    
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_render__SWIG_2(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *arg2 = (char *) 0 ;
    char *arg3 = (char *) 0 ;
    
    if (SWIG_GetArgs(interp, objc, objv,"oss:gv::renderg format filename ",(void *)0,&arg2,&arg3) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agraph_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    render(arg1,arg2,arg3);
    
    
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_render__SWIG_3(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *arg2 = (char *) 0 ;
    FILE *arg3 = (FILE *) 0 ;
    
    if (SWIG_GetArgs(interp, objc, objv,"oso:gv::renderg format f ",(void *)0,&arg2,(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agraph_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[3], (void **) &arg3, SWIGTYPE_p_FILE,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    render(arg1,arg2,arg3);
    
    
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_render__SWIG_4(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *arg2 = (char *) 0 ;
    void **arg3 = (void **) 0 ;
    
    if (SWIG_GetArgs(interp, objc, objv,"oso:gv::renderg format data ",(void *)0,&arg2,(void *)0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_p_Agraph_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[3], (void **) &arg3, SWIGTYPE_p_p_void,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    render(arg1,arg2,arg3);
    
    
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_render(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Tcl_Obj *CONST *argv = objv+1;
    int argc = objc-1;
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_render__SWIG_0(clientData, interp, objc, objv);
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = 1;
            }
            if (_v) {
                return _wrap_render__SWIG_1(clientData, interp, objc, objv);
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = 1;
            }
            if (_v) {
                {
                    void *ptr;
                    if (SWIG_ConvertPtr(argv[2], (void **) &ptr, SWIGTYPE_p_FILE, 0) == TCL_ERROR) {
                        _v = 0;
                    } else {
                        _v = 1;
                    }
                }
                if (_v) {
                    return _wrap_render__SWIG_3(clientData, interp, objc, objv);
                }
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = 1;
            }
            if (_v) {
                {
                    void *ptr;
                    if (SWIG_ConvertPtr(argv[2], (void **) &ptr, SWIGTYPE_p_p_void, 0) == TCL_ERROR) {
                        _v = 0;
                    } else {
                        _v = 1;
                    }
                }
                if (_v) {
                    return _wrap_render__SWIG_4(clientData, interp, objc, objv);
                }
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Agraph_t, 0) == TCL_ERROR) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = 1;
            }
            if (_v) {
                {
                    _v = 1;
                }
                if (_v) {
                    return _wrap_render__SWIG_2(clientData, interp, objc, objv);
                }
            }
        }
    }
    
    Tcl_SetResult(interp,(char *) "No matching function for overloaded 'render'", TCL_STATIC);
    return TCL_ERROR;
}



static swig_command_info swig_commands[] = {
    { SWIG_prefix "digraph", (swig_wrapper_func) _wrap_digraph, NULL},
    { SWIG_prefix "strictgraph", (swig_wrapper_func) _wrap_strictgraph, NULL},
    { SWIG_prefix "strictdigraph", (swig_wrapper_func) _wrap_strictdigraph, NULL},
    { SWIG_prefix "readstring", (swig_wrapper_func) _wrap_readstring, NULL},
    { SWIG_prefix "read", (swig_wrapper_func) _wrap_read, NULL},
    { SWIG_prefix "graph", (swig_wrapper_func) _wrap_graph, NULL},
    { SWIG_prefix "node", (swig_wrapper_func) _wrap_node, NULL},
    { SWIG_prefix "edge", (swig_wrapper_func) _wrap_edge, NULL},
    { SWIG_prefix "setv", (swig_wrapper_func) _wrap_setv, NULL},
    { SWIG_prefix "getv", (swig_wrapper_func) _wrap_getv, NULL},
    { SWIG_prefix "nameof", (swig_wrapper_func) _wrap_nameof, NULL},
    { SWIG_prefix "findsubg", (swig_wrapper_func) _wrap_findsubg, NULL},
    { SWIG_prefix "findnode", (swig_wrapper_func) _wrap_findnode, NULL},
    { SWIG_prefix "findedge", (swig_wrapper_func) _wrap_findedge, NULL},
    { SWIG_prefix "findattr", (swig_wrapper_func) _wrap_findattr, NULL},
    { SWIG_prefix "headof", (swig_wrapper_func) _wrap_headof, NULL},
    { SWIG_prefix "tailof", (swig_wrapper_func) _wrap_tailof, NULL},
    { SWIG_prefix "graphof", (swig_wrapper_func) _wrap_graphof, NULL},
    { SWIG_prefix "rootof", (swig_wrapper_func) _wrap_rootof, NULL},
    { SWIG_prefix "protonode", (swig_wrapper_func) _wrap_protonode, NULL},
    { SWIG_prefix "protoedge", (swig_wrapper_func) _wrap_protoedge, NULL},
    { SWIG_prefix "ok", (swig_wrapper_func) _wrap_ok, NULL},
    { SWIG_prefix "firstsubg", (swig_wrapper_func) _wrap_firstsubg, NULL},
    { SWIG_prefix "nextsubg", (swig_wrapper_func) _wrap_nextsubg, NULL},
    { SWIG_prefix "firstsupg", (swig_wrapper_func) _wrap_firstsupg, NULL},
    { SWIG_prefix "nextsupg", (swig_wrapper_func) _wrap_nextsupg, NULL},
    { SWIG_prefix "firstedge", (swig_wrapper_func) _wrap_firstedge, NULL},
    { SWIG_prefix "nextedge", (swig_wrapper_func) _wrap_nextedge, NULL},
    { SWIG_prefix "firstout", (swig_wrapper_func) _wrap_firstout, NULL},
    { SWIG_prefix "nextout", (swig_wrapper_func) _wrap_nextout, NULL},
    { SWIG_prefix "firsthead", (swig_wrapper_func) _wrap_firsthead, NULL},
    { SWIG_prefix "nexthead", (swig_wrapper_func) _wrap_nexthead, NULL},
    { SWIG_prefix "firstin", (swig_wrapper_func) _wrap_firstin, NULL},
    { SWIG_prefix "nextin", (swig_wrapper_func) _wrap_nextin, NULL},
    { SWIG_prefix "firsttail", (swig_wrapper_func) _wrap_firsttail, NULL},
    { SWIG_prefix "nexttail", (swig_wrapper_func) _wrap_nexttail, NULL},
    { SWIG_prefix "firstnode", (swig_wrapper_func) _wrap_firstnode, NULL},
    { SWIG_prefix "nextnode", (swig_wrapper_func) _wrap_nextnode, NULL},
    { SWIG_prefix "firstattr", (swig_wrapper_func) _wrap_firstattr, NULL},
    { SWIG_prefix "nextattr", (swig_wrapper_func) _wrap_nextattr, NULL},
    { SWIG_prefix "rm", (swig_wrapper_func) _wrap_rm, NULL},
    { SWIG_prefix "layout", (swig_wrapper_func) _wrap_layout, NULL},
    { SWIG_prefix "render", (swig_wrapper_func) _wrap_render, NULL},
    {0, 0, 0}
};

static swig_var_info swig_variables[] = {
    {0,0,0,0}
};

static swig_const_info swig_constants[] = {
    {0,0,0,0,0,0}
};

/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static swig_type_info _swigt__p_Agedge_t = {"_p_Agedge_t", "Agedge_t *", 0, 0, 0};
static swig_type_info _swigt__p_Agnode_t = {"_p_Agnode_t", "Agnode_t *", 0, 0, 0};
static swig_type_info _swigt__p_Agraph_t = {"_p_Agraph_t", "Agraph_t *", 0, 0, 0};
static swig_type_info _swigt__p_Agsym_t = {"_p_Agsym_t", "Agsym_t *", 0, 0, 0};
static swig_type_info _swigt__p_FILE = {"_p_FILE", "FILE *", 0, 0, 0};
static swig_type_info _swigt__p_p_void = {"_p_p_void", "void **", 0, 0, 0};
static swig_type_info _swigt__ptrdiff_t = {"_ptrdiff_t", "ptrdiff_t", 0, 0, 0};
static swig_type_info _swigt__size_t = {"_size_t", "size_t", 0, 0, 0};

static swig_type_info *swig_type_initial[] = {
  &_swigt__p_Agedge_t,
  &_swigt__p_Agnode_t,
  &_swigt__p_Agraph_t,
  &_swigt__p_Agsym_t,
  &_swigt__p_FILE,
  &_swigt__p_p_void,
  &_swigt__ptrdiff_t,
  &_swigt__size_t,
};

static swig_cast_info _swigc__p_Agedge_t[] = {  {&_swigt__p_Agedge_t, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_Agnode_t[] = {  {&_swigt__p_Agnode_t, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_Agraph_t[] = {  {&_swigt__p_Agraph_t, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_Agsym_t[] = {  {&_swigt__p_Agsym_t, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_FILE[] = {  {&_swigt__p_FILE, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_p_void[] = {  {&_swigt__p_p_void, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__ptrdiff_t[] = {  {&_swigt__ptrdiff_t, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__size_t[] = {  {&_swigt__size_t, 0, 0, 0},{0, 0, 0, 0}};

static swig_cast_info *swig_cast_initial[] = {
  _swigc__p_Agedge_t,
  _swigc__p_Agnode_t,
  _swigc__p_Agraph_t,
  _swigc__p_Agsym_t,
  _swigc__p_FILE,
  _swigc__p_p_void,
  _swigc__ptrdiff_t,
  _swigc__size_t,
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */

#ifdef __cplusplus
}
#endif
/*************************************************************************
 * Type initialization:
 * This problem is tough by the requirement that no dynamic 
 * memory is used. Also, since swig_type_info structures store pointers to 
 * swig_cast_info structures and swig_cast_info structures store pointers back
 * to swig_type_info structures, we need some lookup code at initialization. 
 * The idea is that swig generates all the structures that are needed. 
 * The runtime then collects these partially filled structures. 
 * The SWIG_InitializeModule function takes these initial arrays out of 
 * swig_module, and does all the lookup, filling in the swig_module.types
 * array with the correct data and linking the correct swig_cast_info
 * structures together.

 * The generated swig_type_info structures are assigned staticly to an initial 
 * array. We just loop though that array, and handle each type individually.
 * First we lookup if this type has been already loaded, and if so, use the
 * loaded structure instead of the generated one. Then we have to fill in the
 * cast linked list. The cast data is initially stored in something like a
 * two-dimensional array. Each row corresponds to a type (there are the same
 * number of rows as there are in the swig_type_initial array). Each entry in
 * a column is one of the swig_cast_info structures for that type.
 * The cast_initial array is actually an array of arrays, because each row has
 * a variable number of columns. So to actually build the cast linked list,
 * we find the array of casts associated with the type, and loop through it 
 * adding the casts to the list. The one last trick we need to do is making
 * sure the type pointer in the swig_cast_info struct is correct.

 * First off, we lookup the cast->type name to see if it is already loaded. 
 * There are three cases to handle:
 *  1) If the cast->type has already been loaded AND the type we are adding
 *     casting info to has not been loaded (it is in this module), THEN we
 *     replace the cast->type pointer with the type pointer that has already
 *     been loaded.
 *  2) If BOTH types (the one we are adding casting info to, and the 
 *     cast->type) are loaded, THEN the cast info has already been loaded by
 *     the previous module so we just ignore it.
 *  3) Finally, if cast->type has not already been loaded, then we add that
 *     swig_cast_info to the linked list (because the cast->type) pointer will
 *     be correct.
**/

#ifdef __cplusplus
extern "C" {
#endif
    
    SWIGRUNTIME void
    SWIG_InitializeModule(void *clientdata) {
        swig_type_info *type, *ret;
        swig_cast_info *cast;
        size_t i;
        swig_module_info *module_head;
        static int init_run = 0;
        
        clientdata = clientdata;
        
        if (init_run) return;
        init_run = 1;
        
        /* Initialize the swig_module */
        swig_module.type_initial = swig_type_initial;
        swig_module.cast_initial = swig_cast_initial;
        
        /* Try and load any already created modules */
        module_head = SWIG_GetModule(clientdata);
        if (module_head) {
            swig_module.next = module_head->next;
            module_head->next = &swig_module;
        } else {
            /* This is the first module loaded */
            swig_module.next = &swig_module;
            SWIG_SetModule(clientdata, &swig_module);
        }
        
        /* Now work on filling in swig_module.types */
        for (i = 0; i < swig_module.size; ++i) {
            type = 0;
            
            /* if there is another module already loaded */
            if (swig_module.next != &swig_module) {
                type = SWIG_MangledTypeQueryModule(swig_module.next, &swig_module, swig_module.type_initial[i]->name);
            }
            if (type) {
                /* Overwrite clientdata field */
                if (swig_module.type_initial[i]->clientdata) type->clientdata = swig_module.type_initial[i]->clientdata;
            } else {
                type = swig_module.type_initial[i];
            }
            
            /* Insert casting types */
            cast = swig_module.cast_initial[i];
            while (cast->type) {
                /* Don't need to add information already in the list */
                ret = 0;
                if (swig_module.next != &swig_module) {
                    ret = SWIG_MangledTypeQueryModule(swig_module.next, &swig_module, cast->type->name);
                }
                if (ret && type == swig_module.type_initial[i]) {
                    cast->type = ret;
                    ret = 0;
                }
                
                if (!ret) {
                    if (type->cast) {
                        type->cast->prev = cast;
                        cast->next = type->cast;
                    }
                    type->cast = cast;
                }
                
                cast++;
            }
            
            /* Set entry in modules->types array equal to the type */
            swig_module.types[i] = type;
        }
        swig_module.types[i] = 0;
    }
    
    /* This function will propagate the clientdata field of type to
    * any new swig_type_info structures that have been added into the list
    * of equivalent types.  It is like calling
    * SWIG_TypeClientData(type, clientdata) a second time.
    */
    SWIGRUNTIME void
    SWIG_PropagateClientData(void) {
        size_t i;
        swig_cast_info *equiv;
        static int init_run = 0;
        
        if (init_run) return;
        init_run = 1;
        
        for (i = 0; i < swig_module.size; i++) {
            if (swig_module.types[i]->clientdata) {
                equiv = swig_module.types[i]->cast;
                while (equiv) {
                    if (!equiv->converter) {
                        if (equiv->type && !equiv->type->clientdata)
                        SWIG_TypeClientData(equiv->type, swig_module.types[i]->clientdata);
                    }
                    equiv = equiv->next;
                }
            }
        }
    }
    
#ifdef __cplusplus
}
#endif


SWIGEXPORT int SWIG_init(Tcl_Interp *interp) {
    int i;
    if (interp == 0) return TCL_ERROR;
#ifdef USE_TCL_STUBS
    if (Tcl_InitStubs(interp, (char*)"8.1", 0) == NULL) {
        return TCL_ERROR;
    }
#endif
    
    Tcl_PkgProvide(interp, (char*)SWIG_name, (char*)SWIG_version);
    
#ifdef SWIG_namespace
    Tcl_Eval(interp, "namespace eval " SWIG_namespace " { }");
#endif
    
    SWIG_InitializeModule((void *) interp);
    SWIG_PropagateClientData();
    
    for (i = 0; swig_commands[i].name; i++) {
        Tcl_CreateObjCommand(interp, (char *) swig_commands[i].name, (swig_wrapper_func) swig_commands[i].wrapper, swig_commands[i].clientdata, NULL);
    }
    for (i = 0; swig_variables[i].name; i++) {
        Tcl_SetVar(interp, (char *) swig_variables[i].name, (char *) "", TCL_GLOBAL_ONLY);
        Tcl_TraceVar(interp, (char *) swig_variables[i].name, TCL_TRACE_READS | TCL_GLOBAL_ONLY, (Tcl_VarTraceProc *) swig_variables[i].get, (ClientData) swig_variables[i].addr);
        Tcl_TraceVar(interp, (char *) swig_variables[i].name, TCL_TRACE_WRITES | TCL_GLOBAL_ONLY, (Tcl_VarTraceProc *) swig_variables[i].set, (ClientData) swig_variables[i].addr);
    }
    SWIG_InstallConstants(interp, swig_constants);
    
    return TCL_OK;
}
SWIGEXPORT int Gv_SafeInit(Tcl_Interp *interp) {
    return SWIG_init(interp);
}

