/* -*- buffer-read-only: t -*- vi: set ro: */
/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.26
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

/* Implementation : GUILE */

extern "C" {

extern void
SWIG_init (void)
;

}

#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};
#endif

/***********************************************************************
 *
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 *
 ************************************************************************/

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
#  if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#    define SWIGTEMPLATEDISAMBIGUATOR template
#  else
#    define SWIGTEMPLATEDISAMBIGUATOR 
#  endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__) || defined(__ICC)
#   define SWIGUNUSED __attribute__ ((unused)) 
# else
#   define SWIGUNUSED 
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods for Windows DLLs */
#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   define SWIGEXPORT
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif 
#endif


/***********************************************************************
 * swigrun.swg
 *
 *     This file contains generic CAPI SWIG runtime support for pointer
 *     type checking.
 *
 ************************************************************************/

/* This should only be incremented when either the layout of swig_type_info changes,
   or for whatever reason, the runtime changes incompatibly */
#define SWIG_RUNTIME_VERSION "2"

/* define SWIG_TYPE_TABLE_NAME as "SWIG_TYPE_TABLE" */
#ifdef SWIG_TYPE_TABLE
# define SWIG_QUOTE_STRING(x) #x
# define SWIG_EXPAND_AND_QUOTE_STRING(x) SWIG_QUOTE_STRING(x)
# define SWIG_TYPE_TABLE_NAME SWIG_EXPAND_AND_QUOTE_STRING(SWIG_TYPE_TABLE)
#else
# define SWIG_TYPE_TABLE_NAME
#endif

/*
  You can use the SWIGRUNTIME and SWIGRUNTIMEINLINE macros for
  creating a static or dynamic library from the swig runtime code.
  In 99.9% of the cases, swig just needs to declare them as 'static'.
  
  But only do this if is strictly necessary, ie, if you have problems
  with your compiler or so.
*/

#ifndef SWIGRUNTIME
# define SWIGRUNTIME SWIGINTERN
#endif

#ifndef SWIGRUNTIMEINLINE
# define SWIGRUNTIMEINLINE SWIGRUNTIME SWIGINLINE
#endif

#include <string.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

/* Structure to store inforomation on one type */
typedef struct swig_type_info {
  const char             *name;			/* mangled name of this type */
  const char             *str;			/* human readable name of this type */
  swig_dycast_func        dcast;		/* dynamic cast function down a hierarchy */
  struct swig_cast_info  *cast;			/* linked list of types that can cast into this type */
  void                   *clientdata;		/* language specific type data */
} swig_type_info;

/* Structure to store a type and conversion function used for casting */
typedef struct swig_cast_info {
  swig_type_info         *type;			/* pointer to type that is equivalent to this type */
  swig_converter_func     converter;		/* function to cast the void pointers */
  struct swig_cast_info  *next;			/* pointer to next cast in linked list */
  struct swig_cast_info  *prev;			/* pointer to the previous cast */
} swig_cast_info;

/* Structure used to store module information
 * Each module generates one structure like this, and the runtime collects
 * all of these structures and stores them in a circularly linked list.*/
typedef struct swig_module_info {
  swig_type_info         **types;		/* Array of pointers to swig_type_info structures that are in this module */
  size_t                 size;		        /* Number of types in this module */
  struct swig_module_info *next;		/* Pointer to next element in circularly linked list */
  swig_type_info         **type_initial;	/* Array of initially generated type structures */
  swig_cast_info         **cast_initial;	/* Array of initially generated casting structures */
  void                    *clientdata;		/* Language specific module data */
} swig_module_info;


/* 
  Compare two type names skipping the space characters, therefore
  "char*" == "char *" and "Class<int>" == "Class<int >", etc.

  Return 0 when the two name types are equivalent, as in
  strncmp, but skipping ' '.
*/
SWIGRUNTIME int
SWIG_TypeNameComp(const char *f1, const char *l1,
		  const char *f2, const char *l2) {
  for (;(f1 != l1) && (f2 != l2); ++f1, ++f2) {
    while ((*f1 == ' ') && (f1 != l1)) ++f1;
    while ((*f2 == ' ') && (f2 != l2)) ++f2;
    if (*f1 != *f2) return (int)(*f1 - *f2);
  }
  return (l1 - f1) - (l2 - f2);
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
  Return 0 if not equal, 1 if equal
*/
SWIGRUNTIME int
SWIG_TypeEquiv(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = (SWIG_TypeNameComp(nb, ne, tb, te) == 0) ? 1 : 0;
    if (*ne) ++ne;
  }
  return equiv;
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
  Return 0 if equal, -1 if nb < tb, 1 if nb > tb
*/
SWIGRUNTIME int
SWIG_TypeCompare(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = (SWIG_TypeNameComp(nb, ne, tb, te) == 0) ? 1 : 0;
    if (*ne) ++ne;
  }
  return equiv;
}


/* think of this as a c++ template<> or a scheme macro */
#define SWIG_TypeCheck_Template(comparison, ty)         \
  if (ty) {                                             \
    swig_cast_info *iter = ty->cast;                    \
    while (iter) {                                      \
      if (comparison) {                                 \
        if (iter == ty->cast) return iter;              \
        /* Move iter to the top of the linked list */   \
        iter->prev->next = iter->next;                  \
        if (iter->next)                                 \
          iter->next->prev = iter->prev;                \
        iter->next = ty->cast;                          \
        iter->prev = 0;                                 \
        if (ty->cast) ty->cast->prev = iter;            \
        ty->cast = iter;                                \
        return iter;                                    \
      }                                                 \
      iter = iter->next;                                \
    }                                                   \
  }                                                     \
  return 0

/*
  Check the typename
*/
SWIGRUNTIME swig_cast_info *
SWIG_TypeCheck(const char *c, swig_type_info *ty) {
  SWIG_TypeCheck_Template(strcmp(iter->type->name, c) == 0, ty);
}

/* Same as previous function, except strcmp is replaced with a pointer comparison */
SWIGRUNTIME swig_cast_info *
SWIG_TypeCheckStruct(swig_type_info *from, swig_type_info *into) {
  SWIG_TypeCheck_Template(iter->type == from, into);
}

/*
  Cast a pointer up an inheritance hierarchy
*/
SWIGRUNTIMEINLINE void *
SWIG_TypeCast(swig_cast_info *ty, void *ptr) {
  return ((!ty) || (!ty->converter)) ? ptr : (*ty->converter)(ptr);
}

/* 
   Dynamic pointer casting. Down an inheritance hierarchy
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/*
  Return the name associated with this type
*/
SWIGRUNTIMEINLINE const char *
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/*
  Return the pretty name associated with this type,
  that is an unmangled type name in a form presentable to the user.
*/
SWIGRUNTIME const char *
SWIG_TypePrettyName(const swig_type_info *type) {
  /* The "str" field contains the equivalent pretty names of the
     type, separated by vertical-bar characters.  We choose
     to print the last name, as it is often (?) the most
     specific. */
  if (type->str != NULL) {
    const char *last_name = type->str;
    const char *s;
    for (s = type->str; *s; s++)
      if (*s == '|') last_name = s+1;
    return last_name;
  }
  else
    return type->name;
}

/* 
   Set the clientdata field for a type
*/
SWIGRUNTIME void
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_cast_info *cast = ti->cast;
  /* if (ti->clientdata == clientdata) return; */
  ti->clientdata = clientdata;
  
  while (cast) {
    if (!cast->converter) {
      swig_type_info *tc = cast->type;
      if (!tc->clientdata) {
	SWIG_TypeClientData(tc, clientdata);
      }
    }    
    cast = cast->next;
  }
}

/*
  Search for a swig_type_info structure only by mangled name
  Search is a O(log #types)
  
  We start searching at module start, and finish searching when start == end.  
  Note: if start == end at the beginning of the function, we go all the way around
  the circular list.
*/
SWIGRUNTIME swig_type_info *
SWIG_MangledTypeQueryModule(swig_module_info *start, 
                            swig_module_info *end, 
		            const char *name) {
  swig_module_info *iter = start;
  do {
    if (iter->size) {
      register size_t l = 0;
      register size_t r = iter->size - 1;
      do {
	/* since l+r >= 0, we can (>> 1) instead (/ 2) */
	register size_t i = (l + r) >> 1; 
	const char *iname = iter->types[i]->name;
	if (iname) {
	  register int compare = strcmp(name, iname);
	  if (compare == 0) {	    
	    return iter->types[i];
	  } else if (compare < 0) {
	    if (i) {
	      r = i - 1;
	    } else {
	      break;
	    }
	  } else if (compare > 0) {
	    l = i + 1;
	  }
	} else {
	  break; /* should never happen */
	}
      } while (l <= r);
    }
    iter = iter->next;
  } while (iter != end);
  return 0;
}

/*
  Search for a swig_type_info structure for either a mangled name or a human readable name.
  It first searches the mangled names of the types, which is a O(log #types)
  If a type is not found it then searches the human readable names, which is O(#types).
  
  We start searching at module start, and finish searching when start == end.  
  Note: if start == end at the beginning of the function, we go all the way around
  the circular list.
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeQueryModule(swig_module_info *start, 
                     swig_module_info *end, 
		     const char *name) {
  /* STEP 1: Search the name field using binary search */
  swig_type_info *ret = SWIG_MangledTypeQueryModule(start, end, name);
  if (ret) {
    return ret;
  } else {
    /* STEP 2: If the type hasn't been found, do a complete search
       of the str field (the human readable name) */
    swig_module_info *iter = start;
    do {
      register size_t i = 0;
      for (; i < iter->size; ++i) {
	if (iter->types[i]->str && (SWIG_TypeEquiv(iter->types[i]->str, name)))
	  return iter->types[i];
      }
      iter = iter->next;
    } while (iter != end);
  }
  
  /* neither found a match */
  return 0;
}


/* 
   Pack binary data into a string
*/
SWIGRUNTIME char *
SWIG_PackData(char *c, void *ptr, size_t sz) {
  static const char hex[17] = "0123456789abcdef";
  register const unsigned char *u = (unsigned char *) ptr;
  register const unsigned char *eu =  u + sz;
  for (; u != eu; ++u) {
    register unsigned char uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* 
   Unpack binary data from a string
*/
SWIGRUNTIME const char *
SWIG_UnpackData(const char *c, void *ptr, size_t sz) {
  register unsigned char *u = (unsigned char *) ptr;
  register const unsigned char *eu = u + sz;
  for (; u != eu; ++u) {
    register char d = *(c++);
    register unsigned char uu = 0;
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    else 
      return (char *) 0;
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    else 
      return (char *) 0;
    *u = uu;
  }
  return c;
}

/* 
   Pack 'void *' into a string buffer.
*/
SWIGRUNTIME char *
SWIG_PackVoidPtr(char *buff, void *ptr, const char *name, size_t bsz) {
  char *r = buff;
  if ((2*sizeof(void *) + 2) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,&ptr,sizeof(void *));
  if (strlen(name) + 1 > (bsz - (r - buff))) return 0;
  strcpy(r,name);
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackVoidPtr(const char *c, void **ptr, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      *ptr = (void *) 0;
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sizeof(void *));
}

SWIGRUNTIME char *
SWIG_PackDataName(char *buff, void *ptr, size_t sz, const char *name, size_t bsz) {
  char *r = buff;
  size_t lname = (name ? strlen(name) : 0);
  if ((2*sz + 2 + lname) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,ptr,sz);
  if (lname) {
    strncpy(r,name,lname+1);
  } else {
    *r = 0;
  }
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackDataName(const char *c, void *ptr, size_t sz, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      memset(ptr,0,sz);
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sz);
}

#ifdef __cplusplus
}
#endif

/* -*- c -*-
 * -----------------------------------------------------------------------
 * swig_lib/guile/guile_scm_run.swg
 *
 * Author: John Lenz <jelenz@wisc.edu>
 * ----------------------------------------------------------------------- */

#include <libguile.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef SCM (*swig_guile_proc)();
typedef SCM (*guile_destructor)(SCM);

typedef struct swig_guile_clientdata {
  guile_destructor destroy;
  SCM goops_class;
} swig_guile_clientdata;

#define SWIG_scm2str(s) \
  SWIG_Guile_scm2newstr(s, NULL)
#define SWIG_malloc(size) \
  SCM_MUST_MALLOC(size)
#define SWIG_free(mem) \
  scm_must_free(mem)
#define SWIG_ConvertPtr(s, result, type, flags) \
  SWIG_Guile_ConvertPtr(s, result, type, flags)
#define SWIG_MustGetPtr(s, type, argnum, flags) \
  SWIG_Guile_MustGetPtr(s, type, argnum, flags, FUNC_NAME)
#define SWIG_NewPointerObj(ptr, type, owner) \
  SWIG_Guile_NewPointerObj((void*)ptr, type, owner)
#define SWIG_PointerAddress(object) \
  SWIG_Guile_PointerAddress(object)
#define SWIG_PointerType(object) \
  SWIG_Guile_PointerType(object)
#define SWIG_IsPointerOfType(object, type) \
  SWIG_Guile_IsPointerOfType(object, type)
#define SWIG_IsPointer(object) \
  SWIG_Guile_IsPointer(object)
#define SWIG_contract_assert(expr, msg)				\
  if (!(expr))							\
    scm_error(scm_str2symbol("swig-contract-assertion-failed"),	\
	      (char *) FUNC_NAME, (char *) msg,			\
	      SCM_EOL, SCM_BOOL_F); else

/* Runtime API */
#define SWIG_GetModule(clientdata) SWIG_Guile_GetModule()
#define SWIG_SetModule(clientdata, pointer) SWIG_Guile_SetModule(pointer)
  
static char *
SWIG_Guile_scm2newstr(SCM str, size_t *len) {
#define FUNC_NAME "SWIG_Guile_scm2newstr"
  char *ret;
  size_t l;

  SCM_ASSERT (SCM_STRINGP(str), str, 1, FUNC_NAME);
  
  l = SCM_STRING_LENGTH(str);
  ret = (char *) SWIG_malloc( (l + 1) * sizeof(char));
  if (!ret) return NULL;

  memcpy(ret, SCM_STRING_CHARS(str), l);
  ret[l] = '\0';
  if (len) *len = l;
  return ret;
#undef FUNC_NAME
}

static int swig_initialized = 0;
static scm_t_bits swig_tag = 0;
static scm_t_bits swig_collectable_tag = 0;
static scm_t_bits swig_destroyed_tag = 0;
static SCM swig_make_func = SCM_EOL;
static SCM swig_keyword = SCM_EOL;
static SCM swig_symbol = SCM_EOL;

#define SWIG_Guile_GetSmob(x) \
  ( SCM_NNULLP(x) && SCM_INSTANCEP(x) && SCM_NFALSEP(scm_slot_exists_p(x, swig_symbol)) \
      ? scm_slot_ref(x, swig_symbol) : (x) )

static SCM
SWIG_Guile_NewPointerObj(void *ptr, swig_type_info *type, int owner)
{
  if (ptr == NULL)
    return SCM_EOL;
  else {
    SCM smob;
    swig_guile_clientdata *cdata = (swig_guile_clientdata *) type->clientdata;
    if (owner)
      SCM_NEWSMOB2(smob, swig_collectable_tag, ptr, (void *) type);
    else
      SCM_NEWSMOB2(smob, swig_tag, ptr, (void *) type);

    if (!cdata || SCM_NULLP(cdata->goops_class) || swig_make_func == SCM_EOL ) {
      return smob;
    } else {
      /* the scm_make() C function only handles the creation of gf,
	 methods and classes (no instances) the (make ...) function is
	 later redefined in goops.scm.  So we need to call that
	 Scheme function. */
      return scm_apply(swig_make_func,
		       scm_list_3(cdata->goops_class,
				  swig_keyword,
				  smob),
		       SCM_EOL);
    }
  }
}

static unsigned long
SWIG_Guile_PointerAddress(SCM object)
{
  SCM smob = SWIG_Guile_GetSmob(object);
  if (SCM_NULLP(smob)) return 0;
  else if (SCM_SMOB_PREDICATE(swig_tag, smob)
	   || SCM_SMOB_PREDICATE(swig_collectable_tag, smob)
	   || SCM_SMOB_PREDICATE(swig_destroyed_tag, smob)) {
    return (unsigned long) (void *) SCM_CELL_WORD_1(smob);
  }
  else scm_wrong_type_arg("SWIG-Guile-PointerAddress", 1, object);
}

static swig_type_info *
SWIG_Guile_PointerType(SCM object)
{
  SCM smob = SWIG_Guile_GetSmob(object);
  if (SCM_NULLP(smob)) return NULL;
  else if (SCM_SMOB_PREDICATE(swig_tag, smob)
	   || SCM_SMOB_PREDICATE(swig_collectable_tag, smob)
	   || SCM_SMOB_PREDICATE(swig_destroyed_tag, smob)) {
    return (swig_type_info *) SCM_CELL_WORD_2(smob);
  }
  else scm_wrong_type_arg("SWIG-Guile-PointerType", 1, object);
}
  
/* Return 0 if successful. */
static int
SWIG_Guile_ConvertPtr(SCM s, void **result, swig_type_info *type, int flags)
{
  swig_cast_info *cast;
  swig_type_info *from;
  SCM smob = SWIG_Guile_GetSmob(s);

  if (SCM_NULLP(smob)) {
    *result = NULL;
    return 0;
  } else if (SCM_SMOB_PREDICATE(swig_tag, smob) || SCM_SMOB_PREDICATE(swig_collectable_tag, smob)) {
    /* we do not accept smobs representing destroyed pointers */
    from = (swig_type_info *) SCM_CELL_WORD_2(smob);
    if (!from) return 1;
    if (type) {
      cast = SWIG_TypeCheckStruct(from, type);
      if (cast) {
        *result = SWIG_TypeCast(cast, (void *) SCM_CELL_WORD_1(smob));
        return 0;
      } else {
        return 1;
      }
    } else {
      *result = (void *) SCM_CELL_WORD_1(smob);
      return 0;
    }
  }
  return 1;
}

static SWIGINLINE void *
SWIG_Guile_MustGetPtr (SCM s, swig_type_info *type,
		       int argnum, int flags, const char *func_name)
{
  void *result;
  if (SWIG_Guile_ConvertPtr(s, &result, type, flags)) {
    /* type mismatch */
    scm_wrong_type_arg((char *) func_name, argnum, s);
  }
  return result;
}

static SWIGINLINE int
SWIG_Guile_IsPointerOfType (SCM s, swig_type_info *type)
{
  void *result;
  if (SWIG_Guile_ConvertPtr(s, &result, type, 0)) {
    /* type mismatch */
    return 0;
  }
  else return 1;
}

static SWIGINLINE int
SWIG_Guile_IsPointer (SCM s)
{
  return SWIG_Guile_IsPointerOfType (s, NULL);
}

/* Mark a pointer object non-collectable */
static void
SWIG_Guile_MarkPointerNoncollectable(SCM s)
{
  SCM smob = SWIG_Guile_GetSmob(s);
  if (!SCM_NULLP(smob)) {
    if (SCM_SMOB_PREDICATE(swig_tag, smob) || SCM_SMOB_PREDICATE(swig_collectable_tag, smob)) {
      SCM_SET_CELL_TYPE(smob, swig_tag);
    }
    else scm_wrong_type_arg(NULL, 0, s);
  }
}

/* Mark a pointer object destroyed */
static void
SWIG_Guile_MarkPointerDestroyed(SCM s)
{
  SCM smob = SWIG_Guile_GetSmob(s);
  if (!SCM_NULLP(smob)) {
    if (SCM_SMOB_PREDICATE(swig_tag, smob) || SCM_SMOB_PREDICATE(swig_collectable_tag, smob)) {
      SCM_SET_CELL_TYPE(smob, swig_destroyed_tag);
    }
    else scm_wrong_type_arg(NULL, 0, s);
  }
}

/* Init */

static int
print_swig_aux (SCM swig_smob, SCM port, scm_print_state *pstate, const char *attribute)
{
  swig_type_info *type;
  
  type = (swig_type_info *) SCM_CELL_WORD_2(swig_smob);
  if (type) {
    scm_puts((char *) "#<", port);
    scm_puts((char *) attribute, port);
    scm_puts((char *) "swig-pointer ", port);
    scm_puts((char *) SWIG_TypePrettyName(type), port);
    scm_puts((char *) " ", port);
    scm_intprint((long) SCM_CELL_WORD_1(swig_smob), 16, port);
    scm_puts((char *) ">", port);
    /* non-zero means success */
    return 1;
  } else {
    return 0;
  }
}

  
static int
print_swig (SCM swig_smob, SCM port, scm_print_state *pstate)
{
  return print_swig_aux(swig_smob, port, pstate, "");
}

static int
print_collectable_swig (SCM swig_smob, SCM port, scm_print_state *pstate)
{
  return print_swig_aux(swig_smob, port, pstate, "collectable-");
}

static int
print_destroyed_swig (SCM swig_smob, SCM port, scm_print_state *pstate)
{
  return print_swig_aux(swig_smob, port, pstate, "destroyed-");
}

static SCM
equalp_swig (SCM A, SCM B)
{
  if (SCM_CELL_WORD_0(A) == SCM_CELL_WORD_0(B) && SCM_CELL_WORD_1(A) == SCM_CELL_WORD_1(B) 
      && SCM_CELL_WORD_2(A) == SCM_CELL_WORD_2(B))
    return SCM_BOOL_T;
  else return SCM_BOOL_F;
}

static size_t
free_swig(SCM A)
{
  swig_type_info *type = (swig_type_info *) SCM_CELL_WORD_2(A);
  if (type) {
    if (type->clientdata && ((swig_guile_clientdata *)type->clientdata)->destroy)
      ((swig_guile_clientdata *)type->clientdata)->destroy(A);
  } 
  return 0;
}

static int
ensure_smob_tag(SCM swig_module,
		scm_t_bits *tag_variable,
		const char *smob_name,
		const char *scheme_variable_name)
{
  SCM variable = scm_sym2var(scm_str2symbol(scheme_variable_name),
			     scm_module_lookup_closure(swig_module),
			     SCM_BOOL_T);
  if (SCM_UNBNDP(SCM_VARIABLE_REF(variable))) {
    *tag_variable = scm_make_smob_type((char*)scheme_variable_name, 0);
    SCM_VARIABLE_SET(variable,
		     scm_ulong2num(*tag_variable));
    return 1;
  }
  else {
    *tag_variable = scm_num2ulong(SCM_VARIABLE_REF(variable), 0,
				  "SWIG_Guile_Init");
    return 0;
  }
}

static SCM
SWIG_Guile_Init ()
{
  static SCM swig_module;
  
  if (swig_initialized) return swig_module;
  swig_initialized = 1;

  swig_module = scm_c_resolve_module("Swig swigrun");
  if (ensure_smob_tag(swig_module, &swig_tag,
		      "swig-pointer", "swig-pointer-tag")) {
    scm_set_smob_print(swig_tag, print_swig);
    scm_set_smob_equalp(swig_tag, equalp_swig);
  }
  if (ensure_smob_tag(swig_module, &swig_collectable_tag,
		      "collectable-swig-pointer", "collectable-swig-pointer-tag")) {
    scm_set_smob_print(swig_collectable_tag, print_collectable_swig);
    scm_set_smob_equalp(swig_collectable_tag, equalp_swig);
    scm_set_smob_free(swig_collectable_tag, free_swig);
  }
  if (ensure_smob_tag(swig_module, &swig_destroyed_tag,
		      "destroyed-swig-pointer", "destroyed-swig-pointer-tag")) {
    scm_set_smob_print(swig_destroyed_tag, print_destroyed_swig);
    scm_set_smob_equalp(swig_destroyed_tag, equalp_swig);
  }
  swig_make_func = scm_permanent_object(
  scm_variable_ref(scm_c_module_lookup(scm_c_resolve_module("oop goops"), "make")));
  swig_keyword = scm_permanent_object(scm_c_make_keyword((char*) "init-smob"));
  swig_symbol = scm_permanent_object(scm_str2symbol("swig-smob"));
#ifdef SWIG_INIT_RUNTIME_MODULE
  SWIG_INIT_RUNTIME_MODULE
#endif

  return swig_module;
}

static swig_module_info *
SWIG_Guile_GetModule()
{
  SCM module;
  SCM variable;

  module = SWIG_Guile_Init();

  variable = scm_sym2var(scm_str2symbol("swig-type-list-address" SWIG_RUNTIME_VERSION SWIG_TYPE_TABLE_NAME),
			       scm_module_lookup_closure(module),
			       SCM_BOOL_T);
  if (SCM_UNBNDP(SCM_VARIABLE_REF(variable))) {
    return NULL;
  } else {
    return (swig_module_info *) scm_num2ulong(SCM_VARIABLE_REF(variable), 0, "SWIG_Guile_Init");
  }
}

static void
SWIG_Guile_SetModule(swig_module_info *swig_module)
{
  SCM module;
  SCM variable;

  module = SWIG_Guile_Init();
    
  variable = scm_sym2var(scm_str2symbol("swig-type-list-address" SWIG_RUNTIME_VERSION SWIG_TYPE_TABLE_NAME),
			       scm_module_lookup_closure(module),
			       SCM_BOOL_T);

  SCM_VARIABLE_SET(variable, scm_ulong2num((unsigned long) swig_module));
}

static int
SWIG_Guile_GetArgs (SCM *dest, SCM rest,
		    int reqargs, int optargs,
		    const char *procname)
{
  int i;
  int num_args_passed = 0;
  for (i = 0; i<reqargs; i++) {
    if (!SCM_CONSP(rest))
      scm_wrong_num_args(scm_makfrom0str((char *) procname));
    *dest++ = SCM_CAR(rest);
    rest = SCM_CDR(rest);
    num_args_passed++;
  }
  for (i = 0; i<optargs && SCM_CONSP(rest); i++) {
    *dest++ = SCM_CAR(rest);
    rest = SCM_CDR(rest);
    num_args_passed++;
  }
  for (; i<optargs; i++)
    *dest++ = SCM_UNDEFINED;
  if (!SCM_NULLP(rest))
    scm_wrong_num_args(scm_makfrom0str((char *) procname));
  return num_args_passed;
}

#ifdef __cplusplus
}
#endif



#define GUILE_MAYBE_VALUES \
      if (gswig_list_p) gswig_result = scm_values(gswig_result);

#define GUILE_MAYBE_VECTOR \
      if (gswig_list_p) gswig_result = scm_vector(gswig_result);

#define SWIG_APPEND_VALUE(object)						\
    if (gswig_result == SCM_UNSPECIFIED)						\
        gswig_result = object;							\
    else {									\
      if (!gswig_list_p) {							\
	      gswig_list_p = 1;							\
	      gswig_result = scm_listify(gswig_result, object, SCM_UNDEFINED);	\
      }									\
      else									\
            gswig_result = scm_append(scm_listify(gswig_result, scm_listify(object, SCM_UNDEFINED), SCM_UNDEFINED));		\
    }
    /* used by Lib/exception.i */
    #define gh_symbol2scm scm_str2symbol
    /* useb by Lib/cdata.i */
    #define gh_str2scm scm_mem2string



/* -------- TYPES TABLE (BEGIN) -------- */

#define SWIGTYPE_p_Agedge_t swig_types[0]
#define SWIGTYPE_p_Agnode_t swig_types[1]
#define SWIGTYPE_p_Agraph_t swig_types[2]
#define SWIGTYPE_p_Agsym_t swig_types[3]
#define SWIGTYPE_p_FILE swig_types[4]
#define SWIGTYPE_p_p_void swig_types[5]
#define SWIGTYPE_p_unsigned_long swig_types[6]
static swig_type_info *swig_types[8];
static swig_module_info swig_module = {swig_types, 7, 0, 0, 0, 0};
#define SWIG_TypeQuery(name) SWIG_TypeQueryModule(&swig_module, &swig_module, name)
#define SWIG_MangledTypeQuery(name) SWIG_MangledTypeQueryModule(&swig_module, &swig_module, name)

/* -------- TYPES TABLE (END) -------- */



/* some language headers (e.g. php.h, ruby.h) leave these defined */
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION
#undef PACKAGE_NAME

#include "gvc.h"


/** New graphs */
/*** New empty graph */
extern Agraph_t *graph(char *name);
extern Agraph_t *digraph(char *name);
extern Agraph_t *strictgraph(char *name);
extern Agraph_t *strictdigraph(char *name);
/*** New graph from a dot-syntax string or file */
extern Agraph_t *readstring(char *string);
extern Agraph_t *read(char *filename);
extern Agraph_t *read(FILE *f);	
/*** Add new subgraph to existing graph */
extern Agraph_t *graph(Agraph_t *g, char *name);

/** New nodes */
/*** Add new node to existing graph */
extern Agnode_t *node(Agraph_t *g, char *name);

/** New edges */
/*** Add new edge between existing nodes */
extern Agedge_t *edge(Agnode_t *t, Agnode_t *h);
/*** Add a new edge between an existing tail node, and a named head node which will be induced in the graph if it doesn't already exist */
extern Agedge_t *edge(Agnode_t *t, char *hname);
/*** Add a new edge between an existing head node, and a named tail node which will be induced in the graph if it doesn't already exist */
extern Agedge_t *edge(char *tname, Agnode_t *h);
/*** Add a new edge between named tail  and head nodes which will be induced in the graph if they don't already exist */
extern Agedge_t *edge(Agraph_t *g, char *tname, char *hname);

/** Setting attribute values */
/*** Set value of named attribute of graph/node/edge - creating attribute if necessary */
extern char *setv(Agraph_t *g, char *attr, char *val);
extern char *setv(Agnode_t *n, char *attr, char *val);
extern char *setv(Agedge_t *e, char *attr, char *val);

/*** Set value of existing attribute of graph/node/edge (using attribute handle) */
extern char *setv(Agraph_t *g, Agsym_t *a, char *val);
extern char *setv(Agnode_t *n, Agsym_t *a, char *val);
extern char *setv(Agedge_t *e, Agsym_t *a, char *val);

/** Getting attribute values */
/*** Get value of named attribute of graph/node/edge */
extern char *getv(Agraph_t *g, char *attr);
extern char *getv(Agnode_t *n, char *attr);
extern char *getv(Agedge_t *e, char *attr);

/*** Get value of attribute of graph/node/edge (using attribute handle) */
extern char *getv(Agraph_t *g, Agsym_t *a);
extern char *getv(Agnode_t *n, Agsym_t *a);
extern char *getv(Agedge_t *e, Agsym_t *a);

/** Obtain names from handles */
extern char *nameof(Agraph_t *g);
extern char *nameof(Agnode_t *n);
//extern char *nameof(Agedge_t *e);
extern char *nameof(Agsym_t *a);

/** Find handles from names */
extern Agraph_t *findsubg(Agraph_t *g, char *name);
extern Agnode_t *findnode(Agraph_t *g, char *name);
extern Agedge_t *findedge(Agnode_t *t, Agnode_t *h);

/** */
extern Agsym_t *findattr(Agraph_t *g, char *name);
extern Agsym_t *findattr(Agnode_t *n, char *name);
extern Agsym_t *findattr(Agedge_t *e, char *name);

/** Misc graph navigators returning handles */
extern Agnode_t *headof(Agedge_t *e);
extern Agnode_t *tailof(Agedge_t *e);
extern Agraph_t *graphof(Agraph_t *g);
extern Agraph_t *graphof(Agedge_t *e);
extern Agraph_t *graphof(Agnode_t *n);
extern Agraph_t *rootof(Agraph_t *g);

/** Obtain handles of proto node/edge for setting default attribute values */
extern Agnode_t *protonode(Agraph_t *g);
extern Agedge_t *protoedge(Agraph_t *g);

/** Iterators */
/*** Iteration termination tests */
extern bool ok(Agraph_t *g);
extern bool ok(Agnode_t *n);
extern bool ok(Agedge_t *e);
extern bool ok(Agsym_t *a);

/*** Iterate over subgraphs of a graph */
extern Agraph_t *firstsubg(Agraph_t *g);
extern Agraph_t *nextsubg(Agraph_t *g, Agraph_t *sg);

/*** Iterate over supergraphs of a graph (obscure and rarely useful) */
extern Agraph_t *firstsupg(Agraph_t *g);
extern Agraph_t *nextsupg(Agraph_t *g, Agraph_t *sg);

/*** Iterate over edges of a graph */
extern Agedge_t *firstedge(Agraph_t *g);
extern Agedge_t *nextedge(Agraph_t *g, Agedge_t *e);

/*** Iterate over outedges of a graph */
extern Agedge_t *firstout(Agraph_t *g);
extern Agedge_t *nextout(Agraph_t *g, Agedge_t *e);

/*** Iterate over edges of a node */
extern Agedge_t *firstedge(Agnode_t *n);
extern Agedge_t *nextedge(Agnode_t *n, Agedge_t *e);

/*** Iterate over out-edges of a node */
extern Agedge_t *firstout(Agnode_t *n);
extern Agedge_t *nextout(Agnode_t *n, Agedge_t *e);

/*** Iterate over head nodes reachable from out-edges of a node */
extern Agnode_t *firsthead(Agnode_t *n);
extern Agnode_t *nexthead(Agnode_t *n, Agnode_t *h);

/*** Iterate over in-edges of a graph */
extern Agedge_t *firstin(Agraph_t *g);
extern Agedge_t *nextin(Agnode_t *n, Agedge_t *e);

/*** Iterate over in-edges of a node */
extern Agedge_t *firstin(Agnode_t *n);
extern Agedge_t *nextin(Agraph_t *g, Agedge_t *e);

/*** Iterate over tail nodes reachable from in-edges of a node */
extern Agnode_t *firsttail(Agnode_t *n);
extern Agnode_t *nexttail(Agnode_t *n, Agnode_t *t);

/*** Iterate over nodes of a graph */
extern Agnode_t *firstnode(Agraph_t *g);
extern Agnode_t *nextnode(Agraph_t *g, Agnode_t *n);

/*** Iterate over nodes of an edge */
extern Agnode_t *firstnode(Agedge_t *e);
extern Agnode_t *nextnode(Agedge_t *e, Agnode_t *n);

/*** Iterate over attributes of a graph */
extern Agsym_t *firstattr(Agraph_t *g);
extern Agsym_t *nextattr(Agraph_t *g, Agsym_t *a);

/*** Iterate over attributes of an edge */
extern Agsym_t *firstattr(Agedge_t *e);
extern Agsym_t *nextattr(Agedge_t *e, Agsym_t *a);

/*** Iterate over attributes of a node */
extern Agsym_t *firstattr(Agnode_t *n);
extern Agsym_t *nextattr(Agnode_t *n, Agsym_t *a);

/** Remove graph objects */
extern void rm(Agraph_t *g);
extern void rm(Agnode_t *n);
extern void rm(Agedge_t *e);

/** Layout */
/*** Annotate a graph with layout attributes and values using a specific layout engine */
extern void layout(Agraph_t *g, char *engine);

/** Render */
/*** Render a layout into attributes of the graph */
extern void render(Agraph_t *g); 

/*** Render a layout in a specific format */
extern void render(Agraph_t *g, char *format);
extern void render(Agraph_t *g, char *format, char *filename);
extern void render(Agraph_t *g, char *format, FILE *f);
extern void render(Agraph_t *g, char *format, void **data);

static SCM
_wrap_graph__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "graph"
    char *arg1 = (char *) 0 ;
    Agraph_t *result;
    int must_free1 = 0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = SWIG_scm2str(argv[0]);
        must_free1 = 1;
    }
    result = (Agraph_t *)graph(arg1);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agraph_t, 0);
    }
    if (must_free1 && arg1) SWIG_free(arg1);
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_digraph (SCM s_0)
{
#define FUNC_NAME "digraph"
    char *arg1 = (char *) 0 ;
    Agraph_t *result;
    int must_free1 = 0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = SWIG_scm2str(s_0);
        must_free1 = 1;
    }
    result = (Agraph_t *)digraph(arg1);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agraph_t, 0);
    }
    if (must_free1 && arg1) SWIG_free(arg1);
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_strictgraph (SCM s_0)
{
#define FUNC_NAME "strictgraph"
    char *arg1 = (char *) 0 ;
    Agraph_t *result;
    int must_free1 = 0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = SWIG_scm2str(s_0);
        must_free1 = 1;
    }
    result = (Agraph_t *)strictgraph(arg1);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agraph_t, 0);
    }
    if (must_free1 && arg1) SWIG_free(arg1);
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_strictdigraph (SCM s_0)
{
#define FUNC_NAME "strictdigraph"
    char *arg1 = (char *) 0 ;
    Agraph_t *result;
    int must_free1 = 0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = SWIG_scm2str(s_0);
        must_free1 = 1;
    }
    result = (Agraph_t *)strictdigraph(arg1);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agraph_t, 0);
    }
    if (must_free1 && arg1) SWIG_free(arg1);
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_readstring (SCM s_0)
{
#define FUNC_NAME "readstring"
    char *arg1 = (char *) 0 ;
    Agraph_t *result;
    int must_free1 = 0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = SWIG_scm2str(s_0);
        must_free1 = 1;
    }
    result = (Agraph_t *)readstring(arg1);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agraph_t, 0);
    }
    if (must_free1 && arg1) SWIG_free(arg1);
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_read__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "read"
    char *arg1 = (char *) 0 ;
    Agraph_t *result;
    int must_free1 = 0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = SWIG_scm2str(argv[0]);
        must_free1 = 1;
    }
    result = (Agraph_t *)read(arg1);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agraph_t, 0);
    }
    if (must_free1 && arg1) SWIG_free(arg1);
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_read__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "read"
    FILE *arg1 = (FILE *) 0 ;
    Agraph_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (FILE *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_FILE, 1, 0);
    }
    result = (Agraph_t *)read(arg1);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agraph_t, 0);
    }
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_read(SCM rest)
{
#define FUNC_NAME "read"
    SCM argv[1];
    int argc = SWIG_Guile_GetArgs (argv, rest, 0, 1, "read");
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FILE, 0);
        }
        if (_v) {
            return _wrap_read__SWIG_1(argc,argv);
        }
    }
    if (argc == 1) {
        int _v;
        {
            _v = SCM_STRINGP(argv[0]) ? 1 : 0;
        }
        if (_v) {
            return _wrap_read__SWIG_0(argc,argv);
        }
    }
    
    scm_misc_error("read", "No matching method for generic function `read'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_graph__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "graph"
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *arg2 = (char *) 0 ;
    Agraph_t *result;
    int must_free2 = 0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agraph_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agraph_t, 1, 0);
    }
    {
        arg2 = SWIG_scm2str(argv[1]);
        must_free2 = 1;
    }
    result = (Agraph_t *)graph(arg1,arg2);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agraph_t, 0);
    }
    
    if (must_free2 && arg2) SWIG_free(arg2);
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_graph(SCM rest)
{
#define FUNC_NAME "graph"
    SCM argv[2];
    int argc = SWIG_Guile_GetArgs (argv, rest, 0, 2, "graph");
    if (argc == 1) {
        int _v;
        {
            _v = SCM_STRINGP(argv[0]) ? 1 : 0;
        }
        if (_v) {
            return _wrap_graph__SWIG_0(argc,argv);
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agraph_t, 0);
        }
        if (_v) {
            {
                _v = SCM_STRINGP(argv[1]) ? 1 : 0;
            }
            if (_v) {
                return _wrap_graph__SWIG_1(argc,argv);
            }
        }
    }
    
    scm_misc_error("graph", "No matching method for generic function `graph'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_node (SCM s_0, SCM s_1)
{
#define FUNC_NAME "node"
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *arg2 = (char *) 0 ;
    Agnode_t *result;
    int must_free2 = 0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agraph_t *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_Agraph_t, 1, 0);
    }
    {
        arg2 = SWIG_scm2str(s_1);
        must_free2 = 1;
    }
    result = (Agnode_t *)node(arg1,arg2);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agnode_t, 0);
    }
    
    if (must_free2 && arg2) SWIG_free(arg2);
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_edge__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "edge"
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agnode_t *arg2 = (Agnode_t *) 0 ;
    Agedge_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agnode_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agnode_t, 1, 0);
    }
    {
        arg2 = (Agnode_t *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Agnode_t, 2, 0);
    }
    result = (Agedge_t *)edge(arg1,arg2);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agedge_t, 0);
    }
    
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_edge__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "edge"
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    char *arg2 = (char *) 0 ;
    Agedge_t *result;
    int must_free2 = 0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agnode_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agnode_t, 1, 0);
    }
    {
        arg2 = SWIG_scm2str(argv[1]);
        must_free2 = 1;
    }
    result = (Agedge_t *)edge(arg1,arg2);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agedge_t, 0);
    }
    
    if (must_free2 && arg2) SWIG_free(arg2);
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_edge__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "edge"
    char *arg1 = (char *) 0 ;
    Agnode_t *arg2 = (Agnode_t *) 0 ;
    Agedge_t *result;
    int must_free1 = 0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = SWIG_scm2str(argv[0]);
        must_free1 = 1;
    }
    {
        arg2 = (Agnode_t *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Agnode_t, 2, 0);
    }
    result = (Agedge_t *)edge(arg1,arg2);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agedge_t, 0);
    }
    if (must_free1 && arg1) SWIG_free(arg1);
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_edge__SWIG_3 (int argc, SCM *argv)
{
#define FUNC_NAME "edge"
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *arg2 = (char *) 0 ;
    char *arg3 = (char *) 0 ;
    Agedge_t *result;
    int must_free2 = 0 ;
    int must_free3 = 0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agraph_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agraph_t, 1, 0);
    }
    {
        arg2 = SWIG_scm2str(argv[1]);
        must_free2 = 1;
    }
    {
        arg3 = SWIG_scm2str(argv[2]);
        must_free3 = 1;
    }
    result = (Agedge_t *)edge(arg1,arg2,arg3);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agedge_t, 0);
    }
    
    if (must_free2 && arg2) SWIG_free(arg2);
    if (must_free3 && arg3) SWIG_free(arg3);
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_edge(SCM rest)
{
#define FUNC_NAME "edge"
    SCM argv[3];
    int argc = SWIG_Guile_GetArgs (argv, rest, 0, 3, "edge");
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agnode_t, 0);
        }
        if (_v) {
            {
                void *ptr;
                _v = !SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Agnode_t, 0);
            }
            if (_v) {
                return _wrap_edge__SWIG_0(argc,argv);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agnode_t, 0);
        }
        if (_v) {
            {
                _v = SCM_STRINGP(argv[1]) ? 1 : 0;
            }
            if (_v) {
                return _wrap_edge__SWIG_1(argc,argv);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            _v = SCM_STRINGP(argv[0]) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = !SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Agnode_t, 0);
            }
            if (_v) {
                return _wrap_edge__SWIG_2(argc,argv);
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agraph_t, 0);
        }
        if (_v) {
            {
                _v = SCM_STRINGP(argv[1]) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = SCM_STRINGP(argv[2]) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_edge__SWIG_3(argc,argv);
                }
            }
        }
    }
    
    scm_misc_error("edge", "No matching method for generic function `edge'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_setv__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "setv"
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *arg2 = (char *) 0 ;
    char *arg3 = (char *) 0 ;
    char *result;
    int must_free2 = 0 ;
    int must_free3 = 0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agraph_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agraph_t, 1, 0);
    }
    {
        arg2 = SWIG_scm2str(argv[1]);
        must_free2 = 1;
    }
    {
        arg3 = SWIG_scm2str(argv[2]);
        must_free3 = 1;
    }
    result = (char *)setv(arg1,arg2,arg3);
    
    {
        gswig_result = scm_makfrom0str(result);
    }
    
    if (must_free2 && arg2) SWIG_free(arg2);
    if (must_free3 && arg3) SWIG_free(arg3);
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_setv__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "setv"
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    char *arg2 = (char *) 0 ;
    char *arg3 = (char *) 0 ;
    char *result;
    int must_free2 = 0 ;
    int must_free3 = 0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agnode_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agnode_t, 1, 0);
    }
    {
        arg2 = SWIG_scm2str(argv[1]);
        must_free2 = 1;
    }
    {
        arg3 = SWIG_scm2str(argv[2]);
        must_free3 = 1;
    }
    result = (char *)setv(arg1,arg2,arg3);
    
    {
        gswig_result = scm_makfrom0str(result);
    }
    
    if (must_free2 && arg2) SWIG_free(arg2);
    if (must_free3 && arg3) SWIG_free(arg3);
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_setv__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "setv"
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    char *arg2 = (char *) 0 ;
    char *arg3 = (char *) 0 ;
    char *result;
    int must_free2 = 0 ;
    int must_free3 = 0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agedge_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agedge_t, 1, 0);
    }
    {
        arg2 = SWIG_scm2str(argv[1]);
        must_free2 = 1;
    }
    {
        arg3 = SWIG_scm2str(argv[2]);
        must_free3 = 1;
    }
    result = (char *)setv(arg1,arg2,arg3);
    
    {
        gswig_result = scm_makfrom0str(result);
    }
    
    if (must_free2 && arg2) SWIG_free(arg2);
    if (must_free3 && arg3) SWIG_free(arg3);
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_setv__SWIG_3 (int argc, SCM *argv)
{
#define FUNC_NAME "setv"
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agsym_t *arg2 = (Agsym_t *) 0 ;
    char *arg3 = (char *) 0 ;
    char *result;
    int must_free3 = 0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agraph_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agraph_t, 1, 0);
    }
    {
        arg2 = (Agsym_t *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Agsym_t, 2, 0);
    }
    {
        arg3 = SWIG_scm2str(argv[2]);
        must_free3 = 1;
    }
    result = (char *)setv(arg1,arg2,arg3);
    
    {
        gswig_result = scm_makfrom0str(result);
    }
    
    
    if (must_free3 && arg3) SWIG_free(arg3);
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_setv__SWIG_4 (int argc, SCM *argv)
{
#define FUNC_NAME "setv"
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agsym_t *arg2 = (Agsym_t *) 0 ;
    char *arg3 = (char *) 0 ;
    char *result;
    int must_free3 = 0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agnode_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agnode_t, 1, 0);
    }
    {
        arg2 = (Agsym_t *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Agsym_t, 2, 0);
    }
    {
        arg3 = SWIG_scm2str(argv[2]);
        must_free3 = 1;
    }
    result = (char *)setv(arg1,arg2,arg3);
    
    {
        gswig_result = scm_makfrom0str(result);
    }
    
    
    if (must_free3 && arg3) SWIG_free(arg3);
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_setv__SWIG_5 (int argc, SCM *argv)
{
#define FUNC_NAME "setv"
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    Agsym_t *arg2 = (Agsym_t *) 0 ;
    char *arg3 = (char *) 0 ;
    char *result;
    int must_free3 = 0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agedge_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agedge_t, 1, 0);
    }
    {
        arg2 = (Agsym_t *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Agsym_t, 2, 0);
    }
    {
        arg3 = SWIG_scm2str(argv[2]);
        must_free3 = 1;
    }
    result = (char *)setv(arg1,arg2,arg3);
    
    {
        gswig_result = scm_makfrom0str(result);
    }
    
    
    if (must_free3 && arg3) SWIG_free(arg3);
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_setv(SCM rest)
{
#define FUNC_NAME "setv"
    SCM argv[3];
    int argc = SWIG_Guile_GetArgs (argv, rest, 0, 3, "setv");
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agraph_t, 0);
        }
        if (_v) {
            {
                void *ptr;
                _v = !SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Agsym_t, 0);
            }
            if (_v) {
                {
                    _v = SCM_STRINGP(argv[2]) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_setv__SWIG_3(argc,argv);
                }
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agnode_t, 0);
        }
        if (_v) {
            {
                void *ptr;
                _v = !SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Agsym_t, 0);
            }
            if (_v) {
                {
                    _v = SCM_STRINGP(argv[2]) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_setv__SWIG_4(argc,argv);
                }
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agedge_t, 0);
        }
        if (_v) {
            {
                void *ptr;
                _v = !SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Agsym_t, 0);
            }
            if (_v) {
                {
                    _v = SCM_STRINGP(argv[2]) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_setv__SWIG_5(argc,argv);
                }
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agraph_t, 0);
        }
        if (_v) {
            {
                _v = SCM_STRINGP(argv[1]) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = SCM_STRINGP(argv[2]) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_setv__SWIG_0(argc,argv);
                }
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agnode_t, 0);
        }
        if (_v) {
            {
                _v = SCM_STRINGP(argv[1]) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = SCM_STRINGP(argv[2]) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_setv__SWIG_1(argc,argv);
                }
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agedge_t, 0);
        }
        if (_v) {
            {
                _v = SCM_STRINGP(argv[1]) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = SCM_STRINGP(argv[2]) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_setv__SWIG_2(argc,argv);
                }
            }
        }
    }
    
    scm_misc_error("setv", "No matching method for generic function `setv'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_getv__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "getv"
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *arg2 = (char *) 0 ;
    char *result;
    int must_free2 = 0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agraph_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agraph_t, 1, 0);
    }
    {
        arg2 = SWIG_scm2str(argv[1]);
        must_free2 = 1;
    }
    result = (char *)getv(arg1,arg2);
    
    {
        gswig_result = scm_makfrom0str(result);
    }
    
    if (must_free2 && arg2) SWIG_free(arg2);
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_getv__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "getv"
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    char *arg2 = (char *) 0 ;
    char *result;
    int must_free2 = 0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agnode_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agnode_t, 1, 0);
    }
    {
        arg2 = SWIG_scm2str(argv[1]);
        must_free2 = 1;
    }
    result = (char *)getv(arg1,arg2);
    
    {
        gswig_result = scm_makfrom0str(result);
    }
    
    if (must_free2 && arg2) SWIG_free(arg2);
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_getv__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "getv"
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    char *arg2 = (char *) 0 ;
    char *result;
    int must_free2 = 0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agedge_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agedge_t, 1, 0);
    }
    {
        arg2 = SWIG_scm2str(argv[1]);
        must_free2 = 1;
    }
    result = (char *)getv(arg1,arg2);
    
    {
        gswig_result = scm_makfrom0str(result);
    }
    
    if (must_free2 && arg2) SWIG_free(arg2);
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_getv__SWIG_3 (int argc, SCM *argv)
{
#define FUNC_NAME "getv"
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agsym_t *arg2 = (Agsym_t *) 0 ;
    char *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agraph_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agraph_t, 1, 0);
    }
    {
        arg2 = (Agsym_t *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Agsym_t, 2, 0);
    }
    result = (char *)getv(arg1,arg2);
    
    {
        gswig_result = scm_makfrom0str(result);
    }
    
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_getv__SWIG_4 (int argc, SCM *argv)
{
#define FUNC_NAME "getv"
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agsym_t *arg2 = (Agsym_t *) 0 ;
    char *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agnode_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agnode_t, 1, 0);
    }
    {
        arg2 = (Agsym_t *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Agsym_t, 2, 0);
    }
    result = (char *)getv(arg1,arg2);
    
    {
        gswig_result = scm_makfrom0str(result);
    }
    
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_getv__SWIG_5 (int argc, SCM *argv)
{
#define FUNC_NAME "getv"
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    Agsym_t *arg2 = (Agsym_t *) 0 ;
    char *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agedge_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agedge_t, 1, 0);
    }
    {
        arg2 = (Agsym_t *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Agsym_t, 2, 0);
    }
    result = (char *)getv(arg1,arg2);
    
    {
        gswig_result = scm_makfrom0str(result);
    }
    
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_getv(SCM rest)
{
#define FUNC_NAME "getv"
    SCM argv[2];
    int argc = SWIG_Guile_GetArgs (argv, rest, 0, 2, "getv");
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agraph_t, 0);
        }
        if (_v) {
            {
                void *ptr;
                _v = !SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Agsym_t, 0);
            }
            if (_v) {
                return _wrap_getv__SWIG_3(argc,argv);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agnode_t, 0);
        }
        if (_v) {
            {
                void *ptr;
                _v = !SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Agsym_t, 0);
            }
            if (_v) {
                return _wrap_getv__SWIG_4(argc,argv);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agedge_t, 0);
        }
        if (_v) {
            {
                void *ptr;
                _v = !SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Agsym_t, 0);
            }
            if (_v) {
                return _wrap_getv__SWIG_5(argc,argv);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agraph_t, 0);
        }
        if (_v) {
            {
                _v = SCM_STRINGP(argv[1]) ? 1 : 0;
            }
            if (_v) {
                return _wrap_getv__SWIG_0(argc,argv);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agnode_t, 0);
        }
        if (_v) {
            {
                _v = SCM_STRINGP(argv[1]) ? 1 : 0;
            }
            if (_v) {
                return _wrap_getv__SWIG_1(argc,argv);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agedge_t, 0);
        }
        if (_v) {
            {
                _v = SCM_STRINGP(argv[1]) ? 1 : 0;
            }
            if (_v) {
                return _wrap_getv__SWIG_2(argc,argv);
            }
        }
    }
    
    scm_misc_error("getv", "No matching method for generic function `getv'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_nameof__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "nameof"
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agraph_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agraph_t, 1, 0);
    }
    result = (char *)nameof(arg1);
    
    {
        gswig_result = scm_makfrom0str(result);
    }
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_nameof__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "nameof"
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    char *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agnode_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agnode_t, 1, 0);
    }
    result = (char *)nameof(arg1);
    
    {
        gswig_result = scm_makfrom0str(result);
    }
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_nameof__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "nameof"
    Agsym_t *arg1 = (Agsym_t *) 0 ;
    char *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agsym_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agsym_t, 1, 0);
    }
    result = (char *)nameof(arg1);
    
    {
        gswig_result = scm_makfrom0str(result);
    }
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_nameof(SCM rest)
{
#define FUNC_NAME "nameof"
    SCM argv[1];
    int argc = SWIG_Guile_GetArgs (argv, rest, 0, 1, "nameof");
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agraph_t, 0);
        }
        if (_v) {
            return _wrap_nameof__SWIG_0(argc,argv);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agnode_t, 0);
        }
        if (_v) {
            return _wrap_nameof__SWIG_1(argc,argv);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agsym_t, 0);
        }
        if (_v) {
            return _wrap_nameof__SWIG_2(argc,argv);
        }
    }
    
    scm_misc_error("nameof", "No matching method for generic function `nameof'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_findsubg (SCM s_0, SCM s_1)
{
#define FUNC_NAME "findsubg"
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *arg2 = (char *) 0 ;
    Agraph_t *result;
    int must_free2 = 0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agraph_t *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_Agraph_t, 1, 0);
    }
    {
        arg2 = SWIG_scm2str(s_1);
        must_free2 = 1;
    }
    result = (Agraph_t *)findsubg(arg1,arg2);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agraph_t, 0);
    }
    
    if (must_free2 && arg2) SWIG_free(arg2);
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_findnode (SCM s_0, SCM s_1)
{
#define FUNC_NAME "findnode"
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *arg2 = (char *) 0 ;
    Agnode_t *result;
    int must_free2 = 0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agraph_t *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_Agraph_t, 1, 0);
    }
    {
        arg2 = SWIG_scm2str(s_1);
        must_free2 = 1;
    }
    result = (Agnode_t *)findnode(arg1,arg2);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agnode_t, 0);
    }
    
    if (must_free2 && arg2) SWIG_free(arg2);
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_findedge (SCM s_0, SCM s_1)
{
#define FUNC_NAME "findedge"
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agnode_t *arg2 = (Agnode_t *) 0 ;
    Agedge_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agnode_t *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_Agnode_t, 1, 0);
    }
    {
        arg2 = (Agnode_t *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_Agnode_t, 2, 0);
    }
    result = (Agedge_t *)findedge(arg1,arg2);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agedge_t, 0);
    }
    
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_findattr__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "findattr"
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *arg2 = (char *) 0 ;
    Agsym_t *result;
    int must_free2 = 0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agraph_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agraph_t, 1, 0);
    }
    {
        arg2 = SWIG_scm2str(argv[1]);
        must_free2 = 1;
    }
    result = (Agsym_t *)findattr(arg1,arg2);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agsym_t, 0);
    }
    
    if (must_free2 && arg2) SWIG_free(arg2);
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_findattr__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "findattr"
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    char *arg2 = (char *) 0 ;
    Agsym_t *result;
    int must_free2 = 0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agnode_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agnode_t, 1, 0);
    }
    {
        arg2 = SWIG_scm2str(argv[1]);
        must_free2 = 1;
    }
    result = (Agsym_t *)findattr(arg1,arg2);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agsym_t, 0);
    }
    
    if (must_free2 && arg2) SWIG_free(arg2);
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_findattr__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "findattr"
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    char *arg2 = (char *) 0 ;
    Agsym_t *result;
    int must_free2 = 0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agedge_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agedge_t, 1, 0);
    }
    {
        arg2 = SWIG_scm2str(argv[1]);
        must_free2 = 1;
    }
    result = (Agsym_t *)findattr(arg1,arg2);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agsym_t, 0);
    }
    
    if (must_free2 && arg2) SWIG_free(arg2);
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_findattr(SCM rest)
{
#define FUNC_NAME "findattr"
    SCM argv[2];
    int argc = SWIG_Guile_GetArgs (argv, rest, 0, 2, "findattr");
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agraph_t, 0);
        }
        if (_v) {
            {
                _v = SCM_STRINGP(argv[1]) ? 1 : 0;
            }
            if (_v) {
                return _wrap_findattr__SWIG_0(argc,argv);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agnode_t, 0);
        }
        if (_v) {
            {
                _v = SCM_STRINGP(argv[1]) ? 1 : 0;
            }
            if (_v) {
                return _wrap_findattr__SWIG_1(argc,argv);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agedge_t, 0);
        }
        if (_v) {
            {
                _v = SCM_STRINGP(argv[1]) ? 1 : 0;
            }
            if (_v) {
                return _wrap_findattr__SWIG_2(argc,argv);
            }
        }
    }
    
    scm_misc_error("findattr", "No matching method for generic function `findattr'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_headof (SCM s_0)
{
#define FUNC_NAME "headof"
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    Agnode_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agedge_t *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_Agedge_t, 1, 0);
    }
    result = (Agnode_t *)headof(arg1);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agnode_t, 0);
    }
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_tailof (SCM s_0)
{
#define FUNC_NAME "tailof"
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    Agnode_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agedge_t *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_Agedge_t, 1, 0);
    }
    result = (Agnode_t *)tailof(arg1);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agnode_t, 0);
    }
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_graphof__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "graphof"
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agraph_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agraph_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agraph_t, 1, 0);
    }
    result = (Agraph_t *)graphof(arg1);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agraph_t, 0);
    }
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_graphof__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "graphof"
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    Agraph_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agedge_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agedge_t, 1, 0);
    }
    result = (Agraph_t *)graphof(arg1);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agraph_t, 0);
    }
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_graphof__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "graphof"
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agraph_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agnode_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agnode_t, 1, 0);
    }
    result = (Agraph_t *)graphof(arg1);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agraph_t, 0);
    }
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_graphof(SCM rest)
{
#define FUNC_NAME "graphof"
    SCM argv[1];
    int argc = SWIG_Guile_GetArgs (argv, rest, 0, 1, "graphof");
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agraph_t, 0);
        }
        if (_v) {
            return _wrap_graphof__SWIG_0(argc,argv);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agedge_t, 0);
        }
        if (_v) {
            return _wrap_graphof__SWIG_1(argc,argv);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agnode_t, 0);
        }
        if (_v) {
            return _wrap_graphof__SWIG_2(argc,argv);
        }
    }
    
    scm_misc_error("graphof", "No matching method for generic function `graphof'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_rootof (SCM s_0)
{
#define FUNC_NAME "rootof"
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agraph_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agraph_t *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_Agraph_t, 1, 0);
    }
    result = (Agraph_t *)rootof(arg1);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agraph_t, 0);
    }
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_protonode (SCM s_0)
{
#define FUNC_NAME "protonode"
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agnode_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agraph_t *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_Agraph_t, 1, 0);
    }
    result = (Agnode_t *)protonode(arg1);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agnode_t, 0);
    }
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_protoedge (SCM s_0)
{
#define FUNC_NAME "protoedge"
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agedge_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agraph_t *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_Agraph_t, 1, 0);
    }
    result = (Agedge_t *)protoedge(arg1);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agedge_t, 0);
    }
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ok__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "ok"
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    bool result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agraph_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agraph_t, 1, 0);
    }
    result = (bool)ok(arg1);
    
    {
        gswig_result = SCM_BOOL(result);
    }
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ok__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "ok"
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    bool result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agnode_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agnode_t, 1, 0);
    }
    result = (bool)ok(arg1);
    
    {
        gswig_result = SCM_BOOL(result);
    }
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ok__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "ok"
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    bool result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agedge_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agedge_t, 1, 0);
    }
    result = (bool)ok(arg1);
    
    {
        gswig_result = SCM_BOOL(result);
    }
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ok__SWIG_3 (int argc, SCM *argv)
{
#define FUNC_NAME "ok"
    Agsym_t *arg1 = (Agsym_t *) 0 ;
    bool result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agsym_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agsym_t, 1, 0);
    }
    result = (bool)ok(arg1);
    
    {
        gswig_result = SCM_BOOL(result);
    }
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ok(SCM rest)
{
#define FUNC_NAME "ok"
    SCM argv[1];
    int argc = SWIG_Guile_GetArgs (argv, rest, 0, 1, "ok");
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agraph_t, 0);
        }
        if (_v) {
            return _wrap_ok__SWIG_0(argc,argv);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agnode_t, 0);
        }
        if (_v) {
            return _wrap_ok__SWIG_1(argc,argv);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agedge_t, 0);
        }
        if (_v) {
            return _wrap_ok__SWIG_2(argc,argv);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agsym_t, 0);
        }
        if (_v) {
            return _wrap_ok__SWIG_3(argc,argv);
        }
    }
    
    scm_misc_error("ok", "No matching method for generic function `ok'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_firstsubg (SCM s_0)
{
#define FUNC_NAME "firstsubg"
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agraph_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agraph_t *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_Agraph_t, 1, 0);
    }
    result = (Agraph_t *)firstsubg(arg1);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agraph_t, 0);
    }
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_nextsubg (SCM s_0, SCM s_1)
{
#define FUNC_NAME "nextsubg"
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agraph_t *arg2 = (Agraph_t *) 0 ;
    Agraph_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agraph_t *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_Agraph_t, 1, 0);
    }
    {
        arg2 = (Agraph_t *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_Agraph_t, 2, 0);
    }
    result = (Agraph_t *)nextsubg(arg1,arg2);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agraph_t, 0);
    }
    
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_firstsupg (SCM s_0)
{
#define FUNC_NAME "firstsupg"
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agraph_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agraph_t *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_Agraph_t, 1, 0);
    }
    result = (Agraph_t *)firstsupg(arg1);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agraph_t, 0);
    }
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_nextsupg (SCM s_0, SCM s_1)
{
#define FUNC_NAME "nextsupg"
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agraph_t *arg2 = (Agraph_t *) 0 ;
    Agraph_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agraph_t *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_Agraph_t, 1, 0);
    }
    {
        arg2 = (Agraph_t *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_Agraph_t, 2, 0);
    }
    result = (Agraph_t *)nextsupg(arg1,arg2);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agraph_t, 0);
    }
    
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_firstedge__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "firstedge"
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agedge_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agraph_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agraph_t, 1, 0);
    }
    result = (Agedge_t *)firstedge(arg1);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agedge_t, 0);
    }
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_nextedge__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "nextedge"
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agedge_t *arg2 = (Agedge_t *) 0 ;
    Agedge_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agraph_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agraph_t, 1, 0);
    }
    {
        arg2 = (Agedge_t *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Agedge_t, 2, 0);
    }
    result = (Agedge_t *)nextedge(arg1,arg2);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agedge_t, 0);
    }
    
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_firstout__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "firstout"
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agedge_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agraph_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agraph_t, 1, 0);
    }
    result = (Agedge_t *)firstout(arg1);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agedge_t, 0);
    }
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_nextout__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "nextout"
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agedge_t *arg2 = (Agedge_t *) 0 ;
    Agedge_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agraph_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agraph_t, 1, 0);
    }
    {
        arg2 = (Agedge_t *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Agedge_t, 2, 0);
    }
    result = (Agedge_t *)nextout(arg1,arg2);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agedge_t, 0);
    }
    
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_firstedge__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "firstedge"
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agedge_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agnode_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agnode_t, 1, 0);
    }
    result = (Agedge_t *)firstedge(arg1);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agedge_t, 0);
    }
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_firstedge(SCM rest)
{
#define FUNC_NAME "firstedge"
    SCM argv[1];
    int argc = SWIG_Guile_GetArgs (argv, rest, 0, 1, "firstedge");
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agraph_t, 0);
        }
        if (_v) {
            return _wrap_firstedge__SWIG_0(argc,argv);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agnode_t, 0);
        }
        if (_v) {
            return _wrap_firstedge__SWIG_1(argc,argv);
        }
    }
    
    scm_misc_error("firstedge", "No matching method for generic function `firstedge'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_nextedge__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "nextedge"
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agedge_t *arg2 = (Agedge_t *) 0 ;
    Agedge_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agnode_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agnode_t, 1, 0);
    }
    {
        arg2 = (Agedge_t *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Agedge_t, 2, 0);
    }
    result = (Agedge_t *)nextedge(arg1,arg2);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agedge_t, 0);
    }
    
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_nextedge(SCM rest)
{
#define FUNC_NAME "nextedge"
    SCM argv[2];
    int argc = SWIG_Guile_GetArgs (argv, rest, 0, 2, "nextedge");
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agraph_t, 0);
        }
        if (_v) {
            {
                void *ptr;
                _v = !SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Agedge_t, 0);
            }
            if (_v) {
                return _wrap_nextedge__SWIG_0(argc,argv);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agnode_t, 0);
        }
        if (_v) {
            {
                void *ptr;
                _v = !SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Agedge_t, 0);
            }
            if (_v) {
                return _wrap_nextedge__SWIG_1(argc,argv);
            }
        }
    }
    
    scm_misc_error("nextedge", "No matching method for generic function `nextedge'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_firstout__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "firstout"
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agedge_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agnode_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agnode_t, 1, 0);
    }
    result = (Agedge_t *)firstout(arg1);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agedge_t, 0);
    }
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_firstout(SCM rest)
{
#define FUNC_NAME "firstout"
    SCM argv[1];
    int argc = SWIG_Guile_GetArgs (argv, rest, 0, 1, "firstout");
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agraph_t, 0);
        }
        if (_v) {
            return _wrap_firstout__SWIG_0(argc,argv);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agnode_t, 0);
        }
        if (_v) {
            return _wrap_firstout__SWIG_1(argc,argv);
        }
    }
    
    scm_misc_error("firstout", "No matching method for generic function `firstout'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_nextout__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "nextout"
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agedge_t *arg2 = (Agedge_t *) 0 ;
    Agedge_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agnode_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agnode_t, 1, 0);
    }
    {
        arg2 = (Agedge_t *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Agedge_t, 2, 0);
    }
    result = (Agedge_t *)nextout(arg1,arg2);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agedge_t, 0);
    }
    
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_nextout(SCM rest)
{
#define FUNC_NAME "nextout"
    SCM argv[2];
    int argc = SWIG_Guile_GetArgs (argv, rest, 0, 2, "nextout");
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agraph_t, 0);
        }
        if (_v) {
            {
                void *ptr;
                _v = !SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Agedge_t, 0);
            }
            if (_v) {
                return _wrap_nextout__SWIG_0(argc,argv);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agnode_t, 0);
        }
        if (_v) {
            {
                void *ptr;
                _v = !SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Agedge_t, 0);
            }
            if (_v) {
                return _wrap_nextout__SWIG_1(argc,argv);
            }
        }
    }
    
    scm_misc_error("nextout", "No matching method for generic function `nextout'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_firsthead (SCM s_0)
{
#define FUNC_NAME "firsthead"
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agnode_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agnode_t *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_Agnode_t, 1, 0);
    }
    result = (Agnode_t *)firsthead(arg1);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agnode_t, 0);
    }
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_nexthead (SCM s_0, SCM s_1)
{
#define FUNC_NAME "nexthead"
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agnode_t *arg2 = (Agnode_t *) 0 ;
    Agnode_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agnode_t *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_Agnode_t, 1, 0);
    }
    {
        arg2 = (Agnode_t *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_Agnode_t, 2, 0);
    }
    result = (Agnode_t *)nexthead(arg1,arg2);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agnode_t, 0);
    }
    
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_firstin__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "firstin"
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agedge_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agraph_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agraph_t, 1, 0);
    }
    result = (Agedge_t *)firstin(arg1);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agedge_t, 0);
    }
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_nextin__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "nextin"
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agedge_t *arg2 = (Agedge_t *) 0 ;
    Agedge_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agnode_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agnode_t, 1, 0);
    }
    {
        arg2 = (Agedge_t *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Agedge_t, 2, 0);
    }
    result = (Agedge_t *)nextin(arg1,arg2);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agedge_t, 0);
    }
    
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_firstin__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "firstin"
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agedge_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agnode_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agnode_t, 1, 0);
    }
    result = (Agedge_t *)firstin(arg1);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agedge_t, 0);
    }
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_firstin(SCM rest)
{
#define FUNC_NAME "firstin"
    SCM argv[1];
    int argc = SWIG_Guile_GetArgs (argv, rest, 0, 1, "firstin");
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agraph_t, 0);
        }
        if (_v) {
            return _wrap_firstin__SWIG_0(argc,argv);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agnode_t, 0);
        }
        if (_v) {
            return _wrap_firstin__SWIG_1(argc,argv);
        }
    }
    
    scm_misc_error("firstin", "No matching method for generic function `firstin'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_nextin__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "nextin"
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agedge_t *arg2 = (Agedge_t *) 0 ;
    Agedge_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agraph_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agraph_t, 1, 0);
    }
    {
        arg2 = (Agedge_t *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Agedge_t, 2, 0);
    }
    result = (Agedge_t *)nextin(arg1,arg2);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agedge_t, 0);
    }
    
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_nextin(SCM rest)
{
#define FUNC_NAME "nextin"
    SCM argv[2];
    int argc = SWIG_Guile_GetArgs (argv, rest, 0, 2, "nextin");
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agnode_t, 0);
        }
        if (_v) {
            {
                void *ptr;
                _v = !SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Agedge_t, 0);
            }
            if (_v) {
                return _wrap_nextin__SWIG_0(argc,argv);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agraph_t, 0);
        }
        if (_v) {
            {
                void *ptr;
                _v = !SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Agedge_t, 0);
            }
            if (_v) {
                return _wrap_nextin__SWIG_1(argc,argv);
            }
        }
    }
    
    scm_misc_error("nextin", "No matching method for generic function `nextin'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_firsttail (SCM s_0)
{
#define FUNC_NAME "firsttail"
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agnode_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agnode_t *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_Agnode_t, 1, 0);
    }
    result = (Agnode_t *)firsttail(arg1);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agnode_t, 0);
    }
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_nexttail (SCM s_0, SCM s_1)
{
#define FUNC_NAME "nexttail"
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agnode_t *arg2 = (Agnode_t *) 0 ;
    Agnode_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agnode_t *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_Agnode_t, 1, 0);
    }
    {
        arg2 = (Agnode_t *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_Agnode_t, 2, 0);
    }
    result = (Agnode_t *)nexttail(arg1,arg2);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agnode_t, 0);
    }
    
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_firstnode__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "firstnode"
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agnode_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agraph_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agraph_t, 1, 0);
    }
    result = (Agnode_t *)firstnode(arg1);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agnode_t, 0);
    }
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_nextnode__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "nextnode"
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agnode_t *arg2 = (Agnode_t *) 0 ;
    Agnode_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agraph_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agraph_t, 1, 0);
    }
    {
        arg2 = (Agnode_t *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Agnode_t, 2, 0);
    }
    result = (Agnode_t *)nextnode(arg1,arg2);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agnode_t, 0);
    }
    
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_firstnode__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "firstnode"
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    Agnode_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agedge_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agedge_t, 1, 0);
    }
    result = (Agnode_t *)firstnode(arg1);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agnode_t, 0);
    }
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_firstnode(SCM rest)
{
#define FUNC_NAME "firstnode"
    SCM argv[1];
    int argc = SWIG_Guile_GetArgs (argv, rest, 0, 1, "firstnode");
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agraph_t, 0);
        }
        if (_v) {
            return _wrap_firstnode__SWIG_0(argc,argv);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agedge_t, 0);
        }
        if (_v) {
            return _wrap_firstnode__SWIG_1(argc,argv);
        }
    }
    
    scm_misc_error("firstnode", "No matching method for generic function `firstnode'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_nextnode__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "nextnode"
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    Agnode_t *arg2 = (Agnode_t *) 0 ;
    Agnode_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agedge_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agedge_t, 1, 0);
    }
    {
        arg2 = (Agnode_t *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Agnode_t, 2, 0);
    }
    result = (Agnode_t *)nextnode(arg1,arg2);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agnode_t, 0);
    }
    
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_nextnode(SCM rest)
{
#define FUNC_NAME "nextnode"
    SCM argv[2];
    int argc = SWIG_Guile_GetArgs (argv, rest, 0, 2, "nextnode");
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agraph_t, 0);
        }
        if (_v) {
            {
                void *ptr;
                _v = !SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Agnode_t, 0);
            }
            if (_v) {
                return _wrap_nextnode__SWIG_0(argc,argv);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agedge_t, 0);
        }
        if (_v) {
            {
                void *ptr;
                _v = !SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Agnode_t, 0);
            }
            if (_v) {
                return _wrap_nextnode__SWIG_1(argc,argv);
            }
        }
    }
    
    scm_misc_error("nextnode", "No matching method for generic function `nextnode'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_firstattr__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "firstattr"
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agsym_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agraph_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agraph_t, 1, 0);
    }
    result = (Agsym_t *)firstattr(arg1);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agsym_t, 0);
    }
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_nextattr__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "nextattr"
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    Agsym_t *arg2 = (Agsym_t *) 0 ;
    Agsym_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agraph_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agraph_t, 1, 0);
    }
    {
        arg2 = (Agsym_t *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Agsym_t, 2, 0);
    }
    result = (Agsym_t *)nextattr(arg1,arg2);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agsym_t, 0);
    }
    
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_firstattr__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "firstattr"
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    Agsym_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agedge_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agedge_t, 1, 0);
    }
    result = (Agsym_t *)firstattr(arg1);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agsym_t, 0);
    }
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_nextattr__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "nextattr"
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    Agsym_t *arg2 = (Agsym_t *) 0 ;
    Agsym_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agedge_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agedge_t, 1, 0);
    }
    {
        arg2 = (Agsym_t *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Agsym_t, 2, 0);
    }
    result = (Agsym_t *)nextattr(arg1,arg2);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agsym_t, 0);
    }
    
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_firstattr__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "firstattr"
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agsym_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agnode_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agnode_t, 1, 0);
    }
    result = (Agsym_t *)firstattr(arg1);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agsym_t, 0);
    }
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_firstattr(SCM rest)
{
#define FUNC_NAME "firstattr"
    SCM argv[1];
    int argc = SWIG_Guile_GetArgs (argv, rest, 0, 1, "firstattr");
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agraph_t, 0);
        }
        if (_v) {
            return _wrap_firstattr__SWIG_0(argc,argv);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agedge_t, 0);
        }
        if (_v) {
            return _wrap_firstattr__SWIG_1(argc,argv);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agnode_t, 0);
        }
        if (_v) {
            return _wrap_firstattr__SWIG_2(argc,argv);
        }
    }
    
    scm_misc_error("firstattr", "No matching method for generic function `firstattr'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_nextattr__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "nextattr"
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    Agsym_t *arg2 = (Agsym_t *) 0 ;
    Agsym_t *result;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agnode_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agnode_t, 1, 0);
    }
    {
        arg2 = (Agsym_t *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Agsym_t, 2, 0);
    }
    result = (Agsym_t *)nextattr(arg1,arg2);
    
    {
        gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Agsym_t, 0);
    }
    
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_nextattr(SCM rest)
{
#define FUNC_NAME "nextattr"
    SCM argv[2];
    int argc = SWIG_Guile_GetArgs (argv, rest, 0, 2, "nextattr");
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agraph_t, 0);
        }
        if (_v) {
            {
                void *ptr;
                _v = !SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Agsym_t, 0);
            }
            if (_v) {
                return _wrap_nextattr__SWIG_0(argc,argv);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agedge_t, 0);
        }
        if (_v) {
            {
                void *ptr;
                _v = !SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Agsym_t, 0);
            }
            if (_v) {
                return _wrap_nextattr__SWIG_1(argc,argv);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agnode_t, 0);
        }
        if (_v) {
            {
                void *ptr;
                _v = !SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Agsym_t, 0);
            }
            if (_v) {
                return _wrap_nextattr__SWIG_2(argc,argv);
            }
        }
    }
    
    scm_misc_error("nextattr", "No matching method for generic function `nextattr'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_rm__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "rm"
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agraph_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agraph_t, 1, 0);
    }
    rm(arg1);
    
    gswig_result = SCM_UNSPECIFIED;
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_rm__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "rm"
    Agnode_t *arg1 = (Agnode_t *) 0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agnode_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agnode_t, 1, 0);
    }
    rm(arg1);
    
    gswig_result = SCM_UNSPECIFIED;
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_rm__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "rm"
    Agedge_t *arg1 = (Agedge_t *) 0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agedge_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agedge_t, 1, 0);
    }
    rm(arg1);
    
    gswig_result = SCM_UNSPECIFIED;
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_rm(SCM rest)
{
#define FUNC_NAME "rm"
    SCM argv[1];
    int argc = SWIG_Guile_GetArgs (argv, rest, 0, 1, "rm");
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agraph_t, 0);
        }
        if (_v) {
            return _wrap_rm__SWIG_0(argc,argv);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agnode_t, 0);
        }
        if (_v) {
            return _wrap_rm__SWIG_1(argc,argv);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agedge_t, 0);
        }
        if (_v) {
            return _wrap_rm__SWIG_2(argc,argv);
        }
    }
    
    scm_misc_error("rm", "No matching method for generic function `rm'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_layout (SCM s_0, SCM s_1)
{
#define FUNC_NAME "layout"
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *arg2 = (char *) 0 ;
    int must_free2 = 0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agraph_t *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_Agraph_t, 1, 0);
    }
    {
        arg2 = SWIG_scm2str(s_1);
        must_free2 = 1;
    }
    layout(arg1,arg2);
    
    gswig_result = SCM_UNSPECIFIED;
    
    if (must_free2 && arg2) SWIG_free(arg2);
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_render__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "render"
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agraph_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agraph_t, 1, 0);
    }
    render(arg1);
    
    gswig_result = SCM_UNSPECIFIED;
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_render__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "render"
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *arg2 = (char *) 0 ;
    int must_free2 = 0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agraph_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agraph_t, 1, 0);
    }
    {
        arg2 = SWIG_scm2str(argv[1]);
        must_free2 = 1;
    }
    render(arg1,arg2);
    
    gswig_result = SCM_UNSPECIFIED;
    
    if (must_free2 && arg2) SWIG_free(arg2);
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_render__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "render"
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *arg2 = (char *) 0 ;
    char *arg3 = (char *) 0 ;
    int must_free2 = 0 ;
    int must_free3 = 0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agraph_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agraph_t, 1, 0);
    }
    {
        arg2 = SWIG_scm2str(argv[1]);
        must_free2 = 1;
    }
    {
        arg3 = SWIG_scm2str(argv[2]);
        must_free3 = 1;
    }
    render(arg1,arg2,arg3);
    
    gswig_result = SCM_UNSPECIFIED;
    
    if (must_free2 && arg2) SWIG_free(arg2);
    if (must_free3 && arg3) SWIG_free(arg3);
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_render__SWIG_3 (int argc, SCM *argv)
{
#define FUNC_NAME "render"
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *arg2 = (char *) 0 ;
    FILE *arg3 = (FILE *) 0 ;
    int must_free2 = 0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agraph_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agraph_t, 1, 0);
    }
    {
        arg2 = SWIG_scm2str(argv[1]);
        must_free2 = 1;
    }
    {
        arg3 = (FILE *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_FILE, 3, 0);
    }
    render(arg1,arg2,arg3);
    
    gswig_result = SCM_UNSPECIFIED;
    
    if (must_free2 && arg2) SWIG_free(arg2);
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_render__SWIG_4 (int argc, SCM *argv)
{
#define FUNC_NAME "render"
    Agraph_t *arg1 = (Agraph_t *) 0 ;
    char *arg2 = (char *) 0 ;
    void **arg3 = (void **) 0 ;
    int must_free2 = 0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg1 = (Agraph_t *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Agraph_t, 1, 0);
    }
    {
        arg2 = SWIG_scm2str(argv[1]);
        must_free2 = 1;
    }
    {
        arg3 = (void **)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_p_void, 3, 0);
    }
    render(arg1,arg2,arg3);
    
    gswig_result = SCM_UNSPECIFIED;
    
    if (must_free2 && arg2) SWIG_free(arg2);
    
    
    return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_render(SCM rest)
{
#define FUNC_NAME "render"
    SCM argv[3];
    int argc = SWIG_Guile_GetArgs (argv, rest, 0, 3, "render");
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agraph_t, 0);
        }
        if (_v) {
            return _wrap_render__SWIG_0(argc,argv);
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agraph_t, 0);
        }
        if (_v) {
            {
                _v = SCM_STRINGP(argv[1]) ? 1 : 0;
            }
            if (_v) {
                return _wrap_render__SWIG_1(argc,argv);
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agraph_t, 0);
        }
        if (_v) {
            {
                _v = SCM_STRINGP(argv[1]) ? 1 : 0;
            }
            if (_v) {
                {
                    void *ptr;
                    _v = !SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FILE, 0);
                }
                if (_v) {
                    return _wrap_render__SWIG_3(argc,argv);
                }
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agraph_t, 0);
        }
        if (_v) {
            {
                _v = SCM_STRINGP(argv[1]) ? 1 : 0;
            }
            if (_v) {
                {
                    void *ptr;
                    _v = !SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_p_void, 0);
                }
                if (_v) {
                    return _wrap_render__SWIG_4(argc,argv);
                }
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            _v = !SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Agraph_t, 0);
        }
        if (_v) {
            {
                _v = SCM_STRINGP(argv[1]) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = SCM_STRINGP(argv[2]) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_render__SWIG_2(argc,argv);
                }
            }
        }
    }
    
    scm_misc_error("render", "No matching method for generic function `render'", SCM_EOL);
#undef FUNC_NAME
}


#ifdef __cplusplus
extern "C" {
#endif

/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static swig_type_info _swigt__p_Agedge_t = {"_p_Agedge_t", "Agedge_t *", 0, 0, 0};
static swig_type_info _swigt__p_Agnode_t = {"_p_Agnode_t", "Agnode_t *", 0, 0, 0};
static swig_type_info _swigt__p_Agraph_t = {"_p_Agraph_t", "Agraph_t *", 0, 0, 0};
static swig_type_info _swigt__p_Agsym_t = {"_p_Agsym_t", "Agsym_t *", 0, 0, 0};
static swig_type_info _swigt__p_FILE = {"_p_FILE", "FILE *", 0, 0, 0};
static swig_type_info _swigt__p_p_void = {"_p_p_void", "void **", 0, 0, 0};
static swig_type_info _swigt__p_unsigned_long = {"_p_unsigned_long", "unsigned long *|SCM *", 0, 0, 0};

static swig_type_info *swig_type_initial[] = {
  &_swigt__p_Agedge_t,
  &_swigt__p_Agnode_t,
  &_swigt__p_Agraph_t,
  &_swigt__p_Agsym_t,
  &_swigt__p_FILE,
  &_swigt__p_p_void,
  &_swigt__p_unsigned_long,
};

static swig_cast_info _swigc__p_Agedge_t[] = {  {&_swigt__p_Agedge_t, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_Agnode_t[] = {  {&_swigt__p_Agnode_t, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_Agraph_t[] = {  {&_swigt__p_Agraph_t, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_Agsym_t[] = {  {&_swigt__p_Agsym_t, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_FILE[] = {  {&_swigt__p_FILE, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_p_void[] = {  {&_swigt__p_p_void, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_unsigned_long[] = {  {&_swigt__p_unsigned_long, 0, 0, 0},{0, 0, 0, 0}};

static swig_cast_info *swig_cast_initial[] = {
  _swigc__p_Agedge_t,
  _swigc__p_Agnode_t,
  _swigc__p_Agraph_t,
  _swigc__p_Agsym_t,
  _swigc__p_FILE,
  _swigc__p_p_void,
  _swigc__p_unsigned_long,
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */

#define SWIG_GUILE_INIT_STATIC static
/*************************************************************************
 * Type initialization:
 * This problem is tough by the requirement that no dynamic 
 * memory is used. Also, since swig_type_info structures store pointers to 
 * swig_cast_info structures and swig_cast_info structures store pointers back
 * to swig_type_info structures, we need some lookup code at initialization. 
 * The idea is that swig generates all the structures that are needed. 
 * The runtime then collects these partially filled structures. 
 * The SWIG_InitializeModule function takes these initial arrays out of 
 * swig_module, and does all the lookup, filling in the swig_module.types
 * array with the correct data and linking the correct swig_cast_info
 * structures together.

 * The generated swig_type_info structures are assigned staticly to an initial 
 * array. We just loop though that array, and handle each type individually.
 * First we lookup if this type has been already loaded, and if so, use the
 * loaded structure instead of the generated one. Then we have to fill in the
 * cast linked list. The cast data is initially stored in something like a
 * two-dimensional array. Each row corresponds to a type (there are the same
 * number of rows as there are in the swig_type_initial array). Each entry in
 * a column is one of the swig_cast_info structures for that type.
 * The cast_initial array is actually an array of arrays, because each row has
 * a variable number of columns. So to actually build the cast linked list,
 * we find the array of casts associated with the type, and loop through it 
 * adding the casts to the list. The one last trick we need to do is making
 * sure the type pointer in the swig_cast_info struct is correct.

 * First off, we lookup the cast->type name to see if it is already loaded. 
 * There are three cases to handle:
 *  1) If the cast->type has already been loaded AND the type we are adding
 *     casting info to has not been loaded (it is in this module), THEN we
 *     replace the cast->type pointer with the type pointer that has already
 *     been loaded.
 *  2) If BOTH types (the one we are adding casting info to, and the 
 *     cast->type) are loaded, THEN the cast info has already been loaded by
 *     the previous module so we just ignore it.
 *  3) Finally, if cast->type has not already been loaded, then we add that
 *     swig_cast_info to the linked list (because the cast->type) pointer will
 *     be correct.
**/

#ifdef __cplusplus
extern "C" {
#endif
    
    SWIGRUNTIME void
    SWIG_InitializeModule(void *clientdata) {
        swig_type_info *type, *ret;
        swig_cast_info *cast;
        size_t i;
        swig_module_info *module_head;
        static int init_run = 0;
        
        clientdata = clientdata;
        
        if (init_run) return;
        init_run = 1;
        
        /* Initialize the swig_module */
        swig_module.type_initial = swig_type_initial;
        swig_module.cast_initial = swig_cast_initial;
        
        /* Try and load any already created modules */
        module_head = SWIG_GetModule(clientdata);
        if (module_head) {
            swig_module.next = module_head->next;
            module_head->next = &swig_module;
        } else {
            /* This is the first module loaded */
            swig_module.next = &swig_module;
            SWIG_SetModule(clientdata, &swig_module);
        }
        
        /* Now work on filling in swig_module.types */
        for (i = 0; i < swig_module.size; ++i) {
            type = 0;
            
            /* if there is another module already loaded */
            if (swig_module.next != &swig_module) {
                type = SWIG_MangledTypeQueryModule(swig_module.next, &swig_module, swig_module.type_initial[i]->name);
            }
            if (type) {
                /* Overwrite clientdata field */
                if (swig_module.type_initial[i]->clientdata) type->clientdata = swig_module.type_initial[i]->clientdata;
            } else {
                type = swig_module.type_initial[i];
            }
            
            /* Insert casting types */
            cast = swig_module.cast_initial[i];
            while (cast->type) {
                /* Don't need to add information already in the list */
                ret = 0;
                if (swig_module.next != &swig_module) {
                    ret = SWIG_MangledTypeQueryModule(swig_module.next, &swig_module, cast->type->name);
                }
                if (ret && type == swig_module.type_initial[i]) {
                    cast->type = ret;
                    ret = 0;
                }
                
                if (!ret) {
                    if (type->cast) {
                        type->cast->prev = cast;
                        cast->next = type->cast;
                    }
                    type->cast = cast;
                }
                
                cast++;
            }
            
            /* Set entry in modules->types array equal to the type */
            swig_module.types[i] = type;
        }
        swig_module.types[i] = 0;
    }
    
    /* This function will propagate the clientdata field of type to
    * any new swig_type_info structures that have been added into the list
    * of equivalent types.  It is like calling
    * SWIG_TypeClientData(type, clientdata) a second time.
    */
    SWIGRUNTIME void
    SWIG_PropagateClientData(void) {
        size_t i;
        swig_cast_info *equiv;
        static int init_run = 0;
        
        if (init_run) return;
        init_run = 1;
        
        for (i = 0; i < swig_module.size; i++) {
            if (swig_module.types[i]->clientdata) {
                equiv = swig_module.types[i]->cast;
                while (equiv) {
                    if (!equiv->converter) {
                        if (equiv->type && !equiv->type->clientdata)
                        SWIG_TypeClientData(equiv->type, swig_module.types[i]->clientdata);
                    }
                    equiv = equiv->next;
                }
            }
        }
    }
    
#ifdef __cplusplus
}
#endif


void
SWIG_init(void)
{
    SWIG_InitializeModule(0);
    SWIG_PropagateClientData();
    
    scm_c_define_gsubr("digraph", 1, 0, 0, (swig_guile_proc) _wrap_digraph);
    scm_c_define_gsubr("strictgraph", 1, 0, 0, (swig_guile_proc) _wrap_strictgraph);
    scm_c_define_gsubr("strictdigraph", 1, 0, 0, (swig_guile_proc) _wrap_strictdigraph);
    scm_c_define_gsubr("readstring", 1, 0, 0, (swig_guile_proc) _wrap_readstring);
    scm_c_define_gsubr("read", 0, 0, 1, (swig_guile_proc) _wrap_read);
    scm_c_define_gsubr("graph", 0, 0, 1, (swig_guile_proc) _wrap_graph);
    scm_c_define_gsubr("node", 2, 0, 0, (swig_guile_proc) _wrap_node);
    scm_c_define_gsubr("edge", 0, 0, 1, (swig_guile_proc) _wrap_edge);
    scm_c_define_gsubr("setv", 0, 0, 1, (swig_guile_proc) _wrap_setv);
    scm_c_define_gsubr("getv", 0, 0, 1, (swig_guile_proc) _wrap_getv);
    scm_c_define_gsubr("nameof", 0, 0, 1, (swig_guile_proc) _wrap_nameof);
    scm_c_define_gsubr("findsubg", 2, 0, 0, (swig_guile_proc) _wrap_findsubg);
    scm_c_define_gsubr("findnode", 2, 0, 0, (swig_guile_proc) _wrap_findnode);
    scm_c_define_gsubr("findedge", 2, 0, 0, (swig_guile_proc) _wrap_findedge);
    scm_c_define_gsubr("findattr", 0, 0, 1, (swig_guile_proc) _wrap_findattr);
    scm_c_define_gsubr("headof", 1, 0, 0, (swig_guile_proc) _wrap_headof);
    scm_c_define_gsubr("tailof", 1, 0, 0, (swig_guile_proc) _wrap_tailof);
    scm_c_define_gsubr("graphof", 0, 0, 1, (swig_guile_proc) _wrap_graphof);
    scm_c_define_gsubr("rootof", 1, 0, 0, (swig_guile_proc) _wrap_rootof);
    scm_c_define_gsubr("protonode", 1, 0, 0, (swig_guile_proc) _wrap_protonode);
    scm_c_define_gsubr("protoedge", 1, 0, 0, (swig_guile_proc) _wrap_protoedge);
    scm_c_define_gsubr("ok", 0, 0, 1, (swig_guile_proc) _wrap_ok);
    scm_c_define_gsubr("firstsubg", 1, 0, 0, (swig_guile_proc) _wrap_firstsubg);
    scm_c_define_gsubr("nextsubg", 2, 0, 0, (swig_guile_proc) _wrap_nextsubg);
    scm_c_define_gsubr("firstsupg", 1, 0, 0, (swig_guile_proc) _wrap_firstsupg);
    scm_c_define_gsubr("nextsupg", 2, 0, 0, (swig_guile_proc) _wrap_nextsupg);
    scm_c_define_gsubr("firstedge", 0, 0, 1, (swig_guile_proc) _wrap_firstedge);
    scm_c_define_gsubr("nextedge", 0, 0, 1, (swig_guile_proc) _wrap_nextedge);
    scm_c_define_gsubr("firstout", 0, 0, 1, (swig_guile_proc) _wrap_firstout);
    scm_c_define_gsubr("nextout", 0, 0, 1, (swig_guile_proc) _wrap_nextout);
    scm_c_define_gsubr("firsthead", 1, 0, 0, (swig_guile_proc) _wrap_firsthead);
    scm_c_define_gsubr("nexthead", 2, 0, 0, (swig_guile_proc) _wrap_nexthead);
    scm_c_define_gsubr("firstin", 0, 0, 1, (swig_guile_proc) _wrap_firstin);
    scm_c_define_gsubr("nextin", 0, 0, 1, (swig_guile_proc) _wrap_nextin);
    scm_c_define_gsubr("firsttail", 1, 0, 0, (swig_guile_proc) _wrap_firsttail);
    scm_c_define_gsubr("nexttail", 2, 0, 0, (swig_guile_proc) _wrap_nexttail);
    scm_c_define_gsubr("firstnode", 0, 0, 1, (swig_guile_proc) _wrap_firstnode);
    scm_c_define_gsubr("nextnode", 0, 0, 1, (swig_guile_proc) _wrap_nextnode);
    scm_c_define_gsubr("firstattr", 0, 0, 1, (swig_guile_proc) _wrap_firstattr);
    scm_c_define_gsubr("nextattr", 0, 0, 1, (swig_guile_proc) _wrap_nextattr);
    scm_c_define_gsubr("rm", 0, 0, 1, (swig_guile_proc) _wrap_rm);
    scm_c_define_gsubr("layout", 2, 0, 0, (swig_guile_proc) _wrap_layout);
    scm_c_define_gsubr("render", 0, 0, 1, (swig_guile_proc) _wrap_render);
}

#ifdef __cplusplus
}
#endif
extern "C" {
/* Linkage: simple */

}

