/* Generated by GOB (v2.0.11) on Mon Apr  4 17:27:48 2005
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 11

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "gnome-pilot-conduit-config.h"

#include "gnome-pilot-conduit-config-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 33 "gnome-pilot-conduit-config.gob"

#include <config.h>

#line 31 "gnome-pilot-conduit-config.c"
/* self casting macros */
#define SELF(x) GNOME_PILOT_CONDUIT_CONFIG(x)
#define SELF_CONST(x) GNOME_PILOT_CONDUIT_CONFIG_CONST(x)
#define IS_SELF(x) GNOME_IS_PILOT_CONDUIT_CONFIG(x)
#define TYPE_SELF GNOME_TYPE_PILOT_CONDUIT_CONFIG
#define SELF_CLASS(x) GNOME_PILOT_CONDUIT_CONFIG_CLASS(x)

#define SELF_GET_CLASS(x) GNOME_PILOT_CONDUIT_CONFIG_GET_CLASS(x)

/* self typedefs */
typedef GnomePilotConduitConfig Self;
typedef GnomePilotConduitConfigClass SelfClass;

/* here are local prototypes */
static void gnome_pilot_conduit_config_init (GnomePilotConduitConfig * o) G_GNUC_UNUSED;
static void gnome_pilot_conduit_config_class_init (GnomePilotConduitConfigClass * c) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static GtkObjectClass *parent_class = NULL;

/* Short form macros */
#define self_new gnome_pilot_conduit_config_new
#define self_destroy gnome_pilot_conduit_config_destroy
#define self_load_config gnome_pilot_conduit_config_load_config
#define self_save_config gnome_pilot_conduit_config_save_config
#define self_is_enabled gnome_pilot_conduit_config_is_enabled
#define self_enable gnome_pilot_conduit_config_enable
#define self_enable_with_first_sync gnome_pilot_conduit_config_enable_with_first_sync
#define self_remove_first_sync gnome_pilot_conduit_config_remove_first_sync
#define self_disable gnome_pilot_conduit_config_disable
GType
gnome_pilot_conduit_config_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (GnomePilotConduitConfigClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) gnome_pilot_conduit_config_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (GnomePilotConduitConfig),
			0 /* n_preallocs */,
			(GInstanceInitFunc) gnome_pilot_conduit_config_init,
			NULL
		};

		type = g_type_register_static (GTK_TYPE_OBJECT, "GnomePilotConduitConfig", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((GnomePilotConduitConfig *)g_object_new(gnome_pilot_conduit_config_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static GnomePilotConduitConfig * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static GnomePilotConduitConfig *
GET_NEW_VARG (const char *first, ...)
{
	GnomePilotConduitConfig *ret;
	va_list ap;
	va_start (ap, first);
	ret = (GnomePilotConduitConfig *)g_object_new_valist (gnome_pilot_conduit_config_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Config::finalize"
	GnomePilotConduitConfig *self G_GNUC_UNUSED = GNOME_PILOT_CONDUIT_CONFIG (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
}
#undef __GOB_FUNCTION__

static void 
gnome_pilot_conduit_config_init (GnomePilotConduitConfig * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Config::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,TYPE_SELF,GnomePilotConduitConfigPrivate);
}
#undef __GOB_FUNCTION__
static void 
gnome_pilot_conduit_config_class_init (GnomePilotConduitConfigClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Config::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(GnomePilotConduitConfigPrivate));

	parent_class = g_type_class_ref (GTK_TYPE_OBJECT);

	g_object_class->finalize = ___finalize;
}
#undef __GOB_FUNCTION__



#line 50 "gnome-pilot-conduit-config.gob"
GnomePilotConduitConfig * 
gnome_pilot_conduit_config_new (GnomePilotConduitManagement * gpcm, guint32 pilot_id)
#line 142 "gnome-pilot-conduit-config.c"
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Config::new"
{
#line 51 "gnome-pilot-conduit-config.gob"
	
		GtkObject *ret = NULL;
		GnomePilotConduitConfig *obj;

		ret = GTK_OBJECT(GET_NEW);
		obj = SELF(ret);
		obj->_priv->pilot_id = pilot_id;
		obj->_priv->gpcm = gpcm;

		return obj;
	}}
#line 158 "gnome-pilot-conduit-config.c"
#undef __GOB_FUNCTION__

#line 64 "gnome-pilot-conduit-config.gob"
void 
gnome_pilot_conduit_config_destroy (GnomePilotConduitConfig * self)
#line 164 "gnome-pilot-conduit-config.c"
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Config::destroy"
#line 64 "gnome-pilot-conduit-config.gob"
	g_return_if_fail (self != NULL);
#line 64 "gnome-pilot-conduit-config.gob"
	g_return_if_fail (GNOME_IS_PILOT_CONDUIT_CONFIG (self));
#line 171 "gnome-pilot-conduit-config.c"
{
#line 65 "gnome-pilot-conduit-config.gob"
	
		gtk_object_destroy(GTK_OBJECT(self));
	}}
#line 177 "gnome-pilot-conduit-config.c"
#undef __GOB_FUNCTION__

#line 74 "gnome-pilot-conduit-config.gob"
int 
gnome_pilot_conduit_config_load_config (GnomePilotConduitConfig * self)
#line 183 "gnome-pilot-conduit-config.c"
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Config::load_config"
#line 74 "gnome-pilot-conduit-config.gob"
	g_return_val_if_fail (self != NULL, (int )0);
#line 74 "gnome-pilot-conduit-config.gob"
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_CONFIG (self), (int )0);
#line 190 "gnome-pilot-conduit-config.c"
{
#line 75 "gnome-pilot-conduit-config.gob"
	
		gchar *prefix,*tmp;

		if(self_is_enabled(self,NULL)==TRUE) {
			prefix = g_strdup_printf("/gnome-pilot.d/conduits%d/%s/",
						 self->_priv->pilot_id,
				                 gnome_pilot_conduit_management_get_id(self->_priv->gpcm));
			gnome_config_push_prefix(prefix);
			tmp = gnome_config_get_string("sync_type");
			if (tmp) {
				self->sync_type = gnome_pilot_conduit_sync_type_str_to_int(tmp);
			} else {
				g_warning("conduit has no sync_type, synchronization will skip this conduit");
				self->sync_type = GnomePilotConduitSyncTypeNotSet;
			}
			g_free(tmp);
			tmp = gnome_config_get_string("first_sync_type");
			if (tmp) {
				self->first_sync_type = gnome_pilot_conduit_sync_type_str_to_int(tmp);
			} else {
				self->first_sync_type = GnomePilotConduitSyncTypeNotSet;
			}
			g_free(tmp);
			self->first_slow = gnome_config_get_bool("slow_sync");
			gnome_config_pop_prefix();
			g_free(prefix);
		} else 
			return 0;
		return 1;
	}}
#line 223 "gnome-pilot-conduit-config.c"
#undef __GOB_FUNCTION__

#line 106 "gnome-pilot-conduit-config.gob"
int 
gnome_pilot_conduit_config_save_config (GnomePilotConduitConfig * self)
#line 229 "gnome-pilot-conduit-config.c"
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Config::save_config"
#line 106 "gnome-pilot-conduit-config.gob"
	g_return_val_if_fail (self != NULL, (int )0);
#line 106 "gnome-pilot-conduit-config.gob"
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_CONFIG (self), (int )0);
#line 236 "gnome-pilot-conduit-config.c"
{
#line 107 "gnome-pilot-conduit-config.gob"
	
		gchar *prefix;

		if(self_is_enabled(self,NULL)==TRUE) {
			prefix = g_strdup_printf("/gnome-pilot.d/conduits%d/%s/",
						 self->_priv->pilot_id,
				                 gnome_pilot_conduit_management_get_id(self->_priv->gpcm));
			gnome_config_push_prefix(prefix);
			gnome_config_set_string("sync_type",
						gnome_pilot_conduit_sync_type_int_to_str(self->sync_type));
			gnome_config_set_string("first_sync_type",
						gnome_pilot_conduit_sync_type_int_to_str(self->first_sync_type));
			if(self->first_sync_type==GnomePilotConduitSyncTypeSynchronize) 
			        gnome_config_set_bool("slow_sync",self->first_slow);
			else
			        gnome_config_clean_key("slow_sync");
			gnome_config_pop_prefix();
			gnome_config_sync();
			g_free(prefix);
		} else 
			return 0;
		return 1;
	}}
#line 262 "gnome-pilot-conduit-config.c"
#undef __GOB_FUNCTION__

#line 138 "gnome-pilot-conduit-config.gob"
gboolean 
gnome_pilot_conduit_config_is_enabled (GnomePilotConduitConfig * self, GnomePilotConduitSyncType * sync_type)
#line 268 "gnome-pilot-conduit-config.c"
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Config::is_enabled"
#line 138 "gnome-pilot-conduit-config.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 138 "gnome-pilot-conduit-config.gob"
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_CONFIG (self), (gboolean )0);
#line 275 "gnome-pilot-conduit-config.c"
{
#line 140 "gnome-pilot-conduit-config.gob"
	
		gchar *tmp;
		int num_conduits,cnt;
		gchar **conduit_name;
		gboolean retval;
		
		retval = FALSE;
		
		tmp = g_strdup_printf("/gnome-pilot.d/conduits%d/General/",
				      self->_priv->pilot_id);
		/* g_message("prefix = %s",tmp); */
		
		/* load the list */
		gnome_config_push_prefix(tmp);
		gnome_config_get_vector("conduits",&num_conduits,&conduit_name);
		gnome_config_pop_prefix();
		
		/* g_message("number_of_conduits = %d",num_conduits); */
		
		/* loop, compare and free */
		for(cnt=0;cnt<num_conduits;cnt++) {
			/* g_message("g_str_equal(%s,%s)",
			   conduit_name[cnt] ,
			   gnome_pilot_conduit_management_get_id(self->_priv->gpcm)); */
			if(g_str_equal(conduit_name[cnt] ,gnome_pilot_conduit_management_get_id(self->_priv->gpcm))) {
				/* g_message("match on %s, it is enabled",conduit_name[cnt]); */
				if(sync_type) {
					gchar *newpfx,*tmpstr;
					newpfx = g_strdup_printf("/gnome-pilot.d/conduits%d/%s/first_sync_type",
								 self->_priv->pilot_id,
								 gnome_pilot_conduit_management_get_id(self->_priv->gpcm));
					tmpstr = gnome_config_get_string(newpfx);
					if (tmpstr == NULL) {
						g_free(newpfx);
						newpfx = g_strdup_printf("/gnome-pilot.d/conduits%d/%s/sync_type",
									 self->_priv->pilot_id,
									 gnome_pilot_conduit_management_get_id(self->_priv->gpcm));

						tmpstr = gnome_config_get_string(newpfx);
					}
					/* g_message("%s says %s",newpfx,tmpstr); */
					(*sync_type) = gnome_pilot_conduit_sync_type_str_to_int(tmpstr);
					g_free(newpfx);
					g_free(tmpstr);
				}
				retval = TRUE;
			} 
			g_free(conduit_name[cnt]);
		}
		g_free(conduit_name);
		g_free(tmp);
		return retval;
	}}
#line 331 "gnome-pilot-conduit-config.c"
#undef __GOB_FUNCTION__

#line 196 "gnome-pilot-conduit-config.gob"
void 
gnome_pilot_conduit_config_enable (GnomePilotConduitConfig * self, GnomePilotConduitSyncType sync_type)
#line 337 "gnome-pilot-conduit-config.c"
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Config::enable"
#line 196 "gnome-pilot-conduit-config.gob"
	g_return_if_fail (self != NULL);
#line 196 "gnome-pilot-conduit-config.gob"
	g_return_if_fail (GNOME_IS_PILOT_CONDUIT_CONFIG (self));
#line 344 "gnome-pilot-conduit-config.c"
{
#line 198 "gnome-pilot-conduit-config.gob"
	
		gchar *tmp;
		char **conduit_name;
		char **conduit_name_copy;
		int num_conduits,cnt;
	
		/* enable conduit, if it wasn't, otherwise, just write
		   the sync type in case it was changed. */
		if(self_is_enabled(self,NULL)==FALSE) {
			tmp = g_strdup_printf("/gnome-pilot.d/conduits%d/General/",self->_priv->pilot_id);
			/* g_message("prefix = %s",tmp); */
	
			/* load the list of conduits */
			gnome_config_push_prefix(tmp);
			gnome_config_get_vector("conduits",&num_conduits,&conduit_name);
			/* g_message("num_conduits = %d",num_conduits); */
	
			/* copy the list and attach new conduit */
			conduit_name_copy = g_new0(gchar*,num_conduits+2);
			for(cnt=0;cnt<num_conduits;cnt++) {
				/* g_message("duping %d %s",cnt,conduit_name[cnt]); */
				conduit_name_copy[cnt] = g_strdup(conduit_name[cnt]);
				g_free(conduit_name[cnt]);
			}
			g_free(conduit_name);
			/* g_message("adding %s as element %d",gnome_pilot_conduit_management_get_id(self->_priv->gpcm),num_conduits); */ 
			conduit_name_copy[num_conduits] = g_strdup(gnome_pilot_conduit_management_get_id(self->_priv->gpcm));
	
			/* write new list */
			/* g_message("writing new conduits list, size %d",num_conduits+1); */
			gnome_config_set_vector("conduits",num_conduits+1,(const char**)conduit_name_copy);
	
			/* free the copy */
			/* g_message("freeing %d items",num_conduits+1); */
			for(cnt=0;cnt<num_conduits+1;cnt++) {
				/* g_message("should contain %s",conduit_name_copy[cnt]); */
				g_free(conduit_name_copy[cnt]);
			}
			g_free(conduit_name_copy);
	
			gnome_config_pop_prefix();
	
			g_free(tmp);
		}

		/* make section for conduit */
		tmp = g_strdup_printf("/gnome-pilot.d/conduits%d/%s/",
				      self->_priv->pilot_id,
				      gnome_pilot_conduit_management_get_id(self->_priv->gpcm));
		/* g_message("prefix = %s",tmp); */
		gnome_config_push_prefix(tmp);
		gnome_config_set_string("sync_type",
					gnome_pilot_conduit_sync_type_int_to_str(sync_type));
		gnome_config_pop_prefix();
		gnome_config_sync();
		g_free(tmp);
	}}
#line 404 "gnome-pilot-conduit-config.c"
#undef __GOB_FUNCTION__

#line 258 "gnome-pilot-conduit-config.gob"
void 
gnome_pilot_conduit_config_enable_with_first_sync (GnomePilotConduitConfig * self, GnomePilotConduitSyncType sync_type, GnomePilotConduitSyncType first_sync_type, gboolean slow)
#line 410 "gnome-pilot-conduit-config.c"
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Config::enable_with_first_sync"
#line 258 "gnome-pilot-conduit-config.gob"
	g_return_if_fail (self != NULL);
#line 258 "gnome-pilot-conduit-config.gob"
	g_return_if_fail (GNOME_IS_PILOT_CONDUIT_CONFIG (self));
#line 417 "gnome-pilot-conduit-config.c"
{
#line 262 "gnome-pilot-conduit-config.gob"
	
		gchar *tmp;
		
		self_enable(self,sync_type);

		/* add the first_sync info */
		tmp = g_strdup_printf("/gnome-pilot.d/conduits%d/%s/",
				      self->_priv->pilot_id,
				      gnome_pilot_conduit_management_get_id(self->_priv->gpcm));
		gnome_config_push_prefix(tmp);
		gnome_config_set_string("first_sync_type",
					gnome_pilot_conduit_sync_type_int_to_str(first_sync_type));
		if(first_sync_type==GnomePilotConduitSyncTypeSynchronize) 
			gnome_config_set_bool("slow_sync",slow);
		else
			gnome_config_clean_key("slow_sync");
		gnome_config_pop_prefix();
		gnome_config_sync();
		g_free(tmp);
	}}
#line 440 "gnome-pilot-conduit-config.c"
#undef __GOB_FUNCTION__

#line 284 "gnome-pilot-conduit-config.gob"
void 
gnome_pilot_conduit_config_remove_first_sync (GnomePilotConduitConfig * self)
#line 446 "gnome-pilot-conduit-config.c"
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Config::remove_first_sync"
#line 284 "gnome-pilot-conduit-config.gob"
	g_return_if_fail (self != NULL);
#line 284 "gnome-pilot-conduit-config.gob"
	g_return_if_fail (GNOME_IS_PILOT_CONDUIT_CONFIG (self));
#line 453 "gnome-pilot-conduit-config.c"
{
#line 285 "gnome-pilot-conduit-config.gob"
	
		gchar *tmp;
		
		if (self_is_enabled(self,NULL)) {
			/* add the first_sync info */
			tmp = g_strdup_printf("/gnome-pilot.d/conduits%d/%s/",
					      self->_priv->pilot_id,
					      gnome_pilot_conduit_management_get_id(self->_priv->gpcm));
			if (gnome_config_has_section(tmp)) {
				gnome_config_push_prefix(tmp);
				gnome_config_clean_key("first_sync_type");
				gnome_config_clean_key("slow_sync");
				gnome_config_pop_prefix();
			}
			gnome_config_sync();
			g_free(tmp);
		}

		
	}}
#line 476 "gnome-pilot-conduit-config.c"
#undef __GOB_FUNCTION__

#line 307 "gnome-pilot-conduit-config.gob"
void 
gnome_pilot_conduit_config_disable (GnomePilotConduitConfig * self)
#line 482 "gnome-pilot-conduit-config.c"
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Config::disable"
#line 307 "gnome-pilot-conduit-config.gob"
	g_return_if_fail (self != NULL);
#line 307 "gnome-pilot-conduit-config.gob"
	g_return_if_fail (GNOME_IS_PILOT_CONDUIT_CONFIG (self));
#line 489 "gnome-pilot-conduit-config.c"
{
#line 308 "gnome-pilot-conduit-config.gob"
	
		gchar *tmp;
		gchar **conduit_name;
		char **conduit_name_copy;
		int num_conduits,num_conduits_copy,cnt;
		
		if(self_is_enabled(self,NULL)==FALSE) return;

		tmp = g_strdup_printf("/gnome-pilot.d/conduits%d/General/",self->_priv->pilot_id);
		
		/* load the list of conduits */
		gnome_config_push_prefix(tmp);
		gnome_config_get_vector("conduits",&num_conduits,&conduit_name);
		
		/* copy the list, excluding the one to delete, num_conduits is > 0 since is_enables succeeded */
		conduit_name_copy = g_new0(char*,num_conduits);
		num_conduits_copy = 0;
		for(cnt=0;cnt<num_conduits;cnt++) {
			if(g_strcasecmp(conduit_name[cnt],gnome_pilot_conduit_management_get_id(self->_priv->gpcm))) {
				/* g_message("keeping %d:%s",cnt,conduit_name[cnt]); */
				conduit_name_copy[num_conduits_copy]=g_strdup(conduit_name[cnt]);
				num_conduits_copy++;
			} else {
				/* g_message("skipping %d:%s",cnt,conduit_name[cnt]); */
			}
			g_free(conduit_name[cnt]);
		}
		g_free(conduit_name);
		
		/* save new list */
		/* g_message("num_conduits_copy = %d",num_conduits_copy); */
		if ( num_conduits_copy > 0 )
			gnome_config_set_vector("conduits",num_conduits_copy,(const char**)conduit_name_copy);
		else
			gnome_config_clean_key("conduits");
		
		/* free copy */
		for(cnt=0;cnt<num_conduits_copy;cnt++) g_free(conduit_name_copy[cnt]);
		g_free(conduit_name_copy);
		
		gnome_config_pop_prefix();
		
		/* nuke the conduits config section */
		g_free(tmp);
		tmp = g_strdup_printf("/gnome-pilot.d/conduits%d/%s/",
				      self->_priv->pilot_id,
				      gnome_pilot_conduit_management_get_id(self->_priv->gpcm));
		gnome_config_clean_section(tmp);
		
		gnome_config_sync();
		g_free(tmp);		
	}}
#line 544 "gnome-pilot-conduit-config.c"
#undef __GOB_FUNCTION__

#line 362 "gnome-pilot-conduit-config.gob"



#line 551 "gnome-pilot-conduit-config.c"
