/*
   cipelib - library routines common to CIPE (user-mode part) and PKCIPE

   Copyright 2000 Olaf Titz <olaf@bigred.inka.de>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version
   2 of the License, or (at your option) any later version.
*/
/* $Id: hexdump.c,v 1.5 2001/02/12 00:25:18 olaf Exp $ */

#ifdef __KERNEL__

static const char HEX[16]="0123456789abcdef";
#define LOG(f, x, y) printk(KERN_DEBUG f "\n", x, y)
#define hexdump cipe_hexdump

#else /* not __KERNEL__ */

#include <stdio.h>
#include <string.h>
#include "cipelib.h"

extern const char cipelib_HEX[];
#define HEX cipelib_HEX
#define LOG(f, x, y) cipe_syslog(LOG_DEBUG, f, x, y)

#endif /* __KERNEL __ */

void hexdump(const unsigned char *bp, unsigned int len)
{
    static const unsigned short p[16]={
	0,2,5,7,10,12,15,17,21,23,26,28,31,33,36,38};
    short i=0, j=0;
    static /*?*/ char b[59];

    if (len>1024)
	len=1024; /* sanity */
    memset(b, ' ', sizeof(b));
    while (len-->0) {
	if (i>15) {
	    b[sizeof(b)-1]=0;
	    LOG(" %04x:  %s", j, b);
	    memset(b, ' ', sizeof(b));
	    i=0; j+=16;
	}
	b[p[i]]=HEX[*bp>>4]; b[p[i]+1]=HEX[*bp&15];
	b[i+42]=(((*bp)&0x60)==0||*bp==127)?'.':*bp;
	++bp; ++i;
    }
    b[sizeof(b)-1]=0;
    LOG(" %04x:  %s", j, b);
}

#undef LOG
