/*
   BlueFW PCCARD library 
   Copyright (C) 2002  Marcel Holtmann <marcel@holtmann.org>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
 * $Id: pccard.c,v 1.2 2002/10/28 00:24:51 holtmann Exp $
 */

#include <stdio.h>
#include <errno.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <sys/stat.h>
#include <sys/ioctl.h>

#include "pccard.h"

int pccard_open_dev(int sock)
{
	static char *paths[] = { "/var/lib/pcmcia", "/var/run", "/dev", "/tmp", NULL };

	FILE *f;
	int n, major = -1;
	char s[32], t[32];

	int fd;
	char **p, fn[64];
	dev_t dev;

	if (!(f = fopen("/proc/devices", "r")))
		return -errno;

	while (fgets(s, 32, f)) {
		if (sscanf(s, "%d %s", &n, t) == 2)
			if (strcmp("pcmcia", t) == 0) {
				major = n;
				break;
			}
	}

	fclose(f);

	if (major < 0)
		return -ENODEV;

	dev = (major << 8) + sock;

	for (p = paths; *p; p++) {
		sprintf(fn, "%s/cc-%d", *p, getpid());
		if (mknod(fn, (S_IFCHR | S_IREAD | S_IWRITE), dev) == 0) {
			fd = open(fn, O_RDONLY);
			unlink(fn);
			if (fd >= 0)
				return fd;
			if (errno == ENODEV)
				break;
		}
	}

	return -1;
}

int pccard_get_manfid_from_iobase(unsigned int iobase, int *manf, int *card)
{
	config_info_t config;
	ds_ioctl_arg_t arg;
	cistpl_manfid_t *manfid = &arg.tuple_parse.parse.manfid;
	int i, fd;

	for (i = 0; i < PCCARD_MAX_SOCKS; i++) {

		if ((fd = pccard_open_dev(i)) < 0)
			continue;

		config.Function = 0;

		if (ioctl(fd, DS_GET_CONFIGURATION_INFO, &config) < 0) {
			close(fd);
			continue;
		}

		if (config.BasePort1 != iobase) {
			close(fd);
			continue;
		}

		arg.tuple.DesiredTuple = CISTPL_MANFID;
		arg.tuple.Attributes = TUPLE_RETURN_COMMON;
		arg.tuple.TupleOffset = 0;

		if (ioctl(fd, DS_GET_FIRST_TUPLE, &arg) < 0) {
			close(fd);
			continue;
		}

		if (ioctl(fd, DS_GET_TUPLE_DATA, &arg) < 0) {
			close(fd);
			continue;
		}

		if (ioctl(fd, DS_PARSE_TUPLE, &arg) == 0) {
			*manf = manfid->manf;
			*card = manfid->card;
			close(fd);
			return 0;
		}

		close(fd);
	}

	return -1;
}
