/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#ifndef ArmageTron_TEXTURE_H
#define ArmageTron_TEXTURE_H

#include "tString.h"
#include "tList.h"
#include "rGL.h"

#define rTEX_FLOOR 0
#define rTEX_WALL 1
#define rTEX_OBJ 2
#define rTEX_FONT 3
#define rTEX_GROUPS 4

extern int TextureMode[rTEX_GROUPS];
extern char *TextureGroupDescription[rTEX_GROUPS];
extern bool sr_storageHack;

struct SDL_Surface;

class rTexture{
    static bool s_reportErrors;

    int group;

    static tList<rTexture> s_textures;
    int id;

    int textureModeLast;

    GLuint tint;
    bool repx,repy;
    bool storeAlpha;
    const tString fileName;
    bool used;
    bool loaded;
public:
    rTexture(int group,const char *fileName,
             bool repx=0,bool repy=0,bool s_a=false);
    virtual ~rTexture();

    virtual void ProcessImage(SDL_Surface *){};

    void Unload();
    void Select(bool enforce=false); // enforce: activate even if
    // texture mapping is disabled
    bool Loaded(){ return loaded; }  // was the texture successfully loaded?

    static void UnloadAll();
    static void LoadAll();

    void StoreAlpha();

    static void SetIcon();
};

//extern rTexture ArmageTron_dir_eWall,ArmageTron_floor,ArmageTron_mp_floor;


#endif


